<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript(
    "loadledger",
    '$(document).ready(function() {
                    var table_id ="#acc_subledgers";
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                      data.subledger_type_id            = $("#subledger_type_id").val();
                    return data;
                    }).DataTable({
                    scrollY         : "450px",
                    pageLength      : 100,
                    ajax: {
                        url: "' . Yii::app()->createUrl('accounts/subledgers/GetList') . '",
                        type: "POST",
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                });
                $(".dataTables_scrollFoot").hide();
            });',
    CClientScript::POS_HEAD
);


$cs->registerScript("deleteSublegder", "function deleteSublegder(id) {

                jConfirm('', 'Delete Subledger ?', function(r) {
                    if (r == true) {
                            jQuery.ajax({
                                'dataType':'json',
                                'data'  : {'id' : id},
                                'type':'post',
                                'url': '" . Yii::app()->createUrl('accounts/subledgers/DeleteSublegder') . "',
                                'cache': false,
                                'success': function(data) {
                                    if(data.status=='success'){
                                        t8.success('Deleted Successfully!');  
                                        reloadTable('#acc_subledgers'); 
                                    }else{
                                        $.each(data, function(key, val) { 
                                            t8.error(val); 
                                        }); 
                                        reloadTable('#acc_subledgers'); 
                                    }
                                }, 
                                'beforeSend':function(){
                                    $('#loader').show();
                                },
                                'complete':function(){
                                    $('#loader').hide();   
                                }
                            });     
                        }
                    }); 
            };", CClientScript::POS_HEAD);


?>

<script>
    function Search() {
        reloadTable($("#acc_subledgers"));
    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-file"></i> -->
         Subledgers
        <div class="pull-right" style="display:flex;">
            <!------------------------------------------------------->
            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_subLedgers_add"])) { ?>
                <a class="ad-btn"  onclick="loadPopupModal('accounts/subledgers/Create','New subledgers','lg')">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
            <!------------------------------------------------------->
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="acc_subledgers" style="font-size:13px;">
                <thead>
                    <tr>
                        <td colspan="2"></td>

                        <td style="width: 100px">
                            <?php

                            $modelAccSubledgerType = new AccSubledgerType;
                            $voucherArray = ["onchange" => "Search()", 'style' => 'width:200px', 'empty' => '-Subledger Type-'];
                            echo CHtml::dropDownList("subledger_type_id", "", $modelAccSubledgerType->getSublegdertypes(), $voucherArray);
                            ?>
                        </td>
                        <td colspan="2"></td>


                    </tr>

                    <tr>
                        <th>Reference Id</th>
                        <th>Subledger Name</th>
                        <th>Subledger Type</th>
                        <th>last Sync</th>
                        <th> Related Ledgers</th>
                        <th>Actions</th>
                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>