<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", '$(document).ready(function() {  	 	
        var table_id ="#tbl_security_cheque_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('accounts/securitycheque/GetChequeList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
$cs->registerScript("deletecheque",  "function deletecheque(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=accounts/securitycheque/deletecheque',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Deleted SuccessFully!');
                    reloadTable('#tbl_security_cheque_details');
                }else {
                    t8.error('Error while Delete');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-newspaper-o"></i> Security Cheque
            <div class="pull-right">
                <?php if (isset(Yii::app()->user->havePermissionOn['acc_securitycheque_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('accounts/securitycheque/create','Add New Cheque','lg')"><i class="fa fa-plus"></i></button>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_security_cheque_details" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Transaction Type</th>
                            <th>Transaction Date</th>
                            <th>Payee</th>
                            <th>Bank</th>
                            <th>Cheque No</th>  
                            <th>Cheque Date</th>  
                            <th>Amount</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                            <th>No</th>
                            <th>Transaction Type</th>
                            <th>Transaction Date</th>
                            <th>Payee</th>
                            <th>Bank</th>
                            <th>Cheque No</th>  
                            <th>Cheque Date</th>  
                            <th>Amount</th>
                            <th>Actions</th>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
