<!--
chart of accounts
Sataement  report
Date 04-01-2023
author -Indhu 
main setup
-->
<style>
    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }


    .txt-right {
        text-align: right !important;
    }
</style>
<?php


$condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

$condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

if ($ledger_id > 0) {
    $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
    $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
}

if ($outlet_id > 0) {
    $condition .= ' AND t.outlet_id IN(' . $outlet_id . ')';
    $condition_for_opening .= ' AND I.outlet_id IN(' . $outlet_id . ')';
}

if ($subledger > 0) {
    $condition .= ' AND t.subledger_id=' . $subledger;
    $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
}

if ($warehouse_id > 0) {
    $condition .= ' AND t.warehouse_id=' . $warehouse_id;
    $condition_for_opening .= ' AND I.warehouse_id=' . $warehouse_id;
}




$openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount 
 FROM {{acc_voucher_items}} I 
 LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id 
 WHERE  ' . $condition_for_opening . ' ')->queryScalar();




$openingBalance2 = Yii::app()->db->createCommand('SELECT 
ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount 
FROM {{acc_voucher_items}} I 
LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id 
WHERE  ' . $condition_for_opening . ' ')->queryScalar();




$modelMasCurrency =  new MasCurrency();
$modelAccVoucherItems =  new AccVoucherItems();



$items = $modelAccVoucherItems->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

$openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);




$previousBalance = $openingBalance;
$closingBalance = $openingBalance;

$symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

$total_debit = 0;
$total_credit = 0;


function generateUrlsub($childModel)
{

    $url = '#';
    $code = $childModel->parent->vtype->code;
    if ($code == 'SI') {
        $headModel = $childModel->parent->vtype->header_table;
        // $vat_field = $childModel->parent->vtype->vat_value;
        ////$inv = $headModel::model()->findBypk($childModel->parent->transaction_id);
        //$tax = $inv->$vat_field;
        $tax = 1;
        $taxType = ($tax > 0) ? 'tax' : 'taxnil';
        $hire = $inv->invoice_nature == 'H' ? '&hiring=Y' : '';
        $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . $hire . "&frm=" . $taxType . "&type=1', '_blank');";
    } else if ($code == 'PI') {
        $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "', '_blank');";
    } else if ($code == 'DN') {
        $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
    } else if ($code == 'CN') {
        $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
    } else {
        $url = "window.open($('#liveSite').val()+'index.php?r=accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }
    return $url;
}




?>
<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>
            <th style="width:7%">Date</th>
            <th style="width:5%">VO #</th>
            <th style="width:5%">GL No#</th>
            <th style="width:10%">Ledger</th>
            <th style="width:15%">Subledger</th>
            <th style="width:10%">warehouse</th>
            <th style="width:10%;text-align:right !important;" class="text-right">Debit</th>
            <th style="width:10%;text-align:right !important;" class="text-right">Credit</th>
            <th style="width:10%;text-align:right !important;" class="text-right">Balance</th>
            <th style="width:55%">Narration</th>
        </tr>
    </thead>

    <tbody>

        <tr>
            <td colspan="6" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($previousBalance > 0) ? abs($previousBalance) : 0)); 
                                                        ?></td>
            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($previousBalance < 0) ? abs($previousBalance) : 0));
                                                        ?></td>
            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($previousBalance)) . ' ' . $symbol
                                                        ?></td>
            <td></td>
        </tr>


        <?php

        $total_debit += $previousBalance > 0 ? abs($previousBalance) : 0;
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : 0;

        $parent = 1;
        if (!empty($items)) {
            foreach ($items as $each) {



                $debit = ($each->amount > 0) ? round(($each->amount), 4) : 0;
                $credit = ($each->amount < 0) ? round(abs($each->amount), 4) : 0;

                $running = $debit - $credit + $previousBalance;

                $closingBalance += ($debit - $credit);
                $total_debit += $debit;
                $total_credit += $credit;
                $previousBalance = $running;

                $symbol = ($running > 0) ? 'Dr' : 'Cr';

                $subledgerName = ($each->subledger_id > 0) ? $each->subledger->subledger_name : '';
                //  $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';

                $vouchreformat = '<a href="#" onclick="' . generateUrlsub($each) . '">' . $each->parent->fullvoucher . '</a>';

                //     $vouchreformat = '<a href="#" onclick="' . generateUrl(AccVoucherItems::model()->findBypk((int) $each->id)) . '">' . $each->parent->fullvoucher . '</a>';


        ?>
                <tr data-id="' . $parent . '" data-parent="">
                    <td><?php echo date("d/m/Y", strtotime($each->parent->voucher_date)); ?></td>
                    <td><?php echo $vouchreformat; ?></td>
                    <td><?php echo $each->ledger->ledger_acc_no; ?></td>
                    <td><?php echo $each->ledger->ledger_acc_name; ?></td>
                    <td><?php echo $subledgerName; ?></td>
                    <td><?php echo $each->warehouse->warehouse_name; ?></td>
                    <td style="text-align:right !important;"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat((($debit !== '') ? $debit : 0)); ?></td>
                    <td style="text-align:right !important;"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat((($credit !== '') ? $credit : 0)); ?></td>
                    <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($running)) . " " . $symbol; ?></td>
                    <td><small><?php echo $each->narration; ?></small></td>
                </tr>
            <?php $parent = $child;
            }
            $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr'; ?>

            <tr>
                <td colspan="6" style="text-align:right !important;"><b>Total</b></td>
                <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_debit)); ?></b></td>
                <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_credit)); ?></b></td>
                <td></td>
                <td></td>
            </tr>
            <tr>
                <td colspan="6" style="text-align:right !important;"><b>Closing Balance</b></td>
                <td colspan="3" style="text-align:right !important;"><b><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($closingBalance)) . ' ' . $symbol; ?></b></td>
                <td></td>
            </tr>
        <?php } ?>


    </tbody>
</table>