<!--
chart of accounts
Profit and loss report
date 03-10-2022
updated- date 16-12-2022
author -Jisha Ver 2
main setup
-->

<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }
    .to {
        background: rgb(31 103 178);
        color: White;
    }
    .tol1 {
        font-size: 16px !important;
    }
    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }
    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }
    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }
    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }
    .level-5 {
        padding-left: 267px !important;
    }
    .l1 {
        font-size: 17px !important;
    }
    .l2 {
        font-size: 16px !important;
    }
    .l3 {
        font-size: 15px !important;
    }
    .l4 {
        font-size: 14px !important;
    }
    .l5 {
        font-size: 14px !important;
    }
    .txt-right {
        text-align: right !important;
    }
    
    
</style>
<script>
    function showhideOpening(){
        $('#div_opening_closing').show();
    }
    
</script>
<table class="table-tree">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
    $closing_stock                 = $modelAccSystemAccountsMapping->getSystemdefault('closing_stock');
    
    /* taking all ledger List In Profit AND LOSS  ----start---- */
    $sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger FROM `erp_acc_ledger` ORDER BY `erp_acc_ledger`.`ledger_acc_no`  ASC";
    if ($level > 0) {
        $sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger FROM `erp_acc_ledger` 
                WHERE ledger_main_acc IN ('I','E','GP','NP','EB') AND
                level<=" . $level . "
                ORDER BY `erp_acc_ledger`.`ledger_acc_no`  ASC";
    }
    $arr_ledgers = Yii::app()->db->createCommand($sql)->queryAll();
    /* taking all ledger List In Profit AND LOSS  ----end---- */
    /* filter conditions  ----start---- */
    $condition = ' AND is_posted="Y" ';
    if (!empty($from_date)) {
        $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
        $condition .= ' AND voucher_date >="' . $from_date . '"';
    }
    if (!empty($to_date)) {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
        $condition .= ' AND voucher_date <="' . $to_date . '"';
    }
    if ((int)$company>0) {
        $condition .= " AND company_id = '{$company}'";
    }
  
    if ((int)$salesgroup>0) {
        $condition .= " AND salegroup_id = '{$salesgroup}'";
    }
    if ((int)$brand>0) {
        $condition .= " AND brand_id = '{$brand}'";
    }
  
    if ((int)$department_id>0) {
        $condition .= " AND department_id = '{$department_id}'";
    }
    if ((int)$warehouse_id>0) {
        $condition .= " AND warehouse_id = '{$warehouse_id}'";
    }
    if ((int)$outlet_id>0) {
        $condition .= " AND outlet_id = '{$outlet_id}'";
    }
   
   

    /* filter conditions  ----end---- */
    $opening_balance_amt = Yii::app()->db->createCommand("SELECT IFNULL(SUM(I.amount*I.exchange_rate),0) FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} V ON V.id=I.acc_voucher_id   WHERE I.ledger_id='" .$closing_stock. "' AND  V.is_posted ='Y' AND  V.voucher_date<'" . $from_date . "'")->queryScalar();
    $closing_balance_amt = Yii::app()->db->createCommand("SELECT IFNULL(SUM(I.amount*I.exchange_rate),0) FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} V ON V.id=I.acc_voucher_id   WHERE I.ledger_id='" .$closing_stock. "' AND  V.is_posted ='Y' AND  V.voucher_date<='" . $to_date . "'")->queryScalar();
      
    
    foreach ($arr_ledgers as $eachledger) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        //Net Profit
        if(in_array($eachledger['ledger_main_acc'] ,['NP','GP','EB'])){
            $sqlVI = "SELECT IFNULL(SUM(debit+credit),0) FROM view_account_voucher_items WHERE ledger_main_acc IN ('I','E') AND  ledger_acc_no<=" . $eachledger['ledger_acc_no'] . " {$condition}";
            $netamount = Yii::app()->db->createCommand($sqlVI)->queryScalar();
            if ($netamount > 0) {
                $debit = $netamount;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $netamount;
                $style_tr = ' levelnet';
            }
        }else{
            $condition1 = "level>=" . $eachledger['level'] . " AND root LIKE '" . $eachledger['root'] . "%' ";
            $sqlVI = "SELECT IFNULL(SUM(debit+credit),0) As amount   FROM view_account_voucher_items WHERE " . $condition1 . $condition; 
            $netamount = Yii::app()->db->createCommand($sqlVI)->queryScalar();
            if ($netamount > 0) {
                $debit = $netamount;
            } else {
                $credit = $netamount;
            }
        }
        
       
        
        /*if ($eachledger['ledger_main_acc'] == 'NP') {
            $sqlProfit = "SELECT IFNULL(SUM(debit+credit),0) FROM view_account_voucher_items WHERE ledger_main_acc IN ('I','E') {$condition}";
            $total_profit = Yii::app()->db->createCommand($sqlProfit)->queryScalar();
   
            if ($total_profit > 0) {
                $debit = $total_profit;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $total_profit;
                $style_tr = ' levelnet';
            }
        }
        //Gross Profit
        else if ($eachledger['ledger_main_acc'] == 'GP') {
            $gp_acc = $eachledger['ledger_acc_no'];
            $sqlgp_profit = "SELECT IFNULL(SUM(debit+credit),0)  FROM view_account_voucher_items WHERE ledger_main_acc IN ('I','E') AND  ledger_acc_no<=" . $gp_acc . $condition; //AND ledger_id=".$eachledger['id']
            $gp_profit = Yii::app()->db->createCommand($sqlgp_profit)->queryScalar();
            if ($gp_profit > 0) {
                $debit = $gp_profit;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $gp_profit;
                $style_tr = ' levelnet';
            }
        }
        //Ebit
        else if ($eachledger['ledger_main_acc'] == 'EB') {
            $ebit_acc = $eachledger['ledger_acc_no'];
            $sqlebit_profit = "SELECT IFNULL(SUM(debit+credit),0)  FROM view_account_voucher_items WHERE ledger_main_acc IN ('I','E') AND  ledger_acc_no<=" . $ebit_acc . $condition; //AND ledger_id=".$eachledger['id']
            $ebit_profit = Yii::app()->db->createCommand($sqlebit_profit)->queryScalar();
            if ($ebit_profit > 0) {
                $debit = $ebit_profit;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $ebit_profit;
                $style_tr = ' levelnet';
            }
        }
        // All Profit & Loss entries except NP,GP,EB 
        else {
           
            
           $condition1 = "level>=" . $eachledger['level'] . " AND root LIKE '" . $eachledger['root'] . "%' ";
            $sqlVI = "SELECT IFNULL(SUM(debit+credit),0) As amount   FROM view_account_voucher_items WHERE " . $condition1 . $condition; 
            $command = Yii::app()->db->createCommand($sqlVI);
            // Execute the query and fetch the result
            $netamount = $command->queryScalar();
            if ($netamount > 0) {
                $debit = $netamount;
            } else {
                $credit = $netamount;
            }
        } */
        ?>
         <?php
        if ($company < 0 || $company=='' ) {
            $company = 0;
        }
        /*if ($eachledger['is_parent'] == 'N') {
           // $link = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',' . $company . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
            $count = Yii::app()->db->createCommand("SELECT count(*) FROM erp_acc_voucher_items as ledger INNER JOIN erp_acc_voucher head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $eachledger['id'] . "' AND head.is_posted ='Y' AND head.voucher_date>='" . $from_date . "' AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            if ($eachledger['have_subledger'] == 'Y') {
                $link = 'js:load_pl_summary_pl(' . $eachledger['id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
            } else {
                if ($count < 300) {
                    $link = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
                    $link = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
            if($eachledger['id']==$closing_stock) { 
                if ($count < 300) {
                    $linkop = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($from_date)) . '\')'; 
                    $linkcl = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
                    $linkop = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' .  date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($from_date)) . '\')';
                    $linkcl = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' .  date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
            $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
        } else {*/
            $link = '';
            $accountName = '' . $eachledger['ledger_acc_name'] . '';
        //}
        if($type!='NZ'||abs($debit)>0||abs($credit)>0||$eachledger['level']==1){ ?>
        <tr class="l<?php echo $eachledger['level'] . $style_tr; ?> level<?php echo $eachledger['level']; ?>">
            <td class="l1"><?php echo $eachledger['ledger_acc_no']; ?></td>
            <td class="level-<?php echo $eachledger['level']; ?> l<?php echo $eachledger['level']; ?>"><b><?php echo $accountName; ?></b>
            <?php if($eachledger['id']==$closing_stock) { 
            echo '(<a href="#" onclick="' . $linkop . '" style="color:blueviolet;">Opening Stock - '.Yii::app()->numberFormatter->formatCurrency(abs($opening_balance_amt), " ").'</a> ,
            <a href="#" onclick="' . $linkcl . '" style="color:blueviolet;">Closing Stock - '.Yii::app()->numberFormatter->formatCurrency(abs($closing_balance_amt), " ") .'</a>)';
            }?>
            </td>
            <td  class="txt-right l<?php echo $eachledger['level']; ?>"><?php echo Yii::app()->numberFormatter->formatCurrency($debit, ""); ?></td>
            <td  class="txt-right l<?php echo $eachledger['level']; ?>"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($credit), ""); ?></td>
        </tr>
    <?php 
        }
    }
    ?>
</table>