<!DOCTYPE html>
<html>

<head>
    <title>
        <?php
        $type_det     = ($type == 'customer') ? 'CUSTOMER STATEMENT' : 'VENDOR STATEMENT';
        echo $type_det; ?>
    </title>
</head>

<body>

    <div class="container my-md-2 py-2">

        <!--   header -->
        <?php
        $currency = 1;
        $this->renderPartial('//common/header', array('header_name' => 'Statement of Account', 'id' => $modelAccAllocation->id)); ?>

        <!--   header -->


    </div>


    <div class="">

        <?php
         $modelMasCurrency =  new MasCurrency();
        $telenumber = "";
        $fax = "";
        $due_array = [];
        $due_array["0-30"] = 0;
        for ($index = 1; $index < 6; $index++) {
            $lower_limit = ($index * 30) + 1;
            $upper_limit = $lower_limit + 29;
            $label = "{$lower_limit}-{$upper_limit}";
            if (!isset($due_array[$label])) {
                $due_array[$label] = 0;
            }
        }
        $due_array[">180"] = 0;
        ?>


        <div style="text-align:center; float:left; width:100%;">
            <!-- <img src="<?php //echo 'images/logo/' . Yii::app()->user->pdf_company_logo; 
                            ?>" style="margin-top:10px;height:110px;" /> -->
        </div>
        <div class="col-6">

            <?php
            $ledgerModel = AccLedger::model()->findBypk((int) $ledger);
            $subledgerModel = AccSubledger::model()->findBypk((int)$subledger_id);
            ?>

            <br><br>
            <small><?php //echo Ucfirst($type); 
                    ?> CLIENT:</small><br>
            <b><?php

                if ($subledgerModel->subledgertype->type == 'C') {
                    $Customer = Customer::model()->findBypk((int) $subledgerModel->reference_id);
                } else {
                    $vendor = Vendor::model()->findBypk((int) $subledgerModel->reference_id);
                }
                echo strtoupper($subledgerModel->subledger_name); ?></b><br>

            <?php if ($subledgerModel->subledgertype->type == 'C') { ?>

                <small><?php echo strtoupper(nl2br($Customer->customer_address)); ?></small><br>
                <small><?php echo ($Customer->customer_phone_no != '') ? 'Phone : ' . strtoupper($Customer->customer_phone_no) : ''; ?></small><br>
            <?php  } else { ?>
                <small><?php echo strtoupper(nl2br($vendor->vendor_address)); ?></small><br>
                <small><?php echo ($vendor->vendor_phone_no != '') ? 'Phone : ' . strtoupper($vendor->vendor_phone_no) : ''; ?></small><br>

            <?php  } ?>
        </div>

        <div class="col-6 text-right">

            <?php
            $ledgerModel = AccLedger::model()->findBypk((int) $ledger);
            $subledgerModel = AccSubledger::model()->findBypk((int)$subledger_id);
            ?>


            <br><br>
            <B> STATEMENT OF ACCOUNTS:
            </B><br>
            TRN: <?php
                    if ($subledgerModel->subledgertype->type == 'C') {


                        echo strtoupper(nl2br($Customer->customer_trn_no));
                    } else {

                        echo strtoupper(nl2br($vendor->vendor_trn_no));
                    } ?><br>
            Date : <?= date("j-M-Y"); //date("d/m/Y") 
                    ?>
        </div>
        <br>
    </div>
    <div class="col-md-12">
        <!--<p>Dear Sir / Madam, </p>-->
        <?php if ($type == 'customer') { ?>
            <!--   <p class="text-center"><b><u>Sub: Statement of Account as on <?= date("d/m/Y", strtotime($to_date)); ?></u></b></p>-->
        <?php } else {
        ?>
            <!--   <p><b>Subject : Statement Of Account</b></p>-->
        <?php }
        ?>

        <!--  <p>
            This is to inform your Accounts Dept. that our records show an outstanding balance against the following invoices.
        </p>-->
        <table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable">
            <thead>
                <tr>
                    <th>SR.NO</th>
                    <th>Date</th>
                    <th>INV NO</th>
                    <th>PO NO</th>
                    <th>INV BAL AMT</th>
                    <th>BALANCE DUE</th>
                    <th>DUE DATE</th>
                </tr>
            </thead>
            <?php
            $items = array();

            $query = "
            CREATE OR REPLACE VIEW view_acc_statement AS            
            SELECT
                V.id AS voucher_id,
                V.voucher_date,
                V.due_date,
                V.reference_no,
                VI.narration,
                VI.id AS voucher_item_id,
                V.voucher_no,
                V.imported,
                SIGN(VI.amount) * ROUND(ABS(VI.amount * VI.exchange_rate), 4) AS amount,
                SIGN(VI.amount) * ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
                SIGN(VI.amount) * (ROUND(ABS(VI.amount * VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
            FROM
                erp_acc_voucher_items VI
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id
            LEFT JOIN erp_acc_allocation_items AI ON AI.voucher_item_id = VI.id
            WHERE
                V.is_posted = 'Y'
                AND V.voucher_date <='" . $to_date . "'
                AND VI.ledger_id = " . $ledger_id . "
                AND VI.subledger_id = " . $subledger_id . "
                AND VI.amount <> 0
            GROUP BY
                VI.id";

            $opening_bal = '0.00';
            if ($ledger_id > 0 && $subledger_id > 0) {

                Yii::app()->db->createCommand($query)->execute();
                $opening_bal = '0.00';
                if ($from_date != '') {
                    $opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM view_acc_statement where balance!=0 and voucher_date<"' . $from_date . '" order by voucher_date')->queryScalar();
                    $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement where balance!=0 and voucher_date>="' . $from_date . '" order by voucher_date')->queryAll();
                } else {
                    $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement  where balance!=0  order by voucher_date')->queryAll();
                }
            }
            $amount = 0;
            $allocated = 0;
            $balanced = 0;

            $exchange_rate = 1;
            ?>

            <tbody>


                <?php
                $amount += $opening_bal;
                $allocated += 0;
                $balanced += $opening_bal;
                ?>
                <?php if (!empty($items)) {
                    $cumulativeBalance = 0;
                    $w = 0;
                    foreach ($items as $each) {

                        // Graph Array Open
                        $due_days = strtotime($each['voucher_date']);
                        $due = round(abs(strtotime(date('Y-m-d')) - $due_days) / 86400);
                        $array_slot = floor($due / 30);

                        if ($array_slot == 0) {
                            if (!isset($due_array["0-30"])) {
                                $due_array["0-30"] = 0;
                            }
                            $due_array["0-30"] = $due_array["0-30"] + $each['balance'];
                        } else if ($array_slot >= 6) {
                            if (!isset($due_array[">180"])) {
                                $due_array[">180"] = 0;
                            }
                            $due_array[">180"] = $due_array[">180"] + $each['balance'];
                        } else {
                            $lower_limit = ($array_slot * 30) + 1;
                            $upper_limit = $lower_limit + 29;
                            $label = "{$lower_limit}-{$upper_limit}";
                            if (!isset($due_array[$label])) {
                                $due_array[$label] = 0;
                            }
                            $due_array[$label] = $due_array[$label] + $each['balance'];
                        }
                        // Graph Array Close
                       
                        $model_voucher_type = new AccVoucherType();
                        if (round($each['balance'], 2) != 0) {

                            $do = '';
                            $lpo = '';
                            $inv_ref_no = '';
                            $ref = '';
                            $head = AccVoucher::model()->findByPk($each['voucher_id']);
                            $model_voucher_type_si = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
                            $model_voucher_type_pi = $model_voucher_type->find(array('condition' => 'code="PI"'))->id;

                            echo $type;

                            if ($type == 'customer') {
                                if (((int)$head->voucher_type == (int)$model_voucher_type_si) && $each['imported'] == 'Y') {
                                    $inv = Invoice::model()->findByPk($head->transaction_id);
                                    if ($inv) {
                                        $do = $inv->delivery_ids;
                                        $lpo = $inv->order_id;
                                        $inv_ref_no = $inv->file_id;
                                        $ref = $inv->id;
                                    }
                                }
                            } else {

                                if (((int)$head->voucher_type == (int)$model_voucher_type_pi) && $each['imported'] == 'Y') {
                                    $purchasingInvoice = PurchasingInvoice::model()->findByPk($head->transaction_id);
                                    if ($purchasingInvoice) {
                                        $inv_ref_no = $purchasingInvoice->invoice_no;
                                        $ref = $purchasingInvoice->id;
                                    }
                                }
                            }
                            $ref = empty($ref) ? $head->voucher_no : $ref;
                            // Format the voucher link
                            $vouchreformat =  $ref ;
                            // Ensure $inv_ref_no has a value
                            $inv_ref_no = empty($inv_ref_no) ? $head->voucher_no : $inv_ref_no;
                            $head = AccVoucher::model()->findByPk($each['voucher_id']);
                            $AccVoucherType = AccVoucherType::model()->findByPk($head->voucher_type)->description;
                            if (round($each['balance'], 2) != 0) {

                                $cumulativeBalance += $each['balance'] / $exchange_rate;
                            }

                ?>
                            <tr>
                                <td><?php echo $w + 1; ?></td>
                                <td><?php echo  date("d/m/Y", strtotime($each['voucher_date'])) ?></td>
                                <td><?php echo $vouchreformat; ?></td>
                                <td><?php echo $lpo; ?></td>
                                <!--<td class="text-right"><?php //echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($each['amount'] / $exchange_rate));  
                                                            ?></td>-->
                                <td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($each['balance'] / $exchange_rate));  ?></td>
                                <!--<td  class="text-right"><?php //echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($each['allocated'] / $exchange_rate)); 
                                                            ?></td>-->
                                <td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($cumulativeBalance));  ?></td>
                                <td><?php echo ($each['due_date'] !== '0000-00-00') ? date("d/m/Y", strtotime($each['due_date'])) : '-'; ?></td>

                            </tr>
                    <?php
                            $amount += $each['amount'] / $exchange_rate;
                            $allocated += $each['allocated'] / $exchange_rate;
                            $balanced += $each['balance'] / $exchange_rate;
                        }
                        $w++;
                    } ?>
                    <tr>
                        <td colspan="5" class="text-right"><B> TOTAL DUE</B></td>

                        <!--<td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($amount / $exchange_rate));  ?></td>-->
                        <!--<td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($allocated / $exchange_rate));; ?></td>-->
                        <td class="text-right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($balanced / $exchange_rate)); ?></b></td>

                    </tr>

                    <tr>
                        <td class="text-center" colspan="7"><b>
                                <?php
                                $fcurrency = new MasCurrency();
                                ?>
                                <?php
                                if (($balanced / $exchange_rate) > 0) {

                                    echo $fcurrency->number_to_currency(number_format((round($balanced / $exchange_rate, 2)), 2, '.', ''), $currency);
                                } else {
                                    echo "FOC(Free Of Cost)";
                                }
                                ?></b></td>
                    </tr>

                <?php } else { ?>
                    <tr>
                        <td colspan="8" style="text-align:center !important;">No Data</td>
                    </tr>

                <?php } ?>

            </tbody>



        </table>

        <div style="border: solid red 1px">
            <?php
            echo '<table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable"><thead><tr><th>Period</th>';
            foreach ($due_array as $key => $value) {
                echo '<th class="text-right">' . htmlentities($key) . '</th>';
            }
            echo '</tr></thead><tbody><tr><td>Amount</td>';
            foreach ($due_array as $key => $value) {
                echo '<td class="text-right">' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($value) . '</td>';
            }
            echo '</tr></tbody></table>'; ?>
        </div>

        <br>

        <?php $model =  OwnerBankDetails::model()->find(array('condition' => 'currency_id=' . $currency));
        if (empty($model))
            $model =  OwnerBankDetails::model()->find(array('condition' => 'currency_id=23'));
        if (!empty($model)) {
        ?>


            <div class="box" style="width: 100%;">
                <p style="color: #C49A6C;margin-bottom: 3px;margin-top: 5px;font-weight:bold;font-size: 10px;"><u>PLEASE MAKE MONEY TRANSFER OR CHEQUE TO:</u></p>

                <!--<p style="color: #C49A6C;margin-bottom: 3px;margin-top: 5px;font-weight:bold;font-size: 10px;">Bank Details</p>-->
                <div class="h5sub-details">
                    <?= 'Bank       : ' . $model->bank->bank_name ?><br />
                    <?= 'Swift Code : ' . $model->bank_swift ?>
                    <?= 'Name      : ' . $model->bank_account_name ?><br>
                    <?= 'A/C No     : ' . $model->bank_ac_no ?><br>
                    <?= 'Branch     : ' . $model->bank_branch ?><br>
                    <?= 'IBAN       : ' . $model->bank_iban ?><br />
                </div>
            </div>
        <?php } ?>

        <br>
        <!--<p>In case of any queries or discrepancies, please do not hesitate to contact us</p>-->
        <p>Thanks & Best Regards</p>
        <p><b>Finance Dept.</b></p>
    </div>

    <?php $this->renderPartial("//common/footer"); ?>

</body>

</html>