<!DOCTYPE html>
<html>

<head>
    <style>
        .table thead {
            display: table-header-group;
        }
    </style>
    <title><?php echo 'GL REPORT'; ?></title>
</head>

<body>

    <div class="header" style="width:100%;float: left;border-bottom: 6px solid #850EA6;padding-bottom:10px;">
        <div style="text-align:center; float:left; width:100%;">

            <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>" style="margin-top:10px;height:110px;" />

        </div>
    </div>
    
    
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php echo 'GL Report'; ?></b>
                </div>
                <br>
                <table class="table" style="width:100%">
                    <tr>
                        <td class="bc-tl"><b>From</b> </td>
                        <td>
                            <?php echo date("d/m/Y", strtotime(  $from_date)); ?>
                        </td>

                        <td><b>To</b></td>
                        <td>
                            <?php echo date("d/m/Y", strtotime(  $to_date)) ; ?>
                        </td>


                    </tr>

                    <tr>

                        <td><b>Ledger</b></td>
                        <td>

                            <?php
                            $modelAccLedger =  new AccLedger();
                            $modelAccLedger = $modelAccLedger->findByPk($ledger_id);
                            echo $modelAccLedger->ledger_acc_name; ?>


                        </td>

                        <td><b>Sub Ledger</b></td>
                        <td>

                            <?php
                            $modelAccSubledger =  new AccSubledger();
                            $modelAccSubledger = $modelAccSubledger->findByPk($subledger);
                            echo $modelAccSubledger->subledger_name; ?>


                        </td>
                    </tr>

                </table>
            </div>

        </div>
        <br>
        <div class="col-md-12">
            <table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>VO #</th>
                        <th>Particular</th>
                        <th class="text-right">Dr</th>
                        <th class="text-right">Cr</th>
                        <th class="text-right">Balance</th>
                        <th>Narration</th>
                    </tr>

                </thead>
                <?php

                $baseUrl = Yii::app()->baseUrl;


                $condition = 'voucher_date >= "' . $from_date . '" AND voucher_date <=  "' . $to_date . '"';

                $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

                if ($ledger_id > 0) {
                    $condition .= ' AND ledger_id IN(' . $ledger_id . ')';
                    $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
                }

                if ($subledger > 0) {
                    $condition .= ' AND subledger_id=' . $subledger;
                    $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
                }




                $modelAccVoucherItems = new AccVoucherItems();

                $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();
                $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*H.exchange_rate)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id!=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();




                $items_new = Yii::app()->db->createCommand('SELECT * FROM {{acc_view_gl_report_parent}} WHERE  ' . $condition . ' ORDER BY  voucher_date')->queryAll();

                // -----------------------------------------

                $openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);
                $previousBalance = $openingBalance;
                $closingBalance = $openingBalance;
                $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';
                $total_debit = 0;
                $total_credit = 0;
                // -----------------------------------------



                ?>

                <tbody>
                    <tr>
                        <td colspan="3" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                        <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : 0), " "); ?></td>
                        <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : 0), " "); ?></td>
                        <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol; ?></td>
                        <td></td>
                    </tr>
                    <?php
                    $total_debit += $previousBalance > 0 ? abs($previousBalance) : 0;
                    $total_credit += $previousBalance < 0 ? abs($previousBalance) : 0;
                    $parent = 1;


                    foreach ($items_new as $each) {

                        $debit = $each['debit'];
                        $credit = $each['credit'];

                        $debit = ($currency == $each['currency_id']) ? $debit / $each['exchange_rate'] : $debit / $exchange_rate;
                        $credit = ($currency == $each['currency_id']) ? $credit / $each['exchange_rate'] : $credit / $exchange_rate;

                        $running = $debit - $credit + $previousBalance;
                        $previousBalance = $running;
                        $symbol = ($running > 0) ? 'Dr' : 'Cr';

                        $total_debit += $debit;
                        $total_credit += $credit;
                        $vouchreformat = '<a>' . $each['code'] . "/" . $each['acc_voucher_id'] . '</a>';

                        $particular = '';
                        if ($each['amount'] != 0) {

                    ?>

                            <tr data-id="<?php echo $parent; ?>" data-parent="">
                                <td style="cursor:pointer"><i class="fa fa-plus" onclick="clickFunc(<?php echo $each['acc_voucher_id'] ?>,<?php echo $each['id'] ?>,<?php echo $currency; ?>,<?php echo $each['currency_id']; ?>,<?php echo $each['exchange_rate'] ?>,<?php echo $exchange_rate; ?>)"></i><?php echo  date("d/m/Y", strtotime($each['voucher_date'])); ?></a></td>
                                <td><?php echo $vouchreformat; ?></td>
                                <td><?php echo ($each['amount'] > 0) ? $each['particular2'] : $each['particular1']; ?></td>
                                <td style="text-align:right !important;"><?php echo  Yii::app()->numberFormatter->formatCurrency($debit, " "); ?></td>
                                <td style="text-align:right !important;"><?php echo  Yii::app()->numberFormatter->formatCurrency($credit, " "); ?></td>
                                <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol; ?></td>
                                <td><small><?php echo  $each['narration']; ?></small></td>
                            </tr>


                    <?php
                        }
                    }
                    $closingBalance = (abs($total_debit) - abs($total_credit));
                    $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
                    ?>
                    <tr>
                        <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                        <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "); ?></b></td>
                        <td style="text-align:right !important;"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "); ?></b></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
                        <td colspan="2" style="text-align:right !important;"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol; ?></b></td>
                        <td></td>
                    </tr>

                </tbody>
            </table>
        </div>

           <htmlpagefooter name="myfooter">

        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>
    
      <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>