<!DOCTYPE html>
<html>
<head>
    <title>
        <?php
        echo "Auditclose Trial Balance"; ?>
    </title>
    <style type="text/css">
        table {
            font-family: arial, sans-serif !important;
            border-collapse: collapse !important;
            width: 100% !important;
        }
        td,
        th {
            border: 1px solid #dddddd !important;
            text-align: left !important;
            padding: 8px !important;
        }
        .level1 {
            background: #b4c6e7;
            color: black;
        }

        .to {
            background: rgb(31 103 178);
            color: White;
        }

        .tol1 {
            font-size: 16px !important;
        }

        .level-1 {
            padding-left: 5px !important;
            font-weight: bold;
        }

        .level-2 {
            padding-left: 50px !important;
            font-weight: bold;
        }

        .level-3 {
            padding-left: 104px !important;
            font-weight: bold;
        }

        .level-4 {
            padding-left: 197px !important;
            font-weight: bold;
        }

        .level-5 {
            padding-left: 267px !important;
        }

        .l1 {
            font-size: 17px !important;
        }

        .l2 {
            font-size: 16px !important;
        }

        .l3 {
            font-size: 15px !important;
        }

        .l4 {
            font-size: 14px !important;
        }

        .l5 {
            font-size: 14px !important;
        }

        .txt-right {
            text-align: right !important;
        }

        .table-tree th,
        td {
            border-left: 0;
            border-right: 0;
            margin: 0;
            padding: 3px 5px;
        }

        .ze {
            background: #CCC
        }

        .box-pad,
        .box-pad * {
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }

        .tre td {
            /*border:none;*/
        }

        .level-1 {
            padding-left: 5px !important;
        }

        .level-2 {
            padding-left: 20px !important;

        }

        .level-3 {
            padding-left: 35px !important;
        }

        .level-4 {
            padding-left: 55px !important;
        }

        .level-5 {
            padding-left: 80px !important;
        }

        .l1 {
            font-size: 12px !important;
        }

        .l2 {
            font-size: 11px !important;
            font-style: italic !important;
        }

        .l3 {
            font-size: 12px !important;
        }

        .l4 {
            font-size: 11px !important;
            font-style: italic;
        }

        .l5 {
            font-size: 10px !important;
            font-style: italic;
        }

        .txt-right {
            text-align: right !important;
        }

        .tittle {
            width: 100%;
            margin: 10px 0;
            float: left;
            text-align: center;
        }

        .tittle h6 {
            border-bottom: 2px solid #000;
            width: 150px;
            max-width: 400px;
            font-size: 16px;
            margin: 10px auto;
        }

        .date {
            width: 100%;
            float: left;
            font-size: 11px;
            padding-left: 5px;
            font-weight: 600;
            text-align: left;
            padding-bottom: 3px;
        }

        .date span {
            width: 200px;
            display: inline-block;
        }

        .clear {
            clear: both;
        }

        .cell-left {
            text-align: left !important;
        }

        .cell-right {
            text-align: right !important;
        }

        .br-top {
            border-top: 1px solid #000 !important;
            border-bottom: 3px double #000 !important;
        }

        .space {
            width: 100%;
            float: left;
            clear: both;
            height: 5px;
        }

        .col-6 {
            width: 50%;
        }

        .col-9 {
            width: 75%
        }

        .col-3 {
            width: 25%;
        }

        .f-l {
            float: left;
        }

        .f-r {
            float: right;
        }

        .txt-right {
            text-align: right;
        }

        .txt-left {
            text-align: left;
        }

        .x-space {
            box-sizing: border-box;
        }

        .bg-w {
            background: #FFF !important;
        }

        .footer {
            width: 100%;
            float: left;
            font-size: 11px;
            position: absolute;
            bottom: 0px;
            left: 0px;
            text-align: center !important;
            line-height: 18px;
            border-top: 1px dotted #000;
            padding: 5px;
        }

        .span1 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }

        .span2 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }

        .span3 {
            width: auto !important;
            display: inline-block;
            float: left;
        }

        .pro {
            background: #ccffdf;
        }

        .loss {
            background: #ffb4b4;
        }

        .cy {
            background: #cdcdcd;
        }

        .py {
            background: #ececec;
        }

        .to {
            background: #f1f1f1;
        }
    </style>
</head>

<body>
    <div class="header" style="width:100%;float: left;border-bottom: 6px solid #850EA6;padding-bottom:10px;">
        <div style="text-align:center; float:left; width:100%;">
            <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>" style="margin-top:10px;height:110px;" />
        </div>
    </div>
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php echo 'Auditclose Trial Balance'; ?></b>
                </div>
                <br> <br> <br>
                <table class="table" style="font-size: 10px;">
                    <tr>
                        <td><b>Audit Close Date</b></td>
                        <td colspan="7">
                            <?php echo date('d/m/Y', strtotime($auditclose['close_date'])); ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <br>
        <table class="table-tree">
            <thead>
                <tr class="to tol1">
                <th class="cell-left">Account No.</th>
                <th class="cell-left">Description</th>
                <th>Debit</th>
                <th>Credit</th>
            </tr>
        </thead>
        <?php
        $modelMasCurrency =  new MasCurrency();
        foreach ($auditCloseLedgerResults as $eachledger) {
            $debit_opening = $credit_opening = 0;
            $style_tr = '';
            $debit = 0.00;
            $credit = 0.00;

            if ($eachledger['amount'] > 0) {
                $debit = $eachledger['amount'];
            } else {
                $credit = $eachledger['amount'];
            }
            if ($eachledger['level'] == '1') {
                $sum_debit += $debit;
                $sum_credit += $credit;
            }
            if (($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachledger['level'] == 1) && $eachledger['ledger_acc_no']) {
                ?>
                <tr class="l<?php echo $eachledger['level'] . $style_tr; ?> level<?php echo $eachledger['level']; ?>">
                    <td class="l1"><?php echo $eachledger['ledger_acc_no']; ?></td>
                    <td class="level-<?php echo $eachledger['level']; ?> l<?php echo $eachledger['level']; ?>"><b><?php echo $eachledger['ledger_acc_name']; ?></b></td>
                    <td class="txt-right l<?php echo $eachledger['level']; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit)); ?></b></td>
                    <td class="txt-right l<?php echo $eachledger['level']; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></b></td>
                </tr>
                <?php
            }
        } ?>

        <tr class="to tol1">
            <td></td>
            <td><b>Total</b></td>
            <td class="txt-right  "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($sum_debit);  ?></td>
            <td class="txt-right "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($sum_credit));  ?></td>
        </tr>
    </table>
    <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
            date_default_timezone_set("Asia/Dubai");
            echo date('d/m/Y') . " " . date("h:i:sa"); ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
            <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>
</html>