<!DOCTYPE html>
<html>

<head>
    <title>
        <?php
        echo $category == 'RECEIVABLE' ? 'Receivable Aging Report' : 'Payable Aging Report'; ?>
    </title>


    <style>
        body {
            padding: 0px !important;
            font-size: 20px;
        }

        table {
            border-collapse: collapse;
        }

        .item_table {
            border-collapse: collapse;
            font-size: 12px !important;
            margin: 0px;
        }

        table.item_table,
        .item_table th,
        .item_table td {
            border: 1px solid black;
            font-family: 'Times New Roman', Times, serif;
            padding: 1px;
        }

        .second-colom {

            height: 100px;

            border-bottom: 1px solid;

            text-align: center;

            width: 100%;

        }


        .nobdr_table,
        .nobdr_table td {
            border: none !important;
            padding: 0px !important
        }
    </style>
</head>

<body>

    <div class="header" style="width:100%;float: left;border-bottom: 6px solid #850EA6;padding-bottom:10px;">
        <div class="main">
            <?php $this->renderPartial('//common/header');   ?>
        </div>

    </div>
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php
                        echo $category == 'RECEIVABLE' ? 'Receivable Aging Report' : 'Payable Aging Report'; ?></b>
                </div>
                <br> <br> <br>


                <table class="table" style="font-size: 10px;">

                    <tr>
                        <td><b>To</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($to_date)); ?>
                        </td>
                        <td><b>Ledger</b></td>
                        <td>
                            <?php

                            if ($ledger !== '' && $ledger > 0) {
                                $ledger_det = AccLedger::model()->findByPk($ledger);
                                echo $ledger_det->ledger_acc_name;
                            }
                            ?>
                        </td>
                        <td><b>Sub Ledger</b></td>
                        <td>
                            <?php

                            if ($subledger_id !== '' && $subledger_id > 0) {
                                $subledger_det = AccSubledger::model()->findByPk($subledger_id);
                                echo $subledger_det->subledger_name;
                            }
                            ?>
                        </td>


                    </tr>

                </table>
            </div>

        </div>
        <br>
        <?php
        $dates_array = array(
            '0_to_30' => array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date),
            '31_to_60' => array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days'))),
            '61_to_90' => array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days'))),
            '91_to_120' => array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days'))),
            'greaterthan_120' => array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days'))),
        );



        foreach ($dates_array as $key => $each_date_pair) {


            // ------------------------create- or-update- view- view_acc_ageing_--------------------------------------------------------------------------------------------

            $condition = 'V.is_posted =  "Y"';
            if ($subledger_id > 0) {
                $condition .= " AND  VI.subledger_id = '" . (int) $subledger_id . "'";
            }
            $condition .= " AND  VI.ledger_id = '" . (int) $ledger . "'";



            $condition .= ' AND V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '"';


            $query = 'CREATE OR REPLACE VIEW {{view_acc_ageing_' . $key . '}} AS SELECT
        VI.ledger_id AS ledger_id,
        VI.subledger_id AS subledger_id,
        IFNULL(S.subledger_name, "No Subledger") AS subledger,
        V.id AS voucher_id,
        V.voucher_date AS voucher_date,
        V.due_date AS due_date,
        V.reference_no AS reference_no,
        VI.narration AS narration,
        VI.id AS voucher_item_id,
        CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,
        ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,
       IFNULL(ROUND( SUM(AI.amount), 4), 0) AS allocated,
       
        ROUND((VI.amount*VI.exchange_rate), 4) + IFNULL(ROUND( SUM(AI.amount), 4), 0)  AS amount
        
        FROM {{acc_voucher_items}} VI 
        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
        LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
        LEFT JOIN {{acc_subledger}} S ON S.id = VI.subledger_id
        LEFT JOIN {{acc_voucher_type}} VT ON VT.id=V.voucher_type
        WHERE  ' . $condition . '  GROUP BY VI.id, VI.subledger_id';


            $query_old = 'CREATE OR REPLACE VIEW {{view_acc_ageing_' . $key . '}} AS SELECT
                    VI.ledger_id AS ledger_id,
                    VI.subledger_id AS subledger_id,
                    IFNULL(S.subledger_name, "No Subledger") AS subledger,
                    V.id AS voucher_id,
                    V.voucher_date AS voucher_date,
                    V.due_date AS due_date,
                    V.reference_no AS reference_no,
                    VI.narration AS narration,
                    VI.id AS voucher_item_id,
                    CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,
                    ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,
                    IFNULL(ABS(ROUND( SUM(AI.amount), 4)), 0) AS allocated,
                    ROUND((VI.amount*VI.exchange_rate), 4) - IFNULL(ROUND( SUM(AI.amount), 4), 0) AS amount
                    FROM {{acc_voucher_items}} VI 
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    LEFT JOIN {{acc_subledger}} S ON S.id = VI.subledger_id
                    LEFT JOIN {{acc_voucher_type}} VT ON VT.id=V.voucher_type
                    WHERE  ' . $condition . '  GROUP BY VI.id, VI.subledger_id';


            // ------------------------------------------------------------------------------------------------------------------------

            $selectQuery = 'SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM(0_30_receivable) AS 0_30_receivable,
                        SUM(0_30_unallocated) AS 0_30_unallocated,
                        SUM(31_60_receivable) AS 31_60_receivable,
                        SUM(31_60_unallocated) AS 31_60_unallocated,
                        SUM(61_90_receivable) AS 61_90_receivable,
                        SUM(61_90_unallocated) AS 61_90_unallocated,
                        SUM(91_120_receivable) AS 91_120_receivable,
                        SUM(91_120_unallocated) AS 91_120_unallocated,
                        SUM(greater_120_receivable) AS greater_120_receivable,
                        SUM(greater_120_unallocated) AS greater_120_unallocated
                    FROM ( SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 0_30_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_0_to_30}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 31_60_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_31_to_60}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 61_90_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_61_to_90}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 91_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_91_to_120}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS greater_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS greater_120_unallocated
                    FROM {{view_acc_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';


            //    -------------------------------------------        
            Yii::app()->db->createCommand($query)->execute();
            //    -------------------------------------------        

        }
        $aging_report = Yii::app()->db->createCommand($selectQuery)->queryAll();

        ?>
        <table class="table table-hover table-fixed table-bordere" id="tb_table" style="font-size: 12px;">
            <thead>
                <tr class="to tol1">
                    <th>#</th>
                    <th>Subledger</th>
                    <th>Type</th>
                    <th>0-30</th>
                    <th>31-60</th>
                    <th>61-90</th>
                    <th>91-120</th>
                    <th> > 120</th>
                    <th>Total</th>
                    <th>Net Balance</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $modelMasCurrency =  new MasCurrency();
                $grand_total = 0;
                $one = 0;
                $two = 0;
                $three = 0;
                $four = 0;
                $five = 0;
                $labelOne = ($category == 'RECEIVABLE') ? 'Receivable' : 'Unallocated';
                $labelTwo = ($category == 'RECEIVABLE') ? 'Unallocated' : 'Payable';
                $z = 1;
                foreach ($aging_report as $i => $each) {

                    $total_receivable = $each['0_30_receivable'] + $each['31_60_receivable'] + $each['61_90_receivable'] + $each['91_120_receivable'] + $each['greater_120_receivable'];
                    $total_unallocated = $each['0_30_unallocated'] + $each['31_60_unallocated'] + $each['61_90_unallocated'] + $each['91_120_unallocated'] + $each['greater_120_unallocated'];

                    $one_receivable += $each['0_30_receivable'];
                    $two_receivable += $each['31_60_receivable'];
                    $three_receivable += $each['61_90_receivable'];
                    $four_receivable += $each['91_120_receivable'];
                    $five_receivable += $each['greater_120_receivable'];
                    $grand_total_receivable += $total_receivable;

                    $one_unallocated += $each['0_30_unallocated'];
                    $two_unallocated += $each['31_60_unallocated'];
                    $three_unallocated += $each['61_90_unallocated'];
                    $four_unallocated += $each['91_120_unallocated'];
                    $five_unallocated += $each['greater_120_unallocated'];
                    $grand_total_unallocated += $total_unallocated;
                    if ($total_receivable > 0 || $total_unallocated > 0) {
                ?>

                        <tr>
                            <td rowspan="2" title="No."><?php echo $z; ?></td>
                            <td rowspan="2" title="Subledger"><?php echo  $each['subledger']; ?></td>
                            <td title="Type"><?php echo $labelOne; ?></td>
                            <td style="text-align:right !important;" title="0-30"><a><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['0_30_receivable']);  ?></a></td>
                            <td style="text-align:right !important;" title="30-60"><a><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['31_60_receivable']);  ?></a></td>
                            <td style="text-align:right !important;" title="60-90"><a><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['61_90_receivable']); ?></a></td>
                            <td style="text-align:right !important;" title="90-120"><a><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['91_120_receivable']); ?></a></td>
                            <td style="text-align:right !important;" title=">120"><a><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['greater_120_receivable']); ?></a></td>
                            <td style="text-align:right !important;" title="Total"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($total_receivable);  ?></td>
                            <td rowspan="2" style="text-align:right !important;" title="Total"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_receivable - $total_unallocated));  ?></td>

                        </tr>

                        <tr>
                            <td title="Type"><?php echo $labelTwo; ?></td>
                            <td style="text-align:right !important;" title="0-30"><a><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['0_30_unallocated']); ?></a></td>
                            <td style="text-align:right !important;" title="30-60"><a><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['31_60_unallocated']);  ?></a></td>
                            <td style="text-align:right !important;" title="60-90"><a><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['61_90_unallocated']); ?></a></td>
                            <td style="text-align:right !important;" title="90-120"><a><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['91_120_unallocated']);  ?></a></td>
                            <td style="text-align:right !important;" title=">120"><a><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['greater_120_unallocated']);  ?></a></td>
                            <td style="text-align:right !important;" title="Total"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($total_unallocated);  ?></td>

                        </tr>

                <?php
                    }
                    $z++;
                }

                $modelAccLedger = new AccLedger;
                $baseCurrency =   $modelAccLedger->baseCurrencycode();


                ?>

                <tr>
                    <td colspan="2" rowspan="2" style="text-align:right !important;"><b>Total</b></td>
                    <td title="Type"><?php echo  $labelOne; ?></td>
                    <td title="0-30" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($one_receivable) . " " . $baseCurrency; ?></b></td>
                    <td title="30-60" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($two_receivable) . " " . $baseCurrency; ?></b></td>
                    <td title="60-90" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($three_receivable) . " " . $baseCurrency; ?></b></td>
                    <td title="90-120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($four_receivable) . " " . $baseCurrency; ?></b></td>
                    <td title=">120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($five_receivable) . " " . $baseCurrency;  ?></b></td>
                    <td title="Total" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($grand_total_receivable) . " " . $baseCurrency; ?></b></td>
                    <td rowspan="2" title="Total" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($grand_total_receivable - $grand_total_unallocated)) . " " . $baseCurrency; ?></b></td>

                </tr>

                <tr>
                    <td title="Type"><?php echo $labelTwo; ?></td>
                    <td title="0-30" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($one_unallocated) . " " . $baseCurrency; ?></b></td>
                    <td title="30-60" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($two_unallocated) . " " . $baseCurrency; ?></b></td>
                    <td title="60-90" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($three_unallocated) . " " . $baseCurrency; ?></b></td>
                    <td title="90-120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($four_unallocated) . " " . $baseCurrency; ?></b></td>
                    <td title=">120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($five_unallocated) . " " . $baseCurrency; ?></b></td>
                    <td title="Total" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($grand_total_unallocated) . " " . $baseCurrency; ?></b></td>
                </tr>


            </tbody>
        </table>



        <?php $this->renderPartial("//common/footer");?>
</body>

</html>