<!--
chart of accounts
General Ledger Report
Date 16-12-2022
updated- date 16-12-2022
author -Jisha V2
main setup
-->




<?php

$modelMasCurrency =  new MasCurrency();

$baseUrl = Yii::app()->baseUrl;
$cur = MasCurrency::model()->findByPk(1);
$exchange_rate = $cur->exchange_rate;


$condition_new = 'H.is_posted="Y" AND I.amount != 0 AND DATE(H.' . $date_field . ') >= "' . $from_date . '" AND DATE(H.' . $date_field . ')<= "' . $to_date . '"';


$condition_for_opening = 'H.is_posted="Y" AND DATE(H.' . $date_field . ') < "' . $from_date . '"';



if ($ledger_id > 0) {
    $condition_new .= ' AND I.ledger_id IN(' . $ledger_id . ')';
    $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
}

if ($subledger > 0) {
    $condition_new .= ' AND I.subledger_id=' . $subledger;
    $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
}
if ($outlet_id > 0) {
    $condition_new .= " AND I.outlet_id = '" . $outlet_id . "'";
    $condition_for_opening .= ' AND I.outlet_id=' . $outlet_id;
}

// -------------------------------


$cur = MasCurrency::model()->findByPk($currency);
$exchange_rate = $cur->exchange_rate;

$openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();
$openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*H.exchange_rate)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id!=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();




$openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);


$previousBalance = $openingBalance;



$closingBalance = $openingBalance;
$symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

if ($previousBalance > 0) {
    $dbt_previousBalance = $previousBalance;
}
if ($previousBalance < 0) {
    $cr_previousBalance = $previousBalance;
}


$query = 'SELECT
            VI.acc_voucher_id,
            CONCAT(VT.code, "/", V.voucher_no) AS fullvoucher,
            VI.ledger_id,
            L.ledger_acc_name,
            VI.subledger_id,
            S.subledger_name,
            VI.debit,
            VI.credit,
            VI.amount,
            VI.exchange_rate,
            VI.currency_id,
            VI.narration,
            VI.warehouse_id,
            V.voucher_date,
            V.posted_date,
            V.transaction_number,
            V.voucher_no,
            W.warehouse_name,
            VT.code
        FROM
            erp_acc_voucher_items VI
        LEFT JOIN erp_acc_voucher V ON
            V.id = VI.acc_voucher_id
        LEFT JOIN erp_mas_inv_warehouse W ON
            W.id = VI.warehouse_id
        LEFT JOIN erp_acc_voucher_type VT ON
            VT.id = V.voucher_type
        LEFT JOIN erp_acc_ledger L ON
            L.id = VI.ledger_id
        LEFT JOIN erp_acc_subledger S ON
            S.id = VI.subledger_id
        WHERE
            acc_voucher_id IN(
            SELECT DISTINCT
                (I.acc_voucher_id)
            FROM
                erp_acc_voucher_items I
            LEFT JOIN erp_acc_voucher H ON
                H.id = I.acc_voucher_id
            WHERE ' . $condition_new . ' 
        )
        ORDER BY
            VI.acc_voucher_id,
            VI.id
        DESC';

$items = Yii::app()->db->createCommand($query)->queryAll();
// --------------------------------


?>
<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>

            <th style="width:2%">SL.No</th>
            <th style="width:8%">Voucher Date</th>
            <th style="width:7%">Posted Date</th>
            <th style="width:8%">VO #</th>
            <th style="width:8%">Trans #</th>
            <th style="width:15%">Ledger</th>
            <th style="width:15%">Subledger</th>
            <th style="width:9%;text-align:right !important;" class="text-right">Debit</th>
            <th style="width:9%;text-align:right !important;" class="text-right">Credit</th>
            <th style="width:9%;text-align:right !important;" class="text-right">Balance</th>
            <th style="width:15%">Narration</th>

        </tr>
    </thead>
    <tbody>
        <tr style=" background: #c3c8d1">

            <td colspan="7" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($dbt_previousBalance); ?></td>
            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($cr_previousBalance));  ?></td>
            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($previousBalance)) . ' ' . $symbol; ?></td>
            <td></td>

        </tr>
        <?php
        $parent = 1;
        $total_debit = $total_credit = $closingBalance = 0;
        foreach ($items as $key => $each) {

            $row_id = $key + 1;



            $debit = $each['debit'];
            $credit = $each['credit'];


            $debit = ($each['amount'] > 0) ? round(($each['amount'] * $each['exchange_rate']), 4) : 0;
            $credit = ($each['amount'] < 0) ? round(abs($each['amount'] * $each['exchange_rate']), 4) : 0;

            $debit = ($currency == $each['currency_id']) ? $debit / $each['exchange_rate'] : $debit / $exchange_rate;
            $credit = ($currency ==  $each['currency_id']) ? $credit / $each['exchange_rate'] : $credit / $exchange_rate;


            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';


            $total_debit += $debit;
            $total_credit += $credit;


            // --------------------------------------------------------------------------







            $vouchreformat = '<a href="' . $baseUrl . '/index.php?r=accounts/voucher/PrintvoucherPdf&id=' . (int)  $each['acc_voucher_id'] . '" target="_blank">' . $each['fullvoucher'] . '</a>';
            $subledgerName = ($each['subledger_id'] > 0) ? $each['subledger_name'] : '';
            $style = "background-color:none;";
            if ($ledger_id == $each['ledger_id']) {
                $style = "background-color:#7ff67f63;";
            }

        ?>
            <tr style="<?php echo $style ?>">
                <td><?php echo $key + 1; ?></td>


                <td>

                    <?php echo ($each['voucher_date'] == '0000-00-00' ||  $each['voucher_date'] == '30/11/-0001') ? "-" : date('d/m/Y', strtotime($each['voucher_date'])); ?>
                </td>

                <td><?php echo ($each['posted_date'] == '0000-00-00 00:00:00' ||  $each['posted_date'] == '30/11/-0001') ? "-" : date('d/m/Y', strtotime($each['posted_date'])); ?> </td>


                <td><?php echo $vouchreformat; ?></td>
                <td style="text-align:right !important;"><?php echo $each['transaction_number']; ?></td>
                <td><?php echo $each['ledger_acc_name']; ?></td>
                <td><?php echo $subledgerName; ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit);  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit));  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($running)) . " " . $symbol; ?></td>
                <td><small><?php echo $each['narration'] . ' - ' . $each['warehouse_name']; ?></small></td>
            </tr>
        <?php


            //$parent++;
        }
        $closingBalance = abs($total_debit + $dbt_previousBalance) - (abs($total_credit) + abs($cr_previousBalance));
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        ?>
        <tr>
            <td colspan="7" style="text-align:right !important;"><b>Total</b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_debit + $dbt_previousBalance));  ?></b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_credit) + abs($cr_previousBalance));  ?></b></td>
            <td></td>
            <td></td>

        </tr>
        <tr style=" background: #c3c8d1">
            <td colspan="7" style="text-align:right !important;"><b>Closing Balance</b></td>
            <td colspan="3" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($closingBalance)) . ' ' . $symbol; ?></b></td>
            <td></td>

        </tr>
    </tbody>
</table>