<!--
chart of accounts
General Ledger Summary  Report
Date 11-01-2023
author -Indhu
main setup
-->
<?php
$baseUrl = Yii::app()->baseUrl;

$condition = 'VI.ledger_id="' . $ledger_id . '" AND V.is_posted = "Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '"';


$glSummaryquery = 'CREATE OR REPLACE VIEW {{acc_view_gl_summary}} AS SELECT
                                SL.id AS subledger_id,
                                L.ledger_acc_no AS ledger_no,
								IFNULL(SL.subledger_name, "No Subledger") AS subledger_name,
                                ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                L.id AS ledger_id,VI.subledger_id AS voucher_sub_id
							FROM {{acc_voucher_items}} VI
                            LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
							LEFT JOIN {{acc_ledger}} L ON L.id = VI.ledger_id
							LEFT JOIN {{acc_subledger}} SL ON SL.id = VI.subledger_id
							WHERE ' . $condition . '
							GROUP BY  VI.ledger_id, VI.subledger_id';
Yii::app()->db->createCommand($glSummaryquery)->execute();



$summaryItems = Yii::app()->db->createCommand('SELECT * FROM {{acc_view_gl_summary}} WHERE balance != 0 ORDER BY subledger_name')->queryAll();

// -------------------------------

?>
<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>
            <th style="width:10%">#</th>
            <th style="width:30%">Particular</th>
            <th style="width:15%;text-align:right !important;" class="text-right">Debit</th>
            <th style="width:15%;text-align:right !important;" class="text-right">Credit</th>
            <th style="width:17%;text-align:right !important;" class="text-right">Balance</th>

        </tr>
    </thead>
    <tbody>
        <?php
        $modelMasCurrency =  new MasCurrency();
        $totalDebit = $totalCredit =  $totalBalance = 0;

        foreach ($summaryItems as $key=>$each) {
            
            $debit = $each['debit'];
            $credit = $each['credit'];

            $totalDebit += $debit;
            $totalCredit += $credit;
               
            $count = Yii::app()->db->createCommand("SELECT count(*) FROM {{acc_voucher_items}} as ledger INNER JOIN {{acc_voucher}} head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $each['ledger_id'] . "'  AND ledger.subledger_id='" . $each['subledger_id'] . "' AND head.is_posted ='Y' AND head.voucher_date>='" . $from_date . "' AND head.voucher_date<='" . $to_date . "'")->queryScalar();
           
            $function_name = $count < 300 ? 'load_summary_gl_report' : 'load_ledger_summary_gl_excel';
           
            if ($count < 300) {
                $subledgerName = '<a href="#" onclick="js:' . $function_name . '(' . $each['ledger_id']  . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            } else {
                $subledgerName = '<a href="#" onclick="js:' . $function_name . '(' . $each['ledger_id']  . ',' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            }
            // $subledgerName = '<a href="#" onclick="js:load_summary_gl_report(' . $each['ledger_id'] . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            
            $diff_balance = $debit - $credit;
            $symbol =  ($diff_balance > 0) ? 'Dr' : 'Cr';
            $totalBalance += $diff_balance;
        ?>
            <tr>
                <td><?php echo $key+1; ?></td>
                <td><?php echo $subledgerName; ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit); ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($credit);  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($diff_balance)).' '.$symbol; ?></td>

            </tr>
        <?php }  $symbol =  ($totalBalance > 0) ? 'Dr' : 'Cr'; ?>
        <tr>
            <td colspan="2" style="text-align:right !important;"><b>Total</b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($totalDebit);   ?></b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($totalCredit);?></b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($totalBalance)).' '.$symbol; ?></b></td>

        </tr>
        <?php
        $balance = $totalDebit - $totalCredit;
        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;
        $symbol =  ($balance > 0) ? 'Dr' : 'Cr';
        ?>
        <tr>
            <td colspan="4" style="text-align:right !important;"><b>Balance</b></td>
            <!-- <td style="text-align:right !important;"><b><?php //echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debitBalance); ?></b></td> -->
            <!-- <td style="text-align:right !important;"><b><?php //echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($creditBalance);  ?></b></td> -->
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($balance)).' '. $symbol; ?></b></td>

        </tr>
    </tbody>
</table>