<style>
    table,
    th,
    td {
        border: 1px solid black;
    }

    .txt-right {
        text-align: right !important;
    }

    .text-left {
        text-align: left;
    }
</style>
<?php
$condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
$condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

if ($ledger_id > 0) {
    $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
    $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
}

if ($subledger > 0) {
    $condition .= ' AND t.subledger_id=' . $subledger;
    $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
}
if ($warehouse_id > 0) {
    $condition .= ' AND t.warehouse_id=' . $warehouse_id;
    $condition_for_opening .= ' AND I.warehouse_id=' . $warehouse_id;
}

  if ($outlet_id > 0) {
            $condition .= ' AND t.outlet_id IN(' . $outlet_id . ')';
            $condition_for_opening .= ' AND I.outlet_id IN(' . $outlet_id . ')';
        }

$openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount 
        FROM {{acc_voucher_items}} I 
        LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id 
        WHERE  ' . $condition_for_opening . ' ')->queryScalar();


$openingBalance2 = Yii::app()->db->createCommand('SELECT 
        ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount 
        FROM {{acc_voucher_items}} I 
        LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id 
        WHERE  ' . $condition_for_opening . ' ')->queryScalar();

$modelAccVoucherItems =  new AccVoucherItems();
$items = $modelAccVoucherItems->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

$openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);

$previousBalance = $openingBalance;
$closingBalance = $openingBalance;

$symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

$total_debit = 0;
$total_credit = 0;
?>

<table style="width:100%">


    <!-- <table class="table-tree"> -->
    <thead>
        <th colspan="10">
            <?php
            $modelMasCurrency =  new MasCurrency();
            $modelCompany =  MasCompany::model()->find();

            echo $modelCompany->company_name;
            ?>
        </th>
        </tr>
        <tr>

        </tr>
        <tr>
            <th style="color: white ;background-color:#696969;" colspan="10">Subledger Detailed Report</th>
        </tr>


        <?php




        if ($from_date != '') {
        ?>

            <tr>
                <td colspan="4"><b> From Date</b></td>
                <td class="text-left" colspan="6">
                    <?php echo date('d/m/Y', strtotime($from_date)); ?>
                </td>
            </tr>

        <?php
        }
        ?>

        <?php
        if ($to_date != '') {
        ?>

            <tr>
                <td colspan="4"><b> To Date</b></td>
                <td class="text-left" colspan="6">
                    <?php echo date('d/m/Y', strtotime($to_date)); ?>
                </td>
            </tr>

        <?php
        }
        ?>




        <tr>
            <td colspan="4"><b>Sub Ledger</b></td>
            <td colspan="6">

                <?php

                if ($subledger !== '' && $subledger > 0) {
                    $modelAccSubledger = new AccSubledger();
                    $subledger_det = $modelAccSubledger->findByPk($subledger);
                    echo $subledger_det->subledger_name;
                }

                ?>

            </td>
        </tr>
       
        <tr></tr>

        <tr class="to tol1">
            <th>Date</th>
            <th>VO #</th>
            <th>GL No#</th>
            <th>Ledger</th>
            <th>Subledger</th>
            <th>Warehouse</th>
            <th>Debit</th>
            <th>Credit</th>
            <th>Balance</th>
            <th>Narration</th>
        </tr>
    </thead>
    <tbody>

        <tr>
            <td colspan="6" class="txt-right"><b>Opening Balance</b></td>
            <td class="txt-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($previousBalance > 0) ? abs($previousBalance) : 0)); 
                                    ?></td>
            <td class="txt-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($previousBalance < 0) ? abs($previousBalance):0)); 
                                    ?></td>
            <td class="txt-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($previousBalance);
                                    ?></td>
            <td></td>
        </tr>

        <?php

        $total_debit += $previousBalance > 0 ? abs($previousBalance) : 0;
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : 0;

        $parent = 1;
        if (!empty($items)) {
            foreach ($items as $each) {

                $debit = ($each->amount > 0) ? round(($each->amount), 4) : 0;
                $credit = ($each->amount < 0) ? round(abs($each->amount), 4) : 0;

                $running = $debit - $credit + $previousBalance;
                $closingBalance += ($debit - $credit);
                $total_debit += $debit;
                $total_credit += $credit;
                $previousBalance = $running;

                $symbol = ($running > 0) ? 'Dr' : 'Cr';

                $subledgerName = ($each->subledger_id > 0) ? $each->subledger->subledger_name : '';

        ?>
                <tr data-id="' . $parent . '" data-parent="">
                    <td><?php echo date("d/m/Y", strtotime($each->parent->voucher_date)); ?></td>
                    <td><?php echo $vouchreformat; ?></td>
                    <td><?php echo $each->ledger->ledger_acc_no; ?></td>
                    <td><?php echo $each->ledger->ledger_acc_name; ?></td>
                    <td><?php echo $subledgerName; ?></td>
                    <td><?php echo $each->warehouse->warehouse_name; ?></td>
                    <td><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($debit !== '') ? $debit : 0));  ?></td>
                    <td><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($credit !== '') ? $credit : 0));   ?></td>
                    <td><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($running);  ?></td>
                    <td><small><?php echo $each->narration; ?></small></td>
                </tr>
            <?php $parent = $child;
            }
            $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr'; ?>

            <tr>
                <td colspan="6" class="txt-right"><b>Total</b></td>
                <td class="txt-right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_debit));  ?></b></td>
                <td class="txt-right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_credit));  ?></b></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td colspan="6" class="txt-right"><b>Closing Balance</b></td>
                <td colspan="3" class="txt-right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($closingBalance);  ?></b></td>
                <td></td>
            </tr>
        <?php } ?>

    </tbody>
    </tbody>
</table>