<?php
function generateUrlx($childModel)
{
    $url = '#'; // Default URL in case of errors
    // Check if $childModel, $childModel->parent, and $childModel->parent->vtype exist
    if (!$childModel || !$childModel->parent || !$childModel->parent->vtype) {
        return $url;
    }
    $code = $childModel->parent->vtype->code;
    $imported = $childModel->parent->imported;
    $baseUrl = "$('#liveSite').val() + 'index.php?r='"; // Base URL

    // If not imported
    if ($imported == 'N') {
        return "window.open($baseUrl + 'accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }

    // Switch case for different voucher types
    switch ($code) {
        case 'SI':
            $headModel = $childModel->parent->vtype->header_table;

            // Simulate tax logic (replace with actual logic if needed)
            $tax = 1; // Default tax value
            $taxType = ($tax > 0) ? 'tax' : 'taxnil';
            return "window.open($baseUrl + 'invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "&frm=" . $taxType . "&type=1', '_blank');";
        case 'PI':
            return "window.open($baseUrl + 'purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "', '_blank');";
        case 'DN':
            return "window.open($baseUrl + 'debitnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
        case 'CN':
            return "window.open($baseUrl + 'creditnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
        default:
            // Default to voucher print if no matching code is found
            return "window.open($baseUrl + 'accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }
}
?>

<div id="div_daily_details">
    <div class="panel">
        <div class="panel-heading panel-theme clearfix report-head">
            Consolidated Statement Report
        </div>
        <?php
        $items = array();

        $amount = 0;
        $allocated = 0;
        $balanced = 0;
       
        ?>
        <div class="panel-body">
            <div class="table-responsive">
                <table id="tbl_invoice_table" class="table table-hover table-fixed table-bordered table-primary " style="font-size:13px;">
                    <?php

                    $parent = 1;
                    $total_amount = $total_amtwotax = $total_qty = $total_tax  = $total_tax = 0;
                    $table = '<table id="tbl_invoice_table" class="table table-hover table-fixed table-bordered table-primary " style="font-size:13px;">'
                    ?>
                    <tbody>
                        <?php
                        $cur = MasCurrency::model()->findByPk($currency);
                        $exchange_rate = $cur->exchange_rate;
                        $parent = 1;

                        $main_items = array();
                        if ((int)$ledger_id > 0) {

                            $condition_main = 'voucher_date>= "' . $from_date . '"  AND ledger_id="' . $ledger_id . '"  ';

                            if ((int)$subledger_id > 0) {
                                $condition_main .= ' AND subledger_id=' . $subledger_id;
                            }

                            //  $main_items = Yii::app()->db->createCommand('SELECT subledger_name,subledger_id FROM view_acc_consolidated_statement where ' .  $condition_main . '    group by subledger_id  order by voucher_date Limit 5')->queryAll();


                            $main_items = Yii::app()->db->createCommand('
                                SELECT 
                                    subledger_name,
                                    subledger_id,
                                    (SELECT SUM(balance) 
                                    FROM view_acc_consolidated_statement 
                                    WHERE voucher_date < "' . $from_date . '" 
                                    AND ledger_id = ' . $ledger_id . ' 
                                    AND subledger_id = v.subledger_id) AS opening_bal
                                FROM 
                                    view_acc_consolidated_statement v
                                WHERE ' .  $condition_main . '
                                GROUP BY 
                                    subledger_name, 
                                    subledger_id
                                ')->queryAll();
                        }

                        $total_debit = $total_credit = $closingBalance = 0;


                        if (!empty($main_items)) {
                            foreach ($main_items as $key => $row) {
                                //$opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM view_acc_consolidated_statement where voucher_date<"'.$from_date.'" AND ledger_id = '.$ledger_id.' AND subledger_id = '.$row['subledger_id'].' order by voucher_date')->queryScalar();

                                $opening_bal = (float)$row['opening_bal'];
                        ?>
                                <tr data-id="<?php echo $parent; ?>" data-parent="">
                                    <td style="background-color:#d8f5df;font-size:14px;"><b><?php echo ($key + 1) ?></b></td>
                                    <td colspan="10" style="background-color:#d8f5df;font-size:14px;"> <b><?php echo $row['subledger_name']; ?></b></td>
                                </tr>

                                <?php
                                $child = $parent + 1;
                                ?>
                                <tr data-id="<?php echo $child; ?>" data-parent="<?php echo $parent; ?>">
                                    <th style="width:8%">Date</th>
                                    <th style="width:8%">Invoice No</th>
                                    <th style="width:8%">Voucher Type</th>
                                    <th style="width:10%"><?php echo $type; ?></th>
                                    <th style="width:10%">Reference</th>
                                    <th style="width:5%">DO</th>
                                    <th style="width:5%">LPO</th>
                                    <th style="width:10%">Due Date</th>
                                    <th style="width:10%">Invoice value</th>
                                    <th style="width:10%">Paid</th>
                                    <th style="width:10%">Balance</th>
                                <tr style=" background: #c3c8d1 !important;">
                                    <td colspan="8" class="text-center" style="text-align:right !important;"><b>Opening Balance</b></td>
                                    <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($opening_bal / $exchange_rate), " "); ?></td>
                                    <td style="text-align:right !important;"><?php echo  Yii::app()->numberFormatter->formatCurrency((0 / $exchange_rate), " "); ?></td>
                                    <td class="text-right" style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($opening_bal / $exchange_rate), " "); ?></td>
                                </tr>
                                <?php
                                $child++;
                                $main_subledger_id = $row['subledger_id'];
                                $main_items_child = Yii::app()->db->createCommand('SELECT voucher_id,reference_no,transaction_id,voucher_item_id,voucher_date,due_date,voucher_no,subledger_name,amount,allocated, balance,voucher_type_des,voucher_type
                                                    FROM 
                                                        view_acc_consolidated_statement
                                                    WHERE 
                                                        subledger_id = ' . $main_subledger_id . ' 
                                                        AND ledger_id = ' . $ledger_id . ' 
                                                        AND voucher_date<= "' . $to_date . '"
                                                        AND voucher_date>= "' . $from_date . '"
                                                        AND balance != 0
                                                    ORDER BY 
                                                        voucher_date')->queryAll();

                                // $main_items_child = array();
                                $i = 0;
                                $amount = $allocated = $balanced = 0;
                                $amount += $opening_bal;
                                $allocated += 0;
                                $balanced += $opening_bal;
                                if (empty($main_items_child)) { ?>
                                    <tr>
                                        <td colspan="11" style="text-align:center !important;background-color:white !important;">Empty</td>
                                    </tr>
                                    <?php  } else {
                                    foreach ($main_items_child as $i => $each) {

                                        $row_id = $key + 1;
                                        $do = '';
                                        $lpo = '';
                                        $inv_no = '';
                                        $model_voucher_type             = new AccVoucherType();
                                        $model_voucher_type_si             = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;


                                        if ($type == 'customer') {
                                            if ($each['voucher_type'] == $model_voucher_type_si) {

                                                $inv = Yii::app()->db->createCommand('SELECT file_id,delivery_ids,0 as order_lpo_no
                                                    FROM 
                                                        erp_invoice
                                                    WHERE 
                                                        id = ' . $each['transaction_id'] . ' 
                                                    ')->queryRow();

                                                $ref = $inv['file_id'];
                                                $do = $inv['delivery_ids'];
                                                $lpo = $inv['order_lpo_no'];
                                                $inv_no = '<a href="#" onclick="' . generateUrlx(AccVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $each['transaction_id'] . '</a>';
                                            } else {

                                                $ref = $each['transaction_id'];
                                                $do = '-';
                                                $lpo = '-';
                                                $inv_no = '<a href="#" onclick="' . generateUrlx(AccVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $each['voucher_no'] . '</a>';
                                            }
                                        }


                                    ?>
                                        <tr style="background-color:white !important;">
                                            <td><?php echo  date("d/m/Y", strtotime($each['voucher_date'])) ?></td>
                                            <td><?php echo  $inv_no; ?></td>
                                            <td><?php echo $each['voucher_type_des']; ?></td>
                                            <td><?php echo $each['subledger_name'] ?></td>
                                            <td><?php echo $ref; ?></td>
                                            <td><?php echo $do; ?></td>
                                            <td><?php echo $lpo; ?></td>
                                            <td><?php echo ($each['due_date'] !== "0000-00-00") ? date("d/m/Y", strtotime($each['due_date'])) : "-"; ?></td>
                                            <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($each['amount'] / $exchange_rate), " "); ?></td>
                                            <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($each['allocated'] / $exchange_rate), " "); ?></td>
                                            <td style="text-align:right !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($each['balance'] / $exchange_rate), " "); ?></td>
                                        </tr>
                                <?php $i++;
                                        $amount += $each['amount'] / $exchange_rate;
                                        $allocated += $each['allocated'] / $exchange_rate;
                                        $balanced += $each['balance'] / $exchange_rate;
                                    }
                                }
                                ?>

                                <tr style="background: #c3c8d1 !important; border-bottom: 2px solid black !important;">
                                    <td colspan="8" style="text-align:right !important; border-bottom: 2px solid black !important;"><b>Closing Balance</b></td>
                                    <td style="text-align:right !important; border-bottom: 2px solid black !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($amount / $exchange_rate), " "); ?></td>
                                    <td style="text-align:right !important; border-bottom: 2px solid black !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($allocated / $exchange_rate), " "); ?></td>
                                    <td style="text-align:right !important; border-bottom: 2px solid black !important;"><?php echo Yii::app()->numberFormatter->formatCurrency(($balanced / $exchange_rate), " "); ?></td>
                                </tr>



                            <?php }
                        } else { ?>
                            <td style="text-align:center !important;">Empty</td>
                        <?php } ?>
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>