<!--
chart of accounts
Balance Sheet report
Date 09-04-2025
author -Sebi
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }
    .levelnet {
        background: #a8d08d;
        color: black;
    }
    .levelnetloss {
        background: #e87b7b;
        color: black;
    }
    .to {
        background: rgb(31 103 178);
        color: White;
    }
    .tol1 {
        font-size: 16px !important;
    }
    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }
    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }
    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }
    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }
    .level-5 {
        padding-left: 267px !important;
    }
    .l1 {
        font-size: 17px !important;
    }
    .l2 {
        font-size: 16px !important;
    }
    .l3 {
        font-size: 15px !important;
    }
    .l4 {
        font-size: 14px !important;
    }
    .l5 {
        font-size: 14px !important;
    }
    .txt-right {
        text-align: right !important;
    }
    th, td {
        padding: 5px;
    }
    .level-1, .level-2, .level-3 {
        font-weight: normal !important;
    }
</style>
<table class="table-tree" style="width:100%;">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' is_posted="Y" ';
    $from_date='2020-06-01';
   
    if ($to_date != '') {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
    }

    $condition .= ' AND voucher_date <="' . $to_date . '"';
    /* filter conditions  ----end---- */

    $maincondition ='';
    if($level>0){
        $maincondition .= " AND level <= '{$level}'";
    }

    $modelMasCurrency =  new MasCurrency();
    $auditCloseLedgerResults = isset($balanceSheetDetails['auditCloseLedgerResults'])?$balanceSheetDetails['auditCloseLedgerResults']:array();
    $net_profit_acc_no = isset($balanceSheetDetails['net_profit_acc_no'])?$balanceSheetDetails['net_profit_acc_no']:'';
    $auditcloseDetailsAll = isset($balanceSheetDetails['auditcloseDetailsAll'])?$balanceSheetDetails['auditcloseDetailsAll']:'';
    
    foreach ($auditCloseLedgerResults as $eachledger) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        if ($eachledger['ledger_main_acc'] == 'AP') {
            if ($eachledger['amount'] > 0) {
                $debit = $eachledger['amount'];
                $style_tr = ' levelnetloss';
            } else {
                $credit = $eachledger['amount'];
                $style_tr = ' levelnet';
            }
        } else {
            if ($eachledger['amount'] > 0) {
                $debit = $eachledger['amount'];
            } else {
                $credit = $eachledger['amount'];
            }
        }
        /* Total Sum needs only level 1 sum*/
        if ($eachledger['level'] == '1' || $eachledger['ledger_main_acc'] == 'AP') {
            /*For showing Totals at end --start*/
            $sum_debit += $debit;
            $sum_credit += $credit;
            /*For showing Totals at end --end*/            
        }
        if ($company < 0 || $company=='') {
            $company = 0;
        }
        if ($eachledger['is_parent'] == 'N') {
            $count =$eachledger['transaction_count'];
        }
        $accountName = '' . $eachledger['ledger_acc_name'] . '';
        $accountNo = $eachledger['ledger_acc_no'];
        $accountLevel = $eachledger['level'];
        if ($eachledger['ledger_main_acc'] == 'AP') {
            $accountName = 'NET PROFIT';
            $accountNo = $net_profit_acc_no;
            $accountLevel = 1;
        }
        if($type!='NZ'||abs($debit)>0||abs($credit)>0||$eachledger['level']==1){
            if ($level && $eachledger['level'] <= $level) { ?>
                <tr class="l<?= $accountLevel.$style_tr; ?> level<?= $accountLevel; ?>">
                    <td class="l1"><?= $accountNo; ?></td>
                    <td class="level-<?= $accountLevel; ?> l<?= $accountLevel; ?>"><?= $accountName; ?></td>
                    <td  class="txt-right l<?= $accountLevel; ?>"><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit)); ?></td>
                    <td  class="txt-right l<?= $accountLevel; ?>"><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit));  ?></td>
                </tr>
                <?php if ($eachledger['ledger_main_acc'] == 'AP') {
                    if ($auditcloseDetailsAll) {
                        $accountLevel = 2;
                        $style_tr = '';
                        foreach ($auditcloseDetailsAll as $ada => $auditcloseDetails) {
                            if ($auditcloseDetails['netprofit'] > 0) {
                                $debit = $auditcloseDetails['netprofit'];
                            } else {
                                $credit = $auditcloseDetails['netprofit'];
                            } ?>
                            <tr class="l<?= $accountLevel.$style_tr; ?> level<?= $accountLevel; ?>">
                                <td class="l1"><?php //echo $accountNo; ?></td>
                                <td class="level-<?= $accountLevel; ?> l<?= $accountLevel; ?>"><?= $auditcloseDetails['name']; ?></td>
                                <td  class="txt-right l<?= $accountLevel; ?>"><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit)); ?></td>
                                <td  class="txt-right l<?= $accountLevel; ?>"><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></td>
                            </tr>
                        <?php }
                    }
                }
            }
        }
    } ?>
    <tr>
        <td></td><td></td><td></td><td></td>
    </tr>
    <tr class="to tol1"><td></td><td>Total</td>
        <td  class="txt-right  "><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat($sum_debit); ?></td>
        <td  class="txt-right "><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($sum_credit)); ?></td>
    </tr>
</table>