<!-- // chart of accounts 
//  audit close report
// date 24-03-2025
// author -Sebi 
// main setup -->
<style type="text/css">
    .table-tree {
        width: 100%;
        text-align: left;
        padding-left: 10px !important;
        font-size: 12px;
        border-collapse: collapse;
        border-spacing: 0;
    }

    .table-tree th {
        padding-top: 5px;
        padding-bottom: 5px;
        border-top: 1px solid #000;
        border-bottom: 1px solid #000;
    }

    .table-tree th,
    td {
        border-left: 0;
        border-right: 0;
        margin: 0;
        padding: 3px 5px;
    }

    .ze {
        background: #CCC
    }

    .box-pad,
    .box-pad * {
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
    }

    .tre td {
        border: none;
    }

    .tittle {
        width: 100%;
        margin: 10px 0;
        float: left;
        text-align: center;
    }

    .tittle h6 {
        border-bottom: 2px solid #000;
        width: 150px;
        max-width: 400px;
        font-size: 16px;
        margin: 10px auto;
    }

    .date {
        width: 100%;
        float: left;
        font-size: 11px;
        padding-left: 5px;
        font-weight: 600;
        text-align: left;
        padding-bottom: 3px;
    }

    .date span {
        width: 200px;
        display: inline-block;
    }

    .clear {
        clear: both;
    }

    .cell-left {
        text-align: left !important;
    }

    .cell-right {
        text-align: right !important;
    }

    .br-top {
        border-top: 1px solid #000 !important;
        border-bottom: 3px double #000 !important;
    }

    .space {
        width: 100%;
        float: left;
        clear: both;
        height: 5px;
    }

    .col-6 {
        width: 50%;
    }

    .col-9 {
        width: 75%
    }

    .col-3 {
        width: 25%;
    }

    .f-l {
        float: left;
    }

    .f-r {
        float: right;
    }

    .txt-right {
        text-align: right;
    }

    .txt-left {
        text-align: left;
    }

    .x-space {
        box-sizing: border-box;
    }

    .bg-w {
        background: #FFF !important;
    }

    .footer {
        width: 100%;
        float: left;
        font-size: 11px;
        position: absolute;
        bottom: 0px;
        left: 0px;
        text-align: center !important;
        line-height: 18px;
        border-top: 1px dotted #000;
        padding: 5px;
    }

    .span1 {
        width: 80px !important;
        display: inline-block;
        float: left;
    }

    .span2 {
        width: 80px !important;
        display: inline-block;
        float: left;
    }

    .span3 {
        width: auto !important;
        display: inline-block;
        float: left;
    }

    .pro {
        background: #ccffdf;
    }

    .loss {
        background: #ffb4b4;
    }

    .cy {
        background: #cdcdcd;
    }

    .py {
        background: #ececec;
    }

    .to {
        background: #f1f1f1;
    }
</style>
<script src="js/jquery.aCollapTable.js"></script>

<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("loadPage", "function loadPage(){
    var ledger_id = $('#acc_auditclose_date').val();
    if(ledger_id==''){
        t8.error('Please Select Auditclose Date');
        return false;
    } else {
        $('#loader').show();
        jQuery.ajax({
            'type': 'post',
            'url': '" . Yii::app()->createUrl('accounts/reports/Auditclose_detailed_html') . "',
            'data' : { 'ac_id' : $('#acc_auditclose_date').val() },
            'success': function(data) {
                $('#data_div').show();
                $('.main-li-data').html(data);
                $('#loader').hide();
                $('#tb_table').aCollapTable({
                    startCollapsed: true,
                    addColumn: false,
                    plusButton: '<i class=\"fa fa-plus\"></i>&nbsp;', 
                    minusButton: '<i class=\"fa fa-minus\"></i>&nbsp;' 
                });
                
                $('#pl_table_2').aCollapTable({
                    startCollapsed: false,
                    addColumn: false,
                    plusButton: '<i class=\"fa fa-plus\"></i>&nbsp;', 
                    minusButton: '<i class=\"fa fa-minus\"></i>&nbsp;' 
                });
            }
        });
    }
}", CClientScript::POS_HEAD);
?>

<style>
    table {
        font-family: arial, sans-serif !important;
        border-collapse: collapse !important;
        width: 100% !important;
    }

    td,
    th {
        border: 1px solid #dddddd !important;
        text-align: left !important;
        padding: 8px !important;
    }

    table th {
        padding-top: 12px;
        padding-bottom: 12px;
        text-align: left;
        background-color: #1f67b2;
        color: white;
    }
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <span class="rpt-sub-panel-title" id="span_sales_title"> Auditclose Trial Balance</span> <br>
            </header>
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-3">
                        <?php echo CHtml::dropdownlist("acc_auditclose_date", '', $auditclose_ranges, array('class' => 'tooltipster', 'data-label' => 'Auditclose Date')); ?>
                    </li>
                    <?php if ($auditclose_ranges){ ?>
                        <div class="btn-wrap text-center">
                            <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">VIEW</a>
                            <a type="button" class="btn btn-sm btn-theme"
                                onclick="var liveSite = $('#liveSite').val();
                                    var acc_auditclose_date = $('#acc_auditclose_date').val();
                                    var url = liveSite + 'index.php?r=accounts/pdf/Auditclose_detailed_pdf' + '&ac_id=' + encodeURIComponent(acc_auditclose_date);
                                    window.open(url, '_blank');">
                                PDF
                            </a>
                            <a type="button" class="btn btn-sm btn-theme"
                                onclick="
                                    var liveSite = $('#liveSite').val();
                                    var acc_auditclose_date = $('#acc_auditclose_date').val();
                                    var url = liveSite + 'index.php?r=accounts/excel/Auditclose_detailed_Excel' + '&ac_id=' + encodeURIComponent(acc_auditclose_date);
                                    window.open(url, '_blank');">
                                XLS
                            </a>
                        </div>
                    <?php } ?>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;">
                <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
                    <li id="tb_li" class="main-li active"><a href="#tb_tab" data-toggle="tab">Auditclose Trial Balance</a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane main-li-data active" id="tb_tab"></div>
                </div>
            </div>
        </section>
    </div>
</div>
