<?php

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'sale-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
$cs = Yii::app()->getClientScript();
$cs->registerScript("getSubledgerdiv", "function getSubledgerdiv(field_id,value,type){
        var arr_field_id = field_id.split('_');
        var no = arr_field_id[1];
        jQuery.ajax({
            'type': 'post',
            'url': '" . Yii::app()->createUrl('finance/core/getsubledgers') . "',
            'data' : {'account' : value,'i' : no, 'model' : 'AccSystemAccountsMapping', 'field' : 'subledger_id'},
            'success': function(data) { 
                     $('#'+type+no).html(data);
            }
        });
    }", CClientScript::POS_HEAD);

$cs->registerScript("autoCompleteLedger", "function autoCompleteLedger(field_id,frm)
{
    var ledger_id =$('#AccSystemAccountsMapping_account_id').val();
    if(ledger_id==''){
        t8.error('Please select a Ledger'); 
        return false;
    }
    else{ 
        var arr_fields= field_id.split('_');
        var model_name   = arr_fields[0];
        var row_field  = arr_fields[1];
        var all_str  = $('#'+field_id).val();

        var url = '" . Yii::app()->createUrl('accounts/accounts/GetLedgerDetails') . "'+'&ledger_id='+ledger_id+'&frm='+frm;
        $('#'+field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id  	=   $(event.target).attr('id');
                var ledger_id=ui.item.value; 
              

                var have_subledger= ui.item.have_subledger; 
                var subledger_types=ui.item.subledger_types;  
                
                $('#AccSystemAccountsMapping_'+row_field+'_account_id').val(ledger_id);

                if(ledger_id > 0){
                
                
                    jQuery.ajax({
                       'type': 'post',
                       'dataType': 'json',
                       'url': '" . Yii::app()->createUrl('accounts/accounts/Getsubledgerdrop') . "',
                       'data': {'row_field' : row_field, 'ledger_id' : ledger_id,'subledger_types':subledger_types,'have_subledger':have_subledger},
                       'cache': false,
                       'success': function(data) {
                           $('#subledger_'+row_field).html(data.drop);
                           return false;
                       }
                    });
                  
                 
                }                     
              
      
            }
        })
    }
}", CClientScript::POS_HEAD);
?>
<div id="div_service_item_details">
    <div class="table-responsive" style="max-height:500px">
        <table class="table table-hover table-bordered personal-task" id="order_item_table">
            <tr>
                <th style="width:30%">Name</th>
                <th style="width:30%">Account</th>
                <th style="width:20%">Subledger</th>
                <th style="width:30%">Last Account No</th>
            </tr>
            <?php $systemmappings = AccSystemAccountsMapping::model()->findAll(array('order' => 'id')); ?>
            <?php foreach ($systemmappings as $i => $each) { ?>
                <tr>
                    <td>
                        <?php echo $form->hiddenField($each, "[" . $i . "]id"); ?>
                          <?php echo $form->hiddenField($each, "[" . $i . "]attribute"); ?>
                        <?php echo $form->textField($each, "[" . $i . "]description", array('class' => 'form-control go', 'readonly' => true)); ?>
                    </td>
                    <td>
                        <?php //echo $form->dropdownlist($each, "[".$i."]account_id", AccLedger::getChilds(), array('class'=>'qty go', 'onChange' => 'js:getSubledgerdiv(this.id,this.value,"debit_")')); 
                        ?>

                        <?php
                        if ($each->account_id > 0) {
                            $data = $each->account_id;
                        } else {
                            $data = 0;
                        }
                        $acc_ledger_det = AccLedger::model()->findByPk($data);
                        $ledger_name =  $acc_ledger_det->ledger_acc_name;


                        echo $form->textField($each, "[" . $i . "]ledger_name", array('class' => 'form-control go', 'value' => $ledger_name, 'onKeyup' => 'js:autoCompleteLedger(this.id,"AccSystemAccountsMapping");', 'placeholder' => 'Type & Select'));

                        ?>
                        <?php echo $form->hiddenField($each, "[" . $i . "]account_id"); ?>


                    </td>

                    <td id="subledger_<?php echo $i; ?>">

                        <?php
                        $data = array();
                        if ($each->account_id > 0) {
                            $acc_ledger_det = AccLedger::model()->findByPk($each->account_id);
                            $subledger_types = $acc_ledger_det->subledger_types;
                            // $subledger_types_array = AccSubledgerType::getDropSublegdertypes($subledger_types);
                            $subledger_types_array = AccSubledger::getDropSublegder($subledger_types);

                            ($subledger_types_array != '') ? $data = $subledger_types_array : $data = array();
                        }
                        ?>
                        <?php echo $form->dropdownlist($each, "[" . $i . "]subledger_id", $data, array('class' => 'form-control go','empty'=>'-Select-')); ?>


                    </td>


                    <td >
                    <?
                     if ($each->last_account_id > 0) {
                        $data1 = $each->last_account_id;
                    } else {
                        $data1 = 0;
                    }
                    $acc_ledger_det = AccLedger::model()->findByPk($data1);
                    $ledger_acc_no =  $acc_ledger_det->ledger_acc_no;

                    
                      
                        ?>

                     
                        <?php echo $form->textField($each, "[" . $i . "]last_account_id", array('class' => 'form-control go','value'=>$ledger_acc_no, 'disabled' => true)); ?>
                    </td>
                </tr>
            <?php } ?>
        </table>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
  
<?php
    $url = Yii::app()->createUrl('accounts/accounts/savemapping');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            $("#sale-form .rack-save-btn").prop("disabled", false);                      
            $("#sale-form .rack-save-btn").addClass("btn-theme").removeClass("btn_loding");
            if (data.status == "success") {
                $(".x.close").click();
                t8.success("Saved Successfully!");
                reloadTable("#tbl_rack_details");
            } else if (data.status == "warning") {
                if (confirm(data.message)) {
                    saveMappingWithConfirmation();
                } else {
                    $.each(data.errors, function(key, val) {
                        $("#rack-form #" + key + "_em_").text(val).show();
                        t8.error("" + val + ""); 
                    });
                }
            } else if (data.status == "error") {
                $.each(data.errors, function(key, val) {
                    $("#rack-form #" + key + "_em_").text(val).show();
                    t8.error("" + val + "");
                });
            }
        }',
        'beforeSend' => 'function() { 
            $("#loader").show();
            $("#sale-form .rack-save-btn").prop("disabled", true);                      
            $("#sale-form .rack-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'rack-save-btn btn btn-theme'));
?>


<script>
  function saveMappingWithConfirmation() {
    var url = '<?php echo Yii::app()->createUrl('accounts/accounts/savemapping'); ?>';
    $.ajax({
        type: 'POST',
        url: url,
        data: $('#sale-form').serialize() + '&confirm=true',
        dataType: 'json',
        success: function(data) {
            $("#loader").hide();
            $("#sale-form .rack-save-btn").prop("disabled", false);                      
            $("#sale-form .rack-save-btn").addClass("btn-theme").removeClass("btn_loding");
            if (data.status == "success") {
                $(".x.close").click();
                t8.success("Saved Successfully!");
                reloadTable("#tbl_rack_details");
            } else {
                $.each(data.errors, function(key, val) {
                    $("#rack-form #" + key + "_em_").text(val).show();
                    t8.error("" + val + "");
                });
            }
        },
        beforeSend: function() { 
            $("#loader").show();
            $("#sale-form .rack-save-btn").prop("disabled", true);                      
            $("#sale-form .rack-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
        }
    });
}

</script>

    </div>
    <?php $this->endWidget(); ?>