<?php

/* date 21-09-2022
author     -Indhu 
main setup
Tables     - mas_dimension_setting 
Controller - MasdimensionsettingController
 */

/**
 * This is the model class for table "{{mas_dimension_setting}}".
 *
 * The followings are the available columns in table '{{mas_dimension_setting}}':
 * @property integer $id
 * @property string $dimension
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class MasDimensionSetting extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{mas_dimension_setting}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('dimension', 'required'),
            array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
            array('dimension', 'length', 'max'=>255),
            array('isActive', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, dimension, isActive, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'dimension' => 'Dimension',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
            'updated_by' => 'Updated By',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('dimension',$this->dimension,true);

        $criteria->compare('isActive',$this->isActive,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('created_datetime',$this->created_datetime,true);
        $criteria->compare('updated_by',$this->updated_by);
        $criteria->compare('updated_datetime',$this->updated_datetime,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasDimensionSetting the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}