<?php

//  Voucher master setting
//  
//  date 21-09-2022
//  author -Indhu 
//  main setup
//  Tables - acc_voucher_master_setting
//  Controller - VouchermastersettingController

/**
 * This is the model class for table "{{acc_voucher_master_setting}}".
 *
 * The followings are the available columns in table '{{acc_voucher_master_setting}}':
 * @property integer $id
 * @property integer $type_id
 * @property integer $leder_id
 * @property integer $subledger_id
 * @property integer $serial_no
 * @property string $debit
 * @property string $credit
 * @property string $narration
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class AccVoucherMasterSetting extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_voucher_master_setting}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type_id, leder_id, subledger_id, debit, credit,serial_no', 'required'),
                        array('serial_no', 'unique'),

            array('type_id, leder_id,serial_no,subledger_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
            array('debit, credit', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, type_id, leder_id, serial_no,subledger_id, debit, credit, narration, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            
            'vouchertype_det' => array(self::BELONGS_TO, 'AccVoucherType', 'type_id'),
            'ledger_det' => array(self::BELONGS_TO, 'AccLedger', 'leder_id'),
            'subledger_det' => array(self::BELONGS_TO, 'AccSubledger', 'subledger_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'type_id' => 'Type',
            'leder_id' => 'Leder',
            'subledger_id' => 'Subledger',
            'debit' => 'Debit',
            'credit' => 'Credit',
            'narration' => 'Narration',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
            'updated_by' => 'Updated By',
            'updated_datetime' => 'Updated Datetime',
              'serial_no' => 'Serial No',
            
            
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('type_id',$this->type_id);
        $criteria->compare('leder_id',$this->leder_id);
        $criteria->compare('subledger_id',$this->subledger_id);
        $criteria->compare('debit',$this->debit,true);
        $criteria->compare('credit',$this->credit,true);
        $criteria->compare('narration',$this->narration,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('created_datetime',$this->created_datetime,true);
        $criteria->compare('updated_by',$this->updated_by);
        $criteria->compare('updated_datetime',$this->updated_datetime,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccVoucherMasterSetting the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}