<?php


//  Subledgers
//  
//  date 21-09-2022
//  author -Indhu 
//  main setup
//  Tables - acc_subledger
//  Controller - SubledgersController

/**
 * This is the model class for table "{{acc_subledger}}".
 *
 * The followings are the available columns in table '{{acc_subledger}}':
 * @property integer $id
 * @property integer $reference_id
 * @property string $subledger_name
 * @property integer $subledger_type
 * @property string $is_system
 * @property string $is_editable
 * @property string $last_sync
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class AccSubledger extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{acc_subledger}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reference_id, subledger_name,subledger_type,last_sync', 'required'),
			array('reference_id, subledger_type, created_by, updated_by', 'numerical', 'integerOnly' => true),
			array('subledger_name', 'length', 'max' => 200),
			array('is_system, is_editable', 'length', 'max' => 1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, reference_id, subledger_name,is_system,subledger_type, is_system, is_editable, last_sync, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

			'subledgertype' => array(self::BELONGS_TO, 'AccSubledgerType', 'subledger_type'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'reference_id' => 'id taken from vendor or customer or employee',
			'subledger_name' => 'Subledger Name',
			'subledger_type' => 'Subledger Type',
			'is_system' => 'System Generated',
			'is_editable' => 'Is Editable',
			'last_sync' => 'Last Sync',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('reference_id', $this->reference_id);
		$criteria->compare('subledger_name', $this->subledger_name, true);
		$criteria->compare('subledger_type', $this->subledger_type);
		$criteria->compare('is_system', $this->is_system, true);
		$criteria->compare('is_editable', $this->is_editable, true);
		$criteria->compare('last_sync', $this->last_sync, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_datetime', $this->created_datetime, true);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('updated_datetime', $this->updated_datetime, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AccSubledger the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	public static function getSubledger()
	{
		// $condition = 't.isActive =  "Y"';
		$condition = '1=1';
		$model = self::model()->findAll(array('condition' => $condition, 'order' => 'subledger_name'));
		return CHtml::listData($model, 'id', 'subledger_name');
	}

	public static function getSubledgers($account_id)
	{
		//  to get subledgers list  From subledger by using  AccLedger->subledger_types
		$arr_data = array();
		if ($account_id > 0) {
			$modelAccLedger = new AccLedger();
			$accounts = $modelAccLedger->findbyPk($account_id);		
			if ($accounts->subledger_types != '' && $accounts->have_subledger == 'Y') {			
				$model = self::model()->findAll(array('condition' => 'subledger_type IN (' . $accounts->subledger_types . ')'));
				$arr_data =  CHtml::listData($model, 'id', 'subledger_name');
			}
		}
		return $arr_data;
	}

	/*
	---------added by jisha-------------14/11/22-----
	---------to get subledger_id From subledger_type and customer_vendor_id
	*/

	public static function getsubledgerFromledgerandtype($type, $customer_vendor_id)
	{
		$model = self::model()->find(array('condition' => 'subledger_type =' . $type . ' AND  reference_id=' . (int)$customer_vendor_id));
		return $model->id;
	}


	// ------------------updated- by-indhu-17-11-2022---------------------------------

	public function saveCustomerSubledger()
	{

		//  synchronizing All Customers As  sub-ledger

		$modelCustomer   = new Customer();
        $modelCustomer   = $modelCustomer->findAll(array('condition'=>'isActive="Y"'));
		$modAccSubledgerType  = new AccSubledgerType();
		$subledger_type_id    = $modAccSubledgerType->getIdFromType('C');
		foreach ($modelCustomer as $eachcustomer) {
			$condition  = ' t.subledger_type=' . $subledger_type_id;
			$condition .= ' AND t.reference_id=' . $eachcustomer->id;
			$modelAccSubledger = new AccSubledger();
			$modelAccSubledger_det = $modelAccSubledger->find(array('condition' => $condition));
			if ((int)$modelAccSubledger_det->id > 0) {
				$id = $modelAccSubledger_det->id;
				$modelAccSubledger = $modelAccSubledger->findByPk($id);
				$modelAccSubledger->updated_by = Yii::app()->user->id;
				$modelAccSubledger->updated_datetime = date('Y-m-d h:i:s');
			} else {
				$modelAccSubledger->created_by = Yii::app()->user->id;
				$modelAccSubledger->created_datetime = date('Y-m-d h:i:s');
			}
			$modelAccSubledger->subledger_type      = $subledger_type_id;
			$modelAccSubledger->reference_id        = $eachcustomer->id;
			$modelAccSubledger->subledger_name      =  $eachcustomer->customer_name;
			$modelAccSubledger->is_system           = 'Y';
			$modelAccSubledger->last_sync            = date('Y-m-d');

			$modelAccSubledger->save(false);
			$data = "success";
		}
		return $data;
	}


	public function saveVendorSubledger()
	{
		//  synchronizing All vendors As  sub-ledger

		$modelSupplier   = new Vendor();
		//$modelSupplier   = $modelSupplier->findAll();
        $modelSupplier   = $modelSupplier->findAll(array('condition'=>'isActive="Y"'));

		$modAccSubledgerType            = new AccSubledgerType();
		$subledger_type_id              = $modAccSubledgerType->getIdFromType('V');
		foreach ($modelSupplier as $eachSupplier) {
			$condition  = ' t.subledger_type=' . $subledger_type_id;
			$condition .= ' AND t.reference_id=' . $eachSupplier->id;
			$modelAccSubledger = new AccSubledger();
			$modelAccSubledger_det = $modelAccSubledger->find(array('condition' => $condition));
			if ((int)$modelAccSubledger_det->id > 0) {
				$id                                  = $modelAccSubledger_det->id;
				$modelAccSubledger                   = $modelAccSubledger->findByPk($id);
				$modelAccSubledger->updated_by       = Yii::app()->user->id;
				$modelAccSubledger->updated_datetime = date('Y-m-d h:i:s');
			} else {
				$modelAccSubledger->created_by       = Yii::app()->user->id;
				$modelAccSubledger->created_datetime = date('Y-m-d h:i:s');
			}
			$modelAccSubledger->subledger_type       = $subledger_type_id;
			$modelAccSubledger->reference_id         = $eachSupplier->id;
			$modelAccSubledger->subledger_name       = $eachSupplier->vendor_name;
			$modelAccSubledger->is_system            = 'Y';
			$modelAccSubledger->last_sync            = date('Y-m-d');

			$modelAccSubledger->save(false);
			$modelAccSubledger = "success";
			$data = "success";
			// --------------------
		}
		return $data;
	}


	public function saveEachSubledgder($mainid, $name, $type)
	{
		//  synchronizing Each customer and vendor  As sub-ledger

		$modAccSubledgerType   = new AccSubledgerType();
		
		$subledger_type_id = (int)$modAccSubledgerType->getIdFromType($type);

		$condition             = ' t.subledger_type='.$subledger_type_id.' AND t.reference_id=' . $mainid;
		$modelAccSubledger     = new AccSubledger();
		$modelAccSubledger_det = $modelAccSubledger->find(array('condition' => $condition));

		if ((int)$modelAccSubledger_det->id > 0) {
			$id = $modelAccSubledger_det->id;
			$modelAccSubledger                   = $modelAccSubledger->findByPk($id);
			$modelAccSubledger->updated_by       = Yii::app()->user->id;
			$modelAccSubledger->updated_datetime = date('Y-m-d h:i:s');
			$modelAccSubledger->old_name         = $modelAccSubledger->subledger_name;
		} else {
			$modelAccSubledger->created_by       = Yii::app()->user->id;
			$modelAccSubledger->created_datetime = date('Y-m-d h:i:s');
		}
		$modelAccSubledger->subledger_type       = $subledger_type_id;
		$modelAccSubledger->reference_id         = $mainid;
		$modelAccSubledger->subledger_name       = $name;
		$modelAccSubledger->save(false);
	}



	// ---------------------------------------------------

	// ------------added- by-indhu-05-11-2022---------------------------
	public static function getDropSublegder($subledger_types)
	{
		// to get subledgers list by passing subledger_types from AccLedger
        $arr_data=[];
		if (!empty($subledger_types)) {
		    $model = self::model()->findAll(array('condition' => 'subledger_type IN (' . $subledger_types . ')', 'order' => 'subledger_name ASC'));
			$arr_data =  CHtml::listData($model, 'id', 'subledger_name');
		}
		return $arr_data;
	}





	// --------------------------------------------


	public function getOverDueCheck($customer_id = null)
	{
		$status = 0;
		if ($customer_id > 0) {
			$subledger_id = self::model()->find(array('condition' => 'subledger_type=1 AND reference_id=' . $customer_id))->id;
			if ($subledger_id > 0) {
				$to_date = date('Y-m-d');
				$fmapping = new AccSystemAccountsMapping();
				$ledger_id = $fmapping->getSystemdefault('debtors');
				$amountType = 'VI.amount > 0';
				$paidType = 'VI.amount < 0';
				$query = 'CREATE OR REPLACE VIEW {{acc_statement}} AS (SELECT
						V.id AS voucher_id,
						V.voucher_date AS voucher_date,
						V.due_date AS due_date,
						V.reference_no AS reference_no,
						VI.narration AS narration,
						VI.id AS voucher_item_id,
						V.voucher_no,
						-- ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
						-- ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
						-- ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance

						ROUND(ABS(VI.amount*V.exchange_rate), 4) AS amount,
						ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
						ROUND(ABS(VI.amount*V.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
						FROM {{acc_voucher_items}} VI
						LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
						LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
						WHERE V.is_posted ="Y" AND V.voucher_date<="' . $to_date . '"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
						GROUP BY VI.id)
						UNION
						(SELECT
							V.id AS voucher_id,
							V.voucher_date AS voucher_date,
							V.due_date AS due_date,
							V.reference_no AS reference_no,
							VI.narration AS narration,
							VI.id AS voucher_item_id,
							V.voucher_no,
							-(ROUND(ABS(VI.amount*V.exchange_rate), 4)) AS amount,
							-(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
							-(ROUND(ABS(VI.amount*V.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
						FROM {{acc_voucher_items}} VI
						LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
						LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
						WHERE V.is_posted ="Y" AND V.voucher_date>="' . $from_date . '" AND V.voucher_date<="' . $to_date . '"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
						GROUP BY VI.id)';
				Yii::app()->db->createCommand($query)->execute();
				$items = Yii::app()->db->createCommand('SELECT voucher_id FROM {{acc_statement}} where due_date<"' . $to_date . '" AND balance>0 limit 1')->queryScalar();
				if ($items > 0) {
					$status = 'Yes';
				} else {
					$status = 'No';
				}
			} else {
				$model = Customer::model()->findByPk($customer_id);
				$model->saveSublegder();
				$status = 'No';
			}
			return $status;
		}
	}
	
	
	 public static function getEmployeeSubledgers(){
		$arr_data = array();
		//type="E" employee
	    $modelAccSubledgerType              = new AccSubledgerType ();
        $modelAccSubledgerType             = $modelAccSubledgerType->find(array('condition' => 'type="E"'));
		$model = self::model()->findAll(array( 'condition' => 'subledger_type='.$modelAccSubledgerType->id.' AND subledger_name NOT  LIKE "%- CRM%"'));
		$arr_data =  CHtml::listData($model, 'id', 'subledger_name');
		return $arr_data;
	}
	
	
		public function saveEmployeeSubledger()
	{
		//  synchronizing All Employee As sub-ledger

		$modelUser = new User();
		$modelUser                      = $modelUser->findAll(array('condition'=>'isActive="Y" AND company_id='.(int) Yii::app()->user->master_user_company_id.''));
		
		
		$modelhrEmployee = new Employee();
	//	$modelhrEmployee  = $modelhrEmployee->findAll(array('condition'=>'isActive="Y" AND employee_wps_company='.(int) Yii::app()->user->master_user_company_id.''));
		$modelhrEmployee  = $modelhrEmployee->findAll(array('condition'=>'isActive="Y"'));

	
		$modAccSubledgerType            = new AccSubledgerType();
		$subledger_type_id              = $modAccSubledgerType->getIdFromType('E');
		foreach ($modelUser as $eachuser) {
			$condition  = ' t.subledger_type=' . $subledger_type_id.' AND t.reference_id=' . (int)$eachuser->id;
			$modelAccSubledger = new AccSubledger();
			$modelAccSubledger_det = $modelAccSubledger->find(array('condition' => $condition));
			if ((int)$modelAccSubledger_det->id > 0) {
				$id                                  = $modelAccSubledger_det->id;
				$modelAccSubledger                   = $modelAccSubledger->findByPk($id);
				$modelAccSubledger->updated_by       = Yii::app()->user->id;
				$modelAccSubledger->updated_datetime = date('Y-m-d h:i:s');
				$modelAccSubledger->old_name         = $modelAccSubledger->subledger_name;
			} else {
				$modelAccSubledger->created_by       = Yii::app()->user->id;
				$modelAccSubledger->created_datetime = date('Y-m-d h:i:s');
			}
			$modelAccSubledger->subledger_type       = $subledger_type_id;
			$modelAccSubledger->reference_id         = $eachuser->id;
			//$modelAccSubledger->subledger_name       = $eachuser->employeefullname;
			$modelAccSubledger->subledger_name       = $eachuser->fullname;
			$modelAccSubledger->is_system            = 'Y';
			$modelAccSubledger->last_sync            = date('Y-m-d');
			
			

			$modelAccSubledger->save(false);
			$modelAccSubledger = "success";
			$data = "success";
			// --------------------
		}
		return $data;
	}
	
	
		public function saveEmployeeSubledger_old()
	{
		//  synchronizing All Employee As sub-ledger

		$modelUser = new User();
		$modelUser                      = $modelUser->findAll(array('condition'=>'isActive="Y" AND company_id='.(int) Yii::app()->user->master_user_company_id.''));
		$modAccSubledgerType            = new AccSubledgerType();
		$subledger_type_id              = $modAccSubledgerType->getIdFromType('E');
		foreach ($modelUser as $eachuser) {
			$condition  = ' t.subledger_type=' . $subledger_type_id.' AND t.reference_id=' . (int)$eachuser->id;
			$modelAccSubledger = new AccSubledger();
			$modelAccSubledger_det = $modelAccSubledger->find(array('condition' => $condition));
			if ((int)$modelAccSubledger_det->id > 0) {
				$id                                  = $modelAccSubledger_det->id;
				$modelAccSubledger                   = $modelAccSubledger->findByPk($id);
				$modelAccSubledger->updated_by       = Yii::app()->user->id;
				$modelAccSubledger->updated_datetime = date('Y-m-d h:i:s');
				$modelAccSubledger->old_name         = $modelAccSubledger->subledger_name;
			} else {
				$modelAccSubledger->created_by       = Yii::app()->user->id;
				$modelAccSubledger->created_datetime = date('Y-m-d h:i:s');
			}
			$modelAccSubledger->subledger_type       = $subledger_type_id;
			$modelAccSubledger->reference_id         = $eachuser->id;
			$modelAccSubledger->subledger_name       = $eachuser->Fullname;
			$modelAccSubledger->is_system            = 'Y';
			$modelAccSubledger->last_sync            = date('Y-m-d');
			
			

			$modelAccSubledger->save(false);
			$modelAccSubledger = "success";
			$data = "success";
			// --------------------
		}
		return $data;
	}
	
		public  function related_ledgers(){
		$query = 'SELECT GROUP_CONCAT(ledger_acc_name SEPARATOR "<br>") AS parents FROM {{acc_ledger}} WHERE FIND_IN_SET('.$this->subledger_type.', subledger_types)';
		$response = Yii::app()->db->createCommand($query)->queryAll();
		return $response[0]['parents'];
	}
	// ------------added- by-jisha-22-3-2023---------------------------
    public static function getSubledgerdropdownwithAmount($subledger_types,$ledger_id){
        // to get subledgers list by passing subledger_types from AccLedger
        $arr_data=[];
		if (!empty($subledger_types)) {
		    $model = self::model()->findAll(array('condition' => 'subledger_type IN (' . $subledger_types . ')', 'order' => 'subledger_name ASC'));
			foreach ($model as $i => $each) {
			    $ledgers=Yii::app()->db->createCommand("select SUM(I.amount) AS amount from {{acc_voucher_items}} AS I LEFT JOIN {{acc_voucher}} AS H ON I.acc_voucher_id=H.id where H.is_posted='Y' AND I.ledger_id=".(int)$ledger_id." AND I.subledger_id=".(int)$each['id'])->queryScalar();
                $arr_data[$each['id']] = $each['subledger_name'].' : AED '.(float)$ledgers;
			}
		}
		return ($arr_data);
    }
    
    
    	public function saveAgentSubledger()
	{
		//  synchronizing All Agent As sub-ledger

		$modelAgent = new MasAgentCode();
		$modelAgent                      = $modelAgent->findAll(array('condition'=>'Is_Active="Y" '));
		$modAccSubledgerType            = new AccSubledgerType();
		$subledger_type_id              = $modAccSubledgerType->getIdFromType('AG');
		foreach ($modelAgent as $eachuser) {
			$condition  = ' t.subledger_type=' . $subledger_type_id.' AND t.reference_id=' . (int)$eachuser->id;
			$modelAccSubledger = new AccSubledger();
			$modelAccSubledger_det = $modelAccSubledger->find(array('condition' => $condition));
			if ((int)$modelAccSubledger_det->id > 0) {
				$id                                  = $modelAccSubledger_det->id;
				$modelAccSubledger                   = $modelAccSubledger->findByPk($id);
				$modelAccSubledger->updated_by       = Yii::app()->user->id;
				$modelAccSubledger->updated_datetime = date('Y-m-d h:i:s');
				$modelAccSubledger->old_name         = $modelAccSubledger->subledger_name;
			} else {
				$modelAccSubledger->created_by       = Yii::app()->user->id;
				$modelAccSubledger->created_datetime = date('Y-m-d h:i:s');
			}
			$modelAccSubledger->subledger_type       = $subledger_type_id;
			$modelAccSubledger->reference_id         = $eachuser->id;
			$modelAccSubledger->subledger_name       = $eachuser->agent_name;
			$modelAccSubledger->is_system            = 'Y';
			$modelAccSubledger->last_sync            = date('Y-m-d');
			$modelAccSubledger->save(false);
			$modelAccSubledger = "success";
			$data = "success";
			// --------------------
		}
		return $data;
	}

}
