<?php
/*
 chart of accounts
 payment ledger, Save
 date 18-11-2022
 author -Indhu
 main setup
 Tables    - erp_acc_payment_ledger
 Controller used   - paymentledgerController

 */

/**
 * This is the model class for table "{{acc_payment_ledger}}".
 *
 * The followings are the available columns in table '{{acc_payment_ledger}}':
 * @property integer $id
 * @property string $attribute
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class AccPaymentLedger extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_payment_ledger}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('attribute', 'required'),
            array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
            array('attribute', 'unique'),
            array('attribute', 'length', 'max'=>255),
            array('isActive', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, attribute, isActive, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'attribute' => 'Attribute',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_datetime' => 'Created Datetime',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('attribute',$this->attribute,true);
        $criteria->compare('isActive',$this->isActive,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('updated_by',$this->updated_by);
        $criteria->compare('created_datetime',$this->created_datetime,true);
        $criteria->compare('updated_datetime',$this->updated_datetime,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccPaymentLedger the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public static function getAccPaymentLedgers() {

         $condition = 't.isActive =  "Y"';
         $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
         return CHtml::listData($model, 'id', 'attribute');
     }
     
    //-----------------------------------------------
        // get all Payment Ledgers but its name take from erp_acc_system_accounts_mapping
    //-----------------------------------------------
     
     public static function getAllaccPaymentLedgers() {
         $condition = 't.isActive =  "Y"';
         $model = Yii::app()->db->createCommand('SELECT PL.id AS id,AM.description AS attribute  FROM  erp_acc_payment_ledger PL
                                                LEFT JOIN  erp_acc_system_accounts_mapping AM
                                                ON PL.attribute= AM.attribute WHERE PL.isActive="Y"')->queryAll();
         return CHtml::listData($model, 'id', 'attribute');
     }
     
     
         // ----------added -by-indhu-15-03-2023----------------------------

      public static function getAccModePaymentLedgers($ledger_id) {
         $model = Yii::app()->db->createCommand('SELECT PL.id AS id,AM.description AS attribute  FROM  erp_acc_payment_ledger PL
                                                LEFT JOIN  erp_acc_system_accounts_mapping AM
                                                ON PL.attribute= AM.attribute WHERE PL.isActive="Y" AND AM.account_id = '. $ledger_id . '')->queryAll();
         return CHtml::listData($model, 'id', 'attribute');
     }
     
     
}