<?php


/**
 * This is the model class for table "{{acc_audit_close}}".
 *
 * The followings are the available columns in table '{{acc_audit_close}}':
 * @property integer $id
 * @property string $year
 * @property integer $created_by
 * @property string $created_datetime
 */
class AccAuditClose extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_audit_close}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, close_date, created_by, created_datetime', 'required'),
            array('created_by', 'numerical', 'integerOnly' => true),

            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, close_date, created_by, created_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'close_date' => 'close Date',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('year', $this->year, true);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_datetime', $this->created_datetime, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FinanceAuditClose the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public static function lastClosedDate_id()
    {
        return self::model()->find(array('condition' => "closed='PRE'", 'order' => 'id DESC'))->id;
    }

    public static function getClosingyear()
    {
        //	return self::model()->find( array( 'order'=>'id DESC' ) )->year+1;
    }

    public static function lastClosedDate()
    {
        return self::model()->find(array('condition' => "closed='PRE'", 'order' => 'id DESC'))->close_date;
    }

    public static function lastNewClosedDate()
    {
        $lastRecord = self::model()->find(array('condition' => "closed='PRE'", 'order' => 'id DESC'));
        if ($lastRecord == '') {
            $lastFinalRecord = self::model()->lastFinalClosedDate();
            if ($lastFinalRecord) {
                $nextDate = date('Y-m-d', strtotime($lastFinalRecord . ' +1 day'));
                return $nextDate;       
            }
            $nextDate = '2020-01-01';
            return $nextDate;
        } else {
            $nextDate = date('Y-m-d', strtotime($lastRecord->close_date . ' +1 day'));
            return $nextDate;
        }
    }
    
    public function getFormatCloseDate()
    {
        //return date("Y-m-d", strtotime(str_replace('/', '-', $this->close_date)));
        return date("d/m/Y", strtotime($this->close_date));
    }
    
    public static function getAllClosedDateRanges($closeType = '')
    {
        $condition = '1=1';
        if (trim($closeType)) {
            $condition = "closed='".$closeType."'";
        }
        return self::model()->findAll(array('condition' => $condition, 'order' => 'id DESC'));
    }
    
    public static function getAllClosedDateRangesHtml($closeType = '', $type = '')
    {
        $allClosedDateRanges = self::model()->getAllClosedDateRanges($closeType);
        if ($type == 'name') {
            return CHtml::listData($allClosedDateRanges, 'id', 'name');
        } else {
            return CHtml::listData($allClosedDateRanges, 'id', 'FormatCloseDate');
        }
    }
    
    public static function lastFinalStartDate($ac_id)
    {
        return self::model()->find(array('condition' => "closed='FINAL' AND id != $ac_id", 'order' => 'id DESC', 'limit' => '1'))->close_date;
    }
    
    public static function lastFinalClosedDate()
    {
        return self::model()->find(array('condition' => "closed='FINAL'", 'order' => 'id DESC'))->close_date;
    }
    
    public static function lastFinalClosedDateId()
    {
        return self::model()->find(array('condition' => "closed='FINAL'", 'order' => 'id DESC'))->id;
    }
    
    public static function updateAuditcloseDetails($newClosing, $closeDate, $lastCloseddate, $lastCloseddateId)
	{
	    if ($closeDate) {
	        $ledgerResults = AccLedger::model()->findAll(array( 'condition' => "ledger_main_acc IN ('A','L','I','E','AP')", 'order' => 't.ledger_acc_no asc'));
	        if ($lastCloseddateId) {
                $lastAuditcloseDateDetails = self::model()->findByPk($lastCloseddateId);
	        }
	        //$condition = ' V.is_posted="Y" AND ledger_main_acc NOT IN ("AP") ';
	        $condition = ' V.is_posted="Y" ';
	        if ($lastCloseddate) {
	            $condition .= " AND V.voucher_date >'".$lastCloseddate."' AND V.voucher_date <='".$closeDate."' ";
	        } else {
	            $condition .= " AND V.voucher_date <='".$closeDate."' ";
	        }
    	    $SQL = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                FROM `erp_acc_voucher_items` VI 
                LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                WHERE $condition 
                GROUP BY VI.ledger_id 
                ORDER BY L.ledger_acc_name ASC";
            $auditCloseResults = Yii::app()->db->createCommand($SQL)->queryAll();
            $accumulated_profit_condition = '';
            if ($lastCloseddate) {
                $accumulated_profit_condition = " AND voucher_date > '".$lastCloseddate."'";
            }
            $sql_accumulated_profit_auditclose = "SELECT SUM(VI.amount) AS amount 
                FROM {{acc_voucher_items}} VI 
                LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
                LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
                WHERE  ledger_main_acc IN ('I','E') AND is_posted='Y' AND voucher_date <=' " . $closeDate."' ".$accumulated_profit_condition ;
        
            $acc_profit_auditclose = Yii::app()->db->createCommand($sql_accumulated_profit_auditclose)->queryScalar();
            if($ledgerResults) {
    	        foreach ($ledgerResults as $ledgerResult){
    	            $auditCloseLedgerResults[$ledgerResult['id']]['id'] = $ledgerResult['id'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['ledger_id'] = $ledgerResult['id'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['root'] = $ledgerResult['root'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['ledger_acc_no'] = $ledgerResult['ledger_acc_no'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['ledger_acc_name'] = $ledgerResult['ledger_acc_name'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['ledger_acc_type'] = $ledgerResult['ledger_acc_type'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['level'] = $ledgerResult['level'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['is_parent'] = $ledgerResult['is_parent'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['ledger_main_acc'] = $ledgerResult['ledger_main_acc'];
    	            $auditCloseLedgerResults[$ledgerResult['id']]['amount'] = 0.00;
    	            $auditCloseLedgerResults[$ledgerResult['id']]['balance'] = 0.00;
    	            $auditCloseLedgerResults[$ledgerResult['id']]['opening'] = 0.00;
    	            $auditCloseLedgerResults[$ledgerResult['id']]['debit'] = 0.00;
    	            $auditCloseLedgerResults[$ledgerResult['id']]['credit'] = 0.00;
    	            $auditCloseLedgerResults[$ledgerResult['id']]['transaction_count'] = 0;
    	            $auditCloseLedgerResults[$ledgerResult['id']]['ledger_parent_acc'] = $ledgerResult['ledger_parent_acc'];
    	            if ($ledgerResult['ledger_main_acc'] == 'AP') {
    	                $auditCloseLedgerResults[$ledgerResult['id']]['balance'] = $acc_profit_auditclose;
    	                $auditCloseLedgerResults[$ledgerResult['id']]['amount'] = $acc_profit_auditclose;
    	                $auditCloseLedgerResults[$ledgerResult['id']]['opening'] = $acc_profit_auditclose;
    	                $auditCloseLedgerResults[$ledgerResult['ledger_parent_acc']]['balance'] = $acc_profit_auditclose;
    	                $auditCloseLedgerResults[$ledgerResult['ledger_parent_acc']]['amount'] = $acc_profit_auditclose;
    	                $auditCloseLedgerResults[$ledgerResult['ledger_parent_acc']]['opening'] = $acc_profit_auditclose;
    	            }
    	        }
    	        foreach ($auditCloseResults as $auditCloseResult){
	                if(array_key_exists($auditCloseResult['ledger_id'], $auditCloseLedgerResults)){
	                   
	                    $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['amount'] = $auditCloseResult['balance'];
	                    $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['balance'] = $auditCloseResult['balance'];
	                    //$auditCloseLedgerResults[$auditCloseResult['ledger_id']]['opening'] = $auditCloseResult['balance'];
	                    $auditCloseLedgerResults[$auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_parent_acc']]['amount'] += $auditCloseResult['balance'];
    	                $auditCloseLedgerResults[$auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_parent_acc']]['balance'] += $auditCloseResult['balance'];
    	                //$auditCloseLedgerResults[$auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_parent_acc']]['opening'] += $auditCloseResult['balance'];
    	                $level = $auditCloseLedgerResults[$auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_parent_acc']]['level'];
    	                $parentLedgerId = $auditCloseLedgerResults[$auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_parent_acc']]['ledger_parent_acc'];
    	                for($l=1; $l<$level; $l++){
    	                    if($parentLedgerId>0){
    	                        $auditCloseLedgerResults[$parentLedgerId]['amount'] += $auditCloseResult['balance'];
    	                        $auditCloseLedgerResults[$parentLedgerId]['balance'] += $auditCloseResult['balance'];
    	                        //$auditCloseLedgerResults[$parentLedgerId]['opening'] += $auditCloseResult['balance'];
    	                        $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
    	                    }
    	                }
	                }
	            }
            }
            if ($lastCloseddateId) {
                $lastAuditcloseDateLedgerDetails = AccAuditCloseDetails::model()->findAll(array('condition' => 'audit_close_id='.$lastAuditcloseDateDetails->id, 'order' => 'ledger_acc_name asc'));
                foreach ($auditCloseLedgerResults as $m => $eachledger) {
                    foreach ($lastAuditcloseDateLedgerDetails as $n => $lastAuditcloseDateLedgerDetail) {
                        if ($eachledger['ledger_id'] == $lastAuditcloseDateLedgerDetail['ledger_id']) {
                            //$ledgerExist = 1;
                            $auditCloseLedgerResults[$m]['amount'] = (float)$eachledger['amount'] + (float)$lastAuditcloseDateLedgerDetail['amount'];
                            $auditCloseLedgerResults[$m]['balance'] = (float)$eachledger['balance'] + (float)$lastAuditcloseDateLedgerDetail['balance'];
                            $auditCloseLedgerResults[$m]['opening'] = (float)$lastAuditcloseDateLedgerDetail['balance'];
                        }
                    }
                }
            }
            if ($auditCloseLedgerResults) {
                foreach ($auditCloseLedgerResults as $k => $eachledger) {
                    $newClosingDetails[$k] = new AccAuditCloseDetails;
                    $newClosingDetails[$k]->audit_close_id = $newClosing->id;
                    $newClosingDetails[$k]->ledger_id = $eachledger['ledger_id'];
                    $newClosingDetails[$k]->ledger_acc_no = $eachledger['ledger_acc_no'];
                    $newClosingDetails[$k]->ledger_acc_name = $eachledger['ledger_acc_name'];
                    $newClosingDetails[$k]->ledger_acc_type = $eachledger['ledger_acc_type'];
                    $newClosingDetails[$k]->balance = round((float)$eachledger['balance'],6);
                    $newClosingDetails[$k]->amount = round((float)$eachledger['amount'],6);
                    $newClosingDetails[$k]->opening = round((float)$eachledger['opening'],6);
                    $newClosingDetails[$k]->debit = round((float)$eachledger['debit'],6);
                    $newClosingDetails[$k]->credit = round((float)$eachledger['credit'],6);
                    $newClosingDetails[$k]->ledger_main_acc = $eachledger['ledger_main_acc'];
                    $newClosingDetails[$k]->ledger_parent_acc = $eachledger['ledger_parent_acc'];
                    $newClosingDetails[$k]->root = $eachledger['root'];
                    $newClosingDetails[$k]->level = $eachledger['level'];
                    $newClosingDetails[$k]->is_parent = $eachledger['is_parent'];
                    $newClosingDetails[$k]->transaction_count = $eachledger['transaction_count'];
                    $newClosingDetails[$k]->created_by = Yii::app()->user->id;
                    $newClosingDetails[$k]->created_datetime = date('Y-m-d h:i:s');
                    $newClosingDetails[$k]->save();
                }
            }
	    }
	}
}
