<?php

/**
 * This is the model class for table "{{acc_allocation}}".
 *
 * The followings are the available columns in table '{{acc_allocation}}':
 * @property integer $id
 * @property string $allocation_date
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property string $amount
 * @property integer $created_by
 * @property string $created_date_time
 */
class AccAllocation extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_allocation}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('allocation_date, ledger_id, subledger_id, amount, created_by, created_date_time', 'required'),
            array('ledger_id, subledger_id, created_by', 'numerical', 'integerOnly'=>true),
            array('amount', 'length', 'max'=>15),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, allocation_date, ledger_id, subledger_id, amount, created_by, created_date_time', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'ledger_det' => array(self::BELONGS_TO, 'AccLedger', 'ledger_id'),
			'subledger_det' => array(self::BELONGS_TO, 'AccSubledger', 'subledger_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'allocation_date' => 'Allocation Date',
            'ledger_id' => 'Ledger',
            'subledger_id' => 'Subledger',
            'amount' => 'Amount',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('allocation_date',$this->allocation_date,true);
        $criteria->compare('ledger_id',$this->ledger_id);
        $criteria->compare('subledger_id',$this->subledger_id);
        $criteria->compare('amount',$this->amount,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('created_date_time',$this->created_date_time,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccAllocation the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    public function getsubledger_name(){
        return  $this->subledger_det->subledger_name;
    }
}