<?php
/*

  posting
  date 11-11-2022
  author -jisha
  Tables - acc_voucher_items,erp_acc_voucher_items
  models used - AccVoucher,AccVoucherItems
 */
 
 
 
class PostingController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Test'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'index',
                    'PostSales',
                    'SaveAllCustomerSubledgers',
                    'SaveAllVendorSubledgers',
                    'PostPurchaseInvoice',
                    'PostPayment',
                    'PostReceipt',
                    'Savemodulevouchers',
                    'CorrectingLedgerRoots',
                    'clearall',
                    'PurchasinginvoicePosting',
                    'PostCreditnote',
                    'PostDebitnote',
                    'PostIssue',
                    'PostReceipts',
                    'AddRoundingPurchase',  /* 'UnPostSI', 'PostSI', */
                    'UnallocateSalesInvoice',
                    'Roundoff',
                    'addsalesreceiptallocation',
                    'Savecheques',
                    'Savechequesreturn',
                    'Savechequesstatuschange',
                    'Savechequesstatuschangeresubmit'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    // public $modelMasCurrency;
    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }
    public function actionIndex()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    // -----------------------------------------------------------------------------------------------------------
    //Automatic post -sales Invoice & Purchase Invoicr details to finance voucher and voucher items from invoice id
    //------------------------------------------------------------------------------------------------------------

    public static function DirectPostSales($id, $from, $arraypayments)
    {

        // -------------------------------
        $have_sales_receipt  = 'N';
        $allow_multi_receipt = 'N';
        $allow_deliverynote  = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT * FROM {{acc_general_settings}}")->queryRow();
            $have_sales_receipt  =  $acc_settings['have_sales_receipt'];
            $allow_multi_receipt =  $acc_settings['allow_multi_receipt'];
            $allow_deliverynote  =  $acc_settings['allow_deliverynote'];
        }
        // -------------------------------
        $array_id = [$id];
        if ($from == 'directsales') {
            $modelInvoice = new Invoice();
            $modelInvoice = $modelInvoice->findBYPK((int)$id);



            /* if ((int)$modelInvoice->delivery_ids > 0 && $allow_deliverynote == 'Y') {
                $modelDeliveryNote = new DeliveryNote();
                $modelDeliveryNote = $modelDeliveryNote->findBYPK((int)$modelInvoice->delivery_ids);
                if ($modelDeliveryNote->posted == "N") {
                    $var = PostingController::addPostDeliveryNote([$modelDeliveryNote->id], 'INVOICE');
                }
            }*/
            PostingController::addPostSales($array_id, $from);
            if ($have_sales_receipt == 'Y') {
                PostingController::addPostReceipt_frm_invoicenew($id, $arraypayments);
                // PostingController::allocateInvoiceVoucherwithreceipt($id);

            }
        }
    }


    public static function DirectPost($id, $from)
    {
        // -------------------------------
        $have_sales_receipt  = 'N';
        $allow_multi_receipt = 'N';
        $allow_deliverynote  = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT * FROM {{acc_general_settings}}")->queryRow();
            $have_sales_receipt  =  $acc_settings['have_sales_receipt'];
            $allow_multi_receipt =  $acc_settings['allow_multi_receipt'];
            $allow_deliverynote  =  $acc_settings['allow_deliverynote'];
        }
        // -------------------------------
        $array_id = [$id];
        if ($from == 'sales') {
            $modelInvoice = new Invoice();
            $modelInvoice = $modelInvoice->findBYPK((int)$id);
            if ((int)$modelInvoice->delivery_ids > 0 && $allow_deliverynote == 'Y') {
                $modelDeliveryNote = new DeliveryNote();
                $modelDeliveryNote = $modelDeliveryNote->findBYPK((int)$modelInvoice->delivery_ids);
                if ($modelDeliveryNote->posted == "N") {
                   // $var = PostingController::addPostDeliveryNote([$modelDeliveryNote->id], 'INVOICE');
                }
            }
            PostingController::addPostSales($array_id, $from);
            if (isset($modelInvoice->receipt_type) && $have_sales_receipt == 'Y' && $allow_multi_receipt == 'N') {
                if ($modelInvoice->receipt_type != 'CREDIT') {
                    PostingController::addPostReceipt_frm_invoice($id);
                    PostingController::allocateInvoiceVoucherwithreceipt($id);
                }
            }
        } else if ($from == 'sales1') {
            PostingController::addPostSalesx($array_id, $from);
        } else if ($from == 'purchase') {
            PostingController::addPostPurchaseInvoice($array_id, $from);
        } else if ($from == 'creditnote') {
            PostingController::addPostCreditnote($array_id, $from);
            $modelCreditnote = new Creditnote();
            $modelCreditnote = $modelCreditnote->findByPk((int)$id);
            if (isset($modelCreditnote->payment_type) && $have_sales_receipt == 'Y'  && $allow_multi_receipt == 'N') {
                if ($modelCreditnote->payment_type != 'CREDIT') {
                    PostingController::addPostpayment_frm_creditnote($id);
                    PostingController::allocateSalesreturnVoucherwithPayment($id);
                }
            }

            if ($have_sales_receipt == 'Y'  && $allow_multi_receipt == 'Y') {
                $model_voucher_type = new AccVoucherType();
                $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="SI"'));
                $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                $from_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
                $sqlacc = "SELECT 
                        SUM(IFNULL(ABS(VI.allocated_amount), 0)) AS total_allocated,
                        SUM(IFNULL(ABS(VI.amount), 0)) AS total_amount
                            FROM  {{acc_voucher_items}} VI
                            LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                            WHERE   V.is_posted = 'Y' AND  V.transaction_id  = '" . $modelCreditnote->invoice_id . "'  AND V.voucher_type = '" . $model_voucher_type->id . "'  AND VI.ledger_id = '" . $from_ledger . "'
                            GROUP BY V.id";
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryAll();
                //   $inv_balance = (float)$modelCreditnote->invoice->grand_total - (float)$acc_detls[0]['total_allocated'];
                // -------------------------------
                $inv_balance_amt = (float) $acc_detls[0]['total_amount'] - (float) $acc_detls[0]['total_allocated'];
                if ((float) $acc_detls[0]['total_allocated'] == 0) {
                    PostingController::allocateSalesreturnVoucherwithSales((int) $id);
                } else if ($inv_balance_amt >= (float) $modelCreditnote->credited_amount) {
                    PostingController::allocateSalesreturnVoucherwithSales((int) $id);
                } else {
                    PostingController::addPostmultipayment_frm_creditnote((int)$id);
                    PostingController::allocateSalesreturnVoucherwithPaymentandSales((int) $id);
                }
            }
        } else if ($from == 'debitnote') {
            PostingController::addPostdebitnote($array_id, $from);
        } else if ($from == 'salescredit') {
            PostingController::addPostSales($array_id, $from);
        }
    }
    public static function DirectPostCreditnote($id, $from, $total_payment_amount)
    {
        // -------------------------------
        $have_sales_receipt = 'N';
        $allow_multi_receipt = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT have_sales_receipt,allow_multi_receipt FROM {{acc_general_settings}}")->queryRow();
            $have_sales_receipt =  $acc_settings['have_sales_receipt'];
            $allow_multi_receipt =  $acc_settings['allow_multi_receipt'];
        }
        // -------------------------------
        $array_id = [$id];
        $modelCreditnote = new Creditnote();
        $modelCreditnote = $modelCreditnote->findByPk((int) $id);
        PostingController::addPostCreditnote($array_id, $from);
        // -------------------------------
        if (isset($modelCreditnote->payment_type) && $have_sales_receipt == 'Y'  && $allow_multi_receipt == 'N') {
            if ($modelCreditnote->payment_type != 'CREDIT') {
                PostingController::addPostpayment_frm_creditnote($id);
                PostingController::allocateSalesreturnVoucherwithPayment($id);
            }
        }
        if ($have_sales_receipt == 'Y'  && $allow_multi_receipt == 'Y') {
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="SI"'));
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
            $sqlacc = "SELECT 
                    SUM(IFNULL(ABS(VI.allocated_amount), 0)) AS total_allocated,
                    SUM(IFNULL(ABS(VI.amount), 0)) AS total_amount
                        FROM  {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        WHERE   V.is_posted = 'Y' AND  V.transaction_id  = '" . $modelCreditnote->invoice_id . "'  AND V.voucher_type = '" . $model_voucher_type->id . "'  AND VI.ledger_id = '" . $from_ledger . "'
                        GROUP BY V.id";
            $command_acc = Yii::app()->db->createCommand($sqlacc);
            $acc_detls = $command_acc->queryAll();
            //   $inv_balance = (float)$modelCreditnote->invoice->grand_total - (float)$acc_detls[0]['total_allocated'];
            // -------------------------------
            $inv_balance_amt = (float) $acc_detls[0]['total_amount'] - (float) $acc_detls[0]['total_allocated'];
            if ((float) $acc_detls[0]['total_allocated'] == 0) {
                PostingController::allocateSalesreturnVoucherwithSales((int) $id);
            } else if ($inv_balance_amt >= (float) $modelCreditnote->credited_amount) {
                PostingController::allocateSalesreturnVoucherwithSales((int) $id);
            } else {
                PostingController::addPostmultipayment_frm_creditnote((int)$id);
                PostingController::allocateSalesreturnVoucherwithPaymentandSales((int) $id);
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //post sales details to finance voucher and voucher items from invoice id when clicking post to finance button
    //------------------------------------------------------------------------------------------------------------
    public static function actionPostSales()
    {
        // -------------------------------
        $have_sales_receipt = 'N';
        $allow_multi_receipt = 'N';
        $allow_deliverynote = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT * FROM {{acc_general_settings}}")->queryRow();
            $have_sales_receipt =  $acc_settings['have_sales_receipt'];
            $allow_multi_receipt =  $acc_settings['allow_multi_receipt'];
            $allow_deliverynote  =  $acc_settings['allow_deliverynote'];
        }
        // -------------------------------
        $id = [$_POST['id']];
        if ($_POST['id'] > 0) {
            $modelInvoice = Invoice::model()->with('items')->findByPk($_POST['id']);
            $from = '';
            if ($modelInvoice->posted == 'Y') {
                $jsonData['status'] = 'Error In Posting ,  This Invoice was Posted to the Accounts!';
                echo CJSON::encode($jsonData);
            } else if ($modelInvoice->invoice_status == 'C') {
                $jsonData['status'] = 'Error In Posting, This Invoice Cancelled!';
                echo CJSON::encode($jsonData);
            } else {
                if ((int) $modelInvoice->delivery_ids > 0 && $allow_deliverynote == 'Y') {
                    $modelDeliveryNote = new DeliveryNote();
                    $modelDeliveryNote = $modelDeliveryNote->findBYPK((int) $modelInvoice->delivery_ids);
                    if ($modelDeliveryNote->posted == "N") {
                      //  PostingController::addPostDeliveryNote([$modelDeliveryNote->id], 'INVOICE');
                    }
                }
                PostingController::addPostSales($id, $from);
                if (isset($modelInvoice->receipt_type) && $have_sales_receipt == 'Y'  && $allow_multi_receipt == 'N') {
                    if ($modelInvoice->receipt_type != 'CREDIT') {
                        PostingController::addPostReceipt_frm_invoice($_POST['id']);
                        PostingController::allocateInvoiceVoucherwithreceipt($_POST['id']);
                    }
                }
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //post sales return details to finance voucher and voucher items from invoice id when clicking post to finance button
    //------------------------------------------------------------------------------------------------------------

    public static function actionPostCreditnote()
    {
        // -------------------------------
        $have_sales_receipt = 'N';
        $allow_multi_receipt = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT have_sales_receipt,allow_multi_receipt FROM {{acc_general_settings}}")->queryRow();
            $have_sales_receipt =  $acc_settings['have_sales_receipt'];
            $allow_multi_receipt =  $acc_settings['allow_multi_receipt'];
        }
        // -------------------------------
        $array_ids = [$_POST['id']];
        if ($_POST['id'] > 0) {
            $modelCreditnote = new Creditnote();
            $modelCreditnote = $modelCreditnote->with('items')->findByPk($_POST['id']);
            if ($modelCreditnote->posted == 'Y') {
                $jsonData['status']    = 'Error In Posting ,  This Sales Return was Posted to the Finance!';
                echo CJSON::encode($jsonData);
            } else {
                $from = '';
                PostingController::addPostCreditnote($array_ids, $from);
                if (isset($modelCreditnote->payment_type) && $have_sales_receipt == 'Y'  && $allow_multi_receipt == 'N') {
                    if ($modelCreditnote->payment_type != 'CREDIT') {
                        PostingController::addPostpayment_frm_creditnote($_POST['id']);
                        PostingController::allocateSalesreturnVoucherwithPayment($_POST['id']);
                    }
                }

                if ($have_sales_receipt == 'Y'  && $allow_multi_receipt == 'Y') {
                    $model_voucher_type = new AccVoucherType();
                    $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="SI"'));
                    $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                    $from_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
                    $sqlacc = "SELECT 
                            SUM(IFNULL(ABS(VI.allocated_amount), 0)) AS total_allocated,
                            SUM(IFNULL(ABS(VI.amount), 0)) AS total_amount
                                FROM  {{acc_voucher_items}} VI
                                LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                                WHERE   V.is_posted = 'Y' AND  V.transaction_id  = '" . $modelCreditnote->invoice_id . "'  AND V.voucher_type = '" . $model_voucher_type->id . "'  AND VI.ledger_id = '" . $from_ledger . "'
                                GROUP BY V.id";
                    $command_acc = Yii::app()->db->createCommand($sqlacc);
                    $acc_detls = $command_acc->queryAll();
                    //   $inv_balance = (float)$modelCreditnote->invoice->grand_total - (float)$acc_detls[0]['total_allocated'];
                    // -------------------------------
                    $inv_balance_amt = (float) $acc_detls[0]['total_amount'] - (float) $acc_detls[0]['total_allocated'];
                    if ((float) $acc_detls[0]['total_allocated'] == 0) {
                        PostingController::allocateSalesreturnVoucherwithSales((int)$_POST['id']);
                    } else if ($inv_balance_amt >= (float) $modelCreditnote->credited_amount) {
                        PostingController::allocateSalesreturnVoucherwithSales((int) $_POST['id']);
                    } else {
                        PostingController::addPostmultipayment_frm_creditnote((int)$_POST['id']);
                        PostingController::allocateSalesreturnVoucherwithPaymentandSales((int) $_POST['id']);
                    }
                }
            }
        }
    }


    // -----------------------------------------------------------------------------------------------------------
    //post purchase return details to finance voucher and voucher items from invoice id when clicking post to finance button
    //------------------------------------------------------------------------------------------------------------
    public static function actionPostDebitnote()
    {
        $array_ids = [$_POST['id']];
        if ($_POST['id'] > 0) {
            $modelPurchasingdebitnote = Purchasingdebitnote::model()->with('items')->findByPk($_POST['id']);
            if ($modelPurchasingdebitnote->posted == 'Y') {
                $jsonData['status'] = 'Error In Posting ,  This Purchase Return was Posted to the Finance!';
                echo CJSON::encode($jsonData);
            } else {
                $from = '';
                PostingController::addPostdebitnote($array_ids, $from);
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //post purchase return details to finance voucher and voucher items from invoice id when clicking post to finance button
    //------------------------------------------------------------------------------------------------------------
    public static function actionPostIssue()
    {
        $array_ids = [$_POST['id']];
        if ($_POST['id'] > 0) {
            $modelInventoryGoodsIssue = InventoryGoodsIssue::model()->findByPk($_POST['id']);
            if ($modelInventoryGoodsIssue->posted == 'Y') {
                $jsonData['status'] = 'Error In Posting ,  This Issue was Posted to the Finance!';
                echo CJSON::encode($jsonData);
            } else {
                $from = '';
                PostingController::addPostgoodsissue($array_ids, $from);
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //post purchase return details to finance voucher and voucher items from invoice id when clicking post to finance button
    //------------------------------------------------------------------------------------------------------------
    public static function actionPostReceipts()
    {
        $array_ids = [$_POST['id']];
        if ($_POST['id'] > 0) {
            $modelInventoryGoodsReceipt = InventoryGoodsReceipt::model()->findByPk($_POST['id']);
            if ($modelInventoryGoodsReceipt->posted == 'Y') {
                $jsonData['status'] = 'Error In Posting ,  This Receipt was Posted to the Finance!';
                echo CJSON::encode($jsonData);
            } else {
                $from = '';
                PostingController::addPostgoodsreceipt($array_ids, $from);
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //post purchase invoice details to finance voucher and voucher items from purchase_invoice_id
    //------------------------------------------------------------------------------------------------------------
    public function actionPostPurchaseInvoice()
    {
        /* $id = [$_POST['id']];
          $from = '';
          PostingController::addPostPurchaseInvoice($id, $from);
         */
        $id = [$_POST['id']];
        if ($_POST['id'] > 0) {
            $modelInvoice = PurchasingInvoice::model()->findByPk($_POST['id']);
            if ($modelInvoice->posted == 'Y') {
                $jsonData['status'] = 'Error In Posting ,  This Invoice was Posted to the Finance!';
                echo CJSON::encode($jsonData);
            } else {
                $from = '';
                PostingController::addPostPurchaseInvoice($id, $from);
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //add receipt to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public function actionPostReceipt()
    {


        $valid  = true;
        $valid1  = true;
        $validationMessages = [];
        $comming_frm = $_POST['comming_frm'];

        if ($_POST['voucher_date'] == '') {
            $valid1  = false;
            $validationMessages[] = 'voucher_date  !  cant be null';
        }

        if ($_POST['to_account'] == '' || $_POST['to_account'] < 0) {
            $valid1  = false;
            $validationMessages[] = 'Payment Mode !  cant be null';
        }

        if ($_POST['from_account'] == '' || $_POST['from_account'] < 0) {
            $valid  = false;
            $validationMessages[] = 'Received Account  !  cant be null';
        }

        if (!empty($_POST['from_account'])) {
            $modelAccLedger  = new AccLedger();
            $modelAccLedger_det   = $modelAccLedger->findByPk($_POST['from_account']);
            if ($modelAccLedger_det->have_subledger == 'Y') {
                if ($_POST['from_subledger_id'] == '') {
                    $valid  = false;
                    $validationMessages[] = '' . $modelAccLedger_det->ledger_acc_name . ' Account Sub-ledger !  cant be null';
                } else {
                    $valid  = true;
                }
            }
        }

        if ($comming_frm !== 'salesreceipt') {
            if (!empty($_POST['to_account'])) {
                $modelAccLedger  = new AccLedger();
                $modelAccLedger_det   = $modelAccLedger->findByPk($_POST['to_account']);
                if ($modelAccLedger_det->have_subledger == 'Y') {
                    if ($_POST['to_subledger_id'] == '') {
                        $valid  = false;
                        $validationMessages[] = '' . $modelAccLedger_det->ledger_acc_name . ' Receipt Sub-ledger !  cant be null';
                    } else {
                        $valid  = true;
                    }
                }
            }
        } else {
            $modAccSubledgerType       = new AccSubledgerType();
            $subledger_type_id         = $modAccSubledgerType->getIdFromType('E');
            $modAccSubledger           = new AccSubledger();
            $_POST['to_subledger_id']  = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, Yii::app()->user->id);
        }

        if ($comming_frm !== 'salesreceipt') {
            if ($_POST['reference_no'] == '') {
                $valid  = false;
                $validationMessages[] = 'Reference No !  cant be null';
            }
        }


        if ((float)$_POST['amount'] ==  0) {
            $valid  = false;
            $validationMessages[] = 'Amount  !  cant be null';
        }
        if ((float)$_POST['amount'] <  0) {
            $valid  = false;
            $validationMessages[] = 'Amount  Must Be Greater Than Zero';
        }


        if ($_POST['narration'] == '') {
            $valid  = false;
            $validationMessages[] = 'Narration  !  cant be null';
        }

        if ((int)$_POST['lead_owner_id'] <= 0) {
            $valid  = false;
            $validationMessages[] = 'Sales Man  !  cant be null';
        }

        //   ---------------------AccAuditClose check------------------------------------

        $voucher_date  =  (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');

        $modelAccAuditClose = new AccAuditClose();
        $existing_date = strtotime($modelAccAuditClose->lastFinalClosedDate());
        $voucher_date = strtotime($voucher_date);
        if ($voucher_date <= $existing_date) {
            $valid = false;
            $validationMessages[] = ' Given Voucher date must be Greater than Final Audit Close Date ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalClosedDate()))) . '';
        } else {
            $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
            if ($voucher_date <= $existing_date) {
                if (!(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"]))) {
                    $valid = false;
                    $validationMessages[] = ' Given Voucher date must be Greater than Pre Audit Close Date ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastClosedDate()))) . '';
                }
            }
        }
        //   --------------------//-AccAuditClose check------------------------------------


        if ($valid && $valid1) {
            $valid  = true;
            $id = $_POST['id'];
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type             = new AccVoucherType();
            $model_voucher_type             = $model_voucher_type->find(array('condition' => 'code="RV"'));

            if (empty($model_voucher_type)) {
                $valid          = false;
                $others[]       = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details      = new AccVoucherTypeDetails();
                $modelvoucher_type_details      = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int)$model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid          = false;
                    $others[]       = 'Voucher Type Details not defined';
                }


                $_POST['voucher_date'];
                $from_ledger        = $_POST['from_account'];
                $from_subledger     = $_POST['from_subledger_id'];
                $have_from_subledger = 'N';
                if ($_POST['from_account'] > 0) {
                    $modelAccLedger = new AccLedger();
                    $ledger = $modelAccLedger->findByPk($_POST['from_account']);
                    if ($ledger->have_subledger == 'Y') {
                        $have_from_subledger = 'Y';
                    }
                }
                $to_ledger          = $_POST['to_account'];
                $to_subledger       = $_POST['to_subledger_id'];
                $have_to_subledger = 'N';
                if ($to_ledger > 0) {
                    $modelAccLedger = new AccLedger();
                    $ledger         = $modelAccLedger->findByPk($to_ledger);
                    if ($ledger->have_subledger == 'Y') {
                        $have_to_subledger = 'Y';
                    }
                }
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();

                $usermodel          = $usermodel->findByPK((int)Yii::app()->user->id);
                $employee_id        = (int)$usermodel->connected_employee_id;
                $narration          = $_POST['narration'];
                $invoice_id         = 0;
                $amount             = $_POST['amount'];
                $tax_amount         = $_POST['vat_amount'];
                $tot_discount       = 0;
                $round_off_amount   = 0;
                $salegroup_id       = 0;
                $project_id         = 0;
                $branch_id          = $usermodel->branch_id;
                $company_id         = $usermodel->company_id;
                $payment_term_id    = $_POST['payment_modes'];
                $costcenter_id      = 0;
                $warehouse_id       = 0;
                $department_id      = 0;
                $reference          = $_POST['reference_no'];
                $lead_owner_id      = (int)$_POST['lead_owner_id'];
                $discount_amt       = $_POST['discount'];
                $total_amount       = (float)$_POST['discount'] + (float)$_POST['amount'];
                if ((int)$employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int)$employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = 0;
                if ((int)$from_subledger > 0) {
                    $modelCustomer_subledger = new AccSubledger();
                    $modelCustomer_subledger = $modelCustomer_subledger->findByPk((int)$from_subledger);
                    $customer_vendor_id = $modelCustomer_subledger->reference_id;
                }
                $year               = (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y');
                $eachVoucherItem = [];
                $arr_items[$i]                  = new AccVoucherItems();
                $arr_items[$i]->ledger_id       = $from_ledger;
                $arr_items[$i]->subledger_id    = (int)$from_subledger;
                $arr_items[$i]->year            = $year;
                $arr_items[$i]->credit          = abs($total_amount);
                $arr_items[$i]->debit           = '0.00';
                $arr_items[$i]->amount          = (-1 * abs($total_amount));
                $arr_items[$i]->employee_id     = $employee_id;
                $arr_items[$i]->salegroup_id    = $salegroup_id;
                $arr_items[$i]->payment_term_id = $payment_term_id;
                $arr_items[$i]->narration       = $narration;
                $arr_items[$i]->project_id      = $project_id;
                $arr_items[$i]->company_id      = $company_id;
                $arr_items[$i]->branch_id       = $branch_id;
                $arr_items[$i]->costcenter_id   = $costcenter_id;
                $arr_items[$i]->department_id   = $department_id;
                $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                $arr_items[$i]->warehouse_id    = $warehouse_id;

                $i++;
                $arr_items[$i]                  = new AccVoucherItems();
                $arr_items[$i]->ledger_id       = $to_ledger;
                $arr_items[$i]->subledger_id    = (int)$to_subledger;
                $arr_items[$i]->year            = $year;
                $arr_items[$i]->credit          = 0.00;
                $arr_items[$i]->debit           = $amount;
                $arr_items[$i]->amount          = $amount;
                $arr_items[$i]->employee_id     = $employee_id;
                $arr_items[$i]->salegroup_id    = $salegroup_id;
                $arr_items[$i]->payment_term_id = $payment_term_id;
                $arr_items[$i]->payment_mode_id = $payment_term_id;
                $arr_items[$i]->narration       = $narration;
                $arr_items[$i]->project_id      = $project_id;
                $arr_items[$i]->company_id      = $company_id;
                $arr_items[$i]->exchange_rate   = 1;
                $arr_items[$i]->branch_id       = $branch_id;
                $arr_items[$i]->costcenter_id   = $costcenter_id;
                $arr_items[$i]->department_id   = $department_id;
                $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                $arr_items[$i]->warehouse_id    = $warehouse_id;

                $i++;

                if (abs((float)$discount_amt) > 0) {
                    // ---------------------------sales_discount ------------------------
                    $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                    $sales_discount_ledger = $modelAccSystemAccountsMapping->getSystemdefault('sales_discount');
                    $arr_items[$i]                  = new AccVoucherItems();
                    $arr_items[$i]->ledger_id       = (int)$sales_discount_ledger;
                    $arr_items[$i]->subledger_id    = 0;
                    $arr_items[$i]->year            = $year;
                    $arr_items[$i]->debit           = abs((float)$discount_amt);
                    $arr_items[$i]->amount          = abs((float)$discount_amt);
                    $arr_items[$i]->employee_id     = $employee_id;
                    $arr_items[$i]->salegroup_id    = $salegroup_id;
                    $arr_items[$i]->payment_term_id = $payment_term_id;
                    $arr_items[$i]->narration       = $narration;
                    $arr_items[$i]->project_id      = $project_id;
                    $arr_items[$i]->company_id      = $company_id;
                    $arr_items[$i]->exchange_rate   = 1;
                    $arr_items[$i]->branch_id       = $branch_id;
                    $arr_items[$i]->costcenter_id   = $costcenter_id;
                    $arr_items[$i]->department_id   = $department_id;
                    $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                    $arr_items[$i]->warehouse_id    = $warehouse_id;
                    $i++;
                }
                // ---------------------------------------------------

                // ----------------------------------------------------------------------------------------------
                // ------------allocation------------------
                // ----------------------------------------------------------------------------------------------


                if ($_POST['total_allocation_amount'] > 0) {
                    $modelAccAllocation                  = new AccAllocation;
                    $modelAccAllocation['ledger_id']     = $_POST['from_account'];
                    $modelAccAllocation['subledger_id']  = $_POST['from_subledger_id'];
                    $modelAccAllocation['allocation_date']   = date('Y-m-d');
                    $modelAccAllocation['created_by']        = Yii::app()->user->id;
                    $modelAccAllocation['created_date_time'] = date('Y-m-d H:i:s');

                    $j =   0;
                    $debitArray = $creditArray = [];
                    foreach ($_POST['Debit'] as  $each) {
                        if ($each['amount']  > 0) {
                            $creditArray[$j]                  = new AccAllocationItems;
                            $creditArray[$j]->voucher_id      = $each['voucher_id'];
                            $creditArray[$j]->voucher_item_id = $each['voucher_item_id'];
                            $creditArray[$j]->amount          = -1 * ($each['amount']);
                        }
                        $j++;
                    }

                    $k = $totaldebit = 0;
                    foreach ($_POST['CREDIT'] as  $each) {
                        if ($each['amount']  < 0) {
                            $debitArray[$k]                  = new AccAllocationItems;
                            $debitArray[$k]->voucher_id      = $each['voucher_id'];
                            $debitArray[$k]->voucher_item_id = $each['voucher_item_id'];
                            $debitArray[$k]->amount          = -1 * ($each['amount']);
                            $totaldebit += (float)-1 * $each['amount'];
                        }
                        $k++;
                    }


                    if (((float)$total_amount) !== (float)$_POST['total_allocation_amount']) {
                        $valid          = false;
                        $others[]       = 'The total allocation amount should be equal to the Total amount';
                    }
                }


                // ----------------------------------------------------------------------------------------------
                // ------------end allocation------------------
                // ----------------------------------------------------------------------------------------------
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['voucher_type']        = $model_voucher_type->id;
                //Voucher Type id
                $modelAccVoucherType                = new AccVoucherType;
                $voucherHead['voucher_no']          = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                //invoice_no
                $voucherHead['transaction_date']    = date('Y-m-d');
                //invoice_date
                $voucherHead['transaction_number']  = ($reference !== '') ? $reference : $voucherHead['voucher_no'];
                //invoice_id
                $voucherHead['reference_no']        = ($reference !== '') ? $reference : $voucherHead['voucher_no'];
                //invoice_no
                $voucherHead['voucher_date']        =  (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
                //invoice_date
                $voucherHead['narration']           = $narration;

                $voucherHead['lead_owner']           = $lead_owner_id;

                //invoice_no
                $voucherHead['currency_id']         = 1;
                //currency_id
                $voucherHead['amount']              = $total_amount;
                //grand_total
                $voucherHead['payment_method']      = $_POST['payment_modes'];
                //payment_method
                $voucherHead['exchange_rate']       = 1;
                //exchange_rate
                $voucherHead['card_no']             = $_POST['card_no'];
                $voucherHead['bank_name']           = $_POST['bank_name'];
                $voucherHead['cheque_no']           = $_POST['cheque_no'];
                $voucherHead['cheque_date']         = (count(explode('/', $_POST['cheque_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date']))) : date('Y-m-d');;
                $voucherHead['due_date']            =  (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
                $voucherHead['customer_vendor_id']  = $customer_vendor_id;
                $voucherHead['year']                = $year;
                $voucherHead['company_id']          = $company_id;
                $voucherHead['branch_id']           = $branch_id;
                $voucherHead['project_id']          = $project_id;
                $voucherHead['department_id']       = $department_id;
                $voucherHead['employee_id']         = $employee_id;
                $voucherHead['salegroup_id']        = $salegroup_id;
                $voucherHead['vat']                 = $tax_amount;
                $voucherHead['imported']            = 'N';
                $voucherHead['net_amount']          = floatval($tax_amount) + floatval($total_amount);
                $voucherHead['warehouse_id']        = $warehouse_id;

                //-------saving receipt header details---------
                $receiptVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int)$receiptVoucherid > 0) {

                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($receiptVoucherid, $arr_items[$k]);
                    }


                    // ----------------------------------------------------------------------------------------------
                    // ------------allocation------------------
                    // ----------------------------------------------------------------------------------------------
                    if (!empty($modelAccAllocation)) {
                        $modelAccAllocation->amount = $totaldebit + (float)$total_amount;
                        $modelAccAllocation->save(false);
                        $modelAccAllocation->refresh();


                        foreach ($debitArray as $each) {
                            $modelVoucher = new AccVoucher();
                            $modelVoucher = $modelVoucher->findByPK((int)$each->voucher_id);
                            $modAccVoucherItems = new AccVoucherItems();
                            $modAccVoucherItems = $modAccVoucherItems->findByPK($each->voucher_item_id);
                            $each->allocation_id = $modelAccAllocation->id;
                            $each->allocation_date = $modelAccAllocation->allocation_date;
                            $each->ledger_id = $modAccVoucherItems->ledger_id;
                            $each->subledger_id = $modAccVoucherItems->subledger_id;
                            $each->voucher_type = $modelVoucher->voucher_type;
                            $each->customer_vendor_id = $modelVoucher->customer_vendor_id;
                            $each->created_by        = $modelAccAllocation->created_by;
                            $each->created_date_time = $modelAccAllocation->created_date_time;

                            $each->save(false);
                            $modAccVoucherItems->allocated_amount = $modAccVoucherItems->allocated_amount + (float)$each['amount'];
                            if (!empty($modAccVoucherItems->allocate_ids)) {
                                $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $each->id;
                            } else {
                                $modAccVoucherItems->allocate_ids = $each->id;
                            }
                            $modAccVoucherItems->save(false);
                            AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                        }


                        $modelVoucher = new AccVoucher();
                        $modelVoucher = $modelVoucher->findByPK((int)$receiptVoucherid);
                        $modAccVoucherItems = new AccVoucherItems();
                        $modAccVoucherItems = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int)$receiptVoucherid . ' AND ledger_id=' . (int) $_POST['from_account'] . ' AND subledger_id=' . (int) $_POST['from_subledger_id']));


                        $debitArray = new AccAllocationItems;
                        $debitArray->voucher_id = $receiptVoucherid;
                        $debitArray->voucher_item_id = $modAccVoucherItems->id;
                        $debitArray->amount = -1 * $modAccVoucherItems->amount; //round(abs($modAccVoucherItems->amount), 2);
                        $debitArray->allocation_id = $modelAccAllocation->id;
                        $debitArray->allocation_date = $modelAccAllocation->allocation_date;
                        $debitArray->ledger_id = $modAccVoucherItems->ledger_id;
                        $debitArray->subledger_id = $modAccVoucherItems->subledger_id;
                        $debitArray->voucher_type = $modelVoucher->voucher_type;
                        $debitArray->customer_vendor_id = $modelVoucher->customer_vendor_id;
                        $debitArray->created_by        = $modelAccAllocation->created_by;
                        $debitArray->created_date_time = $modelAccAllocation->created_date_time;
                        $debitArray->save(false);
                        $debitArray->refresh();
                        $modAccVoucherItems->allocated_amount = ($modAccVoucherItems->allocated_amount + (-1 * $modAccVoucherItems->amount));
                        if (!empty($modAccVoucherItems->allocate_ids)) {
                            $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $debitArray->id;
                        } else {
                            $modAccVoucherItems->allocate_ids = $debitArray->id;
                        }
                        $modAccVoucherItems->save(false);
                        AccVoucher::model()->updateBypk($debitArray->voucher_id, array('is_allocated' => 'Y'));

                        // -----------------------------

                        foreach ($creditArray as $each) {
                            $modelVoucher = new AccVoucher();
                            $modelVoucher = $modelVoucher->findByPK((int)$each->voucher_id);
                            $modAccVoucherItems = new AccVoucherItems();
                            $modAccVoucherItems = $modAccVoucherItems->findByPK($each->voucher_item_id);
                            $each->allocation_id = $modelAccAllocation->id;
                            $each->allocation_date = $modelAccAllocation->allocation_date;
                            $each->ledger_id = $modAccVoucherItems->ledger_id;
                            $each->subledger_id = $modAccVoucherItems->subledger_id;
                            $each->voucher_type = $modelVoucher->voucher_type;
                            $each->customer_vendor_id = $modelVoucher->customer_vendor_id;
                            $each->created_by        = $modelAccAllocation->created_by;
                            $each->created_date_time = $modelAccAllocation->created_date_time;
                            $each->save(false);
                            $modAccVoucherItems->allocated_amount = $modAccVoucherItems->allocated_amount + (float)$each['amount'];
                            if (!empty($modAccVoucherItems->allocate_ids)) {
                                $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $each->id;
                            } else {
                                $modAccVoucherItems->allocate_ids = $each->id;
                            }
                            $modAccVoucherItems->save(false);
                            AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                        }
                    }
                    // ----------------------------------------------------------------------------------------------
                    // ------------end allocation------------------
                    // ----------------------------------------------------------------------------------------------

                    PostingController::addroundoff($receiptVoucherid);

                    $jsonData['status']             = 'success';
                    if ($_POST['print'] == 'on') {
                        $jsonData['generate_print'] = 'Y';
                    }
                    $jsonData['id']     = (int)$receiptVoucherid;
                } else {
                    $jsonData['status']             = 'error';
                    $jsonData[]                     = 'Voucher Header Not Saved';
                }
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        } else {
            $jsonData['status'] = implode('<br>', $validationMessages);
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //add payment to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public function actionPostPayment()
    {


        $valid  = true;
        $valid1  = true;
        $validationMessages = [];
        if ($_POST['voucher_date'] == '') {
            $valid1  = false;
            $validationMessages[] = 'voucher_date  !  cant be null';
        }

        if ($_POST['to_account'] == '' || $_POST['to_account'] < 0) {
            $valid1  = false;
            $validationMessages[] = 'Expense Account !  cant be null';
        }

        if ($_POST['from_account'] == '' || $_POST['from_account'] < 0) {
            $valid  = false;
            $validationMessages[] = 'Payment Mode !  cant be null';
        }

        if (!empty($_POST['from_account'])) {
            $modelAccLedger  = new AccLedger();
            $modelAccLedger_det   = $modelAccLedger->findByPk($_POST['from_account']);
            if ($modelAccLedger_det->have_subledger == 'Y') {
                if ($_POST['from_subledger_id'] == '') {
                    $valid  = false;
                    $validationMessages[] = '' . $modelAccLedger_det->ledger_acc_name . ' Payment Subledger !  cant be null';
                } else {
                    $valid  = true;
                }
            }
        }


        if (!empty($_POST['to_account'])) {
            $modelAccLedger  = new AccLedger();
            $modelAccLedger_det   = $modelAccLedger->findByPk($_POST['to_account']);
            if ($modelAccLedger_det->have_subledger == 'Y') {
                if ($_POST['to_subledger_id'] == '') {
                    $valid  = false;
                    $validationMessages[] = '' . $modelAccLedger_det->ledger_acc_name . ' Account  Sub-ledger !  cant be null';
                } else {
                    $valid  = true;
                }
            }
        }


        if ($_POST['reference_no'] == '') {
            $valid  = false;
            $validationMessages[] = 'Reference No !  cant be null';
        }



        if ($_POST['amount'] == '') {
            $valid  = false;
            $validationMessages[] = 'Amount  !  cant be null';
        }
        if ($_POST['narration'] == '') {
            $valid  = false;
            $validationMessages[] = 'Narration  !  cant be null';
        }

        //   ---------------------AccAuditClose check------------------------------------

        $voucher_date  =  (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');

        $modelAccAuditClose = new AccAuditClose();
        $existing_date = strtotime($modelAccAuditClose->lastFinalCloseddate());
        $voucher_date = strtotime($voucher_date);
        if ($voucher_date <= $existing_date) {
            $valid = false;
            $validationMessages[] = ' Given Voucher date must be Greater than Final Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalCloseddate()))) . '';
        } else {
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            if ($voucher_date <= $existing_date) {
                if (!(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"]))) {
                    $valid = false;
                    $validationMessages[] = ' Given Voucher date must be Greater than Pre Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalCloseddate()))) . '';
                }
            }
        }
        //   --------------------//-AccAuditClose check------------------------------------




        if ($valid && $valid1) {
            // if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {

            if (isset($_POST['from_account']) && $_POST['from_account'] > 0) {

                $id = $_POST['id'];
                $valid = true;
                $others = [];


                //check whether voucher type defined
                $model_voucher_type             = new AccVoucherType();
                $model_voucher_type             = $model_voucher_type->find(array('condition' => 'code="PV"'));
                if (empty($model_voucher_type)) {
                    $valid          = false;
                    $others[]       = 'Voucher Type not defined';
                } else {
                    //check whether voucher type details defined
                    $modelvoucher_type_details      = new AccVoucherTypeDetails();
                    $modelvoucher_type_details      = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int)$model_voucher_type->id));
                    if (empty($modelvoucher_type_details)) {
                        $valid              = false;
                        $others[]           = 'Voucher Type Details not defined';
                    }

                    $from_ledger            = $_POST['from_account'];
                    $from_subledger         = $_POST['from_subledger_id'];
                    $have_from_subledger    = 'N';
                    if ($_POST['from_account'] > 0) {
                        $modelAccLedger     = new AccLedger();
                        $ledger             = $modelAccLedger->findByPk($_POST['from_account']);
                        if ($ledger->have_subledger == 'Y') {
                            $have_from_subledger = 'Y';
                        }
                    }
                    if ($have_from_subledger == 'Y' && (int)$from_subledger == 0) {

                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($from_ledger);



                        $valid              = false;
                        //  $others[]           = 'From Subledger not selected';
                        $others[] = '' . $modelAccLedger_det->ledger_acc_name . ' Payment Sub-ledger !  cant be null';
                    }


                    $to_ledger          = $_POST['to_account'];
                    $to_subledger       = $_POST['to_subledger_id'];
                    $have_to_subledger  = 'N';
                    if ($to_ledger > 0) {
                        $modelAccLedger = new AccLedger();
                        $ledger         = $modelAccLedger->findByPk($to_ledger);
                        if ($ledger->have_subledger == 'Y') {
                            $have_to_subledger = 'Y';
                        }
                    }
                    if ($have_to_subledger == 'Y' && (int)$to_subledger == 0) {
                        $valid              = false;
                        $others[]           = 'To Subledger not selected';
                    }


                    $modelVoucher = new AccVoucher();
                    $i = 0;
                    $usermodel = new user();
                    $usermodel          = $usermodel->findByPK((int)Yii::app()->user->id);
                    $employee_id        = (int)$usermodel->connected_employee_id;
                    $narration          = $_POST['narration'];
                    $invoice_id         = 0;
                    $amount             = $_POST['amount'];
                    $tax_amount         = $_POST['vat_amount'];
                    $tot_discount       = 0;
                    $round_off_amount   = 0;
                    $salegroup_id       = 0;
                    $project_id         = 0;
                    $branch_id          = $usermodel->branch_id;
                    $company_id         = $usermodel->company_id;
                    $payment_term_id    = $_POST['payment_modes'];
                    $costcenter_id      = 0;
                    $department_id      = 0;
                    $reference          = $_POST['reference_no'];
                    $discount_amt       = $_POST['discount'];
                    $total_amount       = (float)$_POST['amount'];


                    // $total_allocated_amount  = (float)$_POST['discount'] + (float)$_POST['amount'] + (float)$_POST['vat_amount'];
                    $total_allocated_amount  = (float)$_POST['amount'] - (float)$_POST['vat_amount'];

                    if ((int)$employee_id > 0) {
                        $modelEmployee = new Employee();
                        $modelEmployee = $modelEmployee->findByPK((int)$employee_id);
                        $department_id = $modelEmployee->department;
                    }

                    $warehouse_id       = 0;
                    $customer_vendor_id = 0;
                    if ((int)$to_subledger > 0) {
                        $modelCustomer_subledger = new AccSubledger();
                        $modelCustomer_subledger = $modelCustomer_subledger->findByPk((int)$to_subledger);
                        $customer_vendor_id = $modelCustomer_subledger->reference_id;
                    }
                    $year               = (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y');
                    $arr_items = [];
                    // -------------------------Payment Account--------------------------------------------

                    $payment_account_amt = (float)$_POST['amount']  - (float)$_POST['vat_amount'];

                    $arr_items[$i]                  = new AccVoucherItems();
                    $arr_items[$i]->ledger_id       = $to_ledger;
                    $arr_items[$i]->subledger_id    = (int)$to_subledger;
                    $arr_items[$i]->year            = $year;
                    $arr_items[$i]->credit          = 0.00;
                    $arr_items[$i]->debit           =  (float)$payment_account_amt;
                    $arr_items[$i]->amount          =  (float)$payment_account_amt;
                    $arr_items[$i]->employee_id     = $employee_id;
                    $arr_items[$i]->salegroup_id    = $salegroup_id;
                    $arr_items[$i]->payment_term_id = $payment_term_id;
                    $arr_items[$i]->narration       = $narration;
                    $arr_items[$i]->project_id      = $project_id;
                    $arr_items[$i]->company_id      = $company_id;
                    $arr_items[$i]->branch_id       = $branch_id;
                    $arr_items[$i]->costcenter_id   = $costcenter_id;
                    $arr_items[$i]->department_id   = $department_id;
                    $arr_items[$i]->exchange_rate   = 1;
                    $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                    $arr_items[$i]->warehouse_id    = $warehouse_id;
                    $i++;

                    // -------------------------Payment Mode--------------------------------------------
                    //  $payment_mode_amount = (float)$_POST['amount']  + (float)$_POST['vat_amount'] - (float)$_POST['discount'];

                    $payment_mode_amount = (float)$_POST['amount'];

                    $arr_items[$i]                  = new AccVoucherItems();
                    $arr_items[$i]->ledger_id       = $from_ledger;
                    $arr_items[$i]->subledger_id    = (int)$from_subledger;
                    $arr_items[$i]->year            = $year;
                    $arr_items[$i]->credit          = abs($payment_mode_amount);
                    $arr_items[$i]->debit           = '0.00';
                    $arr_items[$i]->amount          = (-1 * abs($payment_mode_amount));
                    $arr_items[$i]->employee_id     = $employee_id;
                    $arr_items[$i]->salegroup_id    = $salegroup_id;
                    $arr_items[$i]->payment_term_id = $payment_term_id;
                    $arr_items[$i]->narration       = $narration;
                    $arr_items[$i]->project_id      = $project_id;
                    $arr_items[$i]->company_id      = $company_id;
                    $arr_items[$i]->branch_id       = $branch_id;
                    $arr_items[$i]->costcenter_id   = $costcenter_id;
                    $arr_items[$i]->department_id   = $department_id;
                    $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                    $arr_items[$i]->warehouse_id    = $warehouse_id;
                    $i++;


                    // ---------------------------expense_vat ------------------------
                    if (abs((float)$tax_amount) > 0) {
                        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                        $expense_vat_ledger = $modelAccSystemAccountsMapping->getSystemdefault('expense_vat');
                        $arr_items[$i]                  = new AccVoucherItems();
                        $arr_items[$i]->ledger_id       = (int)$expense_vat_ledger;
                        $arr_items[$i]->subledger_id    = 0;
                        $arr_items[$i]->year            = $year;
                        $arr_items[$i]->debit           =  (float)$tax_amount;
                        $arr_items[$i]->amount          =  (float)$tax_amount;
                        $arr_items[$i]->employee_id     = $employee_id;
                        $arr_items[$i]->salegroup_id    = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration       = $narration;
                        $arr_items[$i]->project_id      = $project_id;
                        $arr_items[$i]->company_id      = $company_id;
                        $arr_items[$i]->exchange_rate   = 1;
                        $arr_items[$i]->branch_id       = $branch_id;
                        $arr_items[$i]->costcenter_id   = $costcenter_id;
                        $arr_items[$i]->department_id   = $department_id;
                        $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                        $arr_items[$i]->warehouse_id    = $warehouse_id;
                        $i++;
                    }

                    if (abs((float)$discount_amt) > 0) {
                        // ---------------------------sales_discount ------------------------
                        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                        $sales_discount_ledger = $modelAccSystemAccountsMapping->getSystemdefault('sales_discount');
                        $arr_items[$i]                  = new AccVoucherItems();
                        $arr_items[$i]->ledger_id       = (int)$sales_discount_ledger;
                        $arr_items[$i]->subledger_id    = 0;
                        $arr_items[$i]->year            = $year;
                        $arr_items[$i]->credit          = abs((float)$discount_amt);
                        $arr_items[$i]->debit           = '0.00';
                        $arr_items[$i]->amount          = (-1 * abs((float)$discount_amt));
                        $arr_items[$i]->employee_id     = $employee_id;
                        $arr_items[$i]->salegroup_id    = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration       = $narration;
                        $arr_items[$i]->project_id      = $project_id;
                        $arr_items[$i]->company_id      = $company_id;
                        $arr_items[$i]->exchange_rate   = 1;
                        $arr_items[$i]->branch_id       = $branch_id;
                        $arr_items[$i]->costcenter_id   = $costcenter_id;
                        $arr_items[$i]->department_id   = $department_id;
                        $arr_items[$i]->user_id         = (int)Yii::app()->user->id;
                        $arr_items[$i]->warehouse_id    = $warehouse_id;
                        $i++;
                    }



                    // ------------------------------------------allocation new ----------------------------------------------------
                    $comming_allocation_sum = 0;
                    if ($_POST['total_payment_amount_crdr'] > 0) {
                        $comming_allocation_sum = $_POST['total_payment_amount_crdr'];
                    } else if ($_POST['total_allocation_amount'] > 0) {
                        $comming_allocation_sum = $_POST['total_allocation_amount'];
                    }

                    if ($comming_allocation_sum > 0) {

                        $modelAccAllocation                  = new AccAllocation;
                        $modelAccAllocation['ledger_id']     = $_POST['to_account'];
                        $modelAccAllocation['subledger_id']  = $_POST['to_subledger_id'];
                        $modelAccAllocation['allocation_date'] = date('Y-m-d');
                        $modelAccAllocation['created_by'] = Yii::app()->user->id;
                        $modelAccAllocation['created_date_time'] = date('Y-m-d H:i:s');

                        $j = 0;

                        $debitArray = $creditArray = [];
                        $count_credit = $totalcredit = 0;
                        foreach ($_POST['Credit'] as $each) {
                            $allocation_amount = $each['amount'];
                            if ($allocation_amount > 0) {
                                $creditArray[$j]                    = new AccAllocationItems;
                                $creditArray[$j]->voucher_id        = $each['voucher_id'];
                                $creditArray[$j]->voucher_item_id   = $each['voucher_item_id'];
                                $creditArray[$j]->amount            =  ($allocation_amount);
                                $totalcredit += (float) abs($each['amount']);
                                $count_credit++;
                            }
                            $j++;
                        }
                        $k = $totaldebit = $count_debit = 0;
                        foreach ($_POST['Debit'] as $each) {

                            $allocation_amount = $each['amount'];

                            if ($allocation_amount < 0) {
                                $debitArray[$k]                    = new AccAllocationItems;
                                $debitArray[$k]->voucher_id        = $each['voucher_id'];
                                $debitArray[$k]->voucher_item_id   = $each['voucher_item_id'];
                                $debitArray[$k]->amount            =  ($allocation_amount);
                                $totaldebit              += (float)  $allocation_amount;
                                $count_debit++;
                            }
                            $k++;
                        }

                        if ((float)$total_allocated_amount !== (float)$comming_allocation_sum) {
                            $valid          = false;
                            // $others[]       = 'The total allocation amount should be equal to the Total amount';
                            $others[] = "The total allocation amount : (" . (float)$comming_allocation_sum . ") should be equal to the Total amount : (" . (float)$total_allocated_amount . ")";
                        }
                    }



                    // ------------------------------------------allocation old----------------------------------------------------


                    /*  if ($_POST['total_allocation_amount'] > 0) {
                        $modelAccAllocation                  = new AccAllocation;
                        $modelAccAllocation['ledger_id']     = $_POST['to_account'];
                        $modelAccAllocation['subledger_id']  = $_POST['to_subledger_id'];
                        $modelAccAllocation['amount']        = $_POST['total_amount'];
                        $j = 0;
                        $debitArray = $creditArray = [];
                        foreach ($_POST['Credit'] as  $each) {
                            if ($each['amount'] > 0) {
                                $debitArray[$j]                  = new AccAllocationItems;
                                $debitArray[$j]->voucher_id      = $each['voucher_id'];
                                $debitArray[$j]->voucher_item_id = $each['voucher_item_id'];
                                $debitArray[$j]->amount          = $each['amount'];
                            }

                            $creditArray[0]                  = new AccAllocationItems;
                            $creditArray[0]->voucher_id      = 0;
                            $creditArray[0]->voucher_item_id = 0;
                            $creditArray[0]->amount          = -1 * ($total_allocated_amount);
                            $j++;
                        }
                        if ((float)$total_allocated_amount !== (float)$_POST['total_allocation_amount']) {
                            $valid          = false;
                           // $others[]       = 'The total allocation amount should be equal to the Total amount';
                               $others[] = "The total allocation amount : (" . (float)$_POST['total_allocation_amount'] . ") should be equal to the Total amount : (" . (float)$total_allocated_amount . ")";

                        }

                    } */
                    // ----------------------------------------------------------------------------------------------
                    // ------------end allocation------------------
                    // ----------------------------------------------------------------------------------------------


                }
                if ($valid) {

                    $voucherHead = array();
                    $voucherHead['voucher_type']        = $model_voucher_type->id;
                    $modelAccVoucherType                = new AccVoucherType;
                    $voucherHead['voucher_no']          = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                    $voucherHead['transaction_date']    = date('Y-m-d');
                    $voucherHead['transaction_number']  = $reference;
                    $voucherHead['reference_no']        = $reference;
                    $voucherHead['voucher_date']        =  (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
                    $voucherHead['narration']           = $narration;
                    $voucherHead['currency_id']         = 1;
                    $voucherHead['amount']              = $total_amount;
                    $voucherHead['payment_method']      = $_POST['payment_modes'];
                    $voucherHead['exchange_rate']       = 1;
                    $voucherHead['card_no']             = $_POST['card_no'];
                    $voucherHead['bank_name']           = $_POST['bank_name'];
                    $voucherHead['cheque_no']           = $_POST['cheque_no'];
                    $voucherHead['cheque_date']         = (count(explode('/', $_POST['cheque_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date']))) : date('Y-m-d');;
                    $voucherHead['due_date']            =  (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
                    $voucherHead['customer_vendor_id']  = $customer_vendor_id;
                    $voucherHead['lead_owner']          = (int)Yii::app()->user->id;
                    $voucherHead['year']                = $year;
                    $voucherHead['company_id']          = $company_id;
                    $voucherHead['branch_id']           = $branch_id;
                    $voucherHead['project_id']          = $project_id;
                    $voucherHead['department_id']       = $department_id;
                    $voucherHead['employee_id']         = $employee_id;
                    $voucherHead['salegroup_id']        = $salegroup_id;
                    $voucherHead['vat']                 = $tax_amount;
                    $voucherHead['imported']            = 'N';
                    $voucherHead['net_amount']          = floatval($total_amount);
                    $voucherHead['warehouse_id']        = $warehouse_id;
                    //-------saving payment header details---------
                    $paymentVoucherid = PostingController::addVoucherhead($voucherHead);
                    if ((int)$paymentVoucherid > 0) {
                        $modelAccVoucher = new AccVoucher();
                        for (
                            $k = 0;
                            $k < $i;
                            $k++
                        ) {
                            PostingController::addVoucheritems($paymentVoucherid, $arr_items[$k]);
                        }
                        // ------------allocation-----------------------------------------------------------------
                        if (!empty($modelAccAllocation)) {
                            $modelAccAllocation->amount = $totalcredit;
                            $modelAccAllocation->save(false);
                            $modelAccAllocation->refresh();
                            foreach ($debitArray as $each) {
                                $modelVoucher             = new AccVoucher();
                                $modelVoucher             = $modelVoucher->findByPK((int) $each->voucher_id);
                                $modAccVoucherItems       = new AccVoucherItems();
                                $modAccVoucherItems       = $modAccVoucherItems->findByPK($each->voucher_item_id);
                                $each->allocation_id      = $modelAccAllocation->id;
                                $each->allocation_date    = $modelAccAllocation->allocation_date;
                                $each->ledger_id          = $modAccVoucherItems->ledger_id;
                                $each->subledger_id       = $modAccVoucherItems->subledger_id;
                                $each->voucher_type       = $modelVoucher->voucher_type;
                                $each->customer_vendor_id = $modelVoucher->customer_vendor_id;
                                $each->created_by         = $modelAccAllocation->created_by;
                                $each->created_date_time  = $modelAccAllocation->created_date_time;
                                $each->save(false);
                                $modAccVoucherItems->allocated_amount = (float)$modAccVoucherItems->allocated_amount + (float) $each['amount'];
                                if (!empty($modAccVoucherItems->allocate_ids)) {
                                    $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $each->id;
                                } else {
                                    $modAccVoucherItems->allocate_ids = $each->id;
                                }
                                $modAccVoucherItems->save(false);
                                AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                            }
                            $modelVoucher       = new AccVoucher();
                            $modelVoucher       = $modelVoucher->findByPK((int) $paymentVoucherid);
                            $modAccVoucherItems = new AccVoucherItems();
                            $modAccVoucherItems = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $paymentVoucherid . ' AND ledger_id=' . (int) $_POST['to_account'] . ' AND subledger_id=' . (int) $_POST['to_subledger_id']));
                            $debitArray                     = new AccAllocationItems;
                            $debitArray->voucher_id         = $paymentVoucherid;
                            $debitArray->voucher_item_id    = $modAccVoucherItems->id;
                            $debitArray->amount             = -1 * $modAccVoucherItems->amount; //round(abs($modAccVoucherItems->amount), 2);
                            $debitArray->allocation_id      = $modelAccAllocation->id;
                            $debitArray->allocation_date    = $modelAccAllocation->allocation_date;
                            $debitArray->ledger_id          = $modAccVoucherItems->ledger_id;
                            $debitArray->subledger_id       = $modAccVoucherItems->subledger_id;
                            $debitArray->voucher_type       = $modelVoucher->voucher_type;
                            $debitArray->customer_vendor_id = $modelVoucher->customer_vendor_id;
                            $debitArray->created_by         = $modelAccAllocation->created_by;
                            $debitArray->created_date_time  = $modelAccAllocation->created_date_time;
                            $debitArray->save(false);
                            $debitArray->refresh();
                            $modAccVoucherItems->allocated_amount = ((float)$modAccVoucherItems->allocated_amount + (-1 * (float)$modAccVoucherItems->amount));
                            if (!empty($modAccVoucherItems->allocate_ids)) {
                                $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $debitArray->id;
                            } else {
                                $modAccVoucherItems->allocate_ids = $debitArray->id;
                            }
                            $modAccVoucherItems->save(false);
                            AccVoucher::model()->updateBypk($debitArray->voucher_id, array('is_allocated' => 'Y'));
                            // -----------------------------
                            foreach ($creditArray as $each) {
                                $modelVoucher = new AccVoucher();
                                $modelVoucher             = $modelVoucher->findByPK((int) $each->voucher_id);
                                $modAccVoucherItems       = new AccVoucherItems();
                                $modAccVoucherItems       = $modAccVoucherItems->findByPK($each->voucher_item_id);
                                $each->allocation_id      = $modelAccAllocation->id;
                                $each->allocation_date    = $modelAccAllocation->allocation_date;
                                $each->ledger_id          = $modAccVoucherItems->ledger_id;
                                $each->subledger_id       = $modAccVoucherItems->subledger_id;
                                $each->voucher_type       = $modelVoucher->voucher_type;
                                $each->customer_vendor_id = $modelVoucher->customer_vendor_id;
                                $each->created_by = $modelAccAllocation->created_by;
                                $each->created_date_time = $modelAccAllocation->created_date_time;
                                $each->save(false);
                                $modAccVoucherItems->allocated_amount = (float)$modAccVoucherItems->allocated_amount + (float) $each['amount'];
                                if (!empty($modAccVoucherItems->allocate_ids)) {
                                    $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $each->id;
                                } else {
                                    $modAccVoucherItems->allocate_ids = $each->id;
                                }
                                $modAccVoucherItems->save(false);
                                AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                            }
                        }

                        // ------------allocation old------------------
                        /* if (!empty($modelAccAllocation)) {
                            $modelAccVoucher = new AccVoucher();
                            $modAccVoucherItems  = new AccVoucherItems();

                            $paymentallocationid = PostingController::AddMultiAllocationHeader($modelAccAllocation);

                            $debitUpdates = [];

                            for ($x = 0; $x < $j; $x++) {
                                $resultdebit = PostingController::AddMultiAllocationDebititems($paymentallocationid, $debitArray[$x]);
                                $debitUpdates[] = [
                                    'voucher_id' => $resultdebit['voucher_id'],
                                    'voucher_item_id' => $resultdebit['voucher_item_id'],
                                    'amount' => $resultdebit['amount']
                                ];
                            }

                            foreach ($debitUpdates as $debitUpdate) {
                                $modelAccVoucher->updateBypk($debitUpdate['voucher_id'], array('is_allocated' => 'Y'));

                                if ((int)$debitUpdate['voucher_item_id'] > 0) {
                                    $modAccVoucherItems = $modAccVoucherItems->findByPK((int)$debitUpdate['voucher_item_id']);
                                    if (!empty($modAccVoucherItems)) {
                                        $modAccVoucherItems->allocated_amount = (float)$modAccVoucherItems->allocated_amount + (float)$debitUpdate['amount'];
                                        $modAccVoucherItems->save(false);
                                    }
                                }
                            }




                            $resultcredit = PostingController::AddMultiAllocationCredititems($paymentVoucherid, $paymentallocationid, $creditArray[0]);
                            if (!empty($resultcredit)) {
                                $voucherId_credit = $resultcredit['voucher_id'];
                                $voucher_item_id_credit = $resultcredit['voucher_item_id'];
                                $amount_credit = $resultcredit['amount'];
                                $modelAccVoucher->updateBypk($voucherId_credit, array('is_allocated' => 'Y'));

                                if ((int)$resultcredit['voucher_item_id'] > 0) {
                                    $modAccVoucherItems = $modAccVoucherItems->findByPK((int)$resultcredit['voucher_item_id']);
                                    if (!empty($modAccVoucherItems)) {
                                        $modAccVoucherItems->allocated_amount = (float)$modAccVoucherItems->allocated_amount + (float)$resultcredit['amount'];
                                        $modAccVoucherItems->save(false);
                                    }
                                }
                            }
                        } */
                        // ------------end allocation------------------

                        PostingController::addroundoff($paymentVoucherid);

                        $jsonData['status']             = 'success';
                        if ($_POST['print'] == 'on') {
                            $jsonData['generate_print'] = 'Y';
                        }
                        $jsonData['id']     = (int)$paymentVoucherid;
                    } else {
                        $jsonData['status']             = 'error';
                        $jsonData[]                     = 'Voucher Header Not Saved';
                    }
                    echo CJSON::encode($jsonData);
                } else {
                    $error = CJSON::encode($others);
                    //array_merge_recursive($error, $error1, $error2, $error3, $others)
                    if ($error != '[]')
                        echo $error;
                }
            } else {
                $jsonData['status'] = 'Payment Mode !  cant be null';
                echo CJSON::encode($jsonData);
            }
        } else {
            $jsonData['status'] = implode('<br>', $validationMessages);
            echo CJSON::encode($jsonData);
        }
    }
    // ----------------------------------------------------------------------------
    public static function addVoucherhead($arr_items)
    {
        //------------------warehouse-----------------------
        $warehouse_id = $arr_items['warehouse_id'];
        if ((int) $warehouse_id == 0) {
            if ($arr_items['lead_owner'] > 0) {
                $modeluser = new User();
                // $warehouse_id = $modeluser->findByPK($arr_items['lead_owner'])->warehouse_id;
                $user_det = $modeluser->findByPK($arr_items['lead_owner']);
                if ((isset($user_det->warehouse_id))) {
                    $warehouse_id = $user_det->warehouse_id;
                }
            }
        }

        $modelVoucher = new AccVoucher();
        $modelVoucher->file_id = $arr_items['file_id'];
        $modelVoucher->voucher_type = (int) $arr_items['voucher_type'];
        $modelVoucher->voucher_no = $arr_items['voucher_no'];
        $modelVoucher->voucher_date = (isset($arr_items['voucher_date'])) ? $arr_items['voucher_date'] : date('Y-m-d');
        $modelVoucher->transaction_date = (isset($arr_items['transaction_date'])) ? $arr_items['transaction_date'] : $modelVoucher->voucher_date;
        $modelVoucher->transaction_number = (isset($arr_items['transaction_number'])) ? $arr_items['transaction_number'] : $modelVoucher->voucher_no;
        $modelVoucher->transaction_id = (isset($arr_items['transaction_id'])) ? $arr_items['transaction_id'] : $modelVoucher->voucher_no;
        $modelVoucher->reference_no = $arr_items['reference_no'];
        $modelVoucher->general_narration = $arr_items['narration'];
        $modelVoucher->voucher_value = $arr_items['voucher_value'];
        $modelVoucher->currency_id = (isset($arr_items['currency_id'])) ? $arr_items['currency_id'] : '1';
        $modelVoucher->exchange_rate = (isset($arr_items['exchange_rate'])) ? $arr_items['exchange_rate'] : '1';
        $modelVoucher->amount = (isset($arr_items['amount'])) ? round($arr_items['amount'], 2) : '1';
        $modelVoucher->total_amount_in_selected_currency = (isset($arr_items['total_amount_in_selected_currency'])) ? round($arr_items['total_amount_in_selected_currency'], 2) : 0;
        $modelVoucher->total_exchange_difference = (isset($arr_items['total_exchange_difference'])) ? round($arr_items['total_exchange_difference'], 2) : 0;
        $modelVoucher->vat = $arr_items['vat'];
        $modelVoucher->net_amount = $arr_items['net_amount'];
        $modelVoucher->total_discount = $arr_items['total_discount'];
        $modelVoucher->rounding = $arr_items['rounding'];
        $modelVoucher->tax_type = $arr_items['tax_type'];
        $modelVoucher->tax_id = $arr_items['tax_id'];
        $modelVoucher->order_id = $arr_items['order_id'];
        $modelVoucher->delivery_id = $arr_items['delivery_id'];
        $modelVoucher->direct = $arr_items['direct'];
        $modelVoucher->imported = $arr_items['imported'];
        $modelVoucher->bank_name = (isset($arr_items['bank_name'])) ? $arr_items['bank_name'] : '';
        $modelVoucher->card_no = (isset($arr_items['card_no'])) ? $arr_items['card_no'] : '';
        $modelVoucher->customer_vendor_id = (isset($arr_items['customer_vendor_id'])) ? $arr_items['customer_vendor_id'] : '0';
        $modelVoucher->payment_method = (isset($arr_items['payment_method'])) ? $arr_items['payment_method'] : '0';
        $modelVoucher->payment_days = $arr_items['payment_days'];
        $modelVoucher->payment_terms = $arr_items['payment_terms'];
        $modelVoucher->cheque_no = (isset($arr_items['cheque_no'])) ? $arr_items['cheque_no'] : '';
        $modelVoucher->voucher_ref_id = (isset($arr_items['voucher_ref_id'])) ? $arr_items['voucher_ref_id'] : 0;
        $modelVoucher->cheque_date = (isset($arr_items['cheque_date'])) ? $arr_items['cheque_date'] : '0000-00-00';
        $modelVoucher->cheque_cleared = 'N';
        $modelVoucher->due_date = (isset($arr_items['due_date'])) ? $arr_items['due_date'] : $modelVoucher->voucher_date;
        $modelVoucher->is_posted = 'Y';
        $modelVoucher->posted_date = date('Y-m-d h:i:s');;
        $modelVoucher->is_allocated = (isset($arr_items['is_allocated'])) ? $arr_items['is_allocated'] : 'N';
        $modelVoucher->allocation_date = '';
        $modelVoucher->lead_owner = (isset($arr_items['lead_owner'])) ? $arr_items['lead_owner'] : '0';
        $modelVoucher->salegroup_id = $arr_items['salegroup_id'];
        $modelVoucher->year = $arr_items['year'];
        $modelVoucher->company_id = $arr_items['company_id'];
        $modelVoucher->branch_id = $arr_items['branch_id'];
        $modelVoucher->project_id = $arr_items['project_id'];
        $modelVoucher->department_id = $arr_items['department_id'];
        $modelVoucher->employee_id = $arr_items['employee_id'];
        $modelVoucher->created_by = $arr_items['lead_owner'];
        $modelVoucher->warehouse_id = $warehouse_id;
        $modelVoucher->outlet_id =   $arr_items['outlet_id'];
        $modelVoucher->created_datetime = $modelVoucher->transaction_date;
        $modelVoucher->updated_by = $arr_items['lead_owner'];
        $modelVoucher->payment_modes = (isset($arr_items['payment_modes'])) ? $arr_items['payment_modes'] : '';
        $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
        $modelVoucher->save(false);
        return ($modelVoucher->save(false)) ? $modelVoucher->id : 0;
        //exception
    }
    public static function addVoucheritems($headerId, $arr_items)
    {
        $model = new AccVoucherItems();
        $model->acc_voucher_id = $headerId;
        $model->ledger_id = $arr_items['ledger_id'];
        $model->subledger_id = $arr_items['subledger_id'];
        if ($arr_items['ledger_id'] > 0) {
            $modell = new AccLedger;
            $model->ledger_name = $modell->findByPK($arr_items['ledger_id'])->ledger_acc_name;
        }
        if ($arr_items['subledger_id'] > 0) {
            $modelCustomer_subledger = new AccSubledger();
            $model->subledger_name = $modelCustomer_subledger->findByPK($arr_items['subledger_id'])->subledger_name;
        }
        $model->credit = round($arr_items['credit'], 6);
        $model->debit = round($arr_items['debit'], 6);
        $model->year = $arr_items['year'];
        $model->company_id = $arr_items['company_id'];
        $model->branch_id = $arr_items['branch_id'];
        $model->project_id = $arr_items['project_id'];
        $model->department_id = $arr_items['department_id'];
        $model->employee_id = $arr_items['employee_id'];
        $model->costcenter_id = $arr_items['costcenter_id'];
        $narration = $arr_items['narration'];
        if ((int) $arr_items['product_id'] > 0) {
            $model->product_id = (int) $arr_items['product_id'];
            $modStore = new Store();
            $modStore = $modStore->findByPk((int) $model->product_id);
            $narration .= ' Product : ' . $modStore->part_number . ' / ' . $modStore->description;
            $model->part_number = $modStore->part_number;
            $model->product_name = $modStore->description;
            $model->brand_id = $modStore->brand_class_id;
            $model->generic_id = $modStore->generic_id;;
            $model->inventory_item_type = $modStore->inventory_item_type;
        }
        $model->narration = $narration;
        $model->payment_term_id = $arr_items['payment_term_id'];
        $model->salegroup_id = $arr_items['salegroup_id'];
        $model->amount = round($arr_items['amount'], 6);
        $model->currency_amount = round($arr_items['currency_amount'], 6);
        // --------------new-----------------------
        $model->file_id = $arr_items['file_id'];
        $model->quantity = $arr_items['quantity'];
        $model->unit_id = $arr_items['unit_id'];
        $model->unit_factor = $arr_items['unit_factor'];
        $model->rate = $arr_items['rate'];
        $model->currency_id = (isset($arr_items['currency_id'])) ? $arr_items['currency_id'] : '1';
        $model->exchange_rate = ($arr_items['exchange_rate'] != 0) ? $arr_items['exchange_rate'] : '1';
        $model->tax = $arr_items['tax'];
        $model->net_amount = $arr_items['net_amount'];
        $model->current_cost = $arr_items['current_cost'];
        $model->last_cost = $arr_items['last_cost'];
        $model->balance_qty = $arr_items['balance_qty'];
        $model->inventory_value = $arr_items['inventory_value'];
        $model->discount_percentage = $arr_items['discount_percentage'];
        $model->discount_amount = $arr_items['discount_amount'];
        $model->rounding = $arr_items['rounding'];
        $model->warehouse_id = $arr_items['warehouse_id'];
        $model->outlet_id = $arr_items['warehouse_id'];
        $model->foc = $arr_items['foc'];
        $model->payment_mode_id = (isset($arr_items['payment_mode_id'])) ? $arr_items['payment_mode_id'] : '0';
        $model->opening_cheque_cleared = $arr_items['opening_cheque_cleared'];
        $model->cheque_bounced = $arr_items['cheque_bounced'];
        $model->reconciled = $arr_items['reconciled'];
        // --------------//------------------------
        $model->created_by = $arr_items['user_id'];
        $model->created_datetime = date('Y-m-d h:i:s');
        $model->updated_by = $arr_items['user_id'];
        $model->updated_datetime = date('Y-m-d h:i:s');
        $model->batch_no = $arr_items['batch_no'];
        $model->batch_date = $arr_items['batch_date'];
       
        $model->save(false);
    }
    // ------------allocation------------------
    public static function AddMultiAllocationHeader($arr_items)
    {
        $modelAccAllocation = new AccAllocation;
        $modelAccAllocation->ledger_id = $arr_items['ledger_id'];
        $modelAccAllocation->subledger_id = $arr_items['subledger_id'];
        $modelAccAllocation->allocation_date = date('Y-m-d');
        $modelAccAllocation->created_by = Yii::app()->user->id;
        $modelAccAllocation->created_date_time = date('Y-m-d h:i:s');
        $modelAccAllocation->amount = $arr_items['amount'];
        return ($modelAccAllocation->save(false)) ? $modelAccAllocation->id : 0;
    }
    public static function AddMultiAllocationDebititems($headerId, $arr_items)
    {
        $model = new AccAllocation;
        $model = $model->findBypk($headerId);
        $modelAccVoucher = new AccVoucher();
        $modelAccVoucher = $modelAccVoucher->findBypk($arr_items['voucher_id']);
        $modelAccAllocationItems = new AccAllocationItems;
        $modelAccAllocationItems->allocation_id = $headerId;
        $modelAccAllocationItems->voucher_id = $arr_items['voucher_id'];
        $modelAccAllocationItems->voucher_item_id = $arr_items['voucher_item_id'];
        $modelAccAllocationItems->amount = $arr_items['amount'];
        $modelAccAllocationItems->allocation_date = $model->allocation_date;
        $modelAccAllocationItems->ledger_id = $model->ledger_id;
        $modelAccAllocationItems->subledger_id = $model->subledger_id;
        $modelAccAllocationItems->reference_id = $modelAccVoucher->reference_no;
        $modelAccAllocationItems->customer_vendor_id = $modelAccVoucher->customer_vendor_id;
        $modelAccAllocationItems->voucher_type = $modelAccVoucher->voucher_type;
        $modelAccAllocationItems->created_by = Yii::app()->user->id;
        $modelAccAllocationItems->created_date_time = date('Y-m-d h:i:s');
        //  return ($modelAccAllocationItems->save(false)) ? $modelAccAllocationItems->voucher_id : 0;
        if ($modelAccAllocationItems->save(false)) {
            return array(
                'voucher_id' => $modelAccAllocationItems->voucher_id,
                'voucher_item_id' => $modelAccAllocationItems->voucher_item_id,
                'amount' => $modelAccAllocationItems->amount,
            );
        }
        return 0;
    }
    public static function AddMultiAllocationCredititems($voucherheadid, $headerId, $arr_items)
    {
        $model = new AccAllocation;
        $model = $model->findBypk($headerId);
        $modelAccVoucher = new AccVoucher();
        $modelAccVoucher = $modelAccVoucher->findBypk($voucherheadid);
        $modelAccVoucherItems = new AccVoucherItems();
        $modelAccVoucherItems = $modelAccVoucherItems->find(array('condition' => "t.acc_voucher_id = $voucherheadid AND t.ledger_id = {$model->ledger_id}"));
        $modelAccAllocationItems = new AccAllocationItems;
        $modelAccAllocationItems->allocation_id = $headerId;
        $modelAccAllocationItems->voucher_id = $voucherheadid;
        $modelAccAllocationItems->voucher_item_id = $modelAccVoucherItems->id;
        $modelAccAllocationItems->amount = $arr_items['amount'];
        $modelAccAllocationItems->ledger_id = $modelAccVoucherItems->ledger_id;
        $modelAccAllocationItems->subledger_id = $modelAccVoucherItems->subledger_id;
        $modelAccAllocationItems->allocation_date = $model->allocation_date;
        $modelAccAllocationItems->reference_id = $modelAccVoucher->reference_no;
        $modelAccAllocationItems->customer_vendor_id = $modelAccVoucher->customer_vendor_id;
        $modelAccAllocationItems->voucher_type = $modelAccVoucher->voucher_type;
        $modelAccAllocationItems->created_by = Yii::app()->user->id;
        $modelAccAllocationItems->created_date_time = date('Y-m-d h:i:s');
        // return ($modelAccAllocationItems->save(false)) ? $modelAccAllocationItems->voucher_id : 0;
        if ($modelAccAllocationItems->save(false)) {
            return array(
                'voucher_id' => $modelAccAllocationItems->voucher_id,
                'voucher_item_id' => $modelAccAllocationItems->voucher_item_id,
                'amount' => $modelAccAllocationItems->amount,
            );
        }
        return 0;
    }
    // ------------end allocation------------------
    // --------------------------------------------------------------------------------------------------------- ----
    //import (post/unpost) purchase invoice and sales Invoice items to finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public function actionSavemodulevouchers()
    {
        // -------------------------------
        $have_sales_receipt = 'N';
        $allow_multi_receipt = 'N';
        $allow_deliverynote = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT * FROM {{acc_general_settings}}")->queryRow();
            $have_sales_receipt =  $acc_settings['have_sales_receipt'];
            $allow_multi_receipt =  $acc_settings['allow_multi_receipt'];
            $allow_deliverynote  =  $acc_settings['allow_deliverynote'];
        }
        // -------------------------------
        $status = ($_POST['status'] == 'NEW') ? 'N' : 'Y'; // post = 'N' unpost='Y'
        if (!empty($_POST['ids'])) {
            $array_ids = $_POST['ids'];  // array id's
        } else {
            $array_ids = $_POST['Invoice'];
        }
        $import_from = $_POST['import_from'];
        $import_from = $_POST['import_from'];
        // $import_status   = $_POST['import_status'];
        $import_status = $_POST['voucher_import'];
        if ($array_ids != '') {
            if ((count($array_ids)) > 0) {
                /**
                  --import sales invoice items to finance voucher and voucher items--
                 * */
                if ($import_status == "Y") {
                    if ($import_from == 'sales_inv') {
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                foreach ($array_ids as $each_invoice_id) {
                                    $modelInvoice = new Invoice();
                                    $modelInvoice = $modelInvoice->findBYPK((int) $each_invoice_id);
                                    if ((int) $modelInvoice->delivery_ids > 0 && $allow_deliverynote == 'Y') {
                                        $modelDeliveryNote = new DeliveryNote();
                                        $modelDeliveryNote = $modelDeliveryNote->findBYPK((int) $modelInvoice->delivery_ids);
                                        if ($modelDeliveryNote->posted == "N") {
                                            // $var = PostingController::addPostDeliveryNote([$modelDeliveryNote->id], 'INVOICE');
                                        }
                                    }
                                }
                                PostingController::addPostSales($array_ids, $from);
                                foreach ($array_ids as $each_invoice_id) {
                                    $modelInvoice = new Invoice();
                                    $modelInvoice = $modelInvoice->findByPk((int)$each_invoice_id);
                                    if (isset($modelInvoice->receipt_type) && $have_sales_receipt == 'Y'  && $allow_multi_receipt == 'N') {
                                        if ($modelInvoice->receipt_type != 'CREDIT') {
                                            PostingController::addPostReceipt_frm_invoice($each_invoice_id);
                                            PostingController::allocateInvoiceVoucherwithreceipt($each_invoice_id);
                                        }
                                    }
                                }
                            } else if ($status == 'Y') { //un post    


                                PostingController::addUnpostSales($array_ids);
                            }
                        }
                    }
                    /**
                      --import purchase invoice items to finance voucher and voucher items--
                     * */
                    if ($import_from == 'purchase_inv') {
                        //PostingController::addPostPurchaseInvoice($array_ids, $from);
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                PostingController::addPostPurchaseInvoice($array_ids, $from);
                            } else if ($status == 'Y') { //un post
                                PostingController::addUnpostPurchaseInvoice($array_ids);
                            }
                        }
                    }
                    /**
                      --import credit note items to finance voucher and voucher items--
                     * */

                    if ($import_from == 'credit_note') {
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                PostingController::addPostCreditnote($array_ids, $from);

                                foreach ($array_ids as $each_invoice_id) {
                                    $modelCreditnote = new Creditnote();
                                    $modelCreditnote = $modelCreditnote->findByPk((int)$each_invoice_id);
                                    if (isset($modelCreditnote->payment_type) && $have_sales_receipt == 'Y'  && $allow_multi_receipt == 'N') {
                                        if ($modelCreditnote->payment_type != 'CREDIT') {
                                            PostingController::addPostpayment_frm_creditnote($each_invoice_id);
                                            PostingController::allocateSalesreturnVoucherwithPayment($each_invoice_id);
                                        }
                                    }

                                    if ($have_sales_receipt == 'Y'  && $allow_multi_receipt == 'Y') {
                                        $model_voucher_type = new AccVoucherType();
                                        $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="SI"'));
                                        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                                        $from_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
                                        $sqlacc = "SELECT 
                                                SUM(IFNULL(ABS(VI.allocated_amount), 0)) AS total_allocated,
                                                SUM(IFNULL(ABS(VI.amount), 0)) AS total_amount
                                                    FROM  {{acc_voucher_items}} VI
                                                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                                                    WHERE   V.is_posted = 'Y' AND  V.transaction_id  = '" . $modelCreditnote->invoice_id . "'  AND V.voucher_type = '" . $model_voucher_type->id . "'  AND VI.ledger_id = '" . $from_ledger . "'
                                                    GROUP BY V.id";
                                        $command_acc = Yii::app()->db->createCommand($sqlacc);
                                        $acc_detls = $command_acc->queryAll();
                                        //   $inv_balance = (float)$modelCreditnote->invoice->grand_total - (float)$acc_detls[0]['total_allocated'];
                                        // -------------------------------
                                        $inv_balance_amt = (float) $acc_detls[0]['total_amount'] - (float) $acc_detls[0]['total_allocated'];

                                        if ((float) $acc_detls[0]['total_allocated'] == 0) {
                                            PostingController::allocateSalesreturnVoucherwithSales((int) $each_invoice_id);
                                        } else if ($inv_balance_amt >= (float) $modelCreditnote->credited_amount) {
                                            PostingController::allocateSalesreturnVoucherwithSales((int) $each_invoice_id);
                                        } else {
                                            PostingController::addPostmultipayment_frm_creditnote((int)$each_invoice_id);
                                            PostingController::allocateSalesreturnVoucherwithPaymentandSales((int) $each_invoice_id);
                                        }
                                    }
                                }
                            } else  if ($status == 'Y') { //un post
                                PostingController::addUnpostCreditnote($array_ids);
                            }
                        }
                    }

                    /**
                      --import debit note items to finance voucher and voucher items--
                     * */
                    if ($import_from == 'debit_note') {
                        //PostingController::addPostdebitnote($array_ids, $from);
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                PostingController::addPostdebitnote($array_ids, $from);
                            } else if ($status == 'Y') { //un post
                                PostingController::addUnpostdebitnote($array_ids);
                            }
                        }
                    }
                    /**
                      --import goods issue items to finance voucher and voucher items--
                     * */
                    if ($import_from == 'goods_issue') {
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                PostingController::addPostgoodsissue($array_ids, $from);
                            } else if ($status == 'Y') { //un post
                                PostingController::addUnpostgoodsissue($array_ids);
                            }
                        }
                    }
                    /**
                      --import goods receipt items to finance voucher and voucher items--
                     * */
                    if ($import_from == 'goods_receipt') {
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                PostingController::addPostgoodsreceipt($array_ids, $from);
                            } else if ($status == 'Y') { //un post
                                PostingController::addUnpostgoodsreceipt($array_ids);
                            }
                        }
                    }
                    /**
                      --import goods receipt items to finance voucher and voucher items--
                     * */
                    if ($import_from == 'material_receipt') {
                        if ($status != '') {
                            if ($status == 'N') { //post
                                $from = '';
                                PostingController::addPostMaterialReceipt($array_ids, $from);
                            } else if ($status == 'Y') { //un post
                                PostingController::addUnpostMaterialReceipt($array_ids);
                            }
                        }
                    }
                } else {
                    if ($status != '') {
                        if ($status == 'N') { //post
                            $from = '';
                            $change_posted_status_to = 'Y';
                            PostingController::addPostUnpostNormalVoucher($array_ids, $change_posted_status_to);
                        } else if ($status == 'Y') { //un post
                            $change_posted_status_to = 'N';
                            PostingController::addPostUnpostNormalVoucher($array_ids, $change_posted_status_to);
                        }
                    }
                }
            } else {
                $jsonData[] = 'Please Select an Item to Import';
                echo CJSON::encode($jsonData);
            }
        } else {
            $jsonData[] = 'Please Select an Item to Import';
            echo CJSON::encode($jsonData);
        }
    }
    /*     * **Function to Save all customers to subledger ---jisha---- 14/11/22***** */
    public function actionSaveAllCustomerSubledgers()
    {
        $modAccSubledger = new AccSubledger();
        $modAccSubledger->saveCustomerSubledger();
        echo 'success';
    }
    /*     * **Function to Save all vendors to subledger ---jisha---- 14/11/22***** */
    public function actionSaveAllVendorSubledgers()
    {
        $modAccSubledger = new AccSubledger();
        $modAccSubledger->saveVendorSubledger();
        echo 'success';
    }
    // -----------------------------------------------------------------------------------------------------------
    //(post) sales Invoice items to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public static function addPostSales($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];

        // ------------------used for sales vat--voucher items-------------------
        function createAccVoucherItemvat($params, $tax_amount)
        {
            $item = new AccVoucherItems();
            $item->ledger_id = $params['ledger_id'];
            $item->year = $params['year'];
            $item->credit = ($tax_amount >= 0 && $params['default_type'] == 'C') ? $tax_amount : '0.00';
            $item->debit = ($tax_amount >= 0 && $params['default_type'] == 'D') ? $tax_amount : '0.00';
            $item->amount = ($tax_amount >= 0 && $params['default_type'] == 'C') ? (-1 * abs($tax_amount)) : abs($tax_amount);
            $item->employee_id = $params['employee_id'];
            $item->salegroup_id = $params['salegroup_id'];
            $item->payment_term_id = $params['payment_term_id'];
            $item->narration = $params['narration'];
            $item->project_id = $params['project_id'];
            $item->company_id = $params['company_id'];
            $item->branch_id = $params['branch_id'];
            $item->costcenter_id = $params['costcenter_id'];
            $item->department_id = $params['department_id'];
            $item->exchange_rate = $params['exchange_rate'];
            $item->file_id = $params['file_id'];
            $item->warehouse_id = $params['warehouse_id'];
            $item->outlet_id = $params['outlet_id'];
            $item->user_id = $params['user_id'];
            return $item;
        }
        // ---------------------------------------

        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="SI"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--invoice

                $header_model = $model_voucher_type->header_table;


                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Invoice Not Found' . $id;
                } else if ($modelheader->invoice_status == 'C') {
                    $valid = false;
                    $others[] = 'Invoice Cancelled!' . $id;
                } else if ($modelheader->posted == 'Y') {
                    $valid = false;
                    $others[] = 'Invoice Already Posted!' . $id;
                } else {
                    /*$modelhis = AccVoucher::model()->find(['condition' => 'transaction_id=' . (int) $id . ' AND voucher_type=' . $model_voucher_type->id]);
                    if (!empty($modelhis)) {
                        $valid = false;
                        $others[] = 'Invoice Already Posted But status not updated!' . $id;
                    }*/
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->lead_owner_id);
                $employee_id = (int) $usermodel->connected_employee_id;
                $narration = 'Sales Invoice #' . ($from == 'directsales') ? $modelheader->id : $modelheader->invoice_no;
                $invoice_id = $modelheader->id;

                $exchange_rate = $modelheader->exchange_rate;

                //$tax_amount         = $modelheader->total_tax_amount * $modelheader->exchange_rate;
                $tax_amount = round($modelheader->total_tax_amount * $modelheader->exchange_rate, 2);
                // --------------
                $tax_amount_cgst = round($tax_amount / 2, 2);
                $tax_amount_sgst = round($tax_amount / 2, 2);
                $tax_amount_igst = $tax_amount;
                // --------------
                // ------------------------------------
                $condition = 'invoice_id = ' . (int) $id;
                $deduction_amount = Yii::app()->db->createCommand('SELECT sum(deduction_amount) as deduction_amount FROM erp_invoice_item WHERE ' . $condition . '')->queryAll();
                // ------------------------------------
                $tot_discount     = $deduction_amount[0]['deduction_amount']  * $modelheader->exchange_rate;
                $tot_discount_currency     = $deduction_amount[0]['deduction_amount']  / $modelheader->exchange_rate;
                $sales_amount  = $modelheader->grand_total * $modelheader->exchange_rate;
                $sales_amount     = (round($modelheader->grand_total * $modelheader->exchange_rate, 2));
                $sales_amount_currency  = (round($modelheader->grand_total / $modelheader->exchange_rate, 2));
                $project_id       = (isset($modelheader->project_id)) ? $modelheader->project_id : 0;
                $company_id       = (isset($usermodel->company_id)) ? $usermodel->company_id : 0;
                $branch_id        = (isset($usermodel->branch_id)) ? $usermodel->branch_id : 0;
                $payment_term_id  = (isset($modelheader->payment_terms_id)) ? $modelheader->payment_terms_id : 0;

                $currency         = $modelheader->currency_id;
                $exchange_rate    = $modelheader->exchange_rate;
                $file_id          = $modelheader->file_id;
                $transaction_id   = $modelheader->id;

                if (!empty($modelheader) && isset($modelheader->warehouse_id)) {
                    $warehouse_id = $modelheader->warehouse_id;
                } elseif (!empty($usermodel) && isset($usermodel->available_warehouses)) {
                    $warehouse_id = $usermodel->available_warehouses;
                } else {
                    $warehouse_id = 0;
                }

                $costcenter_id    = $warehouse_id;

                if (!empty($modelheader) && isset($modelheader->outlet_id)) {
                    $outlet_id = $modelheader->outlet_id;
                } elseif (!empty($usermodel) && isset($usermodel->outlet_id)) {
                    $outlet_id = $usermodel->outlet_id;
                } else {
                    $outlet_id = 0;
                }



                $salegroup_id     =  isset($modelheader->sales_group_id) ? $modelheader->sales_group_id : 0;
                $round_off_amount = 0;
                $modelMasInvoiceType_inv_code = 0;
                if (isset($modelheader->invoice_type)) {
                    $modelMasInvoiceType = new MasInvoiceType();
                    $modelMasInvoiceType = $modelMasInvoiceType->findByPk((int) $modelheader->invoice_type);
                    $modelMasInvoiceType_inv_code = $modelMasInvoiceType->inv_code;
                }
                // -----------------------------------
                $modelAccPaymentMode = new AccPaymentMode();
                $payment_method = 0;
                if (isset($modelheader->receipt_type)) {
                    $type = $modelAccPaymentMode->find(array('condition' => 'code="' . $modelheader->receipt_type . '"'));
                    if (!empty($type)) {
                        $payment_method = $type->id;
                    }
                }
                // -----------------------------------
                /* $modelMasCurrency = new MasCurrency();
                $currencyRecord = $modelMasCurrency->find(array('condition' => 'id="' . (int)$modelheader->currency_id . '"'));

                if ($currencyRecord === null) {
                    $debt_ledgerId = 0;
                } else {
                    if (isset($currencyRecord->customer_ledger_id)) {
                        $debt_ledgerId = $currencyRecord->customer_ledger_id;
                    } else {
                        $debt_ledgerId = 0;
                    }
                }*/
                // -----------------------------------
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->customer_id;
                $year = date('Y', strtotime($modelheader->$dateField));



                $modelCustomer  = new Customer();
                $modelCustomer  = $modelCustomer->findByPK((int)$customer_vendor_id);
                $customer_ledger_id  = $modelCustomer->ledger_id;


                $modelCustomer = new Customer();

                $customer_vendor_id = isset($customer_vendor_id) ? (int)$customer_vendor_id : 0;

                if ($customer_vendor_id > 0) {
                    $modelCustomer = Customer::model()->findByPk($customer_vendor_id);
                }

                $customer_ledger_id = ($modelCustomer && isset($modelCustomer->ledger_id)) ? (int)$modelCustomer->ledger_id : 0;


                $arr_items = [];

                foreach ($modelvoucher_type_details as $eachtype) {
                    if ($eachtype->attribute == 'debtors') {
                        $arr_items[$i] = new AccVoucherItems();
                        //  $arr_items[$i]->ledger_id = ((int)$debt_ledgerId > 0) ? $debt_ledgerId : $eachtype->ledger_id;
                        $arr_items[$i]->ledger_id = (int)$customer_ledger_id > 0 ? $customer_ledger_id : $eachtype->ledger_id;;
                        $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
                        $modAccSubledger = new AccSubledger();
                        $arr_items[$i]->subledger_id = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
                        $arr_items[$i]->year = $year;
                        if ($sales_amount >= 0) {
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($sales_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($sales_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                            $arr_items[$i]->currency_amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount_currency)) : abs($sales_amount_currency);
                        } else {
                            $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($sales_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($sales_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                            $arr_items[$i]->currency_amount = ($eachtype->default_type == 'D') ? (-1 * abs($sales_amount_currency)) : abs($sales_amount_currency);
                        }
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                        $i++;
                    }
                    // --------------------start vat on sales ------------------------------------                   
                    $tax_type = 'OUT'; //defult tax type
                    $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
                    if ($tableExists) {
                        $tax_type = Yii::app()->db->createCommand("SELECT tax_type FROM {{acc_general_settings}}")->queryScalar();
                    }
                    // Common parameters for createAccVoucherItemvat function
                    $vatparams = [
                        'ledger_id' => $eachtype->ledger_id,
                        'year' => $year,
                        'default_type' => $eachtype->default_type,
                        'employee_id' => $employee_id,
                        'salegroup_id' => $salegroup_id,
                        'payment_term_id' => $payment_term_id,
                        'narration' => $narration,
                        'project_id' => $project_id,
                        'company_id' => $company_id,
                        'branch_id' => $branch_id,
                        'costcenter_id' => $costcenter_id,
                        'department_id' => $department_id,
                        'exchange_rate' => $exchange_rate,
                        'file_id' => $file_id,
                        'warehouse_id' => $warehouse_id,
                        'outlet_id' => $outlet_id,
                        'user_id' => (int) $modelheader->lead_owner_id
                    ];
                    // Check tax type and generate items accordingly
                    if ($tax_type == 'IN') {
                        if ($modelMasInvoiceType_inv_code == 'SCGST') {
                            if ($eachtype->attribute == 'sales_vat_cgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_cgst);
                                $i++;
                            } elseif ($eachtype->attribute == 'sales_vat_sgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_sgst);
                                $i++;
                            }
                        } else if ($modelMasInvoiceType_inv_code == 'IGST') {
                            if ($eachtype->attribute == 'sales_vat_igst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_igst);
                                $i++;
                            }
                        } else {
                            if ($eachtype->attribute == 'sales_vat') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                                $i++;
                            }
                        }
                    } else {
                        if ($eachtype->attribute == 'sales_vat') {
                            $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                            $i++;
                        }
                    }
                    // --------------------end vat on sales ------------------------------------                   
                    if ($eachtype->attribute == 'sales_discount') {
                        $DiscountType_ledger_id = 0;
                        if (isset($modelheader->discount_type_id)) {
                            if ((int) $modelheader->discount_type_id > 0) {
                                $modelMasDiscountType = new MasDiscountType();
                                $DiscountType_ledger_id = $modelMasDiscountType->findByPk((int) $modelheader->discount_type_id)->ledger_id;
                            }
                        }

                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = ((int) $DiscountType_ledger_id > 0) ? $DiscountType_ledger_id : $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($tot_discount)) : abs($tot_discount);
                        $arr_items[$i]->currency_amount = ($eachtype->default_type == 'C') ? (-1 * abs($tot_discount_currency)) : abs($tot_discount_currency);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                        $i++;
                    }
                    if ($eachtype->attribute == 'round_off') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($round_off_amount < 0) ? abs($round_off_amount) : '0.00';
                        $arr_items[$i]->debit = ($round_off_amount > 0) ? abs($round_off_amount) : '0.00';
                        $arr_items[$i]->amount = $round_off_amount;
                        $arr_items[$i]->currency_amount = $round_off_amount / $exchange_rate;
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                        $i++;
                    }

                    // -------------------------------
                    $allow_deliverynote  = 'N';
                    $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
                    if ($tableExists) {
                        $acc_settings = Yii::app()->db->createCommand("SELECT * FROM {{acc_general_settings}}")->queryRow();
                        $allow_deliverynote  =  $acc_settings['allow_deliverynote'];
                    }
                    // -------------------------------
                    $modelInvoiceItems = new InvoiceItem();
                    $modelInvoiceItems = $modelInvoiceItems->findAll(array('condition' => 'invoice_id=' . (int) $id));
                    
                     foreach ($modelInvoiceItems as $eachInvoiceItem) {
                        //  $amount = ($eachInvoiceItem->net_amount - $eachInvoiceItem->tax_vat_amount + $eachInvoiceItem->deduction_amount) * $modelheader->exchange_rate;
                        $amount = round(($eachInvoiceItem->amount * $modelheader->exchange_rate), 2);

                        $modelUnitOfMeasurement = new UnitOfMeasurement();
                        $factor = $modelUnitOfMeasurement->findByPk($eachInvoiceItem->unit_id)->factor;

                        // --------------------------------
                        $model_Store = new Store();
                        $model_store_ledger_id = $model_Store->findByPK((int)$eachInvoiceItem->product_id)->ledger_id;
                        // --------------------------------
                            if ($eachtype->attribute == 'sales') {
                                $arr_items[$i] = new AccVoucherItems();
                                $arr_items[$i]->ledger_id = ((int)$model_store_ledger_id > 0) ? (int)$model_store_ledger_id : $eachtype->ledger_id;
                                $arr_items[$i]->product_id = $eachInvoiceItem->product_id;
                                $arr_items[$i]->year = $year;
                                if ($amount >= 0) {
                                    $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($amount) : '0.00';
                                    $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($amount) : '0.00';
                                    $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                                    $arr_items[$i]->currency_amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount_currency)) : abs($amount_currency);
                                } else {
                                    $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($amount) : '0.00';
                                    $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($amount) : '0.00';
                                    $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($amount)) : abs($amount);
                                    $arr_items[$i]->currency_amount = ($eachtype->default_type == 'D') ? (-1 * abs($amount_currency)) : abs($amount_currency);
                                }
                                $arr_items[$i]->employee_id = $employee_id;
                                $arr_items[$i]->salegroup_id = $salegroup_id;
                                $arr_items[$i]->payment_term_id = $payment_term_id;
                                $arr_items[$i]->narration = $narration;
                                $arr_items[$i]->project_id = $project_id;
                                $arr_items[$i]->company_id = $company_id;
                                $arr_items[$i]->branch_id = $branch_id;
                                $arr_items[$i]->costcenter_id = $costcenter_id;
                                $arr_items[$i]->department_id = $department_id;
                                $arr_items[$i]->quantity = $eachInvoiceItem->quantity;
                                $arr_items[$i]->rate = $eachInvoiceItem->rate;
                                $arr_items[$i]->exchange_rate = $exchange_rate;
                                $arr_items[$i]->file_id = $file_id;
                                $arr_items[$i]->unit_id = $eachInvoiceItem->unit_id;
                                $arr_items[$i]->unit_factor = ((float)$factor > 0) ? $factor : 0;
                                $arr_items[$i]->currency_id = $currency;
                                $arr_items[$i]->exchange_rate = $exchange_rate;
                                $arr_items[$i]->tax = $eachInvoiceItem->tax_vat_amount;
                                $arr_items[$i]->net_amount = $eachInvoiceItem->net_amount;
                                $arr_items[$i]->current_cost = 0;
                                $arr_items[$i]->last_cost = 0;
                                $arr_items[$i]->balance_qty = 0;
                                $arr_items[$i]->inventory_value = 0;
                                $arr_items[$i]->discount_percentage = $eachInvoiceItem->deduction_percentage;
                                $arr_items[$i]->discount_amount = $eachInvoiceItem->deduction_amount;
                                $arr_items[$i]->rounding = 0;
                                $arr_items[$i]->warehouse_id = $warehouse_id;
                                $arr_items[$i]->outlet_id = $outlet_id;
                                $arr_items[$i]->foc = 0;
                                $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                                // --------------//------------------------
                                $i++;
                            }

                       
                           
                        }
                   
                    
               /*     $sql_stockledger ="SELECT  IFNULL((cost_price*quantity),0) as cost_amount,sales_price as amount,product_id,abs(quantity) as quantity,unit_id,unit_factor,batch_no,batch_date 
                    FROM `erp_stock_ledger` WHERE reference_id = '" . $transaction_id . "' AND `transaction_from` = 'DELIVERY_NOTE' ORDER BY `id` ASC";
                    $stockledger_list = Yii::app()->db->createCommand($sql_stockledger)->queryAll();
                    
                    foreach ($stockledger_list as $eachInvoiceItem) {
                        $amount = round(($eachInvoiceItem['amount'] * $eachInvoiceItem['quantity'] * $modelheader->exchange_rate), 2);

                        $cost_amount = $eachInvoiceItem['cost_amount'];
                       

                        $modelUnitOfMeasurement = new UnitOfMeasurement();
                        $factor = $modelUnitOfMeasurement->findByPk($eachInvoiceItem['unit_id'])->factor;

                        // --------------------------------
                        $model_Store = new Store();
                        $model_store_ledger_id = $model_Store->findByPK((int)$eachInvoiceItem['product_id'])->ledger_id;
                 
                        if ($modelheader->is_direct_invoice == "Y" || $allow_deliverynote == 'N') {
                            if ($eachtype->attribute == 'inventory') {
                                $arr_items[$i] = new AccVoucherItems();
                                $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                                $arr_items[$i]->product_id = $eachInvoiceItem['product_id'];
                                $arr_items[$i]->year = $year;
                                $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                                $arr_items[$i]->currency_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount / $exchange_rate)) : abs($cost_amount / $exchange_rate);
                                $arr_items[$i]->employee_id = $employee_id;
                                $arr_items[$i]->salegroup_id = $salegroup_id;
                                $arr_items[$i]->payment_term_id = $payment_term_id;
                                $arr_items[$i]->narration = $narration;
                                $arr_items[$i]->project_id = $project_id;
                                $arr_items[$i]->company_id = $company_id;
                                $arr_items[$i]->branch_id = $branch_id;
                                $arr_items[$i]->costcenter_id = $costcenter_id;
                                $arr_items[$i]->department_id = $department_id;
                                $arr_items[$i]->quantity = $eachInvoiceItem['quantity'];
                                $arr_items[$i]->unit_id = $eachInvoiceItem['unit_id'];
                                $arr_items[$i]->unit_factor = ((float)$factor > 0) ? $factor : 0;
                                $arr_items[$i]->rate =  $eachInvoiceItem['amount'];
                                $arr_items[$i]->exchange_rate = $exchange_rate;
                                $arr_items[$i]->file_id = $file_id;
                                $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                                $arr_items[$i]->warehouse_id = $warehouse_id;
                                $arr_items[$i]->outlet_id = $outlet_id;
                                 $arr_items[$i]->batch_no = $eachInvoiceItem['batch_no'];
                            $arr_items[$i]->batch_date = $eachInvoiceItem['batch_date'];
                                $i++;
                            }
                            if ($eachtype->attribute == 'closing_stock') {
                                $arr_items[$i] = new AccVoucherItems();
                                $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                                $arr_items[$i]->product_id = $eachInvoiceItem['product_id'];
                                $arr_items[$i]->year = $year;
                                $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                                $arr_items[$i]->currency_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount / $exchange_rate)) : abs($cost_amount / $exchange_rate);
                                $arr_items[$i]->employee_id = $employee_id;
                                $arr_items[$i]->salegroup_id = $salegroup_id;
                                $arr_items[$i]->payment_term_id = $payment_term_id;
                                $arr_items[$i]->narration = $narration;
                                $arr_items[$i]->project_id = $project_id;
                                $arr_items[$i]->company_id = $company_id;
                                $arr_items[$i]->branch_id = $branch_id;
                                $arr_items[$i]->costcenter_id = $costcenter_id;
                                $arr_items[$i]->department_id = $department_id;
                                $arr_items[$i]->quantity = $eachInvoiceItem['quantity'];
                                $arr_items[$i]->unit_id = $eachInvoiceItem['unit_id'];
                                $arr_items[$i]->unit_factor = ((float)$factor > 0) ? $factor : 0;
                                $arr_items[$i]->rate =  $eachInvoiceItem['amount'];
                                $arr_items[$i]->exchange_rate = $exchange_rate;
                                $arr_items[$i]->file_id = $file_id;
                                $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                                $arr_items[$i]->warehouse_id = $warehouse_id;
                                $arr_items[$i]->outlet_id = $outlet_id;
                                 $arr_items[$i]->batch_no = $eachInvoiceItem['batch_no'];
                            $arr_items[$i]->batch_date = $eachInvoiceItem['batch_date'];
                                $i++;
                            }
                        }
                    }*/
                }
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['file_id'] = $modelheader->file_id;
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $modelheader->invoice_no;
                $voucherHead['transaction_id'] = $invoice_id;
                $voucherHead['reference_no'] = $modelheader->invoice_no;
                $voucherHead['narration'] = $narration;
                $voucherHead['voucher_value'] = $modelheader->grand_total;
                $voucherHead['currency_id'] = $modelheader->currency_id;
                $voucherHead['exchange_rate'] = $exchange_rate;
                $voucherHead['vat'] = $modelheader->total_tax_amount * $modelheader->exchange_rate;
                $voucherHead['amount'] = ((($modelheader->grand_total) - $modelheader->total_tax_amount)) * $modelheader->exchange_rate;
                $voucherHead['net_amount'] = $modelheader->grand_total * $modelheader->exchange_rate;
                $voucherHead['total_discount'] = $modelheader->total_discount_amount * $modelheader->exchange_rate;
                $voucherHead['rounding'] = $modelheader->round_off_amount * $modelheader->exchange_rate;
                $voucherHead['tax_type'] = $modelheader->invoice_type;
                $voucherHead['tax_id'] = $modelheader->invoice_type;
                $voucherHead['order_id'] = $modelheader->order_id;
                $voucherHead['delivery_id'] = $modelheader->delivery_ids;
                $voucherHead['direct'] = $modelheader->is_direct_invoice;
                $voucherHead['imported'] = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = $payment_method;
                $modelMasPaymentTerm = new MasPaymentTerm();
                $no_of_days = $modelMasPaymentTerm->findByPk($modelheader->payment_terms_id)->no_of_days;
                $voucherHead['payment_days'] = ((float)$no_of_days > 0) ? $no_of_days : 0;
                $voucherHead['payment_terms'] = $modelheader->payment_terms_id;
                $voucherHead['lead_owner'] = $modelheader->lead_owner_id;
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = $warehouse_id;
                $voucherHead['outlet_id'] = $outlet_id;
                //-------saving invoice header details---------
                $invoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $invoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($invoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($invoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($invoice_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {

            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $invoiceVoucherid);

            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Invoice no: - {$voucherModel->transaction_id}  "
            );
            // end audit log

            $jsonData['voucher_id'] = $invoiceVoucherid;
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $invoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(unpost) sales Invoice items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------

    public function addUnpostSales($array_ids)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="SI"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $invoice_id = $modelheader->id;
            //   $condition                = 't.reference_no=' . $invoice_id;
            $modelAccVoucher = new AccVoucher;
            // $AccVoucher_det           = $modelAccVoucher->find(array('condition' => $condition));
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND erp_acc_voucher.transaction_id='{$invoice_id}'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();

            if (!empty($AccVoucher_det)) {
                foreach ($AccVoucher_det as $eachtransaction) {
                    if ($eachtransaction['id'] > 0) {
                        if ($eachtransaction['is_allocated'] == 'N') {

                            // ---------------------------------------
                            $voucherModel = new AccVoucher();
                            $voucherModel = $voucherModel->findByPK((int)$eachtransaction['id']);
                            // inserting to audit log
                            AccAuditLog::saveAuditLogs(
                                'ACCOUNTS',
                                Yii::app()->user->id,
                                'UNPOSTED',
                                changes: "(Imported) {$voucherModel->vtype->description} with Invoice no: - {$voucherModel->transaction_id} "
                            );
                            // end audit log
                            // ---------------------------------------

                            //unpost deliverynote first
                            if ((int) $modelheader->delivery_ids > 0) {
                                $modelDeliveryNote = new DeliveryNote();
                                $modelDeliveryNote = $modelDeliveryNote->findByPK((int) $modelheader->delivery_ids);
                                if ($modelDeliveryNote->posted == "Y") {
                                    $var = PostingController::addUnpostDeliverynote([$modelDeliveryNote->id], 'INVOICE');
                                }
                            }
                            //unpost deliverynote first
                            $modelAccVoucherItems  = new AccVoucherItems();
                            $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $eachtransaction['id']));
                            $modelAccVoucher->deleteByPk($eachtransaction['id']);
                            PostingController::UnallocateSalesInvoice($invoice_id);
                            // --------------------------to delete the receipt voucher related to this sales invoice-----------------------------
                            PostingController::deletePostedReceipt_frm_invoice($invoice_id);
                            $flag = 1;
                        } else {
                            $flag = 3;
                        }
                    }
                }
            } else {
                $flag = 2;
            }
            if ($flag == 1) {

                $modelheader->updateByPk($invoice_id, array('posted' => 'N'));
            }
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }

    // -----------------------------------------------------------------------------------------------------------
    //(delete)  Posted Receipt frm voucher & voucher items
    //------------------------------------------------------------------------------------------------------------
    public function deletePostedReceipt_frm_invoice($each_invoice_id)
    {
        $model_voucher_type = new AccVoucherType();
        $voucher_type_id = $model_voucher_type->find(array('condition' => 'code="RV"'))->id;
        $condition = 't.imported="Y" AND t.voucher_type=' . $voucher_type_id;
        $condition .= ' AND t.transaction_id=' . $each_invoice_id;
        $modelAccVoucher = new AccVoucher;
        $AccVoucher_det = $modelAccVoucher->findAll(array('condition' => $condition));
        if (!empty($AccVoucher_det)) {
            foreach ($AccVoucher_det as $each) {
                if ($each->is_allocated == 'N') {
                    // --------------------------
                    $modelAccVoucher->deleteByPk($each->id);
                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $each->id));
                    // --------------------------
                }
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(delete)  Posted UnallocateSalesInvoice frm allocation & allocation items
    //------------------------------------------------------------------------------------------------------------
    public function UnallocateSalesInvoice($invoice_id)
    {
        $modelheader = new Invoice();
        $modelheader = $modelheader->findByPK((int) $invoice_id);
        $modelallocation = new AccAllocation;
        $modelarrayallocation = $modelallocation->findAll(array('condition' => 'reference_id =' . (int) $invoice_id));
        foreach ($modelarrayallocation as $eachallocation) {
            $modelallocationItems = new AccAllocationItems;
            $modelarrayallocationItems = $modelallocationItems->findAll(array('condition' => 'allocation_id =' . (int) $eachallocation->id));
            foreach ($modelarrayallocationItems as $eachitem) {
                AccVoucher::model()->updateBypk($eachitem->voucher_id, array('is_allocated' => 'N'));
                AccVoucherItems::model()->updateBypk($eachitem->voucher_item_id, array('allocated_amount' => 0));
            }
            $modelallocation->deleteByPK((int) $eachallocation->id);
            $modelallocationItems->deleteAll('allocation_id=:refer_id', array(':refer_id' => (int) $eachallocation->id));
        }
    }

    public function deletePostedpayment_frm_creditnote($creditnote_id)
    {
        $model_voucher_type = new AccVoucherType();
        $voucher_type_id = $model_voucher_type->find(array('condition' => 'code="PV"'))->id;
        $condition = 't.imported="Y" AND t.voucher_type=' . $voucher_type_id;
        $condition .= ' AND t.transaction_id=' . $creditnote_id;
        $modelAccVoucher = new AccVoucher;
        $AccVoucher_det = $modelAccVoucher->find(array('condition' => $condition));
        if (!empty($AccVoucher_det)) {
            if ($AccVoucher_det->is_allocated == 'N') {
                // --------------------------
                $modelAccVoucher->deleteByPk($AccVoucher_det->id);
                $modelAccVoucherItems = new AccVoucherItems();
                $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det->id));
                // --------------------------
            }
        }
    }

    // -----------------------------------------------------------------------------------------------------------
    //(post) purchase Invoice items to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public static function addPostPurchaseInvoice($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];

        // ------------------used for purchase vat--voucher items-------------------
        function createAccVoucherItemvat($params, $tax_amount)
        {
            $item = new AccVoucherItems();
            $item->ledger_id = $params['ledger_id'];
            $item->year = $params['year'];
            $item->credit = ($params['default_type'] == 'C') ? ($tax_amount) : '0.00';
            $item->debit = ($params['default_type'] == 'D') ? ($tax_amount) : '0.00';
            $item->amount = ($params['default_type'] == 'C') ? (-1 * abs($tax_amount)) : abs($tax_amount);
            $item->employee_id = $params['employee_id'];
            $item->salegroup_id = $params['salegroup_id'];
            $item->payment_term_id = $params['payment_term_id'];
            $item->narration = $params['narration'];
            $item->project_id = $params['project_id'];
            $item->company_id = $params['company_id'];
            $item->branch_id = $params['branch_id'];
            $item->costcenter_id = $params['costcenter_id'];
            $item->department_id = $params['department_id'];
            $item->exchange_rate = $params['exchange_rate'];
            $item->file_id = $params['file_id'];
            $item->warehouse_id = $params['warehouse_id'];
            $item->outlet_id = $params['outlet_id'];
            $item->user_id = $params['user_id'];
            return $item;
        }
        // ---------------------------------------
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="PI"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--invoice
                $header_model = $model_voucher_type->header_table;
                if (empty($header_model)) {
                    $valid = false;
                    $others[] = 'Header TModel not defined in Voucher Type';
                }
                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Purchase Invoice Not Found';
                } else if ($modelheader->posted == "Y") {
                    $valid = false;
                    $others[] = 'Purchase Invoice Already posted' . $id;
                } else {
                    $modelhis = AccVoucher::model()->find(['condition' => 'transaction_id=' . (int) $id . ' AND voucher_type=' . $model_voucher_type->id]);
                    if (!empty($modelhis)) {
                        $valid = false;
                        $others[] = 'PurchaseInvoice Already Posted But status not updated!' . $id;
                    }
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->crm_user_id);
                $employee_id = (int) $usermodel->connected_employee_id;
                $invoice_id = $modelheader->id;
                $narration = 'Purchase Invoice #' . $invoice_id . ' #' . $modelheader->$voucherReference;
                //$purchase_amount    = (Yii::app()->db->createCommand("select ROUND(SUM(amount+tax_amount),2)  from erp_purchasinginvoice_item where purchasing_invoice_id='" . $modelheader->id . "')")->queryScalar())*$modelheader->exchange_rate;
                // $sum_amt = Yii::app()->db->createCommand("select SUM(amount+tax_amount)  from erp_purchasinginvoice_item where purchasing_invoice_id='" . $modelheader->id . "' ")->queryScalar();
                // $purchase_amount    = $sum_amt;
                $purchase_amount = ($modelheader->grand_total) * $modelheader->exchange_rate;
                $tax_amount = $modelheader->total_tax_amount * $modelheader->exchange_rate;
                // --------------
                $tax_amount_cgst = round($tax_amount / 2, 2);
                $tax_amount_sgst = round($tax_amount / 2, 2);
                $tax_amount_igst = $tax_amount;
                // --------------
                $condition = 'purchasing_invoice_id = ' . $modelheader->id;
                $deduction_amount = Yii::app()->db->createCommand('SELECT sum(deduction_amount) as deduction_amount FROM erp_purchasinginvoice_item WHERE ' . $condition . '')->queryAll();
                // ------------------------------------
                $tot_discount = $deduction_amount[0]['deduction_amount'];
                $round_off_amount = $modelheader->round_off_amount;
                $salegroup_id = 0;
                $project_id = $modelheader->project_id;
                $company_id = $usermodel->company_id;
                $branch_id = $usermodel->branch_id;
                $payment_term_id = $modelheader->payment_terms;
                $file_id = $modelheader->file_id;
                $exchange_rate = $modelheader->exchange_rate;
                $currency = $modelheader->currency;
                $transaction_id = $modelheader->id;

                $outlet_id = isset($usermodel->outlet_id) ? $usermodel->outlet_id : 0;
                $warehouse_id = isset($usermodel->available_warehouses) ? $usermodel->available_warehouses : 0;
                $warehouse_b = isset($usermodel->available_warehouses) ? $usermodel->available_warehouses : 0;

                if ($warehouse_id == 0) {
                    $warehouse_id = $warehouse_b;
                }

                $costcenter_id = $warehouse_id;
                $warehouse_id = $warehouse_id;
                $modelMasInvoiceType_inv_code = 0;
                if (isset($modelheader->invoice_type)) {
                    $modelMasInvoiceType = new MasInvoiceType();
                    $modelMasInvoiceType = $modelMasInvoiceType->findByPk((int) $modelheader->invoice_type);
                    $modelMasInvoiceType_inv_code = $modelMasInvoiceType->inv_code;
                }
                //$modelheader->invoice_type
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->vendor_id;

                $modelVendor = new Vendor();
                $customer_vendor_id = isset($customer_vendor_id) ? (int)$customer_vendor_id : 0;
                if ($customer_vendor_id > 0) {
                    $modelVendor = Vendor::model()->findByPk($customer_vendor_id);
                }
                $Vendor_ledger_id = ($modelVendor && isset($modelVendor->ledger_id)) ? (int)$modelVendor->ledger_id : 0;

                $year = date('Y', strtotime($modelheader->$dateField));

                $arr_items = [];
                foreach ($modelvoucher_type_details as $eachtype) {
                    if ($eachtype->attribute == 'creditors') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = (int)$Vendor_ledger_id > 0 ? $Vendor_ledger_id : $eachtype->ledger_id;
                        $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id = $modAccSubledgerType->getIdFromType('V');
                        $modAccSubledger = new AccSubledger();
                        $arr_items[$i]->subledger_id = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->vendor_id);
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? abs($purchase_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($purchase_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($purchase_amount)) : abs($purchase_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $i++;
                    }
                    // --------------------start vat on purchase ------------------------------------                   
                    $tax_type = 'OUT'; //defult tax type
                    $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
                    if ($tableExists) {
                        $tax_type = Yii::app()->db->createCommand("SELECT tax_type FROM {{acc_general_settings}}")->queryScalar();
                    }
                    // Common parameters for createAccVoucherItemvat function
                    $vatparams = [
                        'ledger_id' => $eachtype->ledger_id,
                        'year' => $year,
                        'default_type' => $eachtype->default_type,
                        'employee_id' => $employee_id,
                        'salegroup_id' => $salegroup_id,
                        'payment_term_id' => $payment_term_id,
                        'narration' => $narration,
                        'project_id' => $project_id,
                        'company_id' => $company_id,
                        'branch_id' => $branch_id,
                        'costcenter_id' => $costcenter_id,
                        'department_id' => $department_id,
                        'exchange_rate' => $exchange_rate,
                        'file_id' => $file_id,
                        'warehouse_id' => $warehouse_id,
                        'outlet_id' => $outlet_id,
                        'user_id' => (int) $modelheader->crm_user_id
                    ];
                    // Check tax type and generate items accordingly
                    if ($tax_type == 'IN') {
                        if ($modelMasInvoiceType_inv_code == 'SCGST') {
                            if ($eachtype->attribute == 'purchase_vat_cgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_cgst);
                                $i++;
                            } elseif ($eachtype->attribute == 'purchase_vat_sgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_sgst);
                                $i++;
                            }
                        } else if ($modelMasInvoiceType_inv_code == 'IGST') {
                            if ($eachtype->attribute == 'purchase_vat_igst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_igst);
                                $i++;
                            }
                        } else {
                            if ($eachtype->attribute == 'purchase_vat') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                                $i++;
                            }
                        }
                    } else {
                        if ($eachtype->attribute == 'purchase_vat') {
                            $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                            $i++;
                        }
                    }
                    // --------------------end vat on purchase ------------------------------------   
                    if ($eachtype->attribute == 'purchase_discount') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($tot_discount)) : abs($tot_discount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;

                        $i++;
                    }
                    if ($eachtype->attribute == 'round_off') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($round_off_amount < 0) ? ($round_off_amount) : '0.00';
                        $arr_items[$i]->debit = ($round_off_amount > 0) ? ($round_off_amount) : '0.00';
                        $arr_items[$i]->amount = $round_off_amount;
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;

                        $i++;
                    }
                    $modelInvoiceItems = new PurchasingInvoiceItem();
                    $modelInvoiceItems = $modelInvoiceItems->findAll(array('condition' => 'purchasing_invoice_id=' . (int) $id));
                    foreach ($modelInvoiceItems as $eachInvoiceItem) {
                        // $amount = $eachInvoiceItem->net_amount;
                        $amount = ($eachInvoiceItem->net_amount + $eachInvoiceItem->deduction_amount) * $modelheader->exchange_rate;
                        // $cost_amount = $eachInvoiceItem->previous_cost_rate * $eachInvoiceItem->quantity;
                        //$cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from='QUALITY_CHECK' AND product_id='" . $eachInvoiceItem->product_id . "'  AND (header_id ='" . $transaction_id. "')")->queryScalar();
                        $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(buying_price*quantity),0)  from erp_stock_ledger where transaction_from='QUALITY_CHECK' AND product_id='" . $eachInvoiceItem->product_id . "' AND header_id IN ({$modelheader->materialreceived}) AND (file_id ='" . $file_id . "')")->queryScalar();
                        // previous_cost_rate = item rate from store 
                        $model_Store = new Store();
                        $model_store_ledger_id = $model_Store->findByPK((int)$eachInvoiceItem->product_id)->ledger_id;

                        if ($eachtype->attribute == 'purchase') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = ((int)$model_store_ledger_id > 0) ? (int)$model_store_ledger_id : $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachInvoiceItem->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachInvoiceItem->quantity;
                            $arr_items[$i]->rate = $eachInvoiceItem->rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->unit_id = $eachInvoiceItem->unit;
                            $arr_items[$i]->unit_factor = $eachInvoiceItem->unitdetails->factor;
                            $arr_items[$i]->currency_id = $currency;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->tax = $eachInvoiceItem->tax_amount;
                            $arr_items[$i]->net_amount = $eachInvoiceItem->net_amount;
                            $arr_items[$i]->current_cost = 0;
                            $arr_items[$i]->last_cost = 0;
                            $arr_items[$i]->balance_qty = 0;
                            $arr_items[$i]->inventory_value = 0;
                            $arr_items[$i]->discount_percentage = $eachInvoiceItem->deduction_percentage;
                            $arr_items[$i]->discount_amount = $eachInvoiceItem->deduction_amount;
                            $arr_items[$i]->rounding = 0;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $arr_items[$i]->outlet_id = $outlet_id;
                            $arr_items[$i]->foc = 0;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            // --------------//------------------------
                            $i++;
                        }
                       /* if ($eachtype->attribute == 'inventory') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachInvoiceItem->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachInvoiceItem->quantity;
                            $arr_items[$i]->unit_id = $eachInvoiceItem->unit;
                            $arr_items[$i]->unit_factor = $eachInvoiceItem->unitdetails->factor;
                            $arr_items[$i]->rate = $eachInvoiceItem->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $arr_items[$i]->unit_id = (int) $eachInvoiceItem->unit;
                            $arr_items[$i]->unit_factor = $eachInvoiceItem->unitdetails->factor;
                            $arr_items[$i]->tax = $eachInvoiceItem->tax_amount;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $arr_items[$i]->outlet_id = $outlet_id;

                            $i++;
                        }
                        if ($eachtype->attribute == 'closing_stock') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachInvoiceItem->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachInvoiceItem->quantity;
                            $arr_items[$i]->unit_id = $eachInvoiceItem->unit;
                            $arr_items[$i]->unit_factor = $eachInvoiceItem->unitdetails->factor;
                            $arr_items[$i]->rate = $eachInvoiceItem->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $arr_items[$i]->outlet_id = $outlet_id;
                            $i++;
                        }*/
                    }
                }
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['file_id'] = $modelheader->file_id;
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $invoice_id;
                $voucherHead['transaction_id'] = $invoice_id;
                $voucherHead['reference_no'] = $modelheader->$voucherReference;
                $voucherHead['narration'] = $narration;
                $voucherHead['voucher_value'] = $modelheader->grand_total;
                $voucherHead['currency_id'] = $modelheader->currency;
                $voucherHead['exchange_rate'] = $modelheader->exchange_rate;
                $voucherHead['amount'] = ($modelheader->grand_total) - $modelheader->total_tax_amount;
                $voucherHead['vat'] = $modelheader->total_tax_amount;
                $voucherHead['net_amount'] = $modelheader->grand_total * $modelheader->exchange_rate;
                $voucherHead['total_discount'] = (isset($modelheader->total_discount)) ? $modelheader->total_discount : 0;
                $voucherHead['rounding'] = $modelheader->round_off_amount;
                $voucherHead['tax_type'] = $modelheader->taxtype->percentage;
                $voucherHead['tax_id'] = $modelheader->tax_type;
                $voucherHead['order_id'] = 0;
                $voucherHead['delivery_id'] = 0;
                $voucherHead['direct'] = $modelheader->is_direct_invoice;
                $voucherHead['imported'] = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = $modelheader->payment_terms;
                $voucherHead['payment_days'] = 0;
                $voucherHead['payment_terms'] = $modelheader->payment_terms;
                $voucherHead['lead_owner'] = (int) $modelheader->crm_user_id;
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = $warehouse_id;
                $voucherHead['outlet_id'] = $outlet_id;
                //-------saving purchaseinvoice header details---------
                $purchaseinvoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $purchaseinvoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($purchaseinvoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($purchaseinvoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($invoice_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {
            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $purchaseinvoiceVoucherid);
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Purchase Invoice no: - {$voucherModel->transaction_id}  "
            );
            // end audit log
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $purchaseinvoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(unpost) purchase Invoice items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public function addUnpostPurchaseInvoice($array_ids)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="PI"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $invoice_id = $modelheader->id;
            $invoice_no = $modelheader->invoice_no;
            $modelAccVoucher = new AccVoucher;
            //$condition               = 't.reference_no=' . $invoice_no;
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND erp_acc_voucher.transaction_id LIKE '" . $invoice_id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            // $AccVoucher_det          = $modelAccVoucher->find(array('condition' => $condition));
            //$modelheader           = $modelheader->updateByPk($invoice_id, array('posted' => 'N'));
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    // ---------------------------------------
                    $voucherModel = new AccVoucher();
                    $voucherModel = $voucherModel->findByPK((int)$AccVoucher_det[0]['id']);
                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'UNPOSTED',
                        changes: "(Imported) {$voucherModel->vtype->description} with Purchase Invoice: - {$voucherModel->transaction_id} "
                    );
                    // end audit log
                    // ---------------------------------------
                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det[0]['id']));
                    $modelAccVoucher->deleteByPk($AccVoucher_det[0]['id']);
                    $modelheader->updateByPk($invoice_id, array('posted' => 'N'));
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det['id'];
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            // $jsonData['status']    = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(post) Credit Note items to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public static function addPostCreditnote($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];
        // ------------------used for sales vat--voucher items-------------------
        function createAccVoucherItemvat($params, $tax_amount)
        {
            $item = new AccVoucherItems();
            $item->ledger_id = $params['ledger_id'];
            $item->year = $params['year'];
            if ($tax_amount >= 0) {
                $item->credit = ($params['default_type'] == 'C') ? ($tax_amount) : '0.00';
                $item->debit = ($params['default_type'] == 'D') ? ($tax_amount) : '0.00';
                $item->amount = ($params['default_type'] == 'C') ? (-1 * abs($tax_amount)) : abs($tax_amount);
            } else {
                $item->credit = ($params['default_type'] == 'D') ? abs($tax_amount) : '0.00';
                $item->debit = ($params['default_type'] == 'C') ? abs($tax_amount) : '0.00';
                $item->amount = ($params['default_type'] == 'D') ? (-1 * abs($tax_amount)) : abs($tax_amount);
            }
            $item->employee_id = $params['employee_id'];
            $item->salegroup_id = $params['salegroup_id'];
            $item->payment_term_id = $params['payment_term_id'];
            $item->narration = $params['narration'];
            $item->project_id = $params['project_id'];
            $item->company_id = $params['company_id'];
            $item->branch_id = $params['branch_id'];
            $item->costcenter_id = $params['costcenter_id'];
            $item->department_id = $params['department_id'];
            $item->exchange_rate = $params['exchange_rate'];
            $item->file_id = $params['file_id'];
            $item->warehouse_id = $params['warehouse_id'];
            $item->outlet_id = $params[' outlet_id'];
            $item->user_id = $params['user_id'];
            return $item;
        }
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="CN"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--credit note
                $header_model = $model_voucher_type->header_table;
                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Credit Note Not Found';
                } else if ($modelheader->posted == "Y") {
                    $valid = false;
                    $others[] = 'Credit Note Already posted' . $id;
                } else {
                    $modelhis = AccVoucher::model()->find(['condition' => 'transaction_id=' . (int) $id . ' AND voucher_type=' . $model_voucher_type->id]);
                    if (!empty($modelhis)) {
                        $valid = false;
                        $others[] = 'Credit Note Already Posted But status not updated!' . $id;
                    }
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->crm_user_id);


                $warehouse_id = $modelheader?->warehouse_id ?? $usermodel?->available_warehouses ?? 0;
                $costcenter_id    = $warehouse_id;
                $outlet_id = $modelheader?->outlet_id ?? $usermodel?->outlet_id ?? 0;


                $employee_id = (int)$usermodel->connected_employee_id;
                $narration = 'Credit Note #' . $modelheader->id . ' - Invoice ' . $modelheader->$voucherReference;
                $creditnote_id = $modelheader->id;
                $sales_amount = ($modelheader->credited_amount) * $modelheader->exchange_rate;
                $tax_amount = $modelheader->total_tax_amount * $modelheader->exchange_rate;
                // --------------
                $tax_amount_cgst = round($tax_amount / 2, 2);
                $tax_amount_sgst = round($tax_amount / 2, 2);
                $tax_amount_igst = $tax_amount;
                // --------------
                $tot_discount = 0;
                $round_off_amount = 0;
                $modelinvoice = new Invoice();
                $modelinvoice = $modelinvoice->findByPK((int) $modelheader->invoice_id);
                $salegroup_id = $modelinvoice->sales_group_id;
                $project_id = $modelheader->project_id;
                $branch_id = $usermodel->branch_id;
                $company_id = $usermodel->company_id;
                $payment_term_id = $modelinvoice->payment_terms_id;
                $costcenter_id = $warehouse_id;
                $currency = $modelheader->currency;
                $exchange_rate = $modelheader->exchange_rate;
                $file_id = $modelheader->file_id;
                $department_id = 0;
                $customer_vendor_id = $modelheader->customer_id;
                $warehouse_id = $warehouse_id;
                $invoice_no = $modelinvoice->invoice_no;
                $modelMasInvoiceType_inv_code = 0;
                if (isset($modelheader->invoice_type)) {
                    $modelMasInvoiceType = new MasInvoiceType();
                    $modelMasInvoiceType = $modelMasInvoiceType->findByPk((int) $modelheader->invoice_type);
                    $modelMasInvoiceType_inv_code = $modelMasInvoiceType->inv_code;
                }
                // ------------------------------------------
                $modelAccPaymentMode = new AccPaymentMode();
                $payment_method = 0;
                $type = $modelAccPaymentMode->find(array('condition' => 'code="' . $modelheader->payment_type . '"'));
                if (!empty($type)) {
                    $payment_method = $type->id;
                }
                $transaction_id = $modelheader->id;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $year = date('Y', strtotime($modelheader->$dateField));
                $modelCustomer = new Customer();
                $customer_vendor_id = isset($customer_vendor_id) ? (int)$customer_vendor_id : 0;
                if ($customer_vendor_id > 0) {
                    $modelCustomer = Customer::model()->findByPk($customer_vendor_id);
                }
                $customer_ledger_id = ($modelCustomer && isset($modelCustomer->ledger_id)) ? (int)$modelCustomer->ledger_id : 0;


                // ---------------------------------------
                $arr_items = [];
                foreach ($modelvoucher_type_details as $eachtype) {
                    if ($eachtype->attribute == 'debtors') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = (int)$customer_ledger_id > 0 ? $customer_ledger_id : $eachtype->ledger_id;
                        $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
                        $modAccSubledger = new AccSubledger();
                        $arr_items[$i]->subledger_id = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
                        $arr_items[$i]->year = $year;
                        if ($sales_amount >= 0) {
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($sales_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($sales_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                        } else {
                            $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($sales_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($sales_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                        }
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $i++;
                    }
                    // --------------------start vat on sales ------------------------------------                   
                    $tax_type = 'OUT'; //defult tax type
                    $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
                    if ($tableExists) {
                        $tax_type = Yii::app()->db->createCommand("SELECT tax_type FROM {{acc_general_settings}}")->queryScalar();
                    }
                    // Common parameters for createAccVoucherItemvat function
                    $vatparams = [
                        'ledger_id' => $eachtype->ledger_id,
                        'year' => $year,
                        'default_type' => $eachtype->default_type,
                        'employee_id' => $employee_id,
                        'salegroup_id' => $salegroup_id,
                        'payment_term_id' => $payment_term_id,
                        'narration' => $narration,
                        'project_id' => $project_id,
                        'company_id' => $company_id,
                        'branch_id' => $branch_id,
                        'costcenter_id' => $costcenter_id,
                        'department_id' => $department_id,
                        'exchange_rate' => $exchange_rate,
                        'file_id' => $file_id,
                        'warehouse_id' => $warehouse_id,
                        'outlet_id' => $outlet_id,
                        'user_id' => (int) $modelheader->crm_user_id
                    ];
                    // Check tax type and generate items accordingly
                    if ($tax_type == 'IN') {
                        if ($modelMasInvoiceType_inv_code == 'SCGST') {
                            if ($eachtype->attribute == 'sales_vat_cgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_cgst);
                                $i++;
                            } elseif ($eachtype->attribute == 'sales_vat_sgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_sgst);
                                $i++;
                            }
                        } else if ($modelMasInvoiceType_inv_code == 'IGST') {
                            if ($eachtype->attribute == 'sales_vat_igst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_igst);
                                $i++;
                            }
                        } else {
                            if ($eachtype->attribute == 'sales_vat') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                                $i++;
                            }
                        }
                    } else {
                        if ($eachtype->attribute == 'sales_vat') {
                            $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                            $i++;
                        }
                    }
                    // --------------------end vat on sales ------------------------------------     
                    if ($eachtype->attribute == 'sales_discount') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($tot_discount)) : abs($tot_discount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $i++;
                    }
                    if ($eachtype->attribute == 'round_off') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($round_off_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($round_off_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($round_off_amount)) : abs($round_off_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->warehouse_id = $warehouse_id;
                        $arr_items[$i]->outlet_id = $outlet_id;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $i++;
                    }
                    $modelCreditnoteItem = new CreditnoteItem();
                    $modelCreditnoteItems = $modelCreditnoteItem->findAll(array('condition' => 'creditnote_id=' . (int) $id));
                    foreach ($modelCreditnoteItems as $eachCreditnoteItem) {
                        $amount = ($eachCreditnoteItem->net_amount) * $exchange_rate;
                        $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(buying_price*quantity),0)  from erp_stock_ledger where transaction_from='CREDIT_NOTE' AND product_id='" . $eachCreditnoteItem->product_id . "'  AND (header_id ='" . $creditnote_id . "')")->queryScalar();
                        $model_Store = new Store();
                        $model_store_ledger_id = $model_Store->findByPK((int)$eachCreditnoteItem->product_id)->ledger_id;
                        if ($eachtype->attribute == 'credit_note') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = ((int)$model_store_ledger_id > 0) ? (int)$model_store_ledger_id : $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachCreditnoteItem->product_id;
                            $arr_items[$i]->year = $year;
                            if ($amount >= 0) {
                                $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($amount) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($amount) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            } else {
                                $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($amount) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($amount) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($amount)) : abs($amount);
                            }
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachCreditnoteItem->quantity;
                            $arr_items[$i]->rate = $eachCreditnoteItem->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            // --------------new-----------------------
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->unit_id = $eachCreditnoteItem->unit;
                            $arr_items[$i]->unit_factor = $eachCreditnoteItem->orderunit->factor;
                            $arr_items[$i]->currency_id = $currency;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->tax = $eachCreditnoteItem->tax_vat_amount;
                            $arr_items[$i]->net_amount = $eachCreditnoteItem->net_amount;
                            $arr_items[$i]->current_cost = 0;
                            $arr_items[$i]->last_cost = 0;
                            $arr_items[$i]->balance_qty = 0;
                            $arr_items[$i]->inventory_value = 0;
                            $arr_items[$i]->discount_percentage = 0;
                            $arr_items[$i]->discount_amount = 0;
                            $arr_items[$i]->rounding = 0;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $arr_items[$i]->outlet_id = $outlet_id;
                            $arr_items[$i]->foc = 0;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            // --------------//------------------------
                            $i++;
                        }
                      /*  if ($eachtype->attribute == 'inventory') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachCreditnoteItem->product_id;
                            $arr_items[$i]->year = $year;
                            if ($cost_amount >= 0) {
                                $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            } else {
                                $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($cost_amount) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($cost_amount) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            }
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachCreditnoteItem->quantity;
                            $arr_items[$i]->unit_id = $eachCreditnoteItem->unit;
                            $arr_items[$i]->unit_factor = $eachCreditnoteItem->orderunit->factor;
                            $arr_items[$i]->rate = $eachCreditnoteItem->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $arr_items[$i]->outlet_id = $outlet_id;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $i++;
                        }
                        if ($eachtype->attribute == 'closing_stock') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachCreditnoteItem->product_id;
                            $arr_items[$i]->year = $year;
                            if ($cost_amount >= 0) {
                                $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            } else {
                                $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($cost_amount) : '0.00';
                                $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($cost_amount) : '0.00';
                                $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            }
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachCreditnoteItem->quantity;
                            $arr_items[$i]->unit_id = $eachCreditnoteItem->unit;
                            $arr_items[$i]->unit_factor = $eachCreditnoteItem->orderunit->factor;
                            $arr_items[$i]->rate = $eachCreditnoteItem->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $arr_items[$i]->outlet_id = $outlet_id;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $i++;
                        }*/
                    }
                }
            }
            if ($valid) {
                $voucherHead                       = array();
                $voucherHead['file_id']            = $modelheader->file_id;
                $voucherHead['voucher_type']       = $model_voucher_type->id;
                $modelAccVoucherType               = new AccVoucherType;
                $voucherHead['voucher_no']         = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date']       = $modelheader->$dateField;
                $voucherHead['transaction_date']   = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $creditnote_id;
                $voucherHead['transaction_id']     = $creditnote_id;
                $voucherHead['reference_no']       = $invoice_no;
                $voucherHead['narration']          = $narration;
                $voucherHead['voucher_value']      = $modelheader->credited_amount;
                $voucherHead['currency_id']        = $modelheader->currency;
                $voucherHead['exchange_rate']      = $modelheader->exchange_rate;
                $voucherHead['vat']                = $modelheader->total_tax_amount;
                $voucherHead['amount']             = ($modelheader->credited_amount) - $modelheader->total_tax_amount;
                $voucherHead['net_amount']         = $modelheader->credited_amount * $modelheader->exchange_rate;
                $voucherHead['total_discount']     = 0;
                $voucherHead['rounding']           = 0;
                $voucherHead['tax_type']           = $modelheader->taxtype->percentage;
                $voucherHead['tax_id']             = $modelheader->tax_type;
                $voucherHead['order_id']           = $modelheader->order_id;
                $voucherHead['delivery_id']        = 0;
                $voucherHead['direct']             = 0;
                $voucherHead['imported']           = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method']     = $payment_method;
                $voucherHead['payment_terms']      = $payment_term_id;
                $voucherHead['payment_days']       = 0;
                $voucherHead['payment_terms']      = 0;
                $voucherHead['lead_owner']         = $modelheader->crm_user_id;
                $voucherHead['salegroup_id']       = $salegroup_id;
                $voucherHead['year']               = $year;
                $voucherHead['company_id']         = $company_id;
                $voucherHead['branch_id']          = $branch_id;
                $voucherHead['project_id']         = $project_id;
                $voucherHead['department_id']      = $department_id;
                $voucherHead['employee_id']        = $employee_id;
                $voucherHead['warehouse_id']       = $warehouse_id;
                $voucherHead['outlet_id']          = $outlet_id;
                //-------saving invoice header details---------
                $invoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $invoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($invoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($invoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($creditnote_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {
            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $invoiceVoucherid);

            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Creditnote no: - {$voucherModel->transaction_id}  "
            );
            // end audit log
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $invoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }



    //end
    // -----------------------------------------------------------------------------------------------------------
    //(unpost) Credit Note items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public function addUnpostCreditnote($array_ids)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="CN"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $creditnote_id = $modelheader->id;
            //   $condition                = 't.reference_no=' . $creditnote_id;
            $modelAccVoucher = new AccVoucher;
            // $AccVoucher_det           = $modelAccVoucher->find(array('condition' => $condition));
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND  erp_acc_voucher.transaction_id LIKE '" . $creditnote_id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    // ---------------------------------------
                    $voucherModel = new AccVoucher();
                    $voucherModel = $voucherModel->findByPK((int)$AccVoucher_det[0]['id']);
                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'UNPOSTED',
                        changes: "(Imported) {$voucherModel->vtype->description} with Creditnote : - {$voucherModel->transaction_id} "
                    );
                    // end audit log
                    // ---------------------------------------
                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det[0]['id']));
                    $modelAccVoucher->deleteByPk($AccVoucher_det[0]['id']);
                    $modelheader->updateByPk($creditnote_id, array('posted' => 'N'));
                    // --------------------------to delete the payment voucher related to this  Credit Note-----------------------------
                    PostingController::deletePostedpayment_frm_creditnote($creditnote_id);
                    // -----------------------------------------------------------------------------------------------------------
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(post) purchase Debit Note items to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public static function addPostdebitnote($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];
        // ------------------used for purchase vat--voucher items-------------------
        function createAccVoucherItemvat($params, $tax_amount)
        {
            $item = new AccVoucherItems();
            $item->ledger_id = $params['ledger_id'];
            $item->year = $params['year'];
            if ($tax_amount >= 0) {
                $item->credit = ($params['default_type'] == 'C') ? ($tax_amount) : '0.00';
                $item->debit = ($params['default_type'] == 'D') ? ($tax_amount) : '0.00';
                $item->amount = ($params['default_type'] == 'C') ? (-1 * abs($tax_amount)) : abs($tax_amount);
            } else {
                $item->credit = ($params['default_type'] == 'D') ? abs($tax_amount) : '0.00';
                $item->debit = ($params['default_type'] == 'C') ? abs($tax_amount) : '0.00';
                $item->amount = ($params['default_type'] == 'D') ? (-1 * abs($tax_amount)) : abs($tax_amount);
            }
            $item->employee_id = $params['employee_id'];
            $item->salegroup_id = $params['salegroup_id'];
            $item->payment_term_id = $params['payment_term_id'];
            $item->narration = $params['narration'];
            $item->project_id = $params['project_id'];
            $item->company_id = $params['company_id'];
            $item->branch_id = $params['branch_id'];
            $item->costcenter_id = $params['costcenter_id'];
            $item->department_id = $params['department_id'];
            $item->exchange_rate = $params['exchange_rate'];
            $item->file_id = $params['file_id'];
            $item->warehouse_id = $params['warehouse_id'];
            $item->outlet_id = $params['outlet_id'];
            $item->user_id = $params['user_id'];
            return $item;
        }
        // ---------------------------------------

        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="DN"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--invoice
                $header_model = $model_voucher_type->header_table;
                if (empty($header_model)) {
                    $valid = false;
                    $others[] = 'Header Model not defined in Voucher Type';
                }
                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Purchase Invoice Not Found';
                } else if ($modelheader->posted == "Y") {
                    $valid = false;
                    $others[] = 'Purchase Debitnote Already posted' . $id;
                } else {
                    $modelhis = AccVoucher::model()->find(['condition' => 'transaction_id=' . (int) $id . ' AND voucher_type=' . $model_voucher_type->id]);
                    if (!empty($modelhis)) {
                        $valid = false;
                        $others[] = 'Purchase Debitnote Already Posted But status not updated!' . $id;
                    }
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->crm_user_id);


                $employee_id = (int) $usermodel->connected_employee_id;
                $narration = 'Purchase Debit Note #' . $modelheader->id . '/ Invoice - ' . $modelheader->$voucherReference;
                $debit_note_id = $modelheader->id;
                //$grand_total = Yii::app()->db->createCommand("select SUM(net_amount+tax_vat_amount)  from erp_purchasing_debit_note_item where purchasing_debitnote_id='" . $modelheader->id . "' ")->queryScalar();
                // $purchase_amount    = $grand_total - $modelheader->total_discount;
                // $purchase_amount    = $grand_total;
                //   --- ------------------------
                $modelpurchase = new PurchasingInvoice();
                $modelpurchase = $modelpurchase->findByPK((int) $modelheader->purchasing_invoice_id);
                //   --- ------------------------
                $sum_amt = Yii::app()->db->createCommand("select SUM(net_amount+tax_vat_amount)  from erp_purchasing_debit_note_item where purchasing_debitnote_id='" . $modelheader->id . "' ")->queryScalar();
                //$purchase_amount  = $modelheader->netPurchase;
                $tot_discount = 0;
                $round_off_amount = 0;
                $salegroup_id = 0;
                $project_id = 0;
                $branch_id = $usermodel->branch_id;
                $company_id = $usermodel->company_id;
                $payment_term_id = 0;
                $file_id = $modelheader->file_id;
                $exchange_rate = $modelheader->exchange_rate;
                $currency = $modelheader->currency;
                $transaction_id = $modelheader->id;
                $purchase_amount = $sum_amt * $modelheader->exchange_rate;
                $tax_amount = $modelheader->total_tax_amount * $modelheader->exchange_rate;
                // --------------
                $tax_amount_cgst = round($tax_amount / 2, 2);
                $tax_amount_sgst = round($tax_amount / 2, 2);
                $tax_amount_igst = $tax_amount;
                // --------------

                $warehouse_id = $modelheader?->warehouse_id ?? $usermodel?->available_warehouses ?? 0;
                $costcenter_id    = $warehouse_id;
                $outlet_id = $modelheader?->outlet_id ?? $usermodel?->outlet_id ?? 0;

                $costcenter_id = $warehouse_id;
                $warehouse_id = $warehouse_id;
                //$modelheader->invoice_type
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->vendor_id;
                $year = date('Y', strtotime($modelheader->$dateField));
                $modelMasInvoiceType_inv_code = 0;
                if (isset($modelheader->invoice_type)) {
                    $modelMasInvoiceType = new MasInvoiceType();
                    $modelMasInvoiceType = $modelMasInvoiceType->findByPk((int) $modelheader->invoice_type);
                    $modelMasInvoiceType_inv_code = $modelMasInvoiceType->inv_code;
                }
                $modelVendor = new Vendor();
                $customer_vendor_id = isset($customer_vendor_id) ? (int)$customer_vendor_id : 0;
                if ($customer_vendor_id > 0) {
                    $modelVendor = Vendor::model()->findByPk($customer_vendor_id);
                }
                $Vendor_ledger_id = ($modelVendor && isset($modelVendor->ledger_id)) ? (int)$modelVendor->ledger_id : 0;

                $arr_items = [];
                foreach ($modelvoucher_type_details as $eachtype) {
                    if ($eachtype->attribute == 'creditors') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = (int)$Vendor_ledger_id > 0 ? $Vendor_ledger_id : $eachtype->ledger_id;
                        $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id = $modAccSubledgerType->getIdFromType('V');
                        $modAccSubledger = new AccSubledger();
                        $arr_items[$i]->subledger_id = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->vendor_id);
                        $arr_items[$i]->year = $year;
                        if ($purchase_amount >= 0) {
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($purchase_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($purchase_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($purchase_amount)) : abs($purchase_amount);
                        } else {
                            $arr_items[$i]->credit = ($eachtype->default_type == 'D') ? abs($purchase_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'C') ? abs($purchase_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'D') ? (-1 * abs($purchase_amount)) : abs($purchase_amount);
                        }
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $arr_items[$i]->outlet_id = (int) $outlet_id;
                        $i++;
                    }
                    // --------------------start vat on purchase ------------------------------------                   
                    $tax_type = 'OUT'; //defult tax type
                    $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
                    if ($tableExists) {
                        $tax_type = Yii::app()->db->createCommand("SELECT tax_type FROM {{acc_general_settings}}")->queryScalar();
                    }
                    // Common parameters for createAccVoucherItemvat function
                    $vatparams = [
                        'ledger_id' => $eachtype->ledger_id,
                        'year' => $year,
                        'default_type' => $eachtype->default_type,
                        'employee_id' => $employee_id,
                        'salegroup_id' => $salegroup_id,
                        'payment_term_id' => $payment_term_id,
                        'narration' => $narration,
                        'project_id' => $project_id,
                        'company_id' => $company_id,
                        'branch_id' => $branch_id,
                        'costcenter_id' => $costcenter_id,
                        'department_id' => $department_id,
                        'exchange_rate' => $exchange_rate,
                        'file_id' => $file_id,
                        'warehouse_id' => $warehouse_id,
                        'outlet_id' => $outlet_id,
                        'user_id' => (int) $modelheader->crm_user_id
                    ];
                    // Check tax type and generate items accordingly
                    if ($tax_type == 'IN') {
                        if ($modelMasInvoiceType_inv_code == 'SCGST') {
                            if ($eachtype->attribute == 'purchase_vat_cgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_cgst);
                                $i++;
                            } elseif ($eachtype->attribute == 'purchase_vat_sgst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_sgst);
                                $i++;
                            }
                        } else if ($modelMasInvoiceType_inv_code == 'IGST') {
                            if ($eachtype->attribute == 'purchase_vat_igst') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount_igst);
                                $i++;
                            }
                        } else {
                            if ($eachtype->attribute == 'purchase_vat') {
                                $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                                $i++;
                            }
                        }
                    } else {
                        if ($eachtype->attribute == 'purchase_vat') {
                            $arr_items[$i] = createAccVoucherItemvat($vatparams, $tax_amount);
                            $i++;
                        }
                    }
                    // --------------------end vat on purchase ------------------------------------   
                    if ($eachtype->attribute == 'purchase_discount') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($tot_discount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($tot_discount)) : abs($tot_discount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $arr_items[$i]->outlet_id = (int) $outlet_id;
                        $i++;
                    }
                    if ($eachtype->attribute == 'round_off') {
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($round_off_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($round_off_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($round_off_amount)) : abs($round_off_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $arr_items[$i]->outlet_id = (int) $outlet_id;
                        $i++;
                    }
                    $modeldebitnoteItem = new PurchasingdebitnoteItem();
                    $modeldebitnoteItems = $modeldebitnoteItem->findAll(array('condition' => 'purchasing_debitnote_id=' . (int) $id));
                    foreach ($modeldebitnoteItems as $eachdebitnoteItems) {
                        $amount = $eachdebitnoteItems->net_amount * $modelheader->exchange_rate;

                        $model_Store = new Store();
                        $model_store_ledger_id = $model_Store->findByPK((int)$eachdebitnoteItems->product_id)->ledger_id;


                        //$amount = $eachdebitnoteItems->net_amount;
                        //$cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from='DEBIT_NOTE' AND product_id='" . $eachdebitnoteItems->product_id . "'  AND (header_id ='" . $debit_note_id . "')")->queryScalar();
                        if ($eachtype->attribute == 'debit_note') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = ((int)$model_store_ledger_id > 0) ? (int)$model_store_ledger_id : $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachdebitnoteItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachdebitnoteItems->purchased_quantity;
                            $arr_items[$i]->rate = $eachdebitnoteItems->rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->unit_id = $eachdebitnoteItems->unit;
                            $arr_items[$i]->unit_factor = $eachdebitnoteItems->unitdetails->factor;
                            $arr_items[$i]->currency_id = $currency;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->tax = $eachdebitnoteItems->tax_vat_amount * $modelheader->exchange_rate;;
                            $arr_items[$i]->net_amount = $eachdebitnoteItems->net_amount * $modelheader->exchange_rate;;
                            $arr_items[$i]->current_cost = 0;
                            $arr_items[$i]->last_cost = 0;
                            $arr_items[$i]->balance_qty = 0;
                            $arr_items[$i]->inventory_value = 0;
                            $arr_items[$i]->discount_percentage = 0;
                            $arr_items[$i]->discount_amount = 0;
                            $arr_items[$i]->rounding = 0;
                            $arr_items[$i]->warehouse_id = 0;
                            $arr_items[$i]->foc = 0;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->outlet_id = (int) $outlet_id;
                            // --------------//------------------------
                            $i++;
                        }
                     /*   if ($eachtype->attribute == 'inventory') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachdebitnoteItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachdebitnoteItems->purchased_quantity;
                            $arr_items[$i]->unit_id = $eachdebitnoteItems->unit;
                            $arr_items[$i]->unit_factor = $eachdebitnoteItems->unitdetails->factor;
                            $arr_items[$i]->rate = $eachdebitnoteItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->outlet_id = (int) $outlet_id;
                            $i++;
                        }
                        if ($eachtype->attribute == 'closing_stock') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachdebitnoteItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($amount)) : abs($amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachdebitnoteItems->purchased_quantity;
                            $arr_items[$i]->unit_id = $eachdebitnoteItems->unit;
                            $arr_items[$i]->unit_factor = $eachdebitnoteItems->unitdetails->factor;
                            $arr_items[$i]->rate = $eachdebitnoteItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->outlet_id = (int) $outlet_id;
                            $i++;
                        }*/
                    }
                }
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['file_id'] = $modelheader->file_id;
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $debit_note_id;
                $voucherHead['transaction_id'] = $debit_note_id;
                $voucherHead['reference_no'] = $modelheader->$voucherReference;
                $voucherHead['narration'] = $narration;
                $voucherHead['voucher_value'] = $modelheader->debited_amount;
                $voucherHead['currency_id'] = $modelheader->currency;
                $voucherHead['exchange_rate'] = $modelheader->exchange_rate;
                $voucherHead['amount'] = ($purchase_amount) - $tax_amount;
                $voucherHead['vat'] = $modelheader->total_tax_amount;
                $voucherHead['net_amount'] = $purchase_amount;
                $voucherHead['total_discount'] = 0;
                $voucherHead['rounding'] = 0;
                $voucherHead['tax_type'] = $modelheader->taxtype->percentage;
                $voucherHead['tax_id'] = $modelheader->tax_type;
                $voucherHead['order_id'] = 0;
                $voucherHead['delivery_id'] = 0;
                $voucherHead['direct'] = 0;
                $voucherHead['imported'] = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = $modelpurchase->payment_terms;
                $voucherHead['payment_terms'] = $modelpurchase->payment_terms;
                $voucherHead['payment_days'] = 0;
                $voucherHead['payment_terms'] = 0;
                $voucherHead['lead_owner'] = (int) $modelheader->crm_user_id;
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = (int) $warehouse_id;
                //-------saving purchaseinvoice header details---------
                $purchaseinvoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $purchaseinvoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($purchaseinvoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($purchaseinvoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($debit_note_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {
            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $purchaseinvoiceVoucherid);
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Debitnote no: - {$voucherModel->transaction_id}  "
            );
            // end audit log
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $purchaseinvoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(unpost) debit Note items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public function addUnpostdebitnote($array_ids)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="DN"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $debtnote_id = $modelheader->id;
            //   $condition                = 't.reference_no=' . $debtnote_id;
            $modelAccVoucher = new AccVoucher;
            // $AccVoucher_det           = $modelAccVoucher->find(array('condition' => $condition));
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND erp_acc_voucher.transaction_id LIKE '" . $debtnote_id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    // ---------------------------------------
                    $voucherModel = new AccVoucher();
                    $voucherModel = $voucherModel->findByPK((int)$AccVoucher_det[0]['id']);
                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'UNPOSTED',
                        changes: "(Imported) {$voucherModel->vtype->description} with Debitnote : - {$voucherModel->transaction_id} "
                    );
                    // end audit log
                    // ---------------------------------------
                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det[0]['id']));
                    $modelAccVoucher->deleteByPk($AccVoucher_det[0]['id']);
                    $modelheader->updateByPk($debtnote_id, array('posted' => 'N'));
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(post) goods issue to finance voucher and voucher items
    //------------------------------------------------------------------------------------------------------------
    public static function addPostgoodsissue($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="GI"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--credit note
                $header_model = $model_voucher_type->header_table;
                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Goods Issue Not Found';
                } else if ($modelheader->posted == "Y") {
                    $valid = false;
                    $others[] = 'Goods Issue Already posted' . $id;
                } else {
                    $modelhis = AccVoucher::model()->find(['condition' => 'transaction_id=' . (int) $id . ' AND voucher_type=' . $model_voucher_type->id]);
                    if (!empty($modelhis)) {
                        $valid = false;
                        $others[] = 'Goods Issue Already Posted But status not updated!' . $id;
                    }
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->created_by);
                $employee_id = (int) $usermodel->connected_employee_id;
                //$employee_id        = 0;
                $goods_issue_id = $modelheader->id;
                //$sales_amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_issue_item where inventory_goods_issue_id='" . $modelheader->id . "'  ")->queryScalar();
                $sales_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from='GOODS_ISSUE'  AND (header_id ='" . $modelheader->id . "')")->queryScalar();
                //    ---------------------------
                $model_MasInventoryStockAdjustmentType = new MasInventoryStockAdjustmentType();
                $InventoryStockAdjustmentType_det = $model_MasInventoryStockAdjustmentType->find(array('condition' => 'code="' . $modelheader->issue_type . '" AND type="I"'));
                //    ---------------------------
                if (!empty($InventoryStockAdjustmentType_det)) {
                    $narration = 'Goods Issue ' . $InventoryStockAdjustmentType_det->description . '#' . $modelheader->$voucherReference;
                } else {
                    $narration = 'Goods Issue #' . $modelheader->$voucherReference;
                }
                $tax_amount = 0;
                $tot_discount = 0;
                $round_off_amount = 0;
                $salegroup_id = 0;
                $project_id = $modelheader->project_id;
                $branch_id = $usermodel->branch_id;
                $company_id = $usermodel->company_id;
                $payment_term_id = 0;
                $warehouse_id = isset($usermodel->available_warehouses) ? $usermodel->available_warehouses : 0;
                $costcenter_id = $warehouse_id;
                $warehouse_id = $warehouse_id;
                $currency = 1;
                $exchange_rate = 1;
                $file_id = $modelheader->file_id;
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->customer_id;
                
                 $asset_ledger  = isset($modelheader->asset_ledger) ? $modelheader->asset_ledger : 0;

                $income_ledger = isset($modelheader->income_ledger) ? $modelheader->income_ledger : 0;


                $year = date('Y', strtotime($modelheader->$dateField));
                $arr_items = [];
                foreach ($modelvoucher_type_details as $eachtype) {
                    
                    
                       if ($eachtype->attribute == 'goods_issue') {


                        /*  if ($InventoryStockAdjustmentType_det->ledger_id > 0) {
                            $issue_ledger_id = $InventoryStockAdjustmentType_det->ledger_id;
                        } else {
                            $issue_ledger_id = $eachtype->ledger_id;
                        }    */
                        /*  $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
                        if ($InventoryStockAdjustmentType_det->subledger_id > 0) {
                            $arr_items[$i]->subledger_id = (int) $InventoryStockAdjustmentType_det->subledger_id;
                        } else {
                            if ($modelheader->customer_id > 0) {
                                $modAccSubledger = new AccSubledger();
                                $arr_items[$i]->subledger_id = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
                            }
                        } */
                        $income_ledger = ((int) $income_ledger > 0) ? $income_ledger : $eachtype->ledger_id;

                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $income_ledger;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? abs($sales_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? abs($sales_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                        $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->created_by;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $i++;
                    }
                    if ($eachtype->attribute == 'retained_earnings') {
                        $asset_ledger = ((int) $asset_ledger > 0) ? $asset_ledger : $eachtype->ledger_id;

                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $asset_ledger;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? abs($sales_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? abs($sales_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                        $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($sales_amount)) : abs($sales_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->file_id = $file_id;
                        $arr_items[$i]->user_id = (int) $modelheader->created_by;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $i++;
                    }
                 
                    $modeInventoryGoodsIssueItem = new InventoryGoodsIssueItem();
                    $modeInventoryGoodsIssueItems = $modeInventoryGoodsIssueItem->findAll(array('condition' => 'inventory_goods_issue_id=' . (int) $id));
                /*    foreach ($modeInventoryGoodsIssueItems as $eachGoodsIssueItems) {
                        $amount = 0;
                        //added by indhu 19_12_2022
                        // $cost_amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_issue_item where inventory_goods_issue_id='" . $eachGoodsIssueItems->inventory_goods_issue_id . "'  ")->queryScalar();
                        $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from='GOODS_ISSUE' AND product_id='" . $eachGoodsIssueItems->product_id . "'  AND (header_id ='" . $modelheader->id . "  AND abs(quantity)=" . $eachGoodsIssueItems->picked_qty . "')")->queryScalar();
                        //end 
                        if ($eachtype->attribute == 'inventory') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachGoodsIssueItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? abs($cost_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? abs($cost_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachGoodsIssueItems->picked_qty;
                            $arr_items[$i]->rate = $eachGoodsIssueItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->created_by;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->unit_id = $eachGoodsIssueItems->unit;
                            $arr_items[$i]->unit_factor = $eachGoodsIssueItems->uom->factor;
                            $i++;
                        }
                        if ($eachtype->attribute == 'closing_stock') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachGoodsIssueItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachGoodsIssueItems->picked_qty;
                            $arr_items[$i]->rate = $eachGoodsIssueItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->created_by;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->unit_id = $eachGoodsIssueItems->unit;
                            $arr_items[$i]->unit_factor = $eachGoodsIssueItems->uom->factor;
                            $i++;
                        }
                    }*/
                }
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['file_id'] = $modelheader->file_id;
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $goods_issue_id;
                $voucherHead['transaction_id'] = $goods_issue_id;
                $voucherHead['reference_no'] = $modelheader->$voucherReference;
                $voucherHead['narration'] = $narration;
                $voucherHead['voucher_value'] = 0;
                $voucherHead['currency_id'] = 1;
                $voucherHead['exchange_rate'] = 1;
                $voucherHead['vat'] = 0;
                $voucherHead['amount'] = $sales_amount;
                $voucherHead['voucher_value'] = $sales_amount;
                $voucherHead['net_amount'] = $sales_amount;
                $voucherHead['total_discount'] = 0;
                $voucherHead['rounding'] = 0;
                $voucherHead['tax_type'] = 0;
                $voucherHead['tax_id'] = 0;
                $voucherHead['order_id'] = 0;
                $voucherHead['delivery_id'] = 0;
                $voucherHead['direct'] = 0;
                $voucherHead['imported'] = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = 0;
                $voucherHead['payment_days'] = 0;
                $voucherHead['payment_terms'] = 0;
                $voucherHead['lead_owner'] = (int) $modelheader->created_by;
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = $warehouse_id;
                //-------saving invoice header details---------
                $invoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $invoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($invoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($invoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($goods_issue_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {

            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $invoiceVoucherid);
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Goods Issue no: - {$voucherModel->transaction_id}  "

            );
            // end audit log
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $invoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }
    //end
    // -----------------------------------------------------------------------------------------------------------
    //(unpost) goods issue items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public static function addUnpostgoodsissue($array_ids)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="GI"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $goods_issue_id = $modelheader->id;
            //   $condition                = 't.reference_no=' . $goods_issue_id;
            $modelAccVoucher = new AccVoucher;
            // $AccVoucher_det           = $modelAccVoucher->find(array('condition' => $condition));
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND erp_acc_voucher.transaction_id LIKE '" . $goods_issue_id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    // ---------------------------------------
                    $voucherModel = new AccVoucher();
                    $voucherModel = $voucherModel->findByPK((int)$AccVoucher_det[0]['id']);
                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'UNPOSTED',
                        changes: "(Imported) {$voucherModel->vtype->description} with Goodsissue : - {$voucherModel->transaction_id} "
                    );
                    // end audit log
                    // ---------------------------------------
                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det[0]['id']));
                    $modelAccVoucher->deleteByPk($AccVoucher_det[0]['id']);
                    $modelheader->updateByPk($goods_issue_id, array('posted' => 'N'));
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(post) goods receipt items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public static function addPostgoodsreceipt($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="GR"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--credit note
                $header_model = $model_voucher_type->header_table;
                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Goods Receipt Not Found';
                } else if ($modelheader->posted == "Y") {
                    $valid = false;
                    $others[] = 'Goods Receipt Already posted' . $id;
                } else {
                    $modelhis = AccVoucher::model()->find(['condition' => 'transaction_id=' . (int) $id . ' AND voucher_type=' . $model_voucher_type->id]);
                    if (!empty($modelhis)) {
                        $valid = false;
                        $others[] = 'Goods Receipt Already Posted But status not updated!' . $id;
                    }
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->created_by);
                $employee_id = (int) $usermodel->connected_employee_id;
                //    ---------------------------
                $model_MasInventoryStockAdjustmentType = new MasInventoryStockAdjustmentType();
                $InventoryStockAdjustmentType_det = $model_MasInventoryStockAdjustmentType->find(array('condition' => 'code="' . $modelheader->receipt_type . '" AND type="R"'));
                //    ---------------------------
                if (!empty($InventoryStockAdjustmentType_det)) {
                    $narration = 'Goods Receipt ' . $InventoryStockAdjustmentType_det->description . '#' . $modelheader->$voucherReference;
                } else {
                    $narration = 'Goods Receipt #' . $modelheader->$voucherReference;
                }
                $goods_receipt_id = $modelheader->id;
                //$sales_amount       = $modelheader->credited_amount - $modelheader->total_discount;
                $purchase_amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_receipt_item where inventory_goods_receipt_id='" . $modelheader->id . "'  ")->queryScalar();
                $tax_amount = 0;
                $tot_discount = 0;
                $round_off_amount = 0;
                $salegroup_id = 0;
                $project_id = $modelheader->project_id;
                $branch_id = $usermodel->branch_id;
                $company_id = $usermodel->company_id;
                $payment_term_id = 0;

                $warehouse_id = isset($usermodel->available_warehouses) ? $usermodel->available_warehouses : 0;
                $costcenter_id = $warehouse_id;
                $warehouse_id = $warehouse_id;
                $currency = 1;
                $exchange_rate = 1;
                $file_id = $modelheader->file_id;
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->customer_id;
                $year = date('Y', strtotime($modelheader->$dateField));
                
                  $asset_ledger  = isset($modelheader->asset_ledger) ? $modelheader->asset_ledger : 0;

                $expense_ledger = isset($modelheader->expense_ledger) ? $modelheader->expense_ledger : 0;

                $arr_items = [];
                foreach ($modelvoucher_type_details as $eachtype) {
                    $modeInventoryGoodsReceiptItem = new InventoryGoodsReceiptItem();
                    $modeInventoryGoodsReceiptItems = $modeInventoryGoodsReceiptItem->findAll(array('condition' => 'inventory_goods_receipt_id=' . (int) $id));
                    foreach ($modeInventoryGoodsReceiptItems as $eachReceiptItems) {
                        $amount = 0;
                        //added by indhu 19_12_2022
                        $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from='GOODS_RECEIPT' AND product_id='" . $eachReceiptItems->product_id . "'  AND (header_id ='" . $goods_receipt_id . "'  AND abs(quantity)=" . $eachReceiptItems->picked_qty . ")")->queryScalar();
                        //end 
                        if ($eachtype->attribute == 'goods_receipt') {

                        /*  if ($InventoryStockAdjustmentType_det->ledger_id > 0) {
                            $issue_ledger_id = $InventoryStockAdjustmentType_det->ledger_id;
                        } else {
                            $issue_ledger_id = $eachtype->ledger_id;
                        } */

                        /*  $modAccSubledgerType = new AccSubledgerType();
                         $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
                        $modAccSubledger = new AccSubledger();
                          if ($InventoryStockAdjustmentType_det->subledger_id > 0) {
                            $arr_items[$i]->subledger_id = (int) $InventoryStockAdjustmentType_det->subledger_id;
                        } else {
                            if ($modelheader->customer_id > 0) {
                                $arr_items[$i]->subledger_id = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
                            }
                        } */

                        $expense_ledger = ((int)$expense_ledger > 0) ? $expense_ledger : $eachtype->ledger_id;
                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $expense_ledger;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? abs($cost_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($cost_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                        $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->user_id = (int) $modelheader->created_by;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $i++;
                    }


                    if ($eachtype->attribute == 'retained_earnings') {
                        $asset_ledger = ((int)$asset_ledger > 0) ? $asset_ledger : $eachtype->ledger_id;

                        $arr_items[$i] = new AccVoucherItems();
                        $arr_items[$i]->ledger_id = $asset_ledger;
                        $arr_items[$i]->year = $year;
                        $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($cost_amount) : '0.00';
                        $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($cost_amount) : '0.00';
                        $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                        $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                        $arr_items[$i]->employee_id = $employee_id;
                        $arr_items[$i]->salegroup_id = $salegroup_id;
                        $arr_items[$i]->payment_term_id = $payment_term_id;
                        $arr_items[$i]->narration = $narration;
                        $arr_items[$i]->project_id = $project_id;
                        $arr_items[$i]->company_id = $company_id;
                        $arr_items[$i]->branch_id = $branch_id;
                        $arr_items[$i]->costcenter_id = $costcenter_id;
                        $arr_items[$i]->department_id = $department_id;
                        $arr_items[$i]->exchange_rate = $exchange_rate;
                        $arr_items[$i]->user_id = (int) $modelheader->created_by;
                        $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                        $i++;
                    }
                        
                        
                     /*   if ($eachtype->attribute == 'inventory') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachReceiptItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachReceiptItems->picked_qty;
                            $arr_items[$i]->rate = $eachReceiptItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->user_id = (int) $modelheader->created_by;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->unit_id = $eachReceiptItems->unit;
                            $arr_items[$i]->unit_factor = $eachReceiptItems->unitdetails->factor;
                            $i++;
                        }
                        if ($eachtype->attribute == 'closing_stock') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachReceiptItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->net_amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachReceiptItems->picked_qty;
                            $arr_items[$i]->rate = $eachReceiptItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->user_id = (int) $modelheader->created_by;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $arr_items[$i]->unit_id = $eachReceiptItems->unit;
                            $arr_items[$i]->unit_factor = $eachReceiptItems->unitdetails->factor;
                            $i++;
                        }*/
                    }
                }
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['file_id'] = $modelheader->file_id;
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $goods_receipt_id;
                $voucherHead['transaction_id'] = $goods_receipt_id;
                $voucherHead['reference_no'] = $modelheader->$voucherReference;
                $voucherHead['narration'] = $narration;
                $voucherHead['currency_id'] = 1;
                $voucherHead['exchange_rate'] = 1;
                $voucherHead['vat'] = 0;
                $voucherHead['amount'] = $purchase_amount;
                $voucherHead['net_amount'] = $purchase_amount;
                $voucherHead['voucher_value'] = $purchase_amount;
                $voucherHead['total_discount'] = 0;
                $voucherHead['rounding'] = 0;
                $voucherHead['tax_type'] = 0;
                $voucherHead['tax_id'] = 0;
                $voucherHead['order_id'] = 0;
                $voucherHead['delivery_id'] = 0;
                $voucherHead['direct'] = 0;
                $voucherHead['imported'] = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = 0;
                $voucherHead['payment_days'] = 0;
                $voucherHead['payment_terms'] = 0;
                $voucherHead['lead_owner'] = (int) $modelheader->created_by;
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = (int) $warehouse_id;
                //-------saving invoice header details---------
                $invoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $invoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($invoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($invoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($goods_receipt_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {
            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $invoiceVoucherid);
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Goods Receipt no: - {$voucherModel->transaction_id}  "
            );
            // end audit log
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $invoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }
    //end
    // -----------------------------------------------------------------------------------------------------------
    //(unpost) goods receipt items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public function addUnpostgoodsreceipt($array_ids)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="GR"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $goods_receipt_id = $modelheader->id;
            //   $condition                = 't.reference_no=' . $goods_receipt_id;
            $modelAccVoucher = new AccVoucher;
            // $AccVoucher_det           = $modelAccVoucher->find(array('condition' => $condition));
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND erp_acc_voucher.transaction_id LIKE '" . $goods_receipt_id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    // ---------------------------------------
                    $voucherModel = new AccVoucher();
                    $voucherModel = $voucherModel->findByPK((int)$AccVoucher_det[0]['id']);
                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'UNPOSTED',
                        changes: "(Imported) {$voucherModel->vtype->description} with Goodsreceipt : - {$voucherModel->transaction_id} "
                    );
                    // end audit log
                    // ---------------------------------------
                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det[0]['id']));
                    $modelAccVoucher->deleteByPk($AccVoucher_det[0]['id']);
                    $modelheader->updateByPk($goods_receipt_id, array('posted' => 'N'));
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionPostGI()
    {
        if ($status != '') {
            if ($status == 'N') { //post
                $from = '';
                PostingController::addPostgoodsissue($array_ids, $from);
            } else if ($status == 'Y') { //un post
                PostingController::addUnpostgoodsissue($array_ids);
            }
        }
    }
    /**
      --import goods receipt items to finance voucher and voucher items--
     * */
    public function actionPostGR()
    {
        if ($status != '') {
            if ($status == 'N') { //post
                $from = '';
                PostingController::addPostgoodsreceipt($array_ids, $from);
            } else if ($status == 'Y') { //un post
                PostingController::addUnpostgoodsreceipt($array_ids);
            }
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //used to correct leger roots
    //------------------------------------------------------------------------------------------------------------
    public function actionCorrectingLedgerRoots()
    {
        $sql = "SELECT * FROM erp_acc_ledger";
        $ledger_list = Yii::app()->db->createCommand($sql)->queryAll();
        $model = new AccLedger;
        foreach ($ledger_list as $ledger) {
            $prefix_va = 0;
            if ($ledger['level'] > 1) {
                $level = (($ledger['level'] - 1) * 2) - 1;
                $prefix_va = substr($ledger['ledger_acc_no'], 0, $level + 2);
                // $model->root =  $prefix_va;
                // $sql1 = "UPDATE erp_acc_ledger
                // SET root = '" . $prefix_va . "'
                // WHERE id= '" . $ledger['id'] . "' ";
                AccLedger::model()->updatebypk($ledger['id'], array('root' => ($prefix_va)));
            }
        }
        echo 'Success';
    }
    // -----------------------------------------------------------------------------------------------------------
    //used to Rounding Purchase
    //------------------------------------------------------------------------------------------------------------
    public function actionAddRoundingPurchase()
    {
        $sql = "SELECT * FROM (SELECT SUM(VI.amount) AS roundoff,V.id,V.project_id,V.company_id FROM erp_acc_voucher V LEFT JOIN erp_acc_voucher_items VI ON acc_voucher_id =V.id where V.voucher_type=8 GROUP BY V.id)A WHERE roundoff!=0";
        $voucher_list = Yii::app()->db->createCommand($sql)->queryAll();
        $model = new AccVoucherItems();
        foreach ($voucher_list as $voucher) {
            $round_off_amount = -1 * $voucher['roundoff'];
            $modelVI = $model->find(array('condition' => 'acc_voucher_id=' . $voucher['id'] . ' AND ledger_id=10179'));
            if (!empty($modelVI)) {
                $credit = 0;
                $debit = 0;
                $credit = ($round_off_amount < 0) ? ($round_off_amount) : '0.00';
                $debit = ($round_off_amount > 0) ? ($round_off_amount) : '0.00';
                $modelVI->credit = $modelVI->credit + $credit;
                $modelVI->debit = $modelVI->debit + $debit;
                $modelVI->amount = $modelVI->amount + $debit + $credit;
                $modelVI->save(false);
            }
        }
        echo 'Success';
    }
    // -----------------------------------------------------------------------------------------------------------
    //add receipt to finance voucher and voucher items directly from  sales invoice save
    //------------------------------------------------------------------------------------------------------------
    public static function addPostReceipt_frm_invoice($inv_id)

    {

        //  if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {
        $valid  = true;

        $others = [];
        //check whether voucher type defined
        $model_voucher_type             = new AccVoucherType();
        $model_voucher_type             = $model_voucher_type->find(array('condition' => 'code="RV"'));

        if (empty($model_voucher_type)) {
            $valid          = false;
            $others[]       = 'Voucher Type not defined';
        } else {
            //check whether voucher type details defined
            $modelvoucher_type_details      = new AccVoucherTypeDetails();
            $modelvoucher_type_details      = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int)$model_voucher_type->id));
            if (empty($modelvoucher_type_details)) {
                $valid          = false;
                $others[]       = 'Voucher Type Details not defined';
            }
            $modelheader         = new Invoice();
            $modelheader         = $modelheader->findByPK((int)$inv_id);


            if (empty($modelheader)) {
                $valid           = false;
                $others[]        = 'Invoice Not Found' . $inv_id;
            }
            //    ------------------------------------
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger                   = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
            //    ------------------------------------
            $modAccSubledgerType = new AccSubledgerType();
            $subledger_type_id   = $modAccSubledgerType->getIdFromType('C');
            $modAccSubledger     = new AccSubledger();
            $from_subledger      = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
            //    ------------------------------------
            $i = 0;
            $usermodel          = new user();
            $usermodel          = $usermodel->findByPK((int)$modelheader->lead_owner_id);
            //    ------------------------------------

            $employee_id        = (int)$usermodel->connected_employee_id;
            $voucherReference   = $modelheader->invoice_no;
            $narration          = 'Receipt Voucher #' . $voucherReference;

            $amount             = $modelheader->grand_total;
            $net_amount = (isset($modelheader->received_cash_amount) ? $modelheader->received_cash_amount : 0)
                + (isset($modelheader->received_card_amount) ? $modelheader->received_card_amount : 0);

            $tax_amount         = $modelheader->total_tax_amount;
            $tot_discount       = 0;
            $round_off_amount   = 0;
            $salegroup_id       = (isset($modelheader->sales_group)) ? $modelheader->sales_group : 0;
            $project_id         = 0;
            $branch_id          = (isset($usermodel->branch_id)) ? $usermodel->branch_id : 0;
            $company_id         = (isset($usermodel->company_id)) ? $usermodel->company_id : 0;
            $payment_term_id    = (isset($modelheader->payment_terms)) ? $modelheader->payment_terms : 0;
            $costcenter_id      = (isset($usermodel->available_warehouses)) ? $usermodel->available_warehouses : 0;
            $department_id      = 0;
            $reference          = $voucherReference; //invoice number



            if ((int)$employee_id > 0) {
                $modelEmployee = new Employee();
                $modelEmployee = $modelEmployee->findByPK((int)$employee_id);
                $department_id = $modelEmployee->department;
            }
            $customer_vendor_id = 0;
            if ((int)$from_subledger > 0) {
                $modelCustomer_subledger = new AccSubledger();
                $modelCustomer_subledger = $modelCustomer_subledger->findByPk((int)$from_subledger);
                $customer_vendor_id      = $modelCustomer_subledger->reference_id;
            }
            $year               = (count(explode('/', $modelheader->invoice_date)) == 3) ? date("Y", strtotime(str_replace('/', '-', $modelheader->invoice_date))) : date('Y');
            // ------------------------------------------

            // $warehouse_id    = (int)$usermodel->available_warehouses;

            $warehouse_id    = $modelheader->warehouse_id;

            $cash_sub_ledger = 0;
            $bank_sub_ledger = 0;
            if ($warehouse_id > 0) {
                $modelMasInventoryWarehouse  = new MasInventoryWarehouse();
                $Warehouse_det = $modelMasInventoryWarehouse->findByPk((int)$warehouse_id);
                $cash_sub_ledger =  (isset($Warehouse_det->cash_ledger)) ? $Warehouse_det->cash_ledger : 0;
                $bank_sub_ledger =  ((isset($Warehouse_det->bank_ledger))) ? $Warehouse_det->bank_ledger : 0;
            }
            $bank_ledger = $modelAccSystemAccountsMapping->getSystemdefault('bank');
            $cash_ledger = $modelAccSystemAccountsMapping->getSystemdefault('cash');
            // ------------------------------------------


            $payment_method = 0;
            if (isset($modelheader->receipt_type)) {
                $modelAccPaymentMode  = new AccPaymentMode();
                $type = $modelAccPaymentMode->find(array('condition' => 'code="' . $modelheader->receipt_type . '"'));
                if (!empty($type)) {
                    $payment_method = $type->id;
                }
            }

            $arr_items = [];
            // --------------debtor----------------------------
            $arr_items[$i]                  = new AccVoucherItems();
            $arr_items[$i]->ledger_id       = $from_ledger;
            $arr_items[$i]->subledger_id    = (int)$from_subledger;
            $arr_items[$i]->year            = $year;
            $arr_items[$i]->credit          = abs($amount);
            $arr_items[$i]->debit           = '0.00';
            $arr_items[$i]->amount          = -1 * abs($amount);
            $arr_items[$i]->employee_id     = $employee_id;
            $arr_items[$i]->salegroup_id    = $salegroup_id;
            $arr_items[$i]->payment_term_id = $payment_term_id;
            $arr_items[$i]->narration       = $narration;
            $arr_items[$i]->project_id      = $project_id;
            $arr_items[$i]->company_id      = $company_id;
            $arr_items[$i]->branch_id       = $branch_id;
            $arr_items[$i]->costcenter_id   = $costcenter_id;
            $arr_items[$i]->department_id   = $department_id;
            $arr_items[$i]->user_id         = (int)$modelheader->lead_owner_id;
            $arr_items[$i]->warehouse_id    = $warehouse_id;
            $i++;


            // ----------------invoice receipt_type = cash------------------------------------------
            if (isset($modelheader->received_cash_amount)) {
                if ($modelheader->received_cash_amount > 0) {
                    $arr_items[$i]                  = new AccVoucherItems();
                    $arr_items[$i]->ledger_id       = $cash_ledger;
                    $arr_items[$i]->subledger_id    = (int)$cash_sub_ledger;
                    $arr_items[$i]->year            = $year;
                    $arr_items[$i]->credit          = '0.00';
                    $arr_items[$i]->debit           = ((isset($modelheader->received_cash_amount))) ? abs($modelheader->received_cash_amount) : 0;
                    $arr_items[$i]->amount          = ((isset($modelheader->received_cash_amount))) ? (abs($modelheader->received_cash_amount)) : 0;
                    $arr_items[$i]->employee_id     = $employee_id;
                    $arr_items[$i]->salegroup_id    = $salegroup_id;
                    $arr_items[$i]->payment_term_id = $payment_term_id;
                    $arr_items[$i]->narration       = $narration;
                    $arr_items[$i]->project_id      = $project_id;
                    $arr_items[$i]->company_id      = $company_id;
                    $arr_items[$i]->branch_id       = $branch_id;
                    $arr_items[$i]->costcenter_id   = $costcenter_id;
                    $arr_items[$i]->department_id   = $department_id;
                    $arr_items[$i]->user_id         = (int)$modelheader->lead_owner_id;
                    $arr_items[$i]->warehouse_id    = $warehouse_id;
                    $i++;
                }
            }

            // --------------------invoice receipt_type = card--------------------------------------
            if (isset($modelheader->received_card_amount)) {
                if ($modelheader->received_card_amount > 0) {
                    $arr_items[$i]                  = new AccVoucherItems();
                    $arr_items[$i]->ledger_id       = $bank_ledger;
                    $arr_items[$i]->subledger_id    = (int)$bank_sub_ledger;
                    $arr_items[$i]->year            = $year;
                    $arr_items[$i]->credit          = 0.00;
                    $arr_items[$i]->debit           = ((isset($modelheader->received_card_amount))) ? $modelheader->received_card_amount : 0;
                    $arr_items[$i]->amount          = ((isset($modelheader->received_card_amount))) ? (abs($modelheader->received_card_amount)) : 0;
                    $arr_items[$i]->employee_id     = $employee_id;
                    $arr_items[$i]->salegroup_id    = $salegroup_id;
                    $arr_items[$i]->payment_term_id = $payment_term_id;
                    $arr_items[$i]->narration       = $narration;
                    $arr_items[$i]->project_id      = $project_id;
                    $arr_items[$i]->company_id      = $company_id;
                    $arr_items[$i]->exchange_rate   = 1;
                    $arr_items[$i]->branch_id       = $branch_id;
                    $arr_items[$i]->costcenter_id   = $costcenter_id;
                    $arr_items[$i]->department_id   = $department_id;
                    $arr_items[$i]->user_id         = (int)$modelheader->lead_owner_id;
                    $arr_items[$i]->warehouse_id    = $warehouse_id;
                    $i++;
                }
            }
            // ----------------------------------------------------------
        }
        if ($valid) {
            $voucherHead = array();
            $voucherHead['voucher_type']        = $model_voucher_type->id;
            $modelAccVoucherType                = new AccVoucherType;
            $voucherHead['voucher_no']          = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
            $voucherHead['transaction_date']    = date('Y-m-d');
            $voucherHead['transaction_number']  = $inv_id;
            $voucherHead['transaction_id']      = $inv_id;
            $voucherHead['reference_no']        = $reference;
            $voucherHead['voucher_date']        =  (count(explode('-', $modelheader->invoice_date)) == 3) ?  $modelheader->invoice_date : date('Y-m-d');
            $voucherHead['narration']           = $narration;
            $voucherHead['currency_id']         = 1;
            $voucherHead['amount']              = $amount - $tax_amount;
            $voucherHead['payment_method']      = $payment_method;
            $voucherHead['payment_terms']       = (isset($modelheader->payment_terms)) ? $modelheader->payment_terms : 0;
            $voucherHead['exchange_rate']       = 1;
            $voucherHead['card_no']             = 0;
            $voucherHead['bank_name']           = '';
            $voucherHead['cheque_no']           = 0;
            $voucherHead['cheque_date']         = '';
            $voucherHead['due_date']            = '';
            $voucherHead['customer_vendor_id']  = $customer_vendor_id;
            $voucherHead['lead_owner']          = (int)$modelheader->lead_owner_id;
            $voucherHead['year']                = $year;
            $voucherHead['company_id']          = $company_id;
            $voucherHead['branch_id']           = $branch_id;
            $voucherHead['project_id']          = $project_id;
            $voucherHead['department_id']       = $department_id;
            $voucherHead['employee_id']         = $employee_id;
            $voucherHead['salegroup_id']        = $salegroup_id;
            $voucherHead['vat']                 = $tax_amount;
            $voucherHead['imported']            = 'Y';
            $voucherHead['net_amount']          = $net_amount;
            $voucherHead['warehouse_id']        = $warehouse_id;
            //-------saving receipt header details---------
            $receiptVoucherid =  PostingController::addVoucherhead($voucherHead);
            if ((int)$receiptVoucherid > 0) {
                for (
                    $k = 0;
                    $k < $i;
                    $k++
                ) {
                    PostingController::addVoucheritems($receiptVoucherid, $arr_items[$k]);
                }

                PostingController::addroundoff((int)$receiptVoucherid);

                $voucherModel = new AccVoucher();
                $voucherModel = $voucherModel->findByPK((int) $receiptVoucherid);

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    'POSTED',
                    changes: "(Imported) {$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                );
                // end audit log

                /*  $jsonData['status']             = 'success';
                $jsonData['id']     = (int)$receiptVoucherid; */
            } else {
                /*   $jsonData['status']             = 'error';
                $jsonData[]                     = 'Voucher Header Not Saved'; */
            }
            //  echo CJSON::encode($jsonData);
        } else {
            /*   $error = CJSON::encode($others);
            array_merge_recursive($error, $error1, $error2, $error3, $others)
            if ($error != '[]')
                echo $error; */
        }
        /*   } else {
            $jsonData['status'] = 'Please fill all mandatory fields';
            echo CJSON::encode($jsonData);
        } */
    }
    public static function addroundoff($Voucherid)
    {
        $sql = "SELECT roundoff FROM( SELECT SUM(VI.amount) AS roundoff
         FROM erp_acc_voucher V 
         LEFT JOIN erp_acc_voucher_items VI ON acc_voucher_id =V.id 
         where V.id=" . $Voucherid . "
         GROUP BY V.id)A WHERE roundoff!=0";
        $roundoff = Yii::app()->db->createCommand($sql)->queryScalar();
        if ($roundoff != 0) {
            $model = new AccVoucherItems();
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $ledger_round_off = $modelAccSystemAccountsMapping->getSystemdefault('round_off');
            $modelVI = $model->find(array('condition' => 'acc_voucher_id=' . $Voucherid . ' AND ledger_id=' . $ledger_round_off . ''));
            if (!empty($modelVI)) {
                $credit = 0;
                $debit = 0;
                $credit = ($roundoff > 0) ? (abs($roundoff)) : '0.00';
                $debit = ($roundoff < 0) ? (abs($roundoff)) : '0.00';
                $modelVI->credit = $modelVI->credit + $credit;
                $modelVI->debit = $modelVI->debit + $debit;
                if ($debit > 0) {
                    $modelVI->amount = $modelVI->amount + $debit + $credit;
                } else {
                    $modelVI->amount = -1 * abs($modelVI->amount + $debit + $credit);
                }
                $modelVI->save(false);
            } else {
                $modelexist = $model->find(array('condition' => 'acc_voucher_id=' . $Voucherid . ' '));
                $modelVI = new AccVoucherItems();
                $modelVI->acc_voucher_id = $Voucherid;
                $modelVI->ledger_id = $ledger_round_off;
                $credit = 0;
                $debit = 0;
                $credit = ($roundoff > 0) ? (abs($roundoff)) : '0.00';
                $debit = ($roundoff < 0) ? (abs($roundoff)) : '0.00';
                $modelVI->credit = $credit;
                $modelVI->debit = $debit;
                if ($debit > 0) {
                    $modelVI->amount = $debit + $credit;
                } else {
                    $modelVI->amount = -1 * abs($debit + $credit);
                }
                $modelVI->employee_id = $modelexist->employee_id;
                $modelVI->salegroup_id = $modelexist->salegroup_id;
                $modelVI->payment_term_id = $modelexist->payment_term_id;
                $modelVI->narration = $modelexist->narration;
                $modelVI->project_id = $modelexist->project_id;
                $modelVI->company_id = $modelexist->company_id;
                $modelVI->exchange_rate = $modelexist->exchange_rate;
                $modelVI->branch_id = $modelexist->branch_id;
                $modelVI->costcenter_id = $modelexist->costcenter_id;
                $modelVI->department_id = $modelexist->department_id;
                $modelVI->user_id = (int) $modelexist->user_id;
                $modelVI->warehouse_id = $modelexist->warehouse_id;
                $modelVI->save(false);
            }
        }
    }
    //end
    public static function actionRoundoff($Voucherid = 27816)
    {
        $sql = "SELECT roundoff FROM( SELECT SUM(VI.amount) AS roundoff
         FROM erp_acc_voucher V 
         LEFT JOIN erp_acc_voucher_items VI ON acc_voucher_id =V.id 
         where V.id=" . $Voucherid . "
         GROUP BY V.id)A WHERE roundoff!=0";
        $roundoff = Yii::app()->db->createCommand($sql)->queryScalar();
        if ($roundoff != 0) {
            $model = new AccVoucherItems();
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $ledger_round_off = $modelAccSystemAccountsMapping->getSystemdefault('round_off');
            $modelVI = $model->find(array('condition' => 'acc_voucher_id=' . $Voucherid . ' AND ledger_id=' . $ledger_round_off . ''));
            if (!empty($modelVI)) {
                $credit = 0;
                $debit = 0;
                $credit = ($roundoff > 0) ? (abs($roundoff)) : '0.00';
                $debit = ($roundoff < 0) ? (abs($roundoff)) : '0.00';
                $modelVI->credit = $modelVI->credit + $credit;
                $modelVI->debit = $modelVI->debit + $debit;
                if ($debit > 0) {
                    $modelVI->amount = $modelVI->amount + $debit + $credit;
                } else {
                    $modelVI->amount = -1 * abs($modelVI->amount + $debit + $credit);
                }
                $modelVI->save(false);
            } else {
                $modelexist = $model->find(array('condition' => 'acc_voucher_id=' . $Voucherid . ' '));
                $modelVI = new AccVoucherItems();
                $modelVI->acc_voucher_id = $Voucherid;
                $modelVI->ledger_id = $ledger_round_off;
                $credit = 0;
                $debit = 0;
                $credit = ($roundoff > 0) ? (abs($roundoff)) : '0.00';
                $debit = ($roundoff < 0) ? (abs($roundoff)) : '0.00';
                $modelVI->credit = $credit;
                $modelVI->debit = $debit;
                if ($debit > 0) {
                    $modelVI->amount = $debit + $credit;
                } else {
                    $modelVI->amount = -1 * abs($debit + $credit);
                }
                $modelVI->employee_id = $modelexist->employee_id;
                $modelVI->salegroup_id = $modelexist->salegroup_id;
                $modelVI->payment_term_id = $modelexist->payment_term_id;
                $modelVI->narration = $modelexist->narration;
                $modelVI->project_id = $modelexist->project_id;
                $modelVI->company_id = $modelexist->company_id;
                $modelVI->exchange_rate = $modelexist->exchange_rate;
                $modelVI->branch_id = $modelexist->branch_id;
                $modelVI->costcenter_id = $modelexist->costcenter_id;
                $modelVI->department_id = $modelexist->department_id;
                $modelVI->user_id = (int) $modelexist->user_id;
                $modelVI->warehouse_id = $modelexist->warehouse_id;
                $modelVI->save(false);
            }
            echo "Success";
        }
    }
    //end
    public static function allocateInvoiceVoucherwithreceipt($invoice_id)
    {

        $modelheader         = new Invoice();
        $modelheader         = $modelheader->findByPK((int)$invoice_id);

        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        //ledger_id
        $debtor_ledger                   = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
        $modAccSubledgerType = new AccSubledgerType();
        $subledger_type_id   = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger     = new AccSubledger();
        //subledger_id
        $customer_subledger      = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);

        //reciept
        $model_voucher_type     = new AccVoucherType();
        $modelAccVoucher        = new AccVoucher;
        $modAccVoucherItems     = new AccVoucherItems();
        $receiptvoucher_type_id = $model_voucher_type->find(array('condition' => 'code="RV"'))->id;
        $reccondition           = 't.imported="Y" AND t.voucher_type=' . $receiptvoucher_type_id . ' AND t.transaction_id=' . $invoice_id;
        $ReceiptVoucher_det     = $modelAccVoucher->find(array('condition' => $reccondition));
        $vi_receipt_debtor     = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int)$ReceiptVoucher_det->id . ' AND ledger_id=' . (int)$debtor_ledger . ' AND subledger_id=' . (int)$customer_subledger));
        //salesinvoice
        $invoicevoucher_type_id = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
        $invcondition           = 't.imported="Y" AND t.voucher_type=' . $invoicevoucher_type_id . ' AND t.transaction_id=' . $invoice_id;
        $InvoiceVoucher_det      = $modelAccVoucher->find(array('condition' => $invcondition));
        $vi_invoice_debtor     = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int)$InvoiceVoucher_det->id . ' AND ledger_id=' . (int)$debtor_ledger . ' AND subledger_id=' . (int)$customer_subledger));
        if (round(abs($vi_receipt_debtor->amount), 2) == round(abs($vi_invoice_debtor['amount']), 2)) {
            $model = new AccAllocation;
            $model->allocation_date = date('Y-m-d');
            $model->ledger_id = $debtor_ledger;
            $model->subledger_id = $customer_subledger;
            $model->amount = round(abs($vi_receipt_debtor->amount), 2);
            $model->created_by   = (int)$modelheader->lead_owner_id;
            $model->reference_id = (int)$modelheader->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->save(false);
            $model->refresh();
            $debitArray = new AccAllocationItems;
            $debitArray->voucher_id = $ReceiptVoucher_det->id;
            $debitArray->voucher_item_id = $vi_receipt_debtor->id;
            $debitArray->amount = round(abs($vi_receipt_debtor->amount), 2);
            $debitArray->allocation_id = $model->id;
            $debitArray->allocation_date = $model->allocation_date;
            $debitArray->ledger_id = $debtor_ledger;
            $debitArray->subledger_id = $customer_subledger;
            $debitArray->reference_id = (int)$modelheader->id;
            $debitArray->voucher_type = $ReceiptVoucher_det->voucher_type;
            $debitArray->save(false);
            $vi_receipt_debtor->allocated_amount = $vi_receipt_debtor->allocated_amount + (float)round((-1 * $vi_receipt_debtor->amount), 2);
            $vi_receipt_debtor->save(false);
            AccVoucher::model()->updateBypk($ReceiptVoucher_det->id, array('is_allocated' => 'Y'));
            $creditArray = new AccAllocationItems;
            $creditArray->voucher_id = $InvoiceVoucher_det->id;
            $creditArray->voucher_item_id = $vi_invoice_debtor->id;
            $creditArray->amount = -1 * round(abs($vi_invoice_debtor->amount), 2);
            $creditArray->allocation_id = $model->id;
            $creditArray->allocation_date = $model->allocation_date;
            $creditArray->ledger_id = $debtor_ledger;
            $creditArray->subledger_id = $customer_subledger;
            $creditArray->reference_id = (int)$modelheader->id;
            $creditArray->voucher_type = $InvoiceVoucher_det->voucher_type;
            $creditArray->save(false);
            $vi_invoice_debtor->allocated_amount = $vi_invoice_debtor->allocated_amount + (float)round((-1 * $vi_invoice_debtor->amount), 2);
            $vi_invoice_debtor->save(false);
            AccVoucher::model()->updateBypk($InvoiceVoucher_det->id, array('is_allocated' => 'Y'));
        }
    }


    public static function addsalesreceiptallocation($receipt_id, $arr_vouchers)
    {
        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        $model_voucher_type = new AccVoucherType();
        $modelAccVoucher = new AccVoucher;
        $modAccVoucherItems = new AccVoucherItems();
        //ledger_id
        $debtor_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
        $ReceiptVoucher_det = $modelAccVoucher->findByPK((int) $receipt_id);
        $customer_id = $ReceiptVoucher_det->customer_vendor_id;
        $modAccSubledgerType = new AccSubledgerType();
        $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger = new AccSubledger();
        //subledger_id
        $customer_subledger = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);
        $arr_vi_receipt_debtor = $modAccVoucherItems->findAll(array('condition' => 'acc_voucher_id=' . (int) $ReceiptVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        $invoicevoucher_type_id = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
        foreach ($arr_vi_receipt_debtor as $vi_receipt_debtor) {
            $rv_amount_sum += (float) $vi_receipt_debtor->amount;
        }
        foreach ($arr_vouchers as $InvoiceVoucher_det) {
            $vi_invoice_debtor = $modAccVoucherItems->findByPK((int) $InvoiceVoucher_det['voucher_item_id']);
            $vi_amount_sum += (float) $InvoiceVoucher_det['amount'];
        }
        $vi_amount_round = number_format((float) $vi_amount_sum, 2, '.', '');
        $rv_amount_round = number_format((float) $rv_amount_sum, 2, '.', '');
        if (abs($vi_amount_round) == abs($rv_amount_round)) {
            $model = new AccAllocation;
            $model->allocation_date = date('Y-m-d');
            $model->ledger_id = $debtor_ledger;
            $model->subledger_id = $customer_subledger;
            $model->amount = round(abs($rv_amount_sum), 2);
            $model->created_by = (int) $ReceiptVoucher_det->lead_owner;
            $model->reference_id = (int) $ReceiptVoucher_det->transaction_number;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->save(false);
            $model->refresh();
            foreach ($arr_vi_receipt_debtor as $vi_receipt_debtor) {
                $debitArray = new AccAllocationItems;
                $debitArray->voucher_id = $ReceiptVoucher_det->id;
                $debitArray->voucher_item_id = $vi_receipt_debtor->id;
                $debitArray->amount = round(abs($vi_receipt_debtor->amount), 2);
                $debitArray->allocation_id = $model->id;
                $debitArray->allocation_date = $model->allocation_date;
                $debitArray->ledger_id = $debtor_ledger;
                $debitArray->subledger_id = $customer_subledger;
                $debitArray->reference_id = (int) $modelheader->id;
                $debitArray->voucher_type = $ReceiptVoucher_det->voucher_type;
                $debitArray->total_amount = $model->amount;
                $debitArray->save(false);
                $vi_receipt_debtor->allocated_amount = $vi_receipt_debtor->allocated_amount + (float) round((-1 * $vi_receipt_debtor->amount), 2);
                $vi_receipt_debtor->save(false);
            }
            AccVoucher::model()->updateBypk($ReceiptVoucher_det->id, array('is_allocated' => 'Y'));
            foreach ($arr_vouchers as $InvoiceVoucher_det) {
                $vi_invoice_debtor = $modAccVoucherItems->findByPK((int) $InvoiceVoucher_det['voucher_item_id']);
                $creditArray = new AccAllocationItems;
                $creditArray->voucher_id = $InvoiceVoucher_det['voucher_id'];
                $creditArray->voucher_item_id = $vi_invoice_debtor->id;
                $creditArray->amount = -1 * round(abs($InvoiceVoucher_det['amount']), 2);
                $creditArray->allocation_id = $model->id;
                $creditArray->allocation_date = $model->allocation_date;
                $creditArray->ledger_id = $debtor_ledger;
                $creditArray->subledger_id = $customer_subledger;
                $creditArray->reference_id = (int) $InvoiceVoucher_det['transaction_id'];
                $creditArray->voucher_type = $invoicevoucher_type_id;
                $creditArray->total_amount = $model->amount;
                $creditArray->save(false);
                $vi_invoice_debtor->allocated_amount = $vi_invoice_debtor->allocated_amount + (float) round((-1 * $InvoiceVoucher_det['amount']), 2);
                $vi_invoice_debtor->save(false);
                AccVoucher::model()->updateBypk((int) $InvoiceVoucher_det['voucher_id'], array('is_allocated' => 'Y'));
            }
            return 1;
        } else {
            $msg = $vi_amount_round . ' not  equal to ' . $rv_amount_round;
            return $msg;
        }
    }
    public static function allocateSalesreturnVoucherwithPayment($return_id)
    {

        $modelheader         = new Creditnote();
        $modelheader         = $modelheader->findByPK((int)$return_id);

        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        //ledger_id
        $debtor_ledger                   = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
        $modAccSubledgerType = new AccSubledgerType();
        $subledger_type_id   = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger     = new AccSubledger();
        //subledger_id
        $customer_subledger      = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);

        //reciept
        $model_voucher_type     = new AccVoucherType();
        $modelAccVoucher        = new AccVoucher;
        $modAccVoucherItems     = new AccVoucherItems();
        $paymentvoucher_type_id = $model_voucher_type->find(array('condition' => 'code="PV"'))->id;
        $paycondition           = 't.imported="Y" AND t.voucher_type=' . $paymentvoucher_type_id . ' AND t.transaction_id=' . $return_id;
        $PaymentVoucher_det     = $modelAccVoucher->find(array('condition' => $paycondition));
        $vi_receipt_debtor     = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int)$PaymentVoucher_det->id . ' AND ledger_id=' . (int)$debtor_ledger . ' AND subledger_id=' . (int)$customer_subledger));
        //salesinvoice
        $invoicevoucher_type_id = $model_voucher_type->find(array('condition' => 'code="CN"'))->id;
        $invcondition           = 't.imported="Y" AND t.voucher_type=' . $invoicevoucher_type_id . ' AND t.transaction_id=' . $return_id;
        $InvoiceVoucher_det      = $modelAccVoucher->find(array('condition' => $invcondition));
        $vi_invoice_debtor     = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int)$InvoiceVoucher_det->id . ' AND ledger_id=' . (int)$debtor_ledger . ' AND subledger_id=' . (int)$customer_subledger));
        if (round(abs($vi_receipt_debtor->amount), 2) == round(abs($vi_invoice_debtor['amount']), 2)) {
            $model = new AccAllocation;
            $model->allocation_date = date('Y-m-d');
            $model->ledger_id       = $debtor_ledger;
            $model->subledger_id    = $customer_subledger;
            $model->amount          = round(abs($vi_receipt_debtor->amount), 2);

            // $model->created_by      = (int)$modelheader->lead_owner_id;
            $model->created_by      = (int)$modelheader->crm_user_id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->save(false);
            $model->refresh();
            $debitArray = new AccAllocationItems;
            $debitArray->voucher_id = $PaymentVoucher_det->id;
            $debitArray->voucher_item_id = $vi_receipt_debtor->id;
            $debitArray->amount = round($vi_receipt_debtor->amount, 2);
            $debitArray->allocation_id = $model->id;
            $debitArray->allocation_date = $model->allocation_date;
            $debitArray->ledger_id = $debtor_ledger;
            $debitArray->subledger_id = $customer_subledger;
            $debitArray->save(false);
            $vi_receipt_debtor->allocated_amount = $vi_receipt_debtor->allocated_amount + -1 * (float)round(abs($vi_receipt_debtor->amount), 2);
            $vi_receipt_debtor->save(false);
            AccVoucher::model()->updateBypk($PaymentVoucher_det->id, array('is_allocated' => 'Y'));
            $creditArray = new AccAllocationItems;
            $creditArray->voucher_id = $InvoiceVoucher_det->id;
            $creditArray->voucher_item_id = $vi_invoice_debtor->id;
            $creditArray->amount = round($vi_invoice_debtor->amount, 2);
            $creditArray->allocation_id = $model->id;
            $creditArray->allocation_date = $model->allocation_date;
            $creditArray->ledger_id = $debtor_ledger;
            $creditArray->subledger_id = $customer_subledger;
            $creditArray->save(false);
            $vi_invoice_debtor->allocated_amount = $vi_invoice_debtor->allocated_amount + (float)round(abs($vi_invoice_debtor->amount), 2);
            $vi_invoice_debtor->save(false);
            AccVoucher::model()->updateBypk($InvoiceVoucher_det->id, array('is_allocated' => 'Y'));
        }
    }

    public function addPostUnpostNormalVoucher($array_ids, $change_posted_status_to)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $modelheader = new AccVoucher;
            $modelheader = $modelheader->findByPK((int) $id);
            $modelAccVoucher = new AccVoucher;
            $sql = "SELECT * FROM {{acc_voucher}} WHERE  {{acc_voucher}}.id = '" . $id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    $modelheader->is_posted = $change_posted_status_to;
                    if ($change_posted_status_to == "Y") {
                        $modelheader->posted_date = date('Y-m-d h:i:s');
                    } else {
                        $modelheader->posted_date = "0000-00-00 00:00:00";
                    }
                    $modelheader->save(false);
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }
        if ($flag == 1) {
            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $id);
            if ($change_posted_status_to == 'Y') {
                $audittype = 'POSTED';
            } else {
                $audittype = 'UNPOSTED';
            }
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                $audittype,
                changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
            );
            // end audit log            
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //cheques
    //------------------------------------------------------------------------------------------------------------
    public function actionSavecheques()
    {
        $items            = array();
        $i                = 0;
        $ledger_id        = (int) $_POST['ledger_id'];
        $subledger_id     = (int) $_POST['subledger_id'];
        $type             = (int) $_POST['type']; // 1 - Receivable 2 - Payable
        $clearing_account = ($type == 1) ? AccSystemAccountsMapping::getSystemdefault('pdc_r') : AccSystemAccountsMapping::getSystemdefault('pdc_i');
        $clearing_value   = ($type == 1) ? -1 : 1;
        $response         = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));

            $totalValue = 0;
            $arr_cheques = array();
            foreach ($items as $each) {
                $ledger_id      = (int)AccLedger::getBankId();


                $subledger_id   = (int)$_POST['ClearedCheque'][$each]['subledger_id'];


                $cleared_date   = $_POST['ClearedCheque'][$each]['cheque_date'];
                $cleared_date   = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
                if ($ledger_id > 0 && $subledger_id > 0) {

                    $model                               = AccVoucherItems::model()->findBypk($each);

                    $acc_voucher_id = (int)$model->acc_voucher_id;

                    // --------------------------------------
                    $model->opening_cheque_cleared       = 'Y';
                    $model->update();
                    // --------------------------------------

                    $voucherHead = array();

                    $voucherHead['file_id']            = 0;

                    $voucher_type = AccVoucherType::model()->find(array('condition' => 'code="JV"'))->id;

                    $voucherHead['voucher_type']         = $voucher_type; //Journal Voucher
                    //Voucher Type id
                    $modelAccVoucherType                 = new AccVoucherType;

                    $voucherHead['voucher_no']           = $modelAccVoucherType->getVoucherno($voucherHead['voucher_type'], true);

                    $voucherHead['voucher_date']         = $cleared_date; //Y-m-d;

                    $voucherHead['transaction_date']     = '0000-00-00';


                    $voucherHead['transaction_number']   = 0;

                    $voucherHead['transaction_id']       = 0;

                    $voucherHead['reference_no']         =  'Cheques Cleared';

                    $voucherHead['narration']            = '';


                    $voucherHead['voucher_value']        = 0;

                    $voucherHead['currency_id']          = 1;

                    $voucherHead['exchange_rate']        = 1;


                    $voucherHead['vat']                  = 0;

                    $voucherHead['amount']               = 0;

                    $voucherHead['net_amount']           = 0;

                    $voucherHead['total_discount']       = 0;

                    $voucherHead['rounding']             = 0;

                    $voucherHead['tax_type']             = 0;

                    $voucherHead['tax_id']               = 0;

                    $voucherHead['order_id']             = 0;

                    $voucherHead['delivery_id']          = 0;

                    $voucherHead['direct']               = 0;

                    $voucherHead['imported']             = 'N';

                    $voucherHead['is_posted']            = 'Y';

                    $voucherHead['cheque_no']            = $model->parent->cheque_no;

                    $voucherHead['customer_vendor_id']  = 0;

                    $voucherHead['payment_method']      = 0;

                    $voucherHead['payment_days']        = 0;

                    $voucherHead['payment_terms']       = 0;

                    $voucherHead['lead_owner']          = 0;
                    // 

                    $voucherHead['salegroup_id']        = 0;

                    $voucherHead['year']                = 0;

                    $voucherHead['company_id']          = 0;

                    $voucherHead['branch_id']           = 0;

                    $voucherHead['project_id']          = 0;

                    $voucherHead['department_id']       = 0;

                    $voucherHead['employee_id']         = 0;

                    //-------saving invoice header details---------

                    $lastSavedid                         = $this->addVoucherhead($voucherHead);
                    // --------------------------------------
                    $itemsArray                          = array();
                    $itemsArray['ledger_id']             = $model->ledger_id;
                    $itemsArray['subledger_id']          = $model->subledger_id;
                    $itemsArray['narration']             = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' |  Dated ' . date('d/m/Y', strtotime($model->parent->cheque_date));
                    $itemsArray['amount']                = $clearing_value * abs($model->amount);
                    if ($clearing_value > 0) {
                        $itemsArray['debit']                 = abs($model->amount);
                        $itemsArray['credit']                = 0;
                    } else {
                        $itemsArray['debit']                 = 0;
                        $itemsArray['credit']                = abs($model->amount);
                    }
                    $itemsArray['opening_cheque_cleared']    = 'Y';
                    $itemsArray['reconciled']            = 'N';
                    $totalValue                          += $itemsArray['amount'];


                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    // --------------------------------------

                    $arr_cheques[]                        = $model->parent->cheque_no;

                    // BANK
                    $itemsArray = array();
                    $itemsArray['ledger_id']              = $ledger_id;
                    $itemsArray['subledger_id']           = $subledger_id;
                    $itemsArray['subledger_id']           = $subledger_id;
                    $itemsArray['narration']              = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' |  Dated ' . date('d/m/Y', strtotime($model->parent->cheque_date));
                    $itemsArray['amount']                 = -1 * $clearing_value * abs($model->amount);

                    $bank_amt = -1 * $clearing_value * abs($model->amount);
                    if ($bank_amt > 0) {
                        $itemsArray['debit']                 = abs($model->amount);
                        $itemsArray['credit']                = 0;
                    } else {
                        $itemsArray['debit']                 = 0;
                        $itemsArray['credit']                = abs($model->amount);
                    }
                    $itemsArray['reconciled']                = 'N';
                    $itemsArray['opening_cheque_cleared']    = 'Y';

                    $this->addVoucheritems($lastSavedid, $itemsArray);

                    // --------------------------------------
                    AccVoucher::model()->updateBypk($each->acc_voucher_id, array('cheque_cleared' => 'Y'));

                    AccVoucher::model()->updatebypk($lastSavedid, array('amount' => abs($model->amount), 'net_amount' => abs($model->amount)));
                    // --------------------------------------
                }
            }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }
            echo json_encode($response);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //Savechequesreturn
    //------------------------------------------------------------------------------------------------------------
    public function actionSavechequesreturn()
    {
        $items = array();
        $i            = 0;
        $ledger_id    = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        $type         = (int) $_POST['type'];
        // 1 - Receivable 2 - Payable
        // $cleared_date = $_POST['cleared_date'];
        // $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));
            $arr_cheques = array();
            $parent_ids = array();
            $totalValue = 0;

            foreach ($items as $each) {

                $cleared_date = $_POST['ClearedCheque'][$each]['cheque_date'];
                $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');

                $voucher_date = $_POST['ClearedCheque'][$each]['voucher_date'];
                $voucher_date = (count(explode('/', $voucher_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $voucher_date))) : date('Y-m-d');


                $model = AccVoucherItems::model()->findBypk($each);
                $model->cheque_bounced = 'Y';
                $model->no_bounced = $model->no_bounced + 1;
                $model->update();

                // ------------------------------------------------
                $voucherHead = array();

                $voucherHead['file_id']            = 0;

                $voucher_type = AccVoucherType::model()->find(array('condition' => 'code="JV"'))->id;

                $voucherHead['voucher_type']         = $voucher_type; //Journal Voucher
                //Voucher Type id
                $modelAccVoucherType                 = new AccVoucherType;

                $voucherHead['voucher_no']           = $modelAccVoucherType->getVoucherno($voucherHead['voucher_type'], true);

                $voucherHead['voucher_date']         = $cleared_date; //Y-m-d;

                $voucherHead['cheque_date']         = $voucher_date; //Y-m-d;

                $voucherHead['transaction_date']     = '0000-00-00';


                $voucherHead['transaction_number']   = 0;

                $voucherHead['transaction_id']       = 0;

                $voucherHead['reference_no']         =  'Cheques Returned';

                $voucherHead['narration']            = '';


                $voucherHead['voucher_value']        = 0;

                $voucherHead['currency_id']          = 1;

                $voucherHead['exchange_rate']        = 1;


                $voucherHead['vat']                  = 0;

                $voucherHead['amount']               = 0;

                $voucherHead['net_amount']           = 0;

                $voucherHead['total_discount']       = 0;

                $voucherHead['rounding']             = 0;

                $voucherHead['tax_type']             = 0;

                $voucherHead['tax_id']               = 0;

                $voucherHead['order_id']             = 0;

                $voucherHead['delivery_id']          = 0;

                $voucherHead['direct']               = 0;


                $voucherHead['is_posted']            = 'Y';

                $voucherHead['imported']             = 'N';

                $voucherHead['cheque_no']            = $model->parent->cheque_no;

                $voucherHead['customer_vendor_id']  = 0;

                $voucherHead['payment_method']      = 0;

                $voucherHead['payment_days']        = 0;

                $voucherHead['payment_terms']       = 0;

                $voucherHead['lead_owner']          = 0;
                // 

                $voucherHead['salegroup_id']        = 0;

                $voucherHead['year']                = 0;

                $voucherHead['company_id']          = 0;

                $voucherHead['branch_id']           = 0;

                $voucherHead['project_id']          = 0;

                $voucherHead['department_id']       = 0;

                $voucherHead['employee_id']         = 0;

                $voucherHead['cheque_bounced']         = 'Y';  //added on 21-01-2025

                //-------saving invoice header details---------
                $lastSavedid = $this->addVoucherhead($voucherHead);


                // if ($model->parent->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
                $modelHead = AccVoucher::model()->findBypk($model->acc_voucher_id);
                $modelHead->cheque_bounced = 'Y';
                $modelHead->update();
                // ------------------------------------------------

                foreach ($modelHead->items as $each) {
                    $itemsArray = array();
                    $itemsArray['ledger_id']    = $each->ledger_id;
                    $itemsArray['subledger_id'] = $each->subledger_id;
                    $itemsArray['narration']    = 'Voucher No ' . $each->parent->fullvoucher . ' | Cheque No ' . $each->parent->cheque_no . ' Returned';
                    $itemsArray['amount']       = -1 * $each->amount;
                    if ($itemsArray['amount'] > 0) {
                        $itemsArray['debit']       = abs($itemsArray['amount']);
                    } else {
                        $itemsArray['credit']       = abs($itemsArray['amount']);
                    }
                    $itemsArray['opening_cheque_cleared'] = 'Y';
                    $itemsArray['cheque_bounced']       = 'Y'; //added on 21-01-2025
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    if ($each->amount > 0) {
                        $totalValue = $each->amount;
                    }
                }
                AccVoucher::model()->updatebypk($lastSavedid, array('amount' => abs($totalValue), 'net_amount' => abs($totalValue)));
            }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }
            echo json_encode($response);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    // Save cheques status change
    //------------------------------------------------------------------------------------------------------------
    public function actionSavechequesstatuschange()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int) $_POST['bank_ledger_id'];
        $subledger_id = (int) $_POST['bank_subledger_id'];
        $type = (int) $_POST['type']; // 1 - Receivable 2 - Payable
        $clearing_value = ($type == 1) ? 1 : -1;
        $response = array();
        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }
        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));
            $totalValue = 0;
            $arr_cheques = array();
            foreach ($items as $each) {
                $cleared_date = $_POST['ClearedCheque'][$each]['cleared_date'];
                $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
                $ledger_id = (int) AccLedger::getBankId();
                $subledger_id = (int) $_POST['ClearedCheque'][$each]['subledger_id'];
                // ---------------------------
                $model = AccVoucherItems::model()->findBypk($each);
                $model->opening_cheque_cleared = 'Y';
                $model->cheque_bounced = 'N';
                $model->no_bounced = $model->no_bounced + 1;
                $model->update();
                // ---------------------------
                $voucher_type = AccVoucherType::model()->find(array('condition' => 'code="JV"'))->id;
                $voucherHead = array();
                $voucherHead['voucher_type'] = $voucher_type; //Journal Voucher
                $voucherHead['voucher_no'] = AccVoucherType::getVoucherno($voucherHead['voucher_type'], true);
                $voucherHead['voucher_date'] = $cleared_date; //Y-m-d
                $voucherHead['cheque_date'] = $model->parent->cheque_date; //Y-m-d
                $voucherHead['header_table_id'] = 0;
                $voucher_ref_id_det = AccVoucher::model()->findBypk($model->parent->voucher_ref_id);
                $voucherHead['reference_no'] = 'Cheques Bounced -' . $voucher_ref_id_det->vtype->code . "/" . $voucher_ref_id_det->voucher_no;
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['imported'] = 'N';
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                $voucherHead['cheque_no'] = $model->parent->cheque_no;
                $voucherHead['transaction_number'] = $voucherHead['voucher_no'];
                $voucherHead['transaction_id'] = $model->parent->id;
                $voucherHead['currency_id'] = $model->parent->currency_id;
                $voucherHead['customer_vendor_id'] = $model->parent->customer_vendor_id;
                $voucherHead['payment_method'] = $model->parent->payment_method;
                $voucherHead['payment_days'] = $model->parent->payment_days;
                $voucherHead['payment_terms'] = $model->parent->payment_terms;
                $voucherHead['lead_owner'] = $model->parent->lead_owner;
                $voucherHead['voucher_ref_id'] = $model->parent->id;
                $lastSavedid = $this->addVoucherhead($voucherHead);
                // -----------------------------------
                $voucherModel = new AccVoucher();
                $voucherModel = $voucherModel->findByPK((int) $lastSavedid);
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    'CREATED',
                    "{$voucherModel->vtype->description} with voucher no. {$voucherModel->voucher_no} and cheque returned(Bounce) from cheque management"
                );
                // end audit log


                // ---------------------------
                $totalValue = $clearing_value * abs($model->amount);
                // ---------------------------
                if ($type == 1) {
                    /*   $itemsArray = array();
                      $itemsArray['ledger_id']    = $model->ledger_id;
                      $itemsArray['subledger_id'] = $model->subledger_id;
                      $itemsArray['narration']    = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                      $itemsArray['amount']       = -1 * $clearing_value * $model->amount;
                      if( $itemsArray['amount'] >0){
                      $itemsArray['debit']       = abs($itemsArray['amount']);
                      }else{
                      $itemsArray['credit']       =  abs($itemsArray['amount']);
                      }
                      $itemsArray['reconciled']   = 'N';
                      $this->addVoucheritems($lastSavedid, $itemsArray); */
                } else if ($type == 2) {
                    /*  $itemsArray                 = array();
                      $itemsArray['ledger_id']    = $model->ledger_id;
                      $itemsArray['subledger_id'] = $model->subledger_id;
                      $itemsArray['narration']    = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                      $itemsArray['amount']       = 1 * $clearing_value * $model->amount;
                      if( $itemsArray['amount'] >0){
                      $itemsArray['debit']       =  abs($itemsArray['amount']);
                      }else{
                      $itemsArray['credit']       =   abs($itemsArray['amount']);
                      }
                      $itemsArray['reconciled']   = 'N';
                      $this->addVoucheritems($lastSavedid, $itemsArray); */
                }
                $modelHead = AccVoucher::model()->findBypk($model->acc_voucher_id);
                if ($type == 1) {
                    if ($modelHead->voucher_type != AccVoucherType::get_voucher_id('OB')) {
                        foreach ($modelHead->voucher_items as $eachHead) {
                            $pdc_r_ledger = AccSystemAccountsMapping::getSystemdefault('pdc_r');
                            if ($eachHead->ledger_id == $pdc_r_ledger) {
                                $itemsArray = array();
                                $itemsArray['ledger_id'] = $eachHead->ledger_id;
                                $itemsArray['subledger_id'] = $eachHead->subledger_id;
                                $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                                $itemsArray['amount'] = -1 * $clearing_value * $model->amount;
                                if ($itemsArray['amount'] > 0) {
                                    $itemsArray['debit'] = abs($itemsArray['amount']);
                                } else {
                                    $itemsArray['credit'] = abs($itemsArray['amount']);
                                }
                                $itemsArray['opening_cheque_cleared'] = 'Y';
                                $itemsArray['cheque_bounced'] = 'Y';
                                $itemsArray['reconciled'] = 'N';
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                            }
                        }
                    }
                } else if ($type == 2) {
                    if ($modelHead->voucher_type != AccVoucherType::get_voucher_id('OB')) {
                        foreach ($modelHead->voucher_items as $eachHead) {
                            $pdc_i_ledger = AccSystemAccountsMapping::getSystemdefault('pdc_i');
                            if ($eachHead->ledger_id == $pdc_i_ledger) {
                                $itemsArray = array();
                                $itemsArray['ledger_id'] = $eachHead->ledger_id;
                                $itemsArray['subledger_id'] = $eachHead->subledger_id;
                                $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                                $itemsArray['amount'] = 1 * $clearing_value * $model->amount;
                                if ($itemsArray['amount'] > 0) {
                                    $itemsArray['debit'] = abs($itemsArray['amount']);
                                } else {
                                    $itemsArray['credit'] = abs($itemsArray['amount']);
                                }
                                $itemsArray['reconciled'] = 'N';
                                $itemsArray['opening_cheque_cleared'] = 'Y';
                                $itemsArray['cheque_bounced'] = 'Y';
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                            }
                        }
                    }
                }
                $arr_cheques[] = $model->parent->cheque_no;
                AccVoucher::model()->updateBypk($each, array('cheque_cleared' => 'N', 'cheque_bounced' => 'Y'));
                //BANK
                if ($type == 1) {
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = $ledger_id;
                    $itemsArray['subledger_id'] = $subledger_id;
                    $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                    $itemsArray['amount'] = $clearing_value * $model->amount;
                    if ($itemsArray['amount'] > 0) {
                        $itemsArray['debit'] = abs($itemsArray['amount']);
                    } else {
                        $itemsArray['credit'] = abs($itemsArray['amount']);
                    }
                    $itemsArray['reconciled'] = 'N';
                    $itemsArray['opening_cheque_cleared'] = 'Y';
                    $itemsArray['cheque_bounced'] = 'Y';
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                } else if ($type == 2) {
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = $ledger_id;
                    $itemsArray['subledger_id'] = $subledger_id;
                    $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                    $itemsArray['amount'] = -1 * $clearing_value * $model->amount;
                    if ($itemsArray['amount'] > 0) {
                        $itemsArray['debit'] = abs($itemsArray['amount']);
                    } else {
                        $itemsArray['credit'] = abs($itemsArray['amount']);
                    }
                    $itemsArray['reconciled'] = 'N';
                    $itemsArray['opening_cheque_cleared'] = 'Y';
                    $itemsArray['cheque_bounced'] = 'Y';
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                AccVoucher::model()->updatebypk($lastSavedid, array(
                    'amount' => abs($totalValue),
                    'net_amount' => abs($totalValue),
                    'voucher_value' => abs($totalValue)
                )); //$netTotal
            }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }
            if ($ledger_id == 0) {
                $response[] = 'Ledger cannot blank';
            }
            if ($ledger_id > 0 && AccLedger::is_subledger_account($ledger_id) && $subledger_id == 0) {
                $response[] = 'Subledger cannot blank';
            }
            echo json_encode($response);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //Save cheques status changere submit
    //------------------------------------------------------------------------------------------------------------
    public function actionSavechequesstatuschangeresubmit()
    {
        $items = array();
        $i = 0;
        $response = array();
        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }
        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));
            foreach ($items as $each) {
                $totalValue = 0;
                $cleared_date = $_POST['ClearedCheque'][$each]['resubmit_date'];
                $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
                $model = AccVoucherItems::model()->findBypk($each);
                $model->opening_cheque_cleared = 'Y';  // just changed on 21-03-2024
                $model->cheque_bounced = 'N';
                $model->update();
                // ----------------------------
                $voucher_type_id = AccVoucherType::model()->find(array('condition' => 'code="JV"'))->id;
                $voucherHead = array();
                $voucherHead['voucher_type'] = $voucher_type_id; //Journal Voucher
                $voucherHead['voucher_no'] = AccVoucherType::getVoucherno($voucherHead['voucher_type'], true);
                $voucherHead['voucher_date'] = $cleared_date; //Y-m-d
                $voucherHead['header_table_id'] = 0;
                //  $voucherHead['reference_no']     = 'Cheques Resubmitted';
                $voucher_main = AccVoucher::model()->findBypk($model->parent->voucher_ref_id)->voucher_ref_id;
                $voucher_ref_id_det = AccVoucher::model()->findBypk($voucher_main);
                $voucherHead['reference_no'] = 'Cheques Resubmitted -' . $voucher_ref_id_det->vtype->code . "/" . $voucher_ref_id_det->voucher_no;
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['imported'] = 'N';
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                $voucherHead['cheque_no'] = $model->parent->cheque_no;
                $voucherHead['cheque_date'] = $model->parent->cheque_date;
                $voucherHead['voucher_ref_id'] = $model->parent->id;
                $voucherHead['transaction_number'] = $voucherHead['voucher_no'];
                $voucherHead['transaction_id'] = $model->parent->id;
                $voucherHead['currency_id'] = $model->parent->currency_id;
                $voucherHead['exchange_rate'] = $model->parent->exchange_rate;
                $voucherHead['customer_vendor_id'] = $model->parent->customer_vendor_id;
                $voucherHead['payment_method'] = $model->parent->payment_method;
                $voucherHead['payment_days'] = $model->parent->payment_days;
                $voucherHead['payment_terms'] = $model->parent->payment_terms;
                $voucherHead['lead_owner'] = $model->parent->lead_owner;
                $lastSavedid = $this->addVoucherhead($voucherHead);
                // ----------------------------
                $voucherModel = new AccVoucher();
                $voucherModel = $voucherModel->findByPK((int) $lastSavedid);

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    'CREATED',
                    "{$voucherModel->vtype->description} with voucher no. {$voucherModel->voucher_no} and resubmit from cheque management"
                );
                // end audit log
                // ----------------------------
                $modelHead = AccVoucher::model()->findBypk($model->acc_voucher_id);
                $modelHead->cheque_bounced = 'N';
                $modelHead->update();
                // ----------------------------
                foreach ($modelHead->voucher_items as $each) {
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = $each->ledger_id;
                    $itemsArray['subledger_id'] = $each->subledger_id;
                    $itemsArray['narration'] = 'Voucher No ' . $each->parent->fullvoucher . ' | Cheque No ' . $each->parent->cheque_no . ' Resubmitted';
                    $itemsArray['amount'] = -1 * $each->amount;
                    if ($itemsArray['amount'] > 0) {
                        $itemsArray['debit'] = abs($itemsArray['amount']);
                    } else {
                        $itemsArray['credit'] = abs($itemsArray['amount']);
                    }
                    $itemsArray['reconciled'] = 'N';
                    $itemsArray['opening_cheque_cleared'] = 'Y';
                    $itemsArray['cheque_bounced'] = 'N';
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    if ($each->amount > 0) {
                        $totalValue = $each->amount;
                    }
                }
                AccVoucher::model()->updatebypk(
                    $lastSavedid,
                    array(
                        'amount' => abs($totalValue),
                        'net_amount' => abs($totalValue),
                        'voucher_value' => abs($totalValue)
                    )
                ); //$netTotal
            }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }
            echo json_encode($response);
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    //(post) Material Receiptt items from finance voucher and voucher items 
    //------------------------------------------------------------------------------------------------------------
    public static function addPostMaterialReceipt($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="MR"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--credit note
                $header_model = $model_voucher_type->header_table;
                $modelheader = new $header_model;
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Material Receipt Not Found';
                }
                $dateField = $model_voucher_type->date_field;
                $voucherReference = $model_voucher_type->voucher_reference;
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->created_by);
                $employee_id = (int) $usermodel->connected_employee_id;
                //    ---------------------------
                $narration = 'Material Receipt #' . $modelheader->$voucherReference;
                $goods_receipt_id = $modelheader->id;
                //$sales_amount       = $modelheader->credited_amount - $modelheader->total_discount;
                $receipt_amount = Yii::app()->db->createCommand("select SUM(rate*quantity)  from {{purchasing_material_receipt_item}} where purchasing_materialreceipt_id='" . $modelheader->id . "'  ")->queryScalar();
                $tax_amount = 0;
                $tot_discount = 0;
                $round_off_amount = 0;
                $salegroup_id = 0;
                $project_id = 0;
                $branch_id = $usermodel->branch_id;
                $company_id = $usermodel->company_id;
                $payment_term_id = 0;
                $costcenter_id = $usermodel->warehouse_id;
                $warehouse_id = 0;
                $currency = 1;
                $exchange_rate = 1;
                $file_id = $modelheader->file_id;
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->vendor_id;
                $year = date('Y', strtotime($modelheader->$dateField));
                $arr_items = [];
                foreach ($modelvoucher_type_details as $eachtype) {
                    $modePurchasingMaterialreceiptItem = new PurchasingMaterialreceiptItem();
                    $modePurchasingMaterialreceiptItem = $modePurchasingMaterialreceiptItem->findAll(array('condition' => 'purchasing_materialreceipt_id=' . (int) $id));
                    foreach ($modePurchasingMaterialreceiptItem as $eachReceiptItems) {
                        // --------------------------------
                        $model_MasService = new Store();
                        $model_MasService = $model_MasService->findByPK((int) $eachReceiptItems->product_id);
                        /* $sales_ledger_id         = (int)$model_MasService->genericdetails->sales_ledger_id;
                          if ((float)$eachInvoiceItem->net_amount == 0) {
                          $cost_of_ledger_id     = (int)$model_MasService->genericdetails->cost_of_gift_ledger_id;
                          } else {
                          $cost_of_ledger_id      = (int)$model_MasService->genericdetails->cost_of_sales_ledger_id;
                          } */
                        $inventory_ledger_id = (int) $model_MasService->genericdetails->inventory_ledger_id;
                        // --------------------------------
                        $amount = 0;
                        $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(buying_price*quantity),0)  from erp_stock_ledger where transaction_from='QUALITY_CHECK' AND product_id='" . $eachReceiptItems->product_id . "' AND header_id IN ({$modelheader->id}) AND (file_id ='" . $file_id . "')")->queryScalar();
                        if ($eachtype->attribute == 'inventory') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = ($inventory_ledger_id > 0) ? $inventory_ledger_id : $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachReceiptItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachReceiptItems->quantity;
                            $arr_items[$i]->rate = $eachReceiptItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->user_id = (int) $modelheader->created_by;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $i++;
                        }
                        if ($eachtype->attribute == 'closing_stock') {
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachReceiptItems->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? ($cost_amount) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachReceiptItems->quantity;
                            $arr_items[$i]->rate = $eachReceiptItems->rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->user_id = (int) $modelheader->created_by;
                            $arr_items[$i]->warehouse_id = (int) $warehouse_id;
                            $i++;
                        }
                    }
                }
            }
            if ($valid) {
                $voucherHead = array();
                // -----------------new---------------------------------
                $voucherHead['file_id'] = $modelheader->file_id;
                // ------------------//--------------------------------
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                //Voucher Type id
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                //$voucherHead['voucher_no']        = $modelheader->$voucherReference;
                //invoice_no
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                //invoice_date
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                //invoice_date
                //$voucherHead['transaction_number']    = $modelheader->invoice_no;
                $voucherHead['transaction_number'] = $goods_receipt_id;
                //goods_issue_id
                $voucherHead['transaction_id'] = $goods_receipt_id;
                //goods_issue_id
                $voucherHead['reference_no'] = $modelheader->$voucherReference;
                //invoice_no
                $voucherHead['narration'] = $narration;
                //invoice_no
                // -----------------new---------------------------------
                $voucherHead['voucher_value'] = 0;
                $voucherHead['currency_id'] = 1;
                //currency_id
                $voucherHead['exchange_rate'] = 1;
                //exchange_rate
                $voucherHead['vat'] = 0;
                $voucherHead['amount'] = $receipt_amount;
                $voucherHead['net_amount'] = $receipt_amount;
                $voucherHead['total_discount'] = 0;
                $voucherHead['rounding'] = 0;
                $voucherHead['tax_type'] = 0;
                $voucherHead['tax_id'] = 0;
                $voucherHead['order_id'] = 0;
                $voucherHead['delivery_id'] = 0;
                $voucherHead['direct'] = 0;
                $voucherHead['imported'] = 'Y';
                // ------------------//--------------------------------
                //bank_name
                //card_no
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = 0;
                //payment_method
                // -----------------new---------------------------------
                $voucherHead['payment_days'] = 0;
                $voucherHead['payment_terms'] = 0;
                // ------------------//--------------------------------
                // -----------------new---------------------------------
                $voucherHead['lead_owner'] = (int) $modelheader->created_by;
                // ------------------//--------------------------------
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = (int) $warehouse_id;
                //-------saving invoice header details---------
                $invoiceVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $invoiceVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($invoiceVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($invoiceVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($goods_receipt_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        if ($from != '') {
            return 1;
        }
        if ($flag == 1) {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $invoiceVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }

    public static function allocateSalesreturnVoucherwithSales($return_id)
    {
        // ------------------------------------
        $modelMasCurrency = new MasCurrency();
        $decimal_cur = $modelMasCurrency->baseCurrencyDefultDecimal();
        $currenctdecimal = ((int) $decimal_cur > 0) ? (int) $decimal_cur : 2;
        // ------------------------------------
        $modelheader = new Creditnote();
        $modelheader = $modelheader->findByPK((int) $return_id);
        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        //ledger_id
        $debtor_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
        $modAccSubledgerType = new AccSubledgerType();
        $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger = new AccSubledger();
        //subledger_id
        $customer_subledger = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
        //reciept
        $model_voucher_type = new AccVoucherType();
        $modelAccVoucher = new AccVoucher;
        $modAccVoucherItems = new AccVoucherItems();
        $paymentvoucher_type_id = $model_voucher_type->find(array('condition' => 'code="PV"'))->id;
        $paycondition = 't.imported="Y" AND t.voucher_type=' . $paymentvoucher_type_id . ' AND t.transaction_id=' . $return_id;
        $PaymentVoucher_det = $modelAccVoucher->find(array('condition' => $paycondition));
        $vi_receipt_debtor = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $PaymentVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        //salesinvoice
        $invoicevoucher_type_id = $model_voucher_type->find(array('condition' => 'code="CN"'))->id;
        $invcondition = 't.imported="Y" AND t.voucher_type=' . $invoicevoucher_type_id . ' AND t.transaction_id=' . $return_id;
        $InvoiceVoucher_det = $modelAccVoucher->find(array('condition' => $invcondition));
        $vi_invoice_debtor = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $InvoiceVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        $salesvoucher_type_id = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
        $salescondition = 't.imported="Y" AND t.voucher_type=' . $salesvoucher_type_id . ' AND t.transaction_id=' . $modelheader->invoice_id;
        $salesVoucher_det = $modelAccVoucher->find(array('condition' => $salescondition));
        $vi_sales_debtor = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $salesVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        $sl_amount = abs(round($vi_sales_debtor->amount, $currenctdecimal));
        $cn_amount = abs(round($vi_invoice_debtor->amount, $currenctdecimal));
        //  if (round(abs($vi_receipt_debtor->amount), $currenctdecimal) == round(abs($vi_invoice_debtor['amount']), $currenctdecimal)) {



        if ($sl_amount == $cn_amount) {
            $model = new AccAllocation;
            $model->allocation_date = date('Y-m-d');
            $model->ledger_id = $debtor_ledger;
            $model->subledger_id = $customer_subledger;
            $model->amount = round(abs($vi_invoice_debtor->amount), $currenctdecimal);
            $model->reference_id = (int) $modelheader->id;
            $model->created_by = (int) $modelheader->crm_user_id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->save(false);
            $model->refresh();
            // ----------------------SI---------------------------
            $creditArray = new AccAllocationItems;
            $creditArray->voucher_id = $salesVoucher_det->id;
            $creditArray->voucher_item_id = $vi_sales_debtor->id;
            $creditArray->amount = -1 * (round($vi_sales_debtor->amount, $currenctdecimal));
            $creditArray->allocation_id = $model->id;
            $creditArray->allocation_date = $model->allocation_date;
            $creditArray->ledger_id = $debtor_ledger;
            $creditArray->subledger_id = $customer_subledger;
            $creditArray->reference_id = (int) $modelheader->id;
            $creditArray->voucher_type = $salesvoucher_type_id;
            $creditArray->save(false);
            if (!empty($vi_sales_debtor)) {
                $vi_sales_debtor->allocated_amount = (float) $vi_sales_debtor->allocated_amount + -1 * (float) round(abs($vi_sales_debtor->amount), $currenctdecimal);
                $vi_sales_debtor->save(false);
            }
            // ----------------------CN---------------------------
            AccVoucher::model()->updateBypk($PaymentVoucher_det->id, array('is_allocated' => 'Y'));
            $debitArray = new AccAllocationItems;
            $debitArray->voucher_id = $InvoiceVoucher_det->id;
            $debitArray->voucher_item_id = $vi_invoice_debtor->id;
            $debitArray->amount = -1 * (round($vi_invoice_debtor->amount, $currenctdecimal));
            $debitArray->allocation_id = $model->id;
            $debitArray->allocation_date = $model->allocation_date;
            $debitArray->ledger_id = $debtor_ledger;
            $debitArray->subledger_id = $customer_subledger;
            $debitArray->reference_id = (int) $modelheader->id;
            $debitArray->voucher_type = $InvoiceVoucher_det->voucher_type;
            $debitArray->save(false);
            $vi_invoice_debtor->allocated_amount = (float) $vi_invoice_debtor->allocated_amount + -1 * (float) round(abs($vi_invoice_debtor->amount), $currenctdecimal);
            $vi_invoice_debtor->save(false);
            AccVoucher::model()->updateBypk($InvoiceVoucher_det->id, array('is_allocated' => 'Y'));
        }
    }
    public static function allocateSalesreturnVoucherwithPaymentandSales($return_id)
    {
        // ------------------------------------
        $modelMasCurrency = new MasCurrency();
        $decimal_cur = $modelMasCurrency->baseCurrencyDefultDecimal();
        $currenctdecimal = ((int) $decimal_cur > 0) ? (int) $decimal_cur : 2;
        // ------------------------------------
        $modelheader = new Creditnote();
        $modelheader = $modelheader->findByPK((int) $return_id);
        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        //ledger_id
        $debtor_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
        $modAccSubledgerType = new AccSubledgerType();
        $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger = new AccSubledger();
        //subledger_id
        $customer_subledger = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
        //reciept
        $model_voucher_type = new AccVoucherType();
        $modelAccVoucher = new AccVoucher;
        $modAccVoucherItems = new AccVoucherItems();
        $paymentvoucher_type_id = $model_voucher_type->find(array('condition' => 'code="PV"'))->id;
        $paycondition = 't.imported="Y" AND t.voucher_type=' . $paymentvoucher_type_id . ' AND t.transaction_id=' . $return_id;
        $PaymentVoucher_det = $modelAccVoucher->find(array('condition' => $paycondition));
        $vi_receipt_debtor = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $PaymentVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        //salesinvoice
        $invoicevoucher_type_id = $model_voucher_type->find(array('condition' => 'code="CN"'))->id;
        $invcondition = 't.imported="Y" AND t.voucher_type=' . $invoicevoucher_type_id . ' AND t.transaction_id=' . $return_id;
        $InvoiceVoucher_det = $modelAccVoucher->find(array('condition' => $invcondition));
        $vi_invoice_debtor = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $InvoiceVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        $salesvoucher_type_id = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
        $salescondition = 't.imported="Y" AND t.voucher_type=' . $salesvoucher_type_id . ' AND t.transaction_id=' . $modelheader->invoice_id;
        $salesVoucher_det = $modelAccVoucher->find(array('condition' => $salescondition));
        $vi_sales_debtor = $modAccVoucherItems->find(array('condition' => 'acc_voucher_id=' . (int) $salesVoucher_det->id . ' AND ledger_id=' . (int) $debtor_ledger . ' AND subledger_id=' . (int) $customer_subledger));
        $cr_amount = abs(round((float) $vi_invoice_debtor->amount, $currenctdecimal));
        $pv_amount = abs(round((float) $vi_receipt_debtor->amount, $currenctdecimal));
        $sales_amount = abs(round((float) $cr_amount - $pv_amount, $currenctdecimal));

        if ($cr_amount == ($pv_amount + $sales_amount)) {
            // echo "innnallo"; echo "<br>"; 
            $model = new AccAllocation;
            $model->allocation_date = date('Y-m-d');
            $model->ledger_id = $debtor_ledger;
            $model->subledger_id = $customer_subledger;
            $model->amount = round(abs($vi_invoice_debtor->amount), $currenctdecimal);
            $model->reference_id = (int) $modelheader->id;
            $model->created_by = (int) $modelheader->crm_user_id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->save(false);
            $model->refresh();
            // -----------------debit-----CN---------------------------
            AccVoucher::model()->updateBypk($PaymentVoucher_det->id, array('is_allocated' => 'Y'));
            $debitArray = new AccAllocationItems;
            $debitArray->voucher_id = $InvoiceVoucher_det->id;
            $debitArray->voucher_item_id = $vi_invoice_debtor->id;
            $debitArray->amount = -1 * (round((float) $vi_invoice_debtor->amount, $currenctdecimal));
            $debitArray->allocation_id = $model->id;
            $debitArray->allocation_date = $model->allocation_date;
            $debitArray->ledger_id = $debtor_ledger;
            $debitArray->subledger_id = $customer_subledger;
            $debitArray->reference_id = (int) $modelheader->id;
            $debitArray->voucher_type = $InvoiceVoucher_det->voucher_type;
            $debitArray->save(false);
            $vi_invoice_debtor->allocated_amount = (float) $vi_invoice_debtor->allocated_amount + (float) round(abs($vi_invoice_debtor->amount), $currenctdecimal);
            $vi_invoice_debtor->save(false);
            AccVoucher::model()->updateBypk($InvoiceVoucher_det->id, array('is_allocated' => 'Y'));
            // ----------------credit------PV---------------------------
            $creditArray = new AccAllocationItems;
            $creditArray->voucher_id = $PaymentVoucher_det->id;
            $creditArray->voucher_item_id = $vi_receipt_debtor->id;
            $creditArray->amount = -1 * (round((float) $vi_receipt_debtor->amount, $currenctdecimal));
            $creditArray->allocation_id = $model->id;
            $creditArray->allocation_date = $model->allocation_date;
            $creditArray->ledger_id = $debtor_ledger;
            $creditArray->subledger_id = $customer_subledger;
            $creditArray->reference_id = (int) $modelheader->id;
            $creditArray->voucher_type = $InvoiceVoucher_det->voucher_type;
            $creditArray->save(false);
            $vi_receipt_debtor->allocated_amount = (float) $vi_receipt_debtor->allocated_amount + (float) round(abs($vi_receipt_debtor->amount), $currenctdecimal);
            $vi_receipt_debtor->save(false);
            // ---------------credit-------SI---------------------------
            $creditArray = new AccAllocationItems;
            $creditArray->voucher_id = $salesVoucher_det->id;
            $creditArray->voucher_item_id = $vi_sales_debtor->id;
            //  $creditArray->amount =   -1 * (round((float)$inv_balance, $currenctdecimal));
            $creditArray->amount = -1 * (round((float) $sales_amount, $currenctdecimal));
            $creditArray->allocation_id = $model->id;
            $creditArray->allocation_date = $model->allocation_date;
            $creditArray->ledger_id = $debtor_ledger;
            $creditArray->subledger_id = $customer_subledger;
            $creditArray->reference_id = (int) $modelheader->id;
            $creditArray->voucher_type = $salesvoucher_type_id;
            $creditArray->save(false);
            $vi_sales_debtor->allocated_amount = (float) $vi_sales_debtor->allocated_amount + -1 * (float) round(abs($sales_amount), $currenctdecimal);
            $vi_sales_debtor->save(false);
        }
    }
    public static function addPostDeliveryNote($array_ids, $from)
    {
        $flag = 0;
        $valid = true;
        $others = [];
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $valid = true;
            $others = [];
            $arr_pdts_cogs = [];
            $arr_pdts_cogsinv = [];
            //check whether voucher type defined
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="DL"'));
            if (empty($model_voucher_type)) {
                $valid = false;
                $others[] = 'Voucher Type not defined';
            } else {
                //check whether voucher type details defined
                $modelvoucher_type_details = new AccVoucherTypeDetails();
                $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
                if (empty($modelvoucher_type_details)) {
                    $valid = false;
                    $others[] = 'Voucher Type Details not defined';
                }
                //model of header_table--DeliveryNote
                $header_model = 'DeliveryNote';
                $modelheader = new DeliveryNote();     // DeliveryNote
                $modelheader = $modelheader->findByPK((int) $id);
                if (empty($modelheader)) {
                    $valid = false;
                    $others[] = 'Delivery Note Not Found' . $id;
                }
                if ($modelheader->posted == 'Y') {
                    $valid = false;
                    $others[] = 'Delivery Note Already Posted' . $id;
                }
                if ($modelheader->status == 'CN') {
                    $valid = false;
                    $others[] = 'Delivery Note Already Cancelled' . $id;
                }
                if ($modelheader->status == 'PN') {
                    $valid = false;
                    $others[] = 'Delivery Note is Not Packaged' . $id;
                }
                // ---------------------------------------------
                $order_id = $modelheader->order_id;
                if ((int) $order_id > 0) {
                    $modelDirectInvoice = new Order;
                    $modelOrder = $modelDirectInvoice->findByPK((int) $order_id);
                }
                $lead_owner_id = $modelOrder->lead_owner_id;
                $order_payment_terms = $modelOrder->payment_terms_id;
                $order_grand_total = $modelOrder->grand_total;
                $order_tax_type = $modelOrder->invoice_type_id;
                $payment_method = $modelOrder->payment_terms_id;
                // ------------------------------------------------
                $dateField = 'delivery_date';
                $voucherReference = 'id';
                $modelVoucher = new AccVoucher();
                $i = 0;
                $usermodel = new user();
                $usermodel = $usermodel->findByPK((int) $modelheader->lead_owner_id);
                $employee_id = (int) $usermodel->connected_employee_id;
                $narration = 'Delivery Note #' . $modelheader->id;
                $deliverynote_id = $modelheader->id;
                $tax_amount = $modelOrder->total_tax_amount * $modelOrder->exchange_rate;
                // ------------------------------------
                $tot_discount = 0;
                $salegroup_id = $modelOrder->sales_group_id;
                $project_id = 0;
                $company_id = $usermodel->company_id;
                $branch_id = $usermodel->branch_id;
                $payment_term_id = $order_payment_terms;
                $costcenter_id = 0;
                $currency = $modelOrder->currency_id;
                $exchange_rate = $modelOrder->exchange_rate;
                $file_id = $modelheader->file_id;
                $transaction_id = $modelheader->id;
                $warehouse_id = 0;
                // -----------------------------------
                /* $modelAccPaymentMode  = new AccPaymentMode();
                  $modelAccPaymentMode  = new AccPaymentMode();
                  $type = $modelAccPaymentMode->find(array('condition' => 'code="' . $modelheader->receipt_type . '"'));
                  if (!empty($type)) {
                  $payment_method = $type->id;
                  } */
                // -----------------------------------
                $department_id = 0;
                if ((int) $employee_id > 0) {
                    $modelEmployee = new Employee();
                    $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                    $department_id = $modelEmployee->department;
                }
                $customer_vendor_id = $modelheader->customer_id;
                $year = date('Y', strtotime($modelheader->delivery_date));
                $arr_items = [];
                $total_cost = 0;
                foreach ($modelvoucher_type_details as $eachtype) {
                    $modelDeliveryNoteItem = new DeliveryNoteItem();
                    $modelDeliveryNoteItem = $modelDeliveryNoteItem->findAll(array('condition' => 'delivery_note_id =' . (int) $id));
                    foreach ($modelDeliveryNoteItem as $eachDeliveryNoteItem) {
                        //    ----------------------------------------------------
                        $model_store = new Store();
                        $model_store = $model_store->findByPK((int) $eachDeliveryNoteItem->product_id);
                        $cost_of_sales_ledger_id = isset($model_store->genericdetails->cost_of_sales_ledger_id) ? (int) $model_store->genericdetails->cost_of_sales_ledger_id : 0;
                        $inventory_ledger_id = isset($model_store->genericdetails->inventory_ledger_id) ? (int) $model_store->genericdetails->inventory_ledger_id : 0;
                        //    ----------------------------------------------------
                        $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity*unit_factor),0)  from erp_stock_ledger where transaction_from='DELIVERY_NOTE' AND product_id='" . $eachDeliveryNoteItem->product_id . "'  AND (header_id ='" . $transaction_id . "')")->queryScalar();

                        //  $cost_amount = Yii::app()->db->createCommand("select IFNULL(SUM(rate*quantity),0)  from {{direct_invoice_item}} where  product_id='" . $eachDeliveryNoteItem->product_id . "'  AND (invoice_id ='" . $order_id . "')")->queryScalar();
                        if ($eachtype->attribute == 'closing_stock' && !in_array($eachDeliveryNoteItem->product_id, $arr_pdts_cogs)) {
                            $arr_pdts_cogs[] = $eachDeliveryNoteItem->product_id;
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = ($cost_of_sales_ledger_id > 0) ? $cost_of_sales_ledger_id : $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachDeliveryNoteItem->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachDeliveryNoteItem->quantity;
                            // $arr_items[$i]->rate                     = $eachDeliveryNoteItem->cost_rate;
                            $arr_items[$i]->unit_id = $eachDeliveryNoteItem->unit_id;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $i++;
                            $total_cost += abs($cost_amount);
                        }
                        if ($eachtype->attribute == 'inventory' && !in_array($eachDeliveryNoteItem->product_id, $arr_pdts_cogsinv)) {
                            $arr_pdts_cogsinv[] = $eachDeliveryNoteItem->product_id;
                            $arr_items[$i] = new AccVoucherItems();
                            $arr_items[$i]->ledger_id = ($inventory_ledger_id > 0) ? $inventory_ledger_id : $eachtype->ledger_id;
                            $arr_items[$i]->product_id = $eachDeliveryNoteItem->product_id;
                            $arr_items[$i]->year = $year;
                            $arr_items[$i]->credit = ($eachtype->default_type == 'C') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->debit = ($eachtype->default_type == 'D') ? (abs($cost_amount)) : '0.00';
                            $arr_items[$i]->amount = ($eachtype->default_type == 'C') ? (-1 * abs($cost_amount)) : abs($cost_amount);
                            $arr_items[$i]->employee_id = $employee_id;
                            $arr_items[$i]->salegroup_id = $salegroup_id;
                            $arr_items[$i]->payment_term_id = $payment_term_id;
                            $arr_items[$i]->narration = $narration;
                            $arr_items[$i]->project_id = $project_id;
                            $arr_items[$i]->company_id = $company_id;
                            $arr_items[$i]->branch_id = $branch_id;
                            $arr_items[$i]->costcenter_id = $costcenter_id;
                            $arr_items[$i]->department_id = $department_id;
                            $arr_items[$i]->quantity = $eachDeliveryNoteItem->quantity;
                            //$arr_items[$i]->rate                     = $eachDeliveryNoteItem->cost_rate;
                            $arr_items[$i]->exchange_rate = $exchange_rate;
                            $arr_items[$i]->file_id = $file_id;
                            $arr_items[$i]->user_id = (int) $modelheader->lead_owner_id;
                            $arr_items[$i]->unit_id = $eachDeliveryNoteItem->unit_id;
                            $arr_items[$i]->warehouse_id = $warehouse_id;
                            $i++;
                        }
                    }
                }
            }
            if ($valid) {
                $voucherHead = array();
                $voucherHead['file_id'] = $modelheader->file_id;
                $voucherHead['voucher_type'] = $model_voucher_type->id;
                $modelAccVoucherType = new AccVoucherType;
                $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
                $voucherHead['voucher_date'] = $modelheader->$dateField;
                $voucherHead['transaction_date'] = $modelheader->$dateField;
                $voucherHead['transaction_number'] = $deliverynote_id;
                $voucherHead['transaction_id'] = $deliverynote_id;
                $voucherHead['reference_no'] = $modelheader->$voucherReference;
                $voucherHead['narration'] = $narration;
                $voucherHead['voucher_value'] = $total_cost;
                $voucherHead['currency_id'] = $currency;
                $voucherHead['exchange_rate'] = $exchange_rate;
                $voucherHead['vat'] = $tax_amount;
                $voucherHead['amount'] = $total_cost;
                $voucherHead['net_amount'] = $total_cost;
                $voucherHead['total_discount'] = $tot_discount;
                $voucherHead['rounding'] = 0;
                $voucherHead['tax_type'] = $order_tax_type;
                $voucherHead['tax_id'] = 0;
                $voucherHead['order_id'] = $order_id;
                $voucherHead['delivery_id'] = $transaction_id;
                $voucherHead['direct'] = 0;
                $voucherHead['imported'] = 'Y';
                $voucherHead['customer_vendor_id'] = $customer_vendor_id;
                $voucherHead['payment_method'] = $payment_method;
                $voucherHead['payment_days'] = 0;
                $voucherHead['payment_terms'] = $payment_term_id;
                $voucherHead['lead_owner'] = $lead_owner_id;
                $voucherHead['salegroup_id'] = $salegroup_id;
                $voucherHead['year'] = $year;
                $voucherHead['company_id'] = $company_id;
                $voucherHead['branch_id'] = $branch_id;
                $voucherHead['project_id'] = $project_id;
                $voucherHead['department_id'] = $department_id;
                $voucherHead['employee_id'] = $employee_id;
                $voucherHead['warehouse_id'] = $warehouse_id;
                //-------saving Delivery Note header details---------
                $deliveryVoucherid = PostingController::addVoucherhead($voucherHead);
                if ((int) $deliveryVoucherid > 0) {
                    for (
                        $k = 0;
                        $k < $i;
                        $k++
                    ) {
                        PostingController::addVoucheritems($deliveryVoucherid, $arr_items[$k]);
                    }
                    PostingController::addroundoff($deliveryVoucherid);
                    $modelheader = new $header_model;
                    $modelheader = $modelheader->updateByPk($deliverynote_id, array('posted' => 'Y'));
                    $flag = 1;
                } else {
                    $flag = 2;
                }
            } else {
                $error = CJSON::encode($others);
                //array_merge_recursive($error, $error1, $error2, $error3, $others)
                if ($error != '[]')
                    echo $error;
            }
        }
        $voucherModel = new AccVoucher();
        $voucherModel = $voucherModel->findByPK((int) $deliveryVoucherid);

        if ($flag == 1 && $from = 'INVOICE') {
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with Deliverynote no: - {$voucherModel->transaction_id}  "
            );
            // end audit log
        }
        if ($from != '') {
            return 1;
        }


        if ($flag == 1 && $from != 'INVOICE') {
            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
            );
            // end audit log
            $jsonData['voucher_id'] = $deliveryVoucherid;
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $deliveryVoucherid;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData['status'] = 'error';
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        }
    }
    public function addUnpostDeliverynote($array_ids, $from)
    {
        $flag = 0;
        foreach ($array_ids as $i => $each) {
            $id = $each;
            $model_voucher_type = new AccVoucherType();
            $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="DL"'));
            $header_model = $model_voucher_type->header_table;
            $modelheader = new $header_model;
            $modelheader = $modelheader->findByPK((int) $id);
            $delivery_id = $modelheader->id;
            //   $condition                = 't.reference_no=' . $delivery_id;
            $modelAccVoucher = new AccVoucher;
            // $AccVoucher_det           = $modelAccVoucher->find(array('condition' => $condition));
            $sql = "SELECT * FROM erp_acc_voucher  WHERE erp_acc_voucher.voucher_type='{$model_voucher_type->id}' AND erp_acc_voucher.transaction_number LIKE '" . $delivery_id . "%'";
            $AccVoucher_det = Yii::app()->db->createCommand($sql)->queryAll();
            if ($AccVoucher_det[0]['id'] > 0) {
                if ($AccVoucher_det[0]['is_allocated'] == 'N') {
                    // ---------------------------------------
                    $voucherModel = new AccVoucher();
                    $voucherModel = $voucherModel->findByPK((int)$AccVoucher_det[0]['id']);
                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'UNPOSTED',
                        changes: "(Imported) {$voucherModel->vtype->description} with Deliverynote no: - {$voucherModel->transaction_id} "

                    );
                    // end audit log
                    // ---------------------------------------

                    $modelAccVoucherItems = new AccVoucherItems();
                    $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $AccVoucher_det[0]['id']));
                    $modelAccVoucher->deleteByPk($AccVoucher_det[0]['id']);
                    $modelheader->updateByPk($delivery_id, array('posted' => 'N'));
                    $flag = 1;
                } else {
                    $flag = 3;
                }
            } else {
                $flag = 2;
            }
        }

        if ($flag == 1 && $from != 'INVOICE') {
            $jsonData['status'] = 'success';
            $jsonData['id'] = (int) $AccVoucher_det->id;
            echo CJSON::encode($jsonData);
        } else if ($flag == 2) {
            $jsonData[] = 'Voucher Header Not Saved';
            echo CJSON::encode($jsonData);
        } else if ($flag == 3) {
            $jsonData[] = 'Voucher Allocated';
            echo CJSON::encode($jsonData);
        } else {
            return 1;
        }
    }

    public static function addPostmultipayment_frm_creditnote($inv_id)
    {
        //  if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {
        $valid = true;
        $valid = true;
        $others = [];
        //check whether voucher type defined
        $model_voucher_type = new AccVoucherType();
        $model_voucher_type = $model_voucher_type->find(array('condition' => 'code="PV"'));
        if (empty($model_voucher_type)) {
            $valid = false;
            $others[] = 'Voucher Type not defined';
        } else {
            //check whether voucher type details defined
            $modelvoucher_type_details = new AccVoucherTypeDetails();
            $modelvoucher_type_details = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int) $model_voucher_type->id));
            if (empty($modelvoucher_type_details)) {
                $valid = false;
                $others[] = 'Voucher Type Details not defined';
            }
            $modelheader = new Creditnote();
            $modelheader = $modelheader->findByPK((int) $inv_id);
            $modelinvoice = new Invoice();
            $modelinvoice = $modelinvoice->findByPK((int) $modelheader->invoice_id);
            if (empty($modelheader)) {
                $valid = false;
                $others[] = 'Credit Note Not Found' . $inv_id;
            }
            // ------------------------------------------------------
            $model_voucher_type_sales = new AccVoucherType();
            $model_voucher_type_sales = $model_voucher_type_sales->find(array('condition' => 'code="SI"'));
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
            $sqlacc = "SELECT 
                SUM(IFNULL(ABS(VI.allocated_amount), 0)) AS total_allocated
                    FROM  {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    WHERE   V.is_posted = 'Y' AND  V.transaction_id  = '" . $modelheader->invoice_id . "'  AND V.voucher_type = '" . $model_voucher_type_sales->id . "'  AND VI.ledger_id = '" . $from_ledger . "'
                    GROUP BY V.id";
            $command_acc = Yii::app()->db->createCommand($sqlacc);
            $acc_detls = $command_acc->queryAll();
            $inv_balance = $modelheader->invoice->grand_total - $acc_detls[0]['total_allocated'];
            if ($inv_balance < $modelheader->credited_amount) {
                $amount = $acc_detls[0]['total_allocated'];
            } else {
                $amount = $modelheader->credited_amount;
            }
            //    ------------------------------------
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
            //    ------------------------------------
            $modAccSubledgerType = new AccSubledgerType();
            $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
            $modAccSubledger = new AccSubledger();
            $from_subledger = (int) $modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
            $emp_subledger_type_id = $modAccSubledgerType->getIdFromType('E');
            $employee_subledger = (int) $modAccSubledger->getsubledgerFromledgerandtype($emp_subledger_type_id, $modelheader->crm_user_id);
            //    ------------------------------------
            $i = 0;
            $usermodel = new user();
            $usermodel = $usermodel->findByPK((int) $modelheader->created_by);
            //    ------------------------------------
            $employee_id = (int) $usermodel->connected_employee_id;
            $voucherReference = $modelheader->invoice_id;
            $narration = 'Payment Voucher #' . $voucherReference;
            $tax_amount = $modelheader->total_tax_amount;
            $tot_discount = 0;
            $round_off_amount = 0;
            $salegroup_id = isset($modelinvoice->sales_group_id) ?: 0;
            $project_id = isset($modelinvoice->project_id) ?: 0;
            $branch_id = isset($usermodel->branch_id) ? $usermodel->branch_id : 0;
            $company_id = isset($usermodel->company_id) ? $usermodel->company_id : 0;
            $payment_term_id = isset($modelinvoice->payment_terms_id) ? $modelinvoice->payment_terms_id : 0;
            $costcenter_id = isset($usermodel->warehouse_id) ? $usermodel->warehouse_id : 0;
            $department_id = 0;
            $reference = $voucherReference; //invoice number
            $modelWarehouse = new MasInventoryWarehouse();
            $modelWarehouse = $modelWarehouse->find(array('condition' => 'isBaseWareHouse="Y"'));
            $outlet_id = isset($usermodel->warehouse_id) ? (int) $usermodel->warehouse_id : 0;
            $warehouse_id = isset($usermodel->warehouse_id) ? (int) $usermodel->warehouse_id : 0;
            if ((int) $employee_id > 0) {
                $modelEmployee = new Employee();
                $modelEmployee = $modelEmployee->findByPK((int) $employee_id);
                $department_id = $modelEmployee->department;
            }
            $customer_vendor_id = 0;
            if ((int) $from_subledger > 0) {
                $modelCustomer_subledger = new AccSubledger();
                $modelCustomer_subledger = $modelCustomer_subledger->findByPk((int) $from_subledger);
                $customer_vendor_id = $modelCustomer_subledger->reference_id;
            }
            $year = (count(explode('/', $modelheader->credited_date)) == 3) ? date("Y", strtotime(str_replace('/', '-', $modelheader->credited_date))) : date('Y');
            // ------------------------------------------
            $modelCreditnotePayments = new CreditnotePayments();
            $modelCreditnotePayments = $modelCreditnotePayments->model()->findAll(array('condition' => 'creditnote_id="' . (int) $inv_id . '"'));
            if (empty($modelCreditnotePayments)) {
                $valid = false;
                //$others[]        = 'No payments Added' . $inv_id;
            }
        }
        if ($valid) {
            $arr_items = [];
            $modelpaymentmode = new AccPaymentMode();
            $voucherHead = [];
            $arr_items = [];
            $voucherHead = [];
            $i = 0;
            $voucherHead['voucher_type'] = $model_voucher_type->id;
            $modelAccVoucherType = new AccVoucherType;
            $voucherHead['voucher_no'] = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
            $voucherHead['transaction_date'] = (count(explode('-', $modelheader->credited_date)) == 3) ? $modelheader->credited_date : date('Y-m-d');
            $voucherHead['transaction_number'] = $modelheader->creditnote_no;
            $voucherHead['transaction_id'] = $inv_id;
            $voucherHead['reference_no'] = $reference;
            $voucherHead['voucher_date'] = (count(explode('-', $modelheader->credited_date)) == 3) ? $modelheader->credited_date : date('Y-m-d');
            $voucherHead['narration'] = $narration;
            $voucherHead['currency_id'] = 1;
            $voucherHead['amount'] = abs((float) $amount);
            $voucherHead['payment_method'] = $modelpaymentmode->getPaymentmodeid('CH');;
            $voucherHead['payment_terms'] = $modelinvoice->payment_terms_id;
            $voucherHead['exchange_rate'] = 1;
            $voucherHead['card_no'] = '';
            $voucherHead['bank_name'] = '';
            $voucherHead['cheque_no'] = '';
            $voucherHead['cheque_date'] = '';
            $voucherHead['due_date'] = '';
            $voucherHead['customer_vendor_id'] = $customer_vendor_id;
            $voucherHead['lead_owner'] = (int) $modelheader->crm_user_id;
            $voucherHead['year'] = $year;
            $voucherHead['company_id'] = $company_id;
            $voucherHead['branch_id'] = $branch_id;
            $voucherHead['project_id'] = $project_id;
            $voucherHead['department_id'] = $department_id;
            $voucherHead['employee_id'] = $employee_id;
            $voucherHead['salegroup_id'] = $salegroup_id;
            $voucherHead['vat'] = 0;
            $voucherHead['imported'] = 'Y';
            $voucherHead['net_amount'] = $amount;
            $voucherHead['warehouse_id'] = $warehouse_id;
            $voucherHead['outlet_id'] = $warehouse_id;
            $cash_ledger = $modelpaymentmode->getPaymentmodeledger('CH');
            $cash_subledger = $modelpaymentmode->getPaymentmodesubledger('CH');
            $arr_items[$i] = new AccVoucherItems();
            $arr_items[$i]->ledger_id = (int) $cash_ledger;
            $arr_items[$i]->subledger_id = $cash_subledger;
            $arr_items[$i]->year = $year;
            $arr_items[$i]->credit = abs($amount);
            $arr_items[$i]->debit = '0.00';
            $arr_items[$i]->amount = -1 * abs($amount);
            $arr_items[$i]->employee_id = $employee_id;
            $arr_items[$i]->salegroup_id = $salegroup_id;
            $arr_items[$i]->payment_term_id = $payment_term_id;
            $arr_items[$i]->narration = $narration;
            $arr_items[$i]->project_id = $project_id;
            $arr_items[$i]->company_id = $company_id;
            $arr_items[$i]->branch_id = $branch_id;
            $arr_items[$i]->costcenter_id = $costcenter_id;
            $arr_items[$i]->department_id = $department_id;
            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
            $arr_items[$i]->warehouse_id = $warehouse_id;
            $arr_items[$i]->outlet_id = $warehouse_id;
            $i++;
            // --------------debtor----------------------------
            $arr_items[$i] = new AccVoucherItems();
            $arr_items[$i]->ledger_id = $from_ledger;
            $arr_items[$i]->subledger_id = (int) $from_subledger;
            $arr_items[$i]->year = $year;
            $arr_items[$i]->credit = '0.00';
            $arr_items[$i]->debit = abs($amount);
            $arr_items[$i]->amount = (abs($amount));
            $arr_items[$i]->employee_id = $employee_id;
            $arr_items[$i]->salegroup_id = $salegroup_id;
            $arr_items[$i]->payment_term_id = $payment_term_id;
            $arr_items[$i]->narration = $narration;
            $arr_items[$i]->project_id = $project_id;
            $arr_items[$i]->company_id = $company_id;
            $arr_items[$i]->branch_id = $branch_id;
            $arr_items[$i]->costcenter_id = $costcenter_id;
            $arr_items[$i]->department_id = $department_id;
            $arr_items[$i]->user_id = (int) $modelheader->crm_user_id;
            $arr_items[$i]->warehouse_id = $warehouse_id;
            $arr_items[$i]->outlet_id = $warehouse_id;
            $i++;
            //-------saving receipt header details---------
            $paymentVoucherid = PostingController::addVoucherhead($voucherHead);
            if ((int) $paymentVoucherid > 0) {
                for (
                    $k = 0;
                    $k < $i;
                    $k++
                ) {
                    PostingController::addVoucheritems($paymentVoucherid, $arr_items[$k]);
                }
                PostingController::addroundoff((int) $paymentVoucherid);
            }

            $voucherModel = new AccVoucher();
            $voucherModel = $voucherModel->findByPK((int) $paymentVoucherid);

            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                'POSTED',
                changes: "(Imported) {$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
            );
            // end audit log

        } else {
            $error = CJSON::encode($others);
            //array_merge_recursive($error, $error1, $error2, $error3, $others);
            if ($error != '[]')
                echo $error;
        }
    }


    public static function addPostpayment_frm_creditnote($inv_id)

    {
        //  if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {
        $valid  = true;
        $valid = true;
        $others = [];
        //check whether voucher type defined
        $model_voucher_type             = new AccVoucherType();
        $model_voucher_type             = $model_voucher_type->find(array('condition' => 'code="PV"'));


        if (empty($model_voucher_type)) {
            $valid          = false;
            $others[]       = 'Voucher Type not defined';
        } else {
            //check whether voucher type details defined
            $modelvoucher_type_details      = new AccVoucherTypeDetails();
            $modelvoucher_type_details      = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int)$model_voucher_type->id));


            if (empty($modelvoucher_type_details)) {
                $valid          = false;
                $others[]       = 'Voucher Type Details not defined';
            }
            $modelheader         = new Creditnote();
            $modelheader         = $modelheader->findByPK((int)$inv_id);

            $modelinvoice        = new Invoice();
            $modelinvoice        = $modelinvoice->findByPK((int)$modelheader->invoice_id);


            if (empty($modelheader)) {
                $valid           = false;
                $others[]        = 'Credit Note Not Found' . $inv_id;
            }
            //    ------------------------------------
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger                   = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
            //    ------------------------------------
            $modAccSubledgerType = new AccSubledgerType();
            $subledger_type_id   = $modAccSubledgerType->getIdFromType('C');
            $modAccSubledger     = new AccSubledger();
            $from_subledger      = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);


            //    ------------------------------------
            $i = 0;
            $usermodel          = new user();
            $usermodel          = $usermodel->findByPK((int)$modelheader->created_by);
            //    ------------------------------------

            $employee_id        = (isset($usermodel->connected_employee_id)) ? (int)$usermodel->connected_employee_id : 0;
            $voucherReference   = $modelheader->invoice_id;
            $narration          = 'Payment Voucher #' . $voucherReference;
            $amount             = $modelheader->credited_amount;
            $tax_amount         = $modelheader->total_tax_amount;
            $tot_discount       = 0;
            $round_off_amount   = 0;
            $salegroup_id       = ((isset($modelinvoice->sales_group))) ? $modelinvoice->sales_group : 0;

            $project_id         = ((isset($modelinvoice->project_id))) ? $modelinvoice->project_id : 0;
            $branch_id          =  ((isset($usermodel->branch_id))) ? $usermodel->branch_id : 0;
            $company_id         =  ((isset($usermodel->company_id))) ? $usermodel->company_id : 0;
            $payment_term_id    =  ((isset($modelinvoice->payment_terms))) ? $modelinvoice->payment_terms : 0;
            $costcenter_id      =  ((isset($usermodel->available_warehouses))) ? $usermodel->available_warehouses : 0;
            $department_id      = 0;
            $reference          = $voucherReference; //invoice number
            $warehouse_id       =  ((isset($modelheader->warehouse_id))) ? $modelheader->warehouse_id : 0;


            if ((int)$employee_id > 0) {
                $modelEmployee = new Employee();
                $modelEmployee = $modelEmployee->findByPK((int)$employee_id);
                $department_id = $modelEmployee->department;
            }
            $customer_vendor_id = 0;
            if ((int)$from_subledger > 0) {
                $modelCustomer_subledger = new AccSubledger();
                $modelCustomer_subledger = $modelCustomer_subledger->findByPk((int)$from_subledger);
                $customer_vendor_id      = $modelCustomer_subledger->reference_id;
            }
            $year               = (count(explode('/', $modelheader->credited_date)) == 3) ? date("Y", strtotime(str_replace('/', '-', $modelheader->credited_date))) : date('Y');
            // ------------------------------------------

            //$warehouse_id = (int)$usermodel->available_warehouses;
            $cash_sub_ledger = 0;
            $bank_sub_ledger = 0;
            if ($warehouse_id > 0) {
                $modelMasInventoryWarehouse  = new MasInventoryWarehouse();
                $Warehouse_det = $modelMasInventoryWarehouse->findByPk((int)$warehouse_id);
                $cash_sub_ledger =  ((isset($Warehouse_det->cash_ledger))) ? $Warehouse_det->cash_ledger : 0;
                $bank_sub_ledger =  ((isset($Warehouse_det->bank_ledger))) ? $Warehouse_det->bank_ledger : 0;
            }
            $bank_ledger = $modelAccSystemAccountsMapping->getSystemdefault('bank');
            $cash_ledger = $modelAccSystemAccountsMapping->getSystemdefault('cash');
            // ------------------------------------------
            $modelAccPaymentMode  = new AccPaymentMode();
            $payment_method = 0;

            if (isset($modelheader->payment_type) && !empty($modelheader->payment_type)) {
                $type = $modelAccPaymentMode->find(array('condition' => 'code="' . $modelheader->payment_type . '"'));
                if (!empty($type)) {
                    $payment_method = $type->id;
                }
            }

            $modelinvoice        = new Invoice();
            $modelinvoice        = $modelinvoice->findByPK((int)$modelheader->invoice_id);

            $arr_items = [];
            // --------------debtor----------------------------
            $arr_items[$i]                  = new AccVoucherItems();
            $arr_items[$i]->ledger_id       = $from_ledger;
            $arr_items[$i]->subledger_id    = (int)$from_subledger;
            $arr_items[$i]->year            = $year;
            $arr_items[$i]->credit          = '0.00';
            $arr_items[$i]->debit           =  abs($amount);
            $arr_items[$i]->amount          =   (abs($amount));
            $arr_items[$i]->employee_id     = $employee_id;
            $arr_items[$i]->salegroup_id    = $salegroup_id;
            $arr_items[$i]->payment_term_id = $payment_term_id;
            $arr_items[$i]->narration       = $narration;
            $arr_items[$i]->project_id      = $project_id;
            $arr_items[$i]->company_id      = $company_id;
            $arr_items[$i]->branch_id       = $branch_id;
            $arr_items[$i]->costcenter_id   = $costcenter_id;
            $arr_items[$i]->department_id   = $department_id;
            $arr_items[$i]->user_id         = (int)$modelheader->created_by;
            $arr_items[$i]->warehouse_id    = $warehouse_id;

            $i++;

            $cash_amount = ((isset($modelheader->paid_cash_amount))) ? abs($modelheader->paid_cash_amount) : 0;
            $card_amount = ((isset($modelheader->paid_card_amount))) ? abs($modelheader->paid_card_amount) : 0;
            $bank_amount = ((isset($modelheader->paid_amount))) ? abs($modelheader->paid_amount) : 0;
            $payment_type_cr = ((isset($modelheader->payment_type))) ? $modelheader->payment_type : 0;
            if ($bank_amount > 0 && $payment_type_cr == 'BT') {
                $card_amount =   $bank_amount;
            }
            // ----------------invoice receipt_type = cash------------------------------------------
            if ($cash_amount > 0) {

                $arr_items[$i]                  = new AccVoucherItems();
                $arr_items[$i]->ledger_id       = $cash_ledger;
                $arr_items[$i]->subledger_id    = (int)$cash_sub_ledger;
                $arr_items[$i]->year            = $year;
                $arr_items[$i]->credit          = abs($cash_amount);
                $arr_items[$i]->debit           =  '0.00';
                $arr_items[$i]->amount          = -1 * (abs($cash_amount));
                $arr_items[$i]->employee_id     = $employee_id;
                $arr_items[$i]->salegroup_id    = $salegroup_id;
                $arr_items[$i]->payment_term_id = $payment_term_id;
                $arr_items[$i]->narration       = $narration;
                $arr_items[$i]->project_id      = $project_id;
                $arr_items[$i]->company_id      = $company_id;
                $arr_items[$i]->branch_id       = $branch_id;
                $arr_items[$i]->costcenter_id   = $costcenter_id;
                $arr_items[$i]->department_id   = $department_id;
                $arr_items[$i]->user_id         = (int)$modelheader->created_by;
                $arr_items[$i]->warehouse_id    = $warehouse_id;

                $i++;
            }

            // --------------------invoice receipt_type = card--------------------------------------
            if ($card_amount > 0) {
                $arr_items[$i]                  = new AccVoucherItems();
                $arr_items[$i]->ledger_id       = $bank_ledger;
                $arr_items[$i]->subledger_id    = (int)$bank_sub_ledger;
                $arr_items[$i]->year            = $year;
                $arr_items[$i]->credit          = abs($card_amount);
                $arr_items[$i]->debit           = '0.00';
                $arr_items[$i]->amount          = -1 * (abs($card_amount));;
                $arr_items[$i]->employee_id     = $employee_id;
                $arr_items[$i]->salegroup_id    = $salegroup_id;
                $arr_items[$i]->payment_term_id = $payment_term_id;
                $arr_items[$i]->narration       = $narration;
                $arr_items[$i]->project_id      = $project_id;
                $arr_items[$i]->company_id      = $company_id;
                $arr_items[$i]->exchange_rate   = 1;
                $arr_items[$i]->branch_id       = $branch_id;
                $arr_items[$i]->costcenter_id   = $costcenter_id;
                $arr_items[$i]->department_id   = $department_id;
                $arr_items[$i]->user_id         = (int)$modelheader->created_by;
                $arr_items[$i]->warehouse_id    = $warehouse_id;

                $i++;
            }

            // ----------------------------------------------------------

        }
        if ($valid) {
            $voucherHead = array();
            $voucherHead['voucher_type']        = $model_voucher_type->id;
            $modelAccVoucherType                = new AccVoucherType;
            $voucherHead['voucher_no']          = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
            $voucherHead['transaction_date']    = date('Y-m-d');
            $voucherHead['transaction_number']  = $inv_id;
            $voucherHead['transaction_id']      = $inv_id;
            $voucherHead['reference_no']        = $reference;
            $voucherHead['voucher_date']        =  (count(explode('-', $modelheader->credited_date)) == 3) ?  $modelheader->credited_date : date('Y-m-d');
            $voucherHead['narration']           = $narration;
            $voucherHead['currency_id']         = $modelinvoice->currency_id;
            $voucherHead['amount']              = $amount - $tax_amount;
            $voucherHead['payment_method']      = $payment_method;
            $voucherHead['payment_terms']      = ((isset($modelinvoice->payment_terms))) ? $modelinvoice->payment_terms : 0;
            $voucherHead['exchange_rate']       = $modelinvoice->exchange_rate;
            $voucherHead['card_no']             = 0;
            $voucherHead['bank_name']           = '';
            $voucherHead['cheque_no']           = 0;
            $voucherHead['cheque_date']         = '';
            $voucherHead['due_date']            = '';
            $voucherHead['customer_vendor_id']  = $customer_vendor_id;
            $voucherHead['lead_owner']          = ((isset($modelheader->crm_user_id))) ? $modelheader->crm_user_id : 0;
            //$voucherHead['lead_owner']          = (int)$modelheader->created_by;
            $voucherHead['year']                = $year;
            $voucherHead['company_id']          = $company_id;
            $voucherHead['branch_id']           = $branch_id;
            $voucherHead['project_id']          = $project_id;
            $voucherHead['department_id']       = $department_id;
            $voucherHead['employee_id']         = $employee_id;
            $voucherHead['salegroup_id']        = $salegroup_id;
            $voucherHead['vat']                 = $tax_amount;
            $voucherHead['imported']            = 'Y';
            $voucherHead['net_amount']          = $amount;
            $voucherHead['warehouse_id']        = $warehouse_id;
            //-------saving receipt header details---------
            $receiptVoucherid =  PostingController::addVoucherhead($voucherHead);
            if ((int)$receiptVoucherid > 0) {
                for (
                    $k = 0;
                    $k < $i;
                    $k++
                ) {
                    PostingController::addVoucheritems($receiptVoucherid, $arr_items[$k]);
                }

                PostingController::addroundoff($receiptVoucherid);

                $voucherModel = new AccVoucher();
                $voucherModel = $voucherModel->findByPK((int) $receiptVoucherid);

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    'POSTED',
                    changes: "(Imported) {$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                );
                // end audit log

                /*  $jsonData['status']             = 'success';
                $jsonData['id']     = (int)$receiptVoucherid; */
            } else {
                /*   $jsonData['status']             = 'error';
                $jsonData[]                     = 'Voucher Header Not Saved'; */
            }
            //  echo CJSON::encode($jsonData);
        } else {
            /*   $error = CJSON::encode($others);
            array_merge_recursive($error, $error1, $error2, $error3, $others)
            if ($error != '[]')
                echo $error; */
        }
        /*   } else {
            $jsonData['status'] = 'Please fill all mandatory fields';
            echo CJSON::encode($jsonData);
        } */
    }



    public static function addPostReceipt_frm_invoicenew($inv_id, $arraypayments)

    {

        //  if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {
        $valid  = true;

        $others = [];
        //check whether voucher type defined
        $model_voucher_type             = new AccVoucherType();
        $model_voucher_type             = $model_voucher_type->find(array('condition' => 'code="RV"'));

        if (empty($model_voucher_type)) {
            $valid          = false;
            $others[]       = 'Voucher Type not defined';
        } else {
            //check whether voucher type details defined
            $modelvoucher_type_details      = new AccVoucherTypeDetails();
            $modelvoucher_type_details      = $modelvoucher_type_details->findAll(array('condition' => 'voucher_type_id=' . (int)$model_voucher_type->id));
            if (empty($modelvoucher_type_details)) {
                $valid          = false;
                $others[]       = 'Voucher Type Details not defined';
            }
            $modelheader         = new Invoice();
            $modelheader         = $modelheader->findByPK((int)$inv_id);


            if (empty($modelheader)) {
                $valid           = false;
                $others[]        = 'Invoice Not Found' . $inv_id;
            }
            //    ------------------------------------
            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger                   = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
            //    ------------------------------------
            $modAccSubledgerType = new AccSubledgerType();
            $subledger_type_id   = $modAccSubledgerType->getIdFromType('C');
            $modAccSubledger     = new AccSubledger();
            $from_subledger      = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $modelheader->customer_id);
            //    ------------------------------------
            $i = 0;
            $usermodel          = new user();
            $usermodel          = $usermodel->findByPK((int)$modelheader->lead_owner_id);
            //    ------------------------------------

            $employee_id        = (int)$usermodel->connected_employee_id;
            $voucherReference   = $modelheader->invoice_no;
            $narration          = 'Receipt Voucher #' . $voucherReference;

            $tot_discount       = 0;
            $round_off_amount   = 0;
            $salegroup_id       = (isset($modelheader->sales_group)) ? $modelheader->sales_group : 0;
            $project_id         = 0;
            $branch_id          = (isset($usermodel->branch_id)) ? $usermodel->branch_id : 0;
            $company_id         = (isset($usermodel->company_id)) ? $usermodel->company_id : 0;
            $payment_term_id    = (isset($modelheader->payment_terms)) ? $modelheader->payment_terms : 0;
            $costcenter_id      = (isset($usermodel->available_warehouses)) ? $usermodel->available_warehouses : 0;
            $department_id      = 0;
            $reference          = $voucherReference; //invoice number



            if ((int)$employee_id > 0) {
                $modelEmployee = new Employee();
                $modelEmployee = $modelEmployee->findByPK((int)$employee_id);
                $department_id = $modelEmployee->department;
            }
            $customer_vendor_id = 0;
            if ((int)$from_subledger > 0) {
                $modelCustomer_subledger = new AccSubledger();
                $modelCustomer_subledger = $modelCustomer_subledger->findByPk((int)$from_subledger);
                $customer_vendor_id      = $modelCustomer_subledger->reference_id;
            }
            $year               = (count(explode('/', $modelheader->invoice_date)) == 3) ? date("Y", strtotime(str_replace('/', '-', $modelheader->invoice_date))) : date('Y');
            // ------------------------------------------

            // $warehouse_id    = (int)$usermodel->available_warehouses;

            $warehouse_id    = $modelheader->warehouse_id;

            $cash_sub_ledger = 0;
            $bank_sub_ledger = 0;
            if ($warehouse_id > 0) {
                $modelMasInventoryWarehouse  = new MasInventoryWarehouse();
                $Warehouse_det = $modelMasInventoryWarehouse->findByPk((int)$warehouse_id);
                $cash_sub_ledger =  (isset($Warehouse_det->cash_ledger)) ? $Warehouse_det->cash_ledger : 0;
                $bank_sub_ledger =  ((isset($Warehouse_det->bank_ledger))) ? $Warehouse_det->bank_ledger : 0;
            }
            $bank_ledger = $modelAccSystemAccountsMapping->getSystemdefault('bank');
            $cash_ledger = $modelAccSystemAccountsMapping->getSystemdefault('cash');

            $modelCustomer = new Customer();
            $customer_vendor_id = $modelheader->customer_id;
            if ($customer_vendor_id > 0) {
                $modelCustomer = Customer::model()->findByPk($customer_vendor_id);
            }
            $customer_ledger_id = ($modelCustomer && isset($modelCustomer->ledger_id)) ? (int)$modelCustomer->ledger_id : 0;
            // ------------------------------------------

            $payment_method = 0;
            if (isset($modelheader->receipt_type)) {
                $modelAccPaymentMode  = new AccPaymentMode();
                $type = $modelAccPaymentMode->find(array('condition' => 'code="' . $modelheader->receipt_type . '"'));
                if (!empty($type)) {
                    $payment_method = $type->id;
                }
            }

            $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
            $from_ledger                   = $modelAccSystemAccountsMapping->getSystemdefault('debtors');

            $arr_items = [];


            // ----------------invoice receipt_type = cash------------------------------------------
            $net_amount = 0;
            foreach ($arraypayments as $pay) {

                $net_amount += (float)$pay['amount'];
                $arr_items[$i]                  = new AccVoucherItems();
                $arr_items[$i]->ledger_id       = $pay['ledger_id'];
                $arr_items[$i]->subledger_id    = (int)$pay['subledger_id'];
                $arr_items[$i]->year            = $year;
                $arr_items[$i]->credit          = '0.00';
                $arr_items[$i]->debit           = ((isset($pay['amount']))) ? abs((float)$pay['amount']) : 0;
                $arr_items[$i]->amount          = ((isset($pay['amount']))) ? (abs((float)$pay['amount'])) : 0;
                $arr_items[$i]->employee_id     = $employee_id;
                $arr_items[$i]->salegroup_id    = $salegroup_id;
                $arr_items[$i]->payment_term_id = $payment_term_id;
                $arr_items[$i]->payment_mode_id = $pay['payment_type_id'];
                $arr_items[$i]->narration       = $narration;
                $arr_items[$i]->project_id      = $project_id;
                $arr_items[$i]->company_id      = $company_id;
                $arr_items[$i]->branch_id       = $branch_id;
                $arr_items[$i]->costcenter_id   = $costcenter_id;
                $arr_items[$i]->department_id   = $department_id;
                $arr_items[$i]->user_id         = (int)$modelheader->lead_owner_id;
                $arr_items[$i]->warehouse_id    = $warehouse_id;
                $arr_items[$i]->bank_name       = $pay['bank_name'];
                $arr_items[$i]->card_no         = $pay['card_no'];
                $arr_items[$i]->cheque_no       = $pay['cheque_no'];
                $arr_items[$i]->cheque_date     = (count(explode('-', $pay['cheque_date'])) == 3) ?  $pay['cheque_date'] : '0000-00-00';
                $i++;
            }


            // --------------debtor----------------------------
            $arr_items[$i]                  = new AccVoucherItems();
            $arr_items[$i]->ledger_id       = ($customer_ledger_id > 0) ? $customer_ledger_id : $from_ledger;
            $arr_items[$i]->subledger_id    = (int)$from_subledger;
            $arr_items[$i]->year            = $year;
            $arr_items[$i]->credit          = abs($net_amount);
            $arr_items[$i]->debit           = '0.00';
            $arr_items[$i]->amount          = -1 * abs($net_amount);
            $arr_items[$i]->employee_id     = $employee_id;
            $arr_items[$i]->salegroup_id    = $salegroup_id;
            $arr_items[$i]->payment_term_id = $payment_term_id;
            $arr_items[$i]->narration       = $narration;
            $arr_items[$i]->project_id      = $project_id;
            $arr_items[$i]->company_id      = $company_id;
            $arr_items[$i]->branch_id       = $branch_id;
            $arr_items[$i]->costcenter_id   = $costcenter_id;
            $arr_items[$i]->department_id   = $department_id;
            $arr_items[$i]->user_id         = (int)$modelheader->lead_owner_id;
            $arr_items[$i]->warehouse_id    = $warehouse_id;
            $i++;


            // ----------------------------------------------------------
        }
        if ($valid) {
            $voucherHead = array();
            $voucherHead['voucher_type']        = $model_voucher_type->id;
            $modelAccVoucherType                = new AccVoucherType;
            $voucherHead['voucher_no']          = $modelAccVoucherType->getVoucherno($model_voucher_type->id, true);
            $voucherHead['transaction_date']    = date('Y-m-d');
            $voucherHead['transaction_number']  = $modelheader->invoice_no;
            $voucherHead['transaction_id']      = $inv_id;
            $voucherHead['reference_no']        = $reference;
            $voucherHead['voucher_date']        =  (count(explode('-', $modelheader->invoice_date)) == 3) ?  $modelheader->invoice_date : date('Y-m-d');
            $voucherHead['narration']           = $narration;
            $voucherHead['currency_id']         = 1;
            $voucherHead['amount']              = $amount - $tax_amount;
            $voucherHead['payment_method']      = $payment_method;
            $voucherHead['payment_terms']       = (isset($modelheader->payment_terms)) ? $modelheader->payment_terms : 0;
            $voucherHead['exchange_rate']       = 1;
            $voucherHead['card_no']             = 0;
            $voucherHead['bank_name']           = '';
            $voucherHead['cheque_no']           = 0;
            $voucherHead['cheque_date']         = '';
            $voucherHead['due_date']            = '';
            $voucherHead['customer_vendor_id']  = $customer_vendor_id;
            $voucherHead['lead_owner']          = (int)$modelheader->lead_owner_id;
            $voucherHead['year']                = $year;
            $voucherHead['company_id']          = $company_id;
            $voucherHead['branch_id']           = $branch_id;
            $voucherHead['project_id']          = $project_id;
            $voucherHead['department_id']       = $department_id;
            $voucherHead['employee_id']         = $employee_id;
            $voucherHead['salegroup_id']        = $salegroup_id;
            $voucherHead['vat']                 = $tax_amount;
            $voucherHead['imported']            = 'Y';
            $voucherHead['net_amount']          = $net_amount;
            $voucherHead['warehouse_id']        = $warehouse_id;
            //-------saving receipt header details---------
            $receiptVoucherid =  PostingController::addVoucherhead($voucherHead);
            if ((int)$receiptVoucherid > 0) {
                for (
                    $k = 0;
                    $k < $i;
                    $k++
                ) {
                    PostingController::addVoucheritems($receiptVoucherid, $arr_items[$k]);
                }

                PostingController::addroundoff((int)$receiptVoucherid);

                $voucherModel = new AccVoucher();
                $voucherModel = $voucherModel->findByPK((int) $receiptVoucherid);

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    'POSTED',
                    changes: "(Imported) {$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                );
                // end audit log

                /*  $jsonData['status']             = 'success';
                $jsonData['id']     = (int)$receiptVoucherid; */
            } else {
                /*   $jsonData['status']             = 'error';
                $jsonData[]                     = 'Voucher Header Not Saved'; */
            }
            //  echo CJSON::encode($jsonData);
        } else {
            /*   $error = CJSON::encode($others);
            array_merge_recursive($error, $error1, $error2, $error3, $others)
            if ($error != '[]')
                echo $error; */
        }
        /*   } else {
            $jsonData['status'] = 'Please fill all mandatory fields';
            echo CJSON::encode($jsonData);
        } */
    }
}
