<?php

class HrController extends Controller
{


    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Generatesalaryvoucher', 'Deletesalaryvoucher', 'Getsubledgerdrop', 'Generatewps', 'Deletewps'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    
    //  public $modelMasCurrency; 

    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }
    

    public function addVoucherhead($arr_items)
    {


        $model                       = new AccVoucher;
        $model->voucher_type         = $arr_items['voucher_type'];
        $model->voucher_no           = $arr_items['voucher_no'];
        $model->voucher_date         = $arr_items['voucher_date'];
        $model->due_date             = (isset($arr_items['due_date'])) ? $arr_items['due_date'] : $model->voucher_date;
        $model->voucher_value        =  $arr_items['total_voucher_amount'];
        $model->net_amount           =  $arr_items['total_voucher_amount'];
        $model->currency_id          = (isset($arr_items['currency'])) ? $arr_items['currency'] : 'AED';
        $model->exchange_rate        = (isset($arr_items['exchange_rate']) && $arr_items['exchange_rate'] > 0) ? $arr_items['exchange_rate'] : 1;
        // ---------------------------------------
        //$model->header_table_id    = $arr_items['header_table_id'];
        $model->transaction_number   = $arr_items['transaction_number'];
        $model->transaction_id       = $arr_items['transaction_id'];


        // ----------------------------------------------------------------
        $model->reference_no         = $arr_items['reference_no'];
        $model->is_posted            = (isset($arr_items['is_posted'])) ? $arr_items['is_posted'] : 'Y';
        $model->created_by           = Yii::app()->user->id;
        $model->created_datetime     = date('Y-m-d h:i:s');
        $model->cheque_cleared       = (isset($arr_items['cheque_cleared'])) ? $arr_items['cheque_cleared'] : 'Y';
        $model->cheque_date          = (isset($arr_items['cheque_cleared'])) ? $arr_items['cheque_date'] : '0000-00-00';
        $model->cheque_no            = $arr_items['cheque_no'];
        $model->imported             = "Y";
        return ($model->save(false)) ? $model->id : 0; //exception
    }

    public function addVoucheritems($headerId, $arr_items)
    {
        $model                         = new AccVoucherItems;
        $model->acc_voucher_id         = $headerId;
        $model->ledger_id              = $arr_items['ledger_id'];
        $model->brand_id               = (int) $arr_items['brand_id'];
        $model->employee_id            = (int) $arr_items['employee_id'];
        $model->subledger_id           = $arr_items['subledger_id'];
        $model->brand_id               = $arr_items['brand_id'];
        $model->narration              = $arr_items['narration'];
        $model->amount                 = $arr_items['amount'];
        $model->credit                 = ($arr_items['amount'] < 0) ? (abs($arr_items['amount'])) : '0.00';
        $model->debit                  = ($arr_items['amount'] > 0) ? ($arr_items['amount']) : '0.00';
        // $model->currency_code          = (isset($arr_items['currency'])) ? $arr_items['currency'] : 'AED';
        $model->currency_id            = (isset($arr_items['currency_id'])) ? $arr_items['currency_id'] : 1;
        $model->exchange_rate          = (isset($arr_items['exchange_rate']) && $arr_items['exchange_rate'] > 0) ? $arr_items['exchange_rate'] : 1;
        $model->opening_cheque_cleared = (isset($arr_items['opening_cheque_cleared'])) ? $arr_items['opening_cheque_cleared'] : 'Y';
        $model->created_by           = Yii::app()->user->id;
        $model->created_datetime     = date('Y-m-d h:i:s');
        $model->save(false);
    }


    // ------------------------------------------------------------
    // from  salary/history  -connect_to_acc
    // -----------------------------------------------------------

    public function actionGeneratesalaryvoucher()
    {

        $id = $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');
        $voucherHead = array();

        /*  function savableDate($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }*/


        if ($id > 0) :
            $mainModel = SalaryProcessing::model()->findBypk($id);
            if ((int) $mainModel->voucher_id == 0) {
                // if (savableDate($mainModel->payroll_enddate)) {
                //$mainModel->items = SalarySlip (hr_salary_slip)
                if (!empty($mainModel->items)) {

                    foreach ($mainModel->items as $i => $each) {

                        $wps_company_id = Employee::model()->find(array('condition' => 'id=' . $each->employee_id))->employee_wps_company;

                        //   echo $this->ciphertext($each->employeedetail->first_name, "d") . " " . $this->ciphertext($each->employeedetail->last_name, "d"); exit;


                        if ($wps_company_id == 1) {
                            // if($wps_company_id == 2){

                            $totalValue = 0;
                            $totalLeaveSettlement = 0;
                            $leaveVoucher = array();
                            $totalLeavesalary = 0;

                            $modAccVoucherType       = new AccVoucherType();
                            $modAccVoucherType_id    = $modAccVoucherType->get_voucher_id('SL');


                            $voucherHead['voucher_type'] = $modAccVoucherType_id; //salary 12
                            $voucherHead['voucher_no'] = AccVoucherType::getVoucherno($modAccVoucherType_id, true);
                            $voucherHead['voucher_date'] = $mainModel->payroll_enddate;

                            // ------------------------------------------
                            $voucherHead['header_table_id'] = $mainModel->id;

                            $voucherHead['transaction_id'] = $mainModel->id;
                            $voucherHead['transaction_number'] = $mainModel->id;
                            // ------------------------------------------
                            $voucherHead['reference_no'] = 'System generated voucher';
                            $voucherHead['is_posted'] = 'Y';
                            $voucherHead['created_by'] = Yii::app()->user->id;
                            $voucherHead['created_datetime'] = date('Y-m-d h:i:s');




                            $lastSavedid = $this->addVoucherhead($voucherHead);

                            $itemsArray = array();
                            $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                            $itemsArray['subledger_id'] = $each->generateAccSubledger();
                            $itemsArray['narration'] = 'Salary for month ' . $mainModel->payroll_month;
                            $itemsArray['amount'] = -1 * ($each->employee_salary_amount + $each->overtime_amount + $each->other_addition - $each->other_deduction - $each->leave_amount - $each->salary_advance_amount - $each->before_joining_salary + $each->annual_leave_addition - $each->annual_leave_deduction);
                            $itemsArray['employee_id'] = $each->generateAccSubledger();
                            if ($itemsArray['amount'] < 0) :
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                                $totalValue += abs($itemsArray['amount']);

                                //Loan Deduction
                                if ($each->loan_amount > 0) :
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Loan deduction for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = $each->loan_amount;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_loan');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Loan collected for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = -1 * $each->loan_amount;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                endif;

                                //Loan Payment with Salary Posting
                                /* if ($each->sanctioned_loan_amount > 0):

                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_loan');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Loan to employee ';
                                    $itemsArray['amount'] = $each->sanctioned_loan_amount;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                    
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Loan to employee ';
                                    $itemsArray['amount'] = -1*$each->sanctioned_loan_amount;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                    
                                endif;*/


                                //Pension Payable
                                if ($each->pension_amount > 0) :
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Pension deduction for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = $each->pension_amount_employee;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_pension');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Pension share for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = -1 * $each->pension_amount;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $totalValue += abs($each->pension_amount_company);
                                endif;

                                //Leave settlement
                                if ($each->leave_settlement > 0) :
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Leave Settlement for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = -1 * $each->leave_settlement;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                    $totalLeaveSettlement += $each->leave_settlement;
                                endif;

                                //Leave salary Provision
                                if ($each->annual_leave_deduction > 0) :
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Leave salary for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = $each->annual_leave_deduction;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_leave_expense');
                                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                                    $itemsArray['narration'] = 'Leave salary for month ' . $mainModel->payroll_month;
                                    $itemsArray['amount'] = -1 * $each->annual_leave_deduction;
                                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                endif;

                            endif;

                            if ($totalValue > 0) :
                                //Total Salary
                                $itemsArray = array();
                                $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('salary_provison');
                                $itemsArray['subledger_id'] = 0;
                                $itemsArray['narration'] = 'Salary for month ' . $mainModel->payroll_month;
                                $itemsArray['amount'] = (float) $totalValue;
                                $itemsArray['employee_id'] = $each->generateAccSubledger();
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                            endif;

                            //Leave settlement
                            if ($totalLeaveSettlement > 0) :
                                $itemsArray = array();
                                $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_leave_salary_prov');
                                $itemsArray['subledger_id'] = 0;
                                $itemsArray['narration'] = 'Leave Settlement for month ' . $mainModel->payroll_month;
                                $itemsArray['amount'] = $totalLeaveSettlement;
                                $itemsArray['employee_id'] = $each->generateAccSubledger();
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                            endif;

                            AccVoucher::model()->updateBypk($lastSavedid, array('net_amount' => $totalValue, 'voucher_value' => $totalValue));
                        }



                        //AALV Voucher
                        // if( $totalLeavesalary > 0 ) :
                        //     generateLeave($lastSavedid, $leaveVoucher);
                        // endif;
                        $mainModel->posted = 'Y';
                        $mainModel->voucher_id = $lastSavedid;
                        $mainModel->posted_date = date('Y-m-d');
                        $mainModel->update();

                        $response['status'] = 'success';
                        $response['msg'] = 'Success';
                    }
                } else {
                    $response['msg'] = 'No data!';
                }
                // } else {
                //     $response['msg'] = 'Year is closed!';
                // }
            } else {
                $response['msg'] = 'Voucher is already posted!';
            }
        endif;
        echo json_encode($response);
    }


    // ------------------------------------------------------------
    // from  salary/history  -connect_to_acc
    // -----------------------------------------------------------

    public function actionDeletesalaryvoucher()
    {
        $id = $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        /*function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }*/

        if ($id > 0) {
            $mainModel = SalaryProcessing::model()->findBypk($id);
            if ($mainModel->posted == "Y") {
                //if(isPostable($mainModel->payroll_enddate)) {

                $modAccVoucherType                   = new AccVoucherType();
                $modAccVoucherType_id                     = $modAccVoucherType->get_voucher_id('SL');



                $model = AccVoucher::model()->findAll(array('condition' => 'transaction_id="' . $mainModel->id . '" AND voucher_type="' . $modAccVoucherType_id . '" '));
                foreach ($model as $eachModel) {
                    AccVoucher::model()->deleteBypk($eachModel->id);
                    AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $eachModel->id));
                }
                $mainModel->posted = 'N';
                $mainModel->voucher_id = 0;
                $mainModel->posted_date = '0000-00-00';
                $mainModel->update();
                $response['status'] = 'success';
                $response['msg'] = 'Success';
                //}
                // else {
                //         $response['msg'] = 'Cannot unpost voucher, Audited!';
                //     }

            } else {
                $response['msg'] = 'Already unposted!';
            }
        }

        echo json_encode($response);
    }


    // ------------------------------------------------------------
    // from  salarysif/index&type=  -connect_to_acc
    // -----------------------------------------------------------



    public function actionGeneratewps()
    {

        $sif_head = (int) $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        if ($sif_head > 0) {
            $model = MonthlySalarySif::model()->findBypk($sif_head);
            $totalAmount = 0;
            if ($model->posted == 'N') {
                $type = $model->salary_payment_mode;

                switch ($type) {
                    case 1:
                        $account = AccSystemAccountsMapping::getSystemdefault('cash_account');
                        $subledger_account = AccSystemAccountsMapping::getSystemdefault_subledger('cash_account');
                        break;
                    case 2:

                        $account = AccSystemAccountsMapping::getSystemdefault('employee_wps');
                        $subledger_account = AccSystemAccountsMapping::getSystemdefault_subledger('employee_wps');
                        break;
                    case 3:
                        $account = AccSystemAccountsMapping::getSystemdefault('employee_wps');
                        $subledger_account = AccSystemAccountsMapping::getSystemdefault_subledger('employee_wps');
                        break;
                    case 4:
                        $account = AccSystemAccountsMapping::getSystemdefault('employee_wps');
                        $subledger_account = AccSystemAccountsMapping::getSystemdefault_subledger('employee_wps');
                        break;
                }
                foreach ($model->items as $each) {

                    $voucherHead = array();
                    $modAccVoucherType                   = new AccVoucherType();
                    $modAccVoucherType_id                     = $modAccVoucherType->get_voucher_id('WPS');


                    $voucherHead['voucher_type'] = $modAccVoucherType_id; //WPS
                    $voucherHead['voucher_no'] = AccVoucherType::getVoucherno($modAccVoucherType_id, true);
                    $voucherHead['voucher_date'] = $model->date;
                    // $voucherHead['header_table_id'] = $model->id;
                    $voucherHead['transaction_id'] = $model->id;
                    $voucherHead['transaction_number'] = $model->id;
                    $voucherHead['reference_no'] = 'System generated voucher';
                    $voucherHead['is_posted'] = 'Y';
                    $voucherHead['total_voucher_amount'] = $each->total;
                  //  $voucherHead['cheque_no'] = $model->cheque_no;
                   // $voucherHead['cheque_date'] = $model->cheque_date;
                    $voucherHead['created_by'] = Yii::app()->user->id;
                    $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                    if ($type == 2) {
                        $voucherHead['cheque_cleared'] = 'N';
                    }
                    $lastSavedid = $this->addVoucherhead($voucherHead);

                    $totalAmount = $each->total;
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = AccSystemAccountsMapping::getSystemdefault('employee_salary');
                    $itemsArray['subledger_id'] = $each->generateAccSubledger();
                    $itemsArray['narration'] = 'Salary for month ' . $model->salary_month;
                    $itemsArray['amount'] = $each->total;
                    $itemsArray['employee_id'] = $each->generateAccSubledger();
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    $totalAmount = $each->total;
                    if ($type == 2) {
                        $itemsArray = array();
                        $itemsArray['ledger_id'] = $account;
                        $itemsArray['subledger_id'] = $subledger_account;
                        $itemsArray['narration'] = 'Salary for month ' . $model->salary_month;
                        $itemsArray['amount'] = -1 * $each->total;
                        $itemsArray['opening_cheque_cleared'] = 'N';
                        $this->addVoucheritems($lastSavedid, $itemsArray);
                    }
                    if ($type == 4) {
                        $itemsArray = array();
                        $itemsArray['ledger_id'] = $account;
                        $itemsArray['subledger_id'] = $subledger_account;
                        $itemsArray['narration'] = 'Salary for month ' . $model->salary_month;
                        $itemsArray['amount'] = -1 * $each->total;


                        $itemsArray['opening_cheque_cleared'] = 'N';
                        $this->addVoucheritems($lastSavedid, $itemsArray);
                    }

                    if ($type != 2 && $type != 4) {
                        if ($type == 3) {
                           // $subledger_account = $model->wpscompany_detail->fin_bank_subledger_id;
                            $subledger_account = 0;
                        }
                        $itemsArray = array();
                        $itemsArray['ledger_id'] = $account;
                        $itemsArray['subledger_id'] = $subledger_account;
                        $itemsArray['narration'] = 'Salary for month ' . $model->salary_month;
                        $itemsArray['amount'] = -1 * $model->total_amount;
                        $this->addVoucheritems($lastSavedid, $itemsArray);
                    }
                }



                $model->posted = 'Y';
                $model->posted_on = date('Y-m-d');
                $model->voucher_id = $lastSavedid;
                $model->update();

                $response['status'] = 'success';
                $response['msg'] = 'Success';
            } else {
                $response['msg'] = 'Already Posted!';
            }
        } else {
            $response['msg'] = 'Invalid!';
        }
        echo json_encode($response);
    }



    // ------------------------------------------------------------
    // from  salarysif/index&type=4  -connect_to_acc
    // -----------------------------------------------------------


    public function actionDeletewps()
    {
        $sif_head = (int) $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        /*  function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }*/

        if ($sif_head > 0) {
            $mainModel = MonthlySalarySif::model()->findBypk($sif_head);
            if ($mainModel->posted == 'Y' && $mainModel->voucher_id > 0) {

                $modAccVoucherType                   = new AccVoucherType();
                $modAccVoucherType_id                     = $modAccVoucherType->get_voucher_id('WPS');

                $model = AccVoucher::model()->findAll(array('condition' => 'transaction_id="' . $mainModel->id . '" AND voucher_type="' . $modAccVoucherType_id . '"'));
                foreach ($model as $eachModel) {
                    //if (isPostable($eachModel->voucher_date)) {

                    AccVoucher::model()->deleteBypk($eachModel->id);
                    AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $eachModel->id));
                    // }
                }
                $mainModel->posted = 'N';
                $mainModel->posted_on = '0000-00-00';
                $mainModel->voucher_id = 0;
                $mainModel->update();

                $response['status'] = 'success';
                $response['msg'] = 'Success';
            } else {
                $response['msg'] = 'Already Unposted!';
            }
        } else {
            $response['msg'] = 'Invalid!';
        }
        echo json_encode($response);
    }
}
