<?php
/*
created by indhu  on 16-01-2023
 */
class ChequeController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    // ---------------------------------------------------
                    'Reconciliationlist', 'Chequemanagementnew', 'Get_uncleared_pdc_new', 'Savechequesnew', 'Get_reconciliation_history', 'Printreconciliation', 'Deletereconciliation',
                    // ---------------------------------------------------
                    'Chequemanagement', 'Get_uncleared_pdc',
                    // ---------------------------------------------------
                    'Chequestatuschange', 'Get_cleared_pdc',
                    // ---------------------------------------------------
                    'Bouncedchequestatuschange', 'Get_bounced_pdc','GetUnclearedPdc_pdf','GetUnclearedPdc_excel'
                    // ---------------------------------------------------

                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */

    /* public $modelMasCurrency; 

     public function init()
     {
         parent::init();
         $this->modelMasCurrency = new MasCurrency();
     }*/
 

    // -----------------------------------------------------------------------------------------------------------
    //Reconciliation
    //------------------------------------------------------------------------------------------------------------

    public function actionReconciliationlist()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_reconciliation_history_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_reconciliation_history_menu_view']
        )
    ) {
        $this->render('reconciliation_index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}

    public function actionChequemanagementnew()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_management_new');
    }


    public function actionGet_uncleared_pdc_new()
    {
        $from_date       = $_REQUEST['from_date'];
        $to_date         = $_REQUEST['to_date'];
        $bank_id         = (int) $_REQUEST['bank'];
        $status          = $_REQUEST['status'];
        $bank_total_amt  = 0;
        $count           = 0;
        $from_date       = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date         = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');
        $response        = '';
        $legder          = AccSystemAccountsMapping::getSystemdefault('pdc_r') . ',' . AccSystemAccountsMapping::getSystemdefault('pdc_i');
        $bank            = AccSystemAccountsMapping::getSystemdefault('bank');
        $opening_balance = Yii::app()->db->createCommand('select ROUND(SUM(I.amount*I.exchange_rate),2) from {{acc_voucher_items}} I INNER JOIN {{acc_voucher}} H ON H.id=I.acc_voucher_id where ledger_id=' . $bank . ' AND subledger_id=' . $bank_id . ' AND H.voucher_date<="' . $to_date . '" AND H.is_posted="Y"')->queryScalar();
        if ($status == 'N') {
            $opening_balance_bank_rec = Yii::app()->db->createCommand('select ROUND(SUM(I.amount*I.exchange_rate),2) from {{acc_voucher_items}} I INNER JOIN {{acc_voucher}} H ON H.id=I.acc_voucher_id where ledger_id=' . $bank . ' AND subledger_id=' . $bank_id . ' AND  H.voucher_date<="' . $to_date . '"' . '  AND H.is_posted="Y"')->queryScalar();
        } else {
            $opening_balance_bank_rec = Yii::app()->db->createCommand('select ROUND(SUM(I.amount*I.exchange_rate),2) from {{acc_voucher_items}} I INNER JOIN {{acc_voucher}} H ON H.id=I.acc_voucher_id where ledger_id=' . $bank . ' AND subledger_id=' . $bank_id . ' AND I.reconciled="Y" AND I.reconciled_date<"' . $from_date . '"' . ' AND I.reconciled_date!="0000-00-00" AND H.is_posted="Y"')->queryScalar();
        }
        if ($status == 'N') {
            $items = AccVoucherItems::model()->with('parent')->findAll((array('condition' => 'parent.is_posted="Y" AND t.ledger_id=' . $bank . ' AND subledger_id=' . $bank_id . ' AND (parent.voucher_date<="' . $to_date . '") AND ( t.reconciled!="Y" OR ( t.reconciled="Y" AND t.reconciled_date>"' . $to_date . '"))')));
        } else if ($status == 'Y') {
            $items = AccVoucherItems::model()->with('parent')->findAll((array('condition' => 'parent.is_posted="Y" AND t.ledger_id=' . $bank . ' AND subledger_id=' . $bank_id . ' AND t.reconciled="Y" AND (parent.voucher_date>="' . $from_date . '" AND parent.voucher_date<="' . $to_date . '")')));
        } else if ($status == 'ALL') {
            $items = AccVoucherItems::model()->with('parent')->findAll((array('condition' => 'parent.is_posted="Y" AND t.ledger_id=' . $bank . ' AND subledger_id=' . $bank_id . ' AND (parent.voucher_date>="' . $from_date . '" AND parent.voucher_date<="' . $to_date . '")')));
        }
        $received = 0;
        $paid = 0;
        if (!empty($items)) {
            foreach ($items as $i => $each) {
                if (($each->reconciled_date != '0000-00-00') && ($each->reconciled == 'Y')) {
                    $assigned_date = date('d/m/Y', strtotime($each->reconciled_date));
                    $as_val = $assigned_date;
                } else {
                    $assigned_date = date('d/m/Y', strtotime($each->parent->voucher_date));
                    $as_val = '';
                }
                $bank = '';
                $options = AccSubledger::getSubledgers(AccLedger::getBankId());
                if ($type == 2) {
                    $bank = $each->subledger_id;
                    $options = array($each->subledger_id => $each->subledger->subledger_name);
                }
                if ($each->amount > 0) {
                    $prefix = 'Dr';
                } else {
                    $prefix = 'Cr';
                }
                $ass_date_id = '#ClearedCheque_' . $each->id . '_cheque_date';
                $ass_date_value = $assigned_date;
                $check_id = '#Cleared_' . $i . '_check';
                $item = 'calculateValue("' . $ass_date_id . '","' . $ass_date_value . '","' . $check_id . '")';
                $voucher_items = AccVoucherItems::model()->findAll(array('condition' => 'id!=' . $each->id . ' AND acc_voucher_id=' . $each->acc_voucher_id));
                
                
                $other_accounts = '';
                foreach ($voucher_items as $z => $vitems) {
                    if ($z == 0) {
                        $other_accounts .= $vitems->ledger->ledger_acc_name . ' (' . $vitems->subledger->subledger_name . ')';
                    } else {
                        $other_accounts .= ', ' . $vitems->ledger->ledger_acc_name . ' (' . $vitems->subledger->subledger_name . ')';
                    }
                }
                if ($each->amount < 0) {
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id, 'class' => 'checkbox', 'onclick' => 'calculateValue("' . $ass_date_id . '","' . $ass_date_value . '","' . $check_id . '")')) . '</td>
                                    <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][cheque_date]', $as_val, array("data-label" => "Date", "class" => "datepicker")) . '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $other_accounts . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenField('ClearedCheque[' . $each->id . '][values]', $each->amount * $each->exchange_rate) . CHtml::hiddenField('ClearedCheque[' . $i . '][as_date_id]', $ass_date_id) . CHtml::hiddenField('ClearedCheque[' . $i . '][as_date]', $ass_date_value) . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $bank_total_amt += $each->amount * $each->exchange_rate;
                    $paid += -1 * $each->amount * $each->exchange_rate;
                } else {
                    $response .= '<tr>
                        <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id, 'class' => 'checkbox', 'onclick' => 'calculateValue("' . $ass_date_id . '","' . $ass_date_value . '","' . $check_id . '")')) . '</td>
                        <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][cheque_date]', $as_val, array("data-label" => "Date", "class" => "datepicker")) . '</td>
                        <td>' . $each->parent->fullvoucher . '</td>
                        <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                        <td>' . $each->parent->cheque_no . '</td>
                        <td>' . $other_accounts . '</td>
                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenField('ClearedCheque[' . $each->id . '][values]', $each->amount * $each->exchange_rate) . CHtml::hiddenField('ClearedCheque[' . $i . '][as_date_id]', $ass_date_id) . CHtml::hiddenField('ClearedCheque[' . $i . '][as_date]', $ass_date_value) . '</td>
                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                        <td>' . $each->narration . '</td>
                     </tr>';
                    $bank_total_amt += $each->amount * $each->exchange_rate;
                    $received += $each->amount * $each->exchange_rate;
                }
                $count++;
            }
        } else {
            $response .= '<tr>
                                <td colspan="9" class="text-center"> No Data</td>
                            </tr>';
        }
        $bank_total_amt += $opening_balance_bank_rec;
        // echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count,'opening_balance'=>$opening_balance,'bank_total_amount'=>$bank_total_amt,'paid'=>$paid,'received'=>$received,'opening_balance_bank_rec'=>$opening_balance_bank_rec));
        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count, 'opening_balance' => ($opening_balance_bank_rec), 'bank_total_amount' => $bank_total_amt, 'paid' => $paid, 'received' => $received, 'opening_balance_bank_rec' => $opening_balance_bank_rec));
    }



    public function actionSavechequesnew()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int)AccSystemAccountsMapping::getSystemdefault('bank');
        $subledger_id = (int) $_POST['bank'];
        //        $type = (int) $_POST['type'];
        //        $clearing_account = ($type == 1) ? AccSystemAccountsMapping::getSystemdefault('pdc_r') : AccSystemAccountsMapping::getSystemdefault('pdc_i');
        //        $clearing_value = ($type == 1) ? -1 : 1;
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));

            $totalValue = 0;
            $arr_cheques = array();
            foreach ($items as $each) {
                $ledger_id = (int)AccLedger::getBankId();
                $cleared_date = $_POST['ClearedCheque'][$each]['cheque_date'];
                $cleared_value = $_POST['ClearedCheque'][$each]['values'];
                $clearing_value = ($cleared_value > 0) ? -1 : 1;
                $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : '0000-00-00';
                if ($ledger_id > 0 && $subledger_id > 0) {
                    $model = AccVoucherItems::model()->findBypk($each);
                    $model->reconciled_date = $cleared_date;
                    if ($cleared_date == '0000-00-00') {
                        $model->reconciled = 'N';
                    } else {
                        $model->reconciled = 'Y';
                    }
                    $model->update();
                    $bank_item_id = $model->id;
                    //Reconciliation
                    AccReconciliation::model()->deleteAll(array('condition' => 'funds_in_ids=' . $bank_item_id . ' OR funds_out_ids=' . $bank_item_id));
                    if ($cleared_date != '0000-00-00') {
                        $model = new AccReconciliation;
                        $model->statement_date = date('Y-m-d');
                        $model->ledger_id = $ledger_id;
                        $model->subledger_id = $subledger_id;
                        if ($clearing_value > 0) {
                            $model->funds_in_ids = $bank_item_id;
                        } else {
                            $model->funds_out_ids = $bank_item_id;
                        }
                        $model->created_by = Yii::app()->user->id;
                        $model->created_date_time = date('Y-m-d h:i:s');
                        $model->save(false);
                    }
                }
            }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }

            echo json_encode($response);
        }
    }



    public function actionGet_reconciliation_history()
    {
        $model = new AccReconciliation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $searchString = trim($_POST['search']['value']);
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.statement_date',
            2 => 'ledger.ledger_acc_name',
            3 => 'subledger.subledger_name',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition = 't.statement_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($searchString != "") {
            $condition .= ' AND ( t.id LIKE "%' . $searchString . '%" OR ledger.ledger_acc_name LIKE "%' . $searchString . '%" OR subledger.subledger_name LIKE "%' . $searchString . '%" )';
        }

        $count = $model->with('ledger', 'subledger')->count(array('condition' => $condition));
        $model = $model->with('ledger', 'subledger')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {

            $div = '<div class="btn-wrap text-center">';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_reconciliation_history_delete"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Delete Allocation" onclick="deleteReconciliation(' . $eachItem['id'] . ')"><i class="fa fa-remove"></i></button>';
            }

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_reconciliation_history_print"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=accounts/cheque/printreconciliation&id=' . $eachItem['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            }

            $div .= '</div>';
            if ($eachItem->funds_in_ids != '' || $eachItem->funds_out_ids != '') {
                $vouchers = '';
                $cheque_no = '';
                $in_arr = explode(",", $eachItem->funds_in_ids);
                $out_arr = explode(",", $eachItem->funds_out_ids);
                //in
                if (!empty($in_arr)) {
                    foreach ($in_arr as $each_in) {
                        $in_fin_items = AccVoucherItems::model()->findByPk((int)$each_in);
                        if (!empty($in_fin_items)) {
                            if ($vouchers == '') {
                                $vouchers .= $in_fin_items->parent->vtype->code . '/' . $in_fin_items->parent->voucher_no;
                            } else {
                                $vouchers .= ',' . $in_fin_items->parent->vtype->code . '/' . $in_fin_items->parent->voucher_no;
                            }
                            if ($cheque_no == '') {
                                $cheque_no .= $in_fin_items->parent->cheque_no;
                            } else {
                                $cheque_no .= ',' . $in_fin_items->parent->cheque_no;
                            }
                        }
                    }
                }
                //out
                if (!empty($out_arr)) {
                    foreach ($out_arr as $each_out) {
                        $in_fin_items = AccVoucherItems::model()->findByPk($each_out);
                        if (!empty($in_fin_items)) {
                            if (empty($vouchers)) {
                                $vouchers .= $in_fin_items->parent->vtype->code . '/' . $in_fin_items->parent->voucher_no;
                            } else {
                                $vouchers .= ',' . $in_fin_items->parent->vtype->code . '/' . $in_fin_items->parent->voucher_no;
                            }
                            if (empty($cheque_no)) {
                                $cheque_no .= $in_fin_items->parent->cheque_no;
                            } else {
                                $cheque_no .= ',' . $in_fin_items->parent->cheque_no;
                            }
                        }
                    }
                }
            }
            // $vouchers=$eachItem->funds_in_ids;
            // $cheque_no=$eachItem->funds_out_ids;
            $eachItemData[] = array($eachItem['id'], date('d/m/Y', strtotime($eachItem['statement_date'])), $eachItem['ledger']['ledger_acc_name'], $eachItem['subledger']['subledger_name'], $vouchers, $div);
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }



    public function actionPrintreconciliation()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = AccReconciliation::model()->findBypk($id);

          
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $page_name = 'reconciliation_pdf';
            $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name,  array('model' => $model), true));



            //  $mpdf->WriteHTML($this->renderPartial('reconciliation_pdf', array('model' => $model), true));
            $mpdf->Output(date('dmYhis'), 'I');
        } else {
            echo 'Oops!';
        }
    }


    public function actionDeletereconciliation()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = AccReconciliation::model()->findBypk($id);
            if ($model->funds_in_ids != '') {
                //  Yii::app()->db->createCommand('UPDATE {{acc_voucher_items}} SET reconciled="N", reconciliation_id=0,  reconciled_date="0000-00-00" WHERE id IN(' . $model->funds_in_ids . ')')->execute();
                Yii::app()->db->createCommand('UPDATE {{acc_voucher_items}} SET reconciled="N",  reconciled_date="0000-00-00" WHERE id IN(' . $model->funds_in_ids . ')')->execute();
            }

            if ($model->funds_out_ids != '') {
                //  Yii::app()->db->createCommand('UPDATE {{acc_voucher_items}} SET reconciled="N", reconciliation_id=0,  reconciled_date="0000-00-00" WHERE id IN(' . $model->funds_out_ids . ')')->execute();
                Yii::app()->db->createCommand('UPDATE {{acc_voucher_items}} SET reconciled="N",  reconciled_date="0000-00-00" WHERE id IN(' . $model->funds_out_ids . ')')->execute();
            }

            AccReconciliation::model()->deleteBypk($id);
        }
        echo 'success';
    }

    // -----------------------------------------------------------------------------------------------------------
    //cheque management
    //------------------------------------------------------------------------------------------------------------


    public function actionChequemanagement()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_management');
    }


    public function actionGet_uncleared_pdc()
    {
        $from_date = $_POST['from_date'];
        $to_date   = $_POST['to_date'];
        $type      = (int) $_POST['type'];


        $count     = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date   = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder   = ($type == 1) ? AccSystemAccountsMapping::getSystemdefault('pdc_r') : AccSystemAccountsMapping::getSystemdefault('pdc_i');



        if ($legder > 0) {
            $condition = '(parent.voucher_type=' . AccVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="N" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="N" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ';
                
            $items = AccVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.cheque_date ASC'));

            if (!empty($items)) {
                foreach ($items as $i => $each) {
                    
                    
                    $assigned_date = date('d/m/Y', strtotime($each->parent->voucher_date));
                    $cheque_date = ($each->parent->cheque_date!=="0000-00-00")?date('d/m/Y', strtotime($each->parent->cheque_date)):"00/00/0000";
                   
                    
                    $bank = '';
                   // $options = AccSubledger::getSubledgers(AccLedger::getBankId());
                    
                    $options = AccLedger::getBankIdlist();
                   /* if ($type == 2) {
                        $bank = $each->subledger_id;
                        $options = array($each->subledger_id => $each->subledger->subledger_name);
                    }*/
                    
                    

                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id, 'class' => 'checkbox')) . '</td>
                                    <td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . CHtml::hiddenField('ClearedCheque[' . $each->id . '][voucher_date]',$each->parent->voucher_date, array()) . '</td>                                 
                                    <td>' .CHtml::textField('ClearedCheque[' . $each->id . '][cheque_date]', $cheque_date, array('class' => 'datepicker')) . '</td>
                                    <td>' . CHtml::dropdownlist('ClearedCheque[' . $each->id . '][subledger_id]', $bank, $options, array('class' => 'tooltipster', 'data-label' => 'Bank')) . '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $each->subledger->subledger_name . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="9" class="text-center"> No Data</td>
                            </tr>';
            }
        } else {
            $response .= '<tr>
                                <td colspan="9" class="text-center"> Please map accounts Properly</td>
                            </tr>';
        }

        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count));
    }

    // -----------------------------------------------------------------------------------------------------------
    //Cheque status change
    //------------------------------------------------------------------------------------------------------------

    public function actionChequestatuschange()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_statuschange');
    }


    public function actionGet_cleared_pdc()
    {
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $type = (int) $_POST['type'];

        $count = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder = ($type == 1) ? AccSystemAccountsMapping::getSystemdefault('pdc_r') : AccSystemAccountsMapping::getSystemdefault('pdc_i');
        if ($legder > 0) {
            // original
            $items = AccVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . AccVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="Y" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ', 'order' => 'parent.cheque_date ASC'));


            if (!empty($items)) {
                foreach ($items as $i => $each) {
                    $assigned_date = date('d/m/Y', strtotime(($each->parent->cheque_date != '0000-00-00') ? $each->parent->cheque_date : $each->parent->voucher_date));
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id, 'class' => 'checkbox')) . '</td>
                                    <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][cleared_date]', $assigned_date, array("data-label" => "Return Date", "class" => "datepicker")) . '</td>
                                    <td>' . CHtml::dropdownlist('ClearedCheque[' . $each->id . '][subledger_id]', '', AccSubledger::getSubledgers(AccLedger::getBankId()), array('class' => 'tooltipster', 'data-label' => 'Bank')) . '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $each->subledger->subledger_name . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="9" class="text-center"> No Data</td>
                            </tr>';
            }
        } else {
            $response .= '<tr>
                                <td colspan="9" class="text-center"> Please map accounts Properly</td>
                            </tr>';
        }

        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count));
    }
    // -----------------------------------------------------------------------------------------------------------
    //Bounced cheque status change
    //------------------------------------------------------------------------------------------------------------

    public function actionBouncedchequestatuschange()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('bounced_cheque_statuschange');
    }

    public function actionGet_bounced_pdc()
    {
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $type = (int) $_POST['type'];

        $count = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder = ($type == 1) ? AccSystemAccountsMapping::getSystemdefault('pdc_r') : AccSystemAccountsMapping::getSystemdefault('pdc_i');
        if ($legder > 0) {
            $items = AccVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . AccVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="Y" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ', 'order' => 'parent.cheque_date ASC'));

            // $items = AccVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . AccVoucherType::get_voucher_id('JV') . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="Y" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ', 'order' => 'parent.cheque_date ASC'));

            if (!empty($items)) {
                foreach ($items as $i => $each) {
                    $assigned_date = date('d/m/Y', strtotime(($each->parent->cheque_date != '0000-00-00') ? $each->parent->cheque_date : $each->parent->voucher_date));
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id, 'class' => 'checkbox')) . '</td>
                                    <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][resubmit_date]', $assigned_date, array("data-label" => "Resubmit Date", "class" => "datepicker")) . '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $each->subledger->subledger_name . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="7" class="text-center"> No Data</td>
                            </tr>';
            }
        } else {
            $response .= '<tr>
                                <td colspan="7" class="text-center"> Please map accounts Properly</td>
                            </tr>';
        }

        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count));
    }


    public function actionGetUnclearedPdc_pdf()
    {
        $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $type          = $_REQUEST['type'];

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $page_name = 'get_unclearedPdc_pdf';
        $param = array(
            'from_date'    => $from_date,
            'to_date'      => $to_date,
            'type'         => $type,
        );
        $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name, $param, true));
        $mpdf->Output("TBReport" . date("d-m-Y") . ".pdf", 'I');
    }

    public function actionGetUnclearedPdc_excel()
    {
        $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $type           = $_REQUEST['type'];
        $param = array(
            'from_date'    => $from_date,
            'to_date'      => $to_date,
            'type'         => $type,
        );
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'get_uclearedPdc_excel.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.modules.accounts.views.reports.excel.get_uclearedPdc_excel', $param, false, true);
        Yii::app()->end();
    }

    //end
}
