<?php
/*
 chart of accounts
 Ledger Create, Save 
 date 21-09-2022
 author -Nisha
 updated by - indhu
 main setup
 Main Tables - erp_acc_ledger,
 Main models used - AccLedger
 */


class AccountsController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Ledgers',
                    'getAllSubLedger',
                    'Getledgers',
                    'createledger',
                    'GetAllLedger',
                    'Getaccountno',
                    'Subledgertype',
                    'createsubledgerType',
                    'Saveledger',
                    'Deleteledger',
                    'GetLedgerDetails',
                    'Getsubledgerdrop',
                    'GetLedgersSubledger',
                    'systemmapping',
                    'Getsubledgers',
                    'savemapping',
                    'Saveloopledger',
                    'Getsubledgerdropitems',
                    'Getledgerssubledgerdropnew',
                    'Auditclosing',
                    'Closeyear_preaudit',
                    'Unlockyear_preaudit',
                    'Closeyear_finalaudit',
                    'Unlockyear_finalaudit',
                    'GetsubledgerdropNew',
                    'GetledgersPaymentMode',
                    'GetSubLedgerDetails',
                    'GetSublegerByLedgerDetails'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    // public $modelMasCurrency;

    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }



    public function actionLedgers()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_ledgers_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_ledgers_menu_view']
        )
    ) {
        $this->render('ledger');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}

    public function actionGetledgers()
    {
        $model   = new AccLedger();
        $draw    = $_POST['draw'];
        $offset  = $_POST['start'];
        $limit   = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'ledger_acc_no',
            1 => 'ledger_acc_name',
            2 => 'have_subledger',
            3 => 'is_parent',
            4 => 'id',
            5 => 'ledger_parent_acc',
            6 => 'level',
            7 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy     = $filterColumn . " " . $filterOrder;
        $condition   = '1=1';
        if ($_POST['parent_account'] > 0) {
            $condition .= ' AND ledger_parent_acc=' . $_POST['parent_account'];
        }
        if(!empty($_POST['classification'])){           
            $condition .= " AND classification='" .$_POST['classification']. "'";
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (ledger_acc_no LIKE "%' . $searchString . '%" OR ledger_acc_name LIKE "%' . $searchString . '%")';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        function getGroup($type)
        {
            $groups = array('A' => 'Assets', 'L' => 'Equity & Liabilities', 'I' => 'Income', 'E' => 'Expense');
            return $groups[$type];
        }

        foreach ($model as $eachItem) {

            $SQL = 'SELECT *   FROM {{acc_voucher_items}} WHERE `ledger_id` = ' .  $eachItem['id'] . ' LIMIT 1';
            $voucher_items_det = Yii::app()->db->createCommand($SQL)->queryAll();


            $modelAccLedger = new AccLedger();
            $parent  = $modelAccLedger->getParent($eachItem['ledger_parent_acc']);

            $div        = '<div class="btn-wrap text-center">';
            if ($eachItem['system_generated'] == 'N') {
                // -----------------------------------------------------------------
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_ledgers_edit"])) {
                    $div       .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'accounts/accounts/createledger&id=' . $eachItem['id'] . '\',\' ' . addslashes($eachItem['ledger_acc_name']) . ' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                }
                // -----------------------------------------------------------------
            }

            if ($eachItem['is_parent'] == "N"  && $eachItem['system_generated'] == "N" && empty($voucher_items_det)) {
                // -----------------------------------------------------------------
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_ledgers_delete"])) {
                    $div   .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteAccount(' . $eachItem['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                }
                // -----------------------------------------------------------------
            }
            $div       .= '</div>';
            $eachItemData[] = array($eachItem['ledger_acc_no'], $eachItem['ledger_acc_name'], ($eachItem['have_subledger'] == "Y") ? 'Yes' : 'No', ($eachItem['is_parent'] == "Y") ? 'Yes' : 'No', getGroup($eachItem['ledger_main_acc']),  $parent, $eachItem['level'], $div);
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }




    public function actionSaveledger()
    {
        // print_r($_POST['AccLedger']['root']); exit;
        $oldParent            = 0;
        $oldledger_parent_acc = 0;
        $oldlis_parent        = 0;
        $error1 = array();
        $other  = array();
        $valid1 = true;
        $model  = new AccLedger;
        $valid  = true;

        if ((int) $_POST['AccLedger']['id'] > 0) {
            $model                = $model->findBypk((int) $_POST['AccLedger']['id']);
            $oldParent            = $model->ledger_acc_no;
            $oldsubledger_types   = $model->subledger_types;
            $oldledger_parent_acc = $model->ledger_parent_acc;
            $oldlis_parent        = $model->is_parent;
            $audit_type = 'UPDATED';
            $searchArray = explode(',', $oldsubledger_types);
        } else {
            $audit_type = 'CREATED';
        }
        $model->attributes       = $_POST['AccLedger'];
        $model->subledger_types  = $_POST['AccLedger']['subledger_types'];
        $model->system_generated = $_POST['AccLedger']['system_generated'];
        $model->root = $_POST['AccLedger']['root'] . $_POST['prefix_va'];


        // ------------addded- by indhu-21-10-2022---------------------

        /*   if ($_POST['AccLedger']['id'] > 0 && $oldledger_parent_acc > 0) {
                if ($_POST['AccLedger']['ledger_parent_acc'] !== $oldledger_parent_acc) {
                    $valid1  = false;
                    $other[] = 'Can not Change Parent Account';
                }
        } */


        // -----------------------------------------
        $array_subledger_types    = $_POST['AccLedger']['subledger_types'];
        if (!empty($array_subledger_types)) {
            $imploded_subledger_types = implode(', ', $array_subledger_types);
        }

        $targetArray   = (!empty($_POST['AccLedger']['subledger_types']))?$_POST['AccLedger']['subledger_types']:array();
       
      

        if ($_POST['AccLedger']['have_subledger'] == 'N') {
            if ($_POST['AccLedger']['id'] > 0) {
                if (!empty($imploded_subledger_types || $oldsubledger_types)) {
                    $implodedSubledgerTypes = !empty($imploded_subledger_types) ? $imploded_subledger_types : $oldsubledger_types;

                    $sql = 'SELECT VI.ledger_id, VI.subledger_id, ST.id AS subledger_type_id 
                                    FROM {{acc_voucher_items}} VI
                                    LEFT JOIN {{acc_subledger}} S ON S.id = VI.subledger_id
                                    LEFT JOIN {{acc_subledger_type}} ST ON ST.id = S.subledger_type
                                    WHERE VI.ledger_id = :ledger_id AND ST.id IN (' . $implodedSubledgerTypes . ')';

                    $command = Yii::app()->db->createCommand($sql);
                    $command->bindValue(':ledger_id', $_POST['AccLedger']['id']);

                    $modelsubledger_types = $command->queryAll();
                    $countsubledger_types = count($modelsubledger_types);

                    if ($countsubledger_types > 0) {
                        $valid1 = false;
                        $other[] = 'Cannot change subledger. Account has an entry in voucher items. Please delete all.';
                    }
                }
            }
        }
        // -----------------------------------------
        if ($_POST['AccLedger']['id'] > 0) {
            $count_AccVoucherItems = AccVoucherItems::model()->count(array('condition' => 'ledger_id=' . $_POST['AccLedger']['id']));
            if ($count_AccVoucherItems > 0) {
                if (!empty($oldsubledger_types) && $model->id > 0) {
                    if (count(array_diff($searchArray, $targetArray)) !== 0) {
                        $difference_sub_type_array = array_diff($searchArray, $targetArray);
                        $implode_sub_type = implode(',', $difference_sub_type_array);
                        if (!empty($implode_sub_type)) {

                            $sqlsubledger_types = 'SELECT VI.ledger_id, VI.subledger_id, ST.id AS subledger_type_id FROM {{acc_voucher_items}} VI
                            LEFT JOIN {{acc_subledger}} S ON S.id = VI.subledger_id
                            LEFT JOIN {{acc_subledger_type}} ST ON ST.id = S.subledger_type
                            WHERE VI.ledger_id = "' . $_POST['AccLedger']['id'] . '" AND ST.id IN (' . $implode_sub_type . ')';

                            $modelsubledger_types = Yii::app()->db->createCommand($sqlsubledger_types)->queryAll();
                            $countsubledger_types = count($modelsubledger_types);
                            if ($countsubledger_types > 0) {
                                $valid1                = false;
                                $other[]                = 'Cannot remove existing Subledger Types, Account has an entry in voucher items.Please Delete All';
                            }
                        }
                    }
                }
            }
        }
        // -----------------------------------------



        if ($_POST['AccLedger']['id'] > 0) {
            if ($_POST['AccLedger']['ledger_acc_no'] != $oldParent) {
                $count_of_child = AccLedger::model()->count(array('condition' => 'ledger_parent_acc=' . $_POST['AccLedger']['id']));
                if ($count_of_child > 0) {
                    $valid1     = false;
                    $other[]    = 'Cant Change Account No!Child Records Exists';
                }
            }
        }



        if ($_POST['AccLedger']['id'] > 0 && $oldledger_parent_acc > 0) {

            if ($_POST['AccLedger']['ledger_parent_acc'] != $oldledger_parent_acc) {
                if ($_POST['AccLedger']['is_parent'] == 'Y') {
                    $valid1  = false;
                    $other[] = 'Can not Change Parent Account';
                }
            }
        }

        // -----------------------------------------
        if ($_POST['AccLedger']['is_parent'] == 'Y') {
            if ($_POST['AccLedger']['id'] > 0) {
                $count_AccVoucherItems = AccVoucherItems::model()->count(array('condition' => 'ledger_id=' . $_POST['AccLedger']['id']));
                if ($count_AccVoucherItems > 0) {
                    $model->subledger_types = 0;
                    $valid1                 = false;
                    $other[]                = 'This Account has an entry in voucher items.Please Delete All';
                }
            }
        }
        // --------------------end------------------

        if ($_POST['AccLedger']['have_subledger'] == 'Y') {
            //  if ($model->have_subledger == 'Y') {
            if ($model->subledger_types == '') {
                $model->scenario = 'havesublegder';
            }
            // --------indhu-31--10-2022-----------

            if ($_POST['AccLedger']['is_parent'] == 'Y') {
                $valid1  = false;
                $other[] = 'This is a parent account, so can not change its subledger';
            }

            // --------end-----------
            if (is_array($_POST['AccLedger']['subledger_types'])) {
                foreach ($_POST['AccLedger']['subledger_types'] as $eachSub) {
                    $arr_sub_type[]     = $eachSub;
                }
                $model->subledger_types = implode(',', $arr_sub_type);
            }
        } else {
            $model->subledger_types     = 0;
        }
        // --------indhu-31--10-2022-----------

        /*   if ($_POST['AccLedger']['have_subledger'] == 'Y') {
            if ($_POST['AccLedger']['is_parent'] == 'Y') {
                $valid1  = false;
                $other[] = 'This is a parent account, so can not change its subledger';
            }
        } */

        if ((int) $model->ledger_parent_acc > 0 && $oldParent != $model->ledger_parent_acc) {
            $parentModel             = AccLedger::model()->findBypk((int) $model->ledger_parent_acc);
            $model->ledger_acc_type  = $parentModel->ledger_acc_type;
            $model->ledger_main_acc  = $parentModel->ledger_main_acc;
            $model->level            = $parentModel->level + 1;
            $model->created_by       = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            $model->updated_by       = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
        }
        if ($model->is_parent == 'Y') {
            $model->have_subledger == 'N';
            $model->subledger_types = null;
        } else {
            if ($_POST['AccLedger']['id'] > 0) {
                $count_of_child = AccLedger::model()->count(array('condition' => 'ledger_parent_acc=' . $_POST['AccLedger']['id']));
                // $valid1      = false;
                // $other[]     = 'Child Records Exists';
                if ($count_of_child > 0) {
                    $valid1     = false;
                    $other[]    = 'Child Records Exists';
                }
            }
        }
        if ($model->level > 5) {
            $valid1  = false;
            $other[] = 'Maximum 4 levels are allowed';
        }


        $valid = $model->validate();

        if ($valid && $model->level <= 5 && $count_of_child == 0 && $valid1) {
            echo json_encode(array('status' => 'success'));
            $model->save();
            $model->setup_levels();

            // inserting to audit log
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                $audit_type,
                "Ledger: {$model->ledger_acc_name} ({$model->id})"
            );
            // end audit log

        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if ($model->level > 5) {
                $others[] = 'Maximum 4 levels are allowed';
            }
            /*  if ($count_of_child > 0) {
                $other[] = 'Child Records Exists';
            } */
            $error = CJSON::encode(array_merge_recursive($error1, $other));
            if ($error != '[]')
                echo $error;
        }
    }


    public function actionCreateledger()
    {
        $model     = new AccLedger();
        $id        = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findBypk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('ledger_create', array('model' => $model));
    }

    public function actionGetaccountno()
    {
        $parent_id = (int) $_POST['parent_id'];
        $response  = array();
        if ($parent_id > 0) {
            $modelAccLedger             = new AccLedger();
            $parentModel                =  $modelAccLedger->findByPk($parent_id);
            if ($parentModel['is_parent'] == 'Y' && $parentModel['ledger_parent_acc'] != '0') {
                $level                  = $parentModel['level'];
                //  $level                  =  $level*2;
                $level                  =  ($level * 2) - 1;
                $response['account_no'] = substr($parentModel->ledger_acc_no, 0, $level);
            } else {
                $response['account_no'] = substr($parentModel->ledger_acc_no, 0, 1);
            }
            //	$response['account_no'] = $parentModel->ledger_acc_no;
        }
        echo json_encode($response);
    }


    public function actionGetAllLedger()
    {
        $terms =  Yii::app()->request->getParam('term');
        // $term  = trim($_POST['term']);
        $response = array();
        if ($terms != '')
            $condition = '( t.ledger_acc_no LIKE "%' . $terms . '%" OR t.ledger_acc_name LIKE "%' . $terms . '%" ) ';

        //    -------27-10-2022-added by-indhu----------------------
        $condition .= 'AND t.is_parent="N"';
        //    ---------------------------------

        $modelAccLedger = new AccLedger();
        $model_ledgers =  $modelAccLedger->findAll(array('select' => 'ledger_acc_no, ledger_acc_name, id', 'condition' => $condition, 'limit' => 10));
        foreach ($model_ledgers as $i => $each) {
            $response[$i]['label']           =  $each['ledger_acc_no'] . ' : ' . $each['ledger_acc_name'];
            $response[$i]['ledger_acc_name'] = $each['ledger_acc_name'];
            $response[$i]['value']           = $each['id'];
        }
        echo json_encode($response);
    }


    public function actiongetAllSubLedger()
    {
        //$term   = trim($_POST['term']);
        $terms    =  Yii::app()->request->getParam('term');
        $response = array();
        if ($terms != '')
            $condition = '( t.subledger_name LIKE "%' . $terms . '%" ) ';
        $modelAccSubledger = new AccSubledger();
        $model_ledgers     = $modelAccSubledger->findAll(array('select' => 'subledger_name, id', 'condition' => $condition, 'limit' => 10));
        foreach ($model_ledgers as $i => $each) {
            $response[$i]['label']          =  $each['subledger_name'];
            $response[$i]['subledger_name'] = $each['subledger_name'];
            $response[$i]['value']          = $each['id'];
        }
        echo json_encode($response);
    }


    public function actionDeleteledger()
    {
        $data = array();
        $errorMessages = array();

        if (isset($_POST['id'])) {
            $ledger_id = $_POST['id'];
            $model = new AccLedger();

            $ledger_det = $model->findByPk($ledger_id);
            if ($ledger_det !== null) {
                $is_parent = $ledger_det->is_parent;
                $system_generated = $ledger_det->system_generated;

                $SQL = 'SELECT count(id) as count FROM {{acc_voucher_items}} WHERE `ledger_id` = ' . $ledger_id;
                $voucher_items_count = Yii::app()->db->createCommand($SQL)->queryScalar();


                $SQLx = 'SELECT count(id) as count FROM {{acc_system_accounts_mapping}} WHERE `account_id` = ' . $ledger_id;
                $acc_mapping = Yii::app()->db->createCommand($SQLx)->queryScalar();



                $SQLy = 'SELECT count(id) as count FROM {{acc_voucher_type_details}} WHERE `ledger_id` = ' . $ledger_id;
                $voucher_type_det = Yii::app()->db->createCommand($SQLy)->queryScalar();



                $SQLz = 'SELECT count(id) as count FROM {{acc_payment_mode}} WHERE `ledger_id` = ' . $ledger_id;
                $payment_mode_det = Yii::app()->db->createCommand($SQLz)->queryScalar();


                $SQLw = 'SELECT count(id) as count FROM {{store}} WHERE `ledger_id` = ' . $ledger_id;
                $store_det = Yii::app()->db->createCommand($SQLw)->queryScalar();


                if ($is_parent == "Y") {
                    $errorMessages[] = 'ledger  marked as a parent.';
                }
                if ($system_generated == "Y") {
                    $errorMessages[] = 'ledger marked as system-generated.';
                }
                if ($voucher_items_count  > 0) {
                    $errorMessages[] = 'This ledger referenced in voucher items.';
                }


                if ($acc_mapping  > 0) {
                    $errorMessages[] = 'This ledger referenced in Mapping.';
                }


                if ($voucher_type_det  > 0) {
                    $errorMessages[] = 'This ledger referenced in Voucher Type Details.';
                }

                if ($payment_mode_det  > 0) {
                    $errorMessages[] = 'This ledger referenced in Payment Mode.';
                }

                if ($store_det  > 0) {
                    $errorMessages[] = 'This ledger referenced in Store.';
                }


                if ($is_parent == "N" && $system_generated == "N" && ($voucher_items_count  <= 0)  && ($acc_mapping  <= 0) && ($payment_mode_det  <= 0) && ($store_det  <= 0) && ($voucher_type_det  <= 0)) {

                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'DELETED',
                        "Ledger: {$ledger_det->ledger_acc_name} ({$ledger_det->id})"
                    );
                    // end audit log
                    $model->deleteByPk($ledger_id);
                    $datax['status'] = 'success';
                    $datax['message'] = 'Deleted successfully';
                    echo CJSON::encode($datax);
                    exit;
                }
            } else {
                $errorMessages[] = 'Ledger not found';
            }
        } else {
            $errorMessages[] = 'No ledger id provided.';
        }
        //$data['message'] = implode('<br>', $errorMessages);

        $data['message'] = implode(', ', $errorMessages);

        echo CJSON::encode($data);
    }





    public function actionGetLedgerDetails()
    {
        $from       = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition  = '(ledger_acc_name LIKE "%' . $searchTerm . '%" OR ledger_acc_name LIKE "%' . $searchTerm . '%")';
        $condition .= 'AND is_parent="N"';
        $limit      = 50;
        $query      = 'SELECT * FROM {{acc_ledger}} WHERE ' . $condition . ' ORDER BY ledger_acc_name LIMIT ' . $limit;
        $model      = Yii::app()->db->createCommand($query)->queryAll();
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value']           = $eachModel['id'];
            $data[$i]['label']           = $eachModel['ledger_acc_name'] . ' : ' . $eachModel['ledger_acc_no'];
            $data[$i]['have_subledger']  = $eachModel['have_subledger'];
            $data[$i]['subledger_types'] = $eachModel['subledger_types'];
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetSubLedgerDetails()
    {
        $ledger_id       = $_GET['ledger_id'];

        $modelAccLedger        = new AccLedger();
        $acc_ledger_det        = $modelAccLedger->findByPk($ledger_id);
        $subledger_types       = $acc_ledger_det->subledger_types;
        $modelAccSubledger     = new AccSubledger();
        $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
        //$arr_orders =CHtml::listData($model_orders, 'id', 'id');
        $searchTerm = $_GET['term'];

        $condition = 'subledger_type IN (' . $subledger_types . ') AND subledger_name LIKE "%' . $searchTerm . '%"';
        $model = $modelAccSubledger->findAll(array('condition' => $condition,  'order' => 'subledger_name ASC',));

        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value']           = $eachModel['id'];
            $data[$i]['label']           = $eachModel['subledger_name'];
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }



    public function actionGetsubledgerdropNew()
    {
        $ledger = $_POST['ledger_id'];


        $drop   = array();
        $modelAccPaymentMode    = new AccPaymentMode;
        if ($ledger > 0) {
            $modelAccLedger            = new AccLedger();
            $acc_ledger_det            =  $modelAccLedger->findByPk($ledger);
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getSubledgerdropdownwithAmount($subledger_types, (int)$ledger);
                if (!empty($subledger_types_array)) {
                    $drop['drop'] = $form->dropDownList($modelAccPaymentMode, 'subledger_id', $subledger_types_array, ['class' => 'tooltipster', 'data-label' => 'Sub Ledger <span style="color:red">*</span>',]);
                } else {
                    $drop['drop'] = $form->dropDownList($modelAccPaymentMode, 'subledger_id', array(), ['class' => 'tooltipster', 'data-label' => 'Sub Ledger <span style="color:red">*</span>',]);
                }
            } else {
                $drop['drop'] = $form->dropDownList($modelAccPaymentMode, 'subledger_id', array(), ['class' => 'tooltipster', 'data-label' => 'Sub Ledger <span style="color:red">*</span>',]);
            }
        }
        echo CJSON::encode($drop);
    }

    public function actionGetsubledgerdrop()
    {
        $ledger = $_POST['ledger_id'];
        $row    = $_POST['row_field'];
        $drop   = array();
        $modelAccVoucherTypeDetails    = new AccVoucherTypeDetails;
        if ($ledger > 0) {
            $modelAccLedger            = new AccLedger();
            $acc_ledger_det            =  $modelAccLedger->findByPk($ledger);
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                //$subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types); 
                //       below code added by jisha--for subledger amount
                $subledger_types_array = $modelAccSubledger->getSubledgerdropdownwithAmount($subledger_types, (int)$ledger);
                if (!empty($subledger_types_array)) {
                    $drop['drop']      = CHtml::activedropdownlist($modelAccVoucherTypeDetails, "[" . $row . "]subledger_id", $subledger_types_array, array('class' => 'form-control go cls_subledger', 'prompt' => '--select--'));
                } else {
                    $drop['drop']      = CHtml::activedropdownlist($modelAccVoucherTypeDetails, "[" . $row . "]subledger_id", '', array('class' => 'form-control go cls_subledger', 'prompt' => '--select--'));
                }
            } else {
                $drop['drop']          = CHtml::activedropdownlist($modelAccVoucherTypeDetails, "[" . $row . "]subledger_id", '', array('class' => 'form-control go cls_subledger', 'prompt' => '--select--'));
            }
        }
        echo CJSON::encode($drop);
    }


    public function actionGetsubledgerdropitems()
    {
        $ledger = $_POST['ledger_id'];
        $row    = $_POST['row_field'];
        $drop   = array();
        $modelAccVoucherTypeDetails    = new AccVoucherItems;
        if ($ledger > 0) {
            $modelAccLedger            = new AccLedger();
            $acc_ledger_det            =  $modelAccLedger->findByPk($ledger);
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                if (!empty($subledger_types_array)) {
                    $drop['drop']      = CHtml::activedropdownlist($modelAccVoucherTypeDetails, "[" . $row . "]subledger_id", $subledger_types_array, array('class' => 'form-control go', 'prompt' => '--select--'));
                } else {
                    $drop['drop']      = CHtml::activedropdownlist($modelAccVoucherTypeDetails, "[" . $row . "]subledger_id", '', array('class' => 'form-control go', 'prompt' => '--select--'));
                }
            } else {
                $drop['drop']          = CHtml::activedropdownlist($modelAccVoucherTypeDetails, "[" . $row . "]subledger_id", '', array('class' => 'form-control go', 'prompt' => '--select--'));
            }
        }
        echo CJSON::encode($drop);
    }




    public function actionGetLedgersSubledger()
    {
        $to_subledger          = $_POST['to_subledger'];
        $from_subledger        = $_POST['from_subledger'];
        $ledger                = $_POST['ledger_id'];
        $modelAccLedger        = new AccLedger();
        $acc_ledger_det        = $modelAccLedger->findByPk($ledger);
        $subledger_types       = $acc_ledger_det->subledger_types;
        $modelAccSubledger     = new AccSubledger();
        $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
        //$arr_orders =CHtml::listData($model_orders, 'id', 'id');
        $drop      = '<div class="material"> ';
        if ($to_subledger == 'to_subledger') {
            $drop .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Account Subledger', 'empty' => '-Select-', 'data-search' => 'true'));
        } else  if ($from_subledger == 'from_subledger') {
            $drop .= CHtml::dropDownList('from_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Payment Subledger', 'empty' => '-Select-', 'data-search' => 'true'));
        } else {
            $drop .= CHtml::dropDownList('subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Subledger', 'empty' => '-Select-', 'data-search' => 'true'));
        }
        $drop     .= '</div>';
        echo $drop;
    }


    public function actionSystemmapping()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('system_mapping');
    }

    public function actionGetsubledgers()
    {
        $model   = $_POST['model'];
        $field   = $_POST['field'];
        $account = (int) $_POST['account'];
        $i       = $_POST['i'];
        echo CHtml::activedropdownlist(new $model, "[" . $i . "]" . $field, AccSubledger::getSubledgers($account), array('class' => 'form-control', 'prompt' => '-select-'));
    }




    public function actionSavemapping()
    {
        $modelMapping = [];
        $error_attributes = [];
        $old_account_id_mismatch = false;
        $validate = true;

        if (isset($_POST['AccSystemAccountsMapping']) && is_array($_POST['AccSystemAccountsMapping'])) {
            foreach ($_POST['AccSystemAccountsMapping'] as $i => $item) {
                $modelMapping[$i] = new AccSystemAccountsMapping();

                // Populate model attributes
                $modelMapping[$i]->attributes = $item;
                $modelMapping[$i]->modified_by = Yii::app()->user->id;
                $modelMapping[$i]->modified_date_time = date('Y-m-d h:i:s');

                // Check for existing model
                if (!empty($item['id'])) {
                    $existingModel = AccSystemAccountsMapping::model()->findByPk($item['id']);
                    if ($existingModel !== null) {
                        $last_id = $existingModel->account_id;
                        $last_subledger_id = $existingModel->subledger_id;
                        $old_account_id = $existingModel->account_id; // Assuming $old_account_id is from $existingModel
                        $modelMapping[$i] = $existingModel;
                    } else {
                        $last_id = null;
                        $old_account_id = null;
                        $last_subledger_id = null;
                    }
                } else {
                    $last_id = null;
                    $old_account_id = null;
                    $last_subledger_id = null;
                }
                $modelMapping[$i]->account_id =  (int)$item['account_id'];
                $modelMapping[$i]->subledger_id =  (int)$item['subledger_id'];
                // Validate and check for mismatches
                if ($last_id !== $item['account_id']) {
                    $modelMapping[$i]->last_account_id = $last_id;
                }


                if ((int)$old_account_id !== (int)$item['account_id']) {
                    $old_account_id_mismatch = true;
                    $error_attributes[$i] = $item['attribute'];
                }

                $validate = $validate && $modelMapping[$i]->validate();
            }
        }

        // Handle validation result
        if ($validate) {
            if ($old_account_id_mismatch && !isset($_POST['confirm'])) {
                echo json_encode([
                    'status' => 'warning',
                    'message' => 'Account ID mismatch for attributes: ' . implode(', ', $error_attributes) . '. Do you want to continue?',
                    'attributes' => $error_attributes
                ]);
                Yii::app()->end();
            } else {
                foreach ($modelMapping as $eachModel) {
                    $eachModel->save();

                    // Example of updating related details (modify as per your actual model structure)
                    $modelAccVoucherTypeDetails = AccVoucherTypeDetails::model()->findAll(['condition' => 'attribute=:attribute', 'params' => [':attribute' => $eachModel->attribute]]);
                    foreach ($modelAccVoucherTypeDetails as $detail) {
                        $detail->ledger_id = (int)$eachModel->account_id;
                        $detail->subledger_id = (int)$eachModel->subledger_id;
                        $detail->save();
                    }
                }
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    'UPDATED',
                    "Mapping"
                );
                // end audit log

                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        } else {
            // Handle validation errors
            $error = json_decode(CActiveForm::validateTabular($modelMapping, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error));
            if ($error != '[]') {
                echo $error;
            }
        }
    }


    // -----------------------15-03-2023---frm payment ,commisstion and receipt add----------------------------------------
    public function actionGetledgerssubledgerdropnew()
    {

        $ledger_id   = (int)Yii::app()->request->getparam("ledger_id");
        $columnWidth = Yii::app()->request->getparam("columnWidth");
        $from        = Yii::app()->request->getparam("frm");

        $dropx = '<li class="col-sm-' . $columnWidth . '">';
        $modelAccLedger            = new AccLedger();
        $acc_ledger_det            =  $modelAccLedger->findByPk($ledger_id);

        if ($from == 'paymentfrmsubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('from_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Payment Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('from_subledger_id', '', array(), array('class' => 'tooltipster', 'data-label' => 'Payment Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else   if ($from == 'paymenttosubledger') {

            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'onChange' => 'js:GetallocationdataFromPayment(this.value);', 'data-label' => 'Account Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('to_subledger_id', '', array(), array('class' => 'tooltipster', 'data-label' => 'Account Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else if ($from == 'receiptfromsubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('from_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'onChange' => 'js:GetallocationdataFromReceipt(this.value);', 'data-label' => 'Account Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('from_subledger_id', '', array(), array('class' => 'tooltipster', 'data-label' => 'Account Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else   if ($from == 'receipttosubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Receipt Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('to_subledger_id', '', array(), array('class' => 'tooltipster', 'data-label' => 'Receipt Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else   if ($from == 'paidto') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Paid To<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('to_subledger_id', '', array(), array('class' => 'tooltipster', 'data-label' => 'Paid To<span style="color:red">(No Subledgers)</span>'));
            }
        }


        $dropx .= '</li>';

        echo CJSON::encode($dropx);
    }
    public function actionGetledgerssubledgerdropnewold()
    {

        $ledger_id   = (int)Yii::app()->request->getparam("ledger_id");
        $columnWidth = Yii::app()->request->getparam("columnWidth");
        $from        = Yii::app()->request->getparam("frm");

        $dropx = '<li class="col-sm-' . $columnWidth . '">';
        $modelAccLedger            = new AccLedger();
        $acc_ledger_det            =  $modelAccLedger->findByPk($ledger_id);

        if ($from == 'paymentfrmsubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('from_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Payment Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('from_subledger_id', '', '', array('class' => 'tooltipster', 'data-label' => 'Payment Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else   if ($from == 'paymenttosubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Account Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('to_subledger_id', '', '', array('class' => 'tooltipster', 'data-label' => 'Account Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else if ($from == 'receiptfromsubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('from_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Account Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('from_subledger_id', '', '', array('class' => 'tooltipster', 'data-label' => 'Account Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else   if ($from == 'receipttosubledger') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Receipt Subledger<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('to_subledger_id', '', '', array('class' => 'tooltipster', 'data-label' => 'Receipt Subledger<span style="color:red">(No Subledgers)</span>'));
            }
        } else   if ($from == 'paidto') {
            if ($acc_ledger_det->have_subledger == 'Y') {
                $subledger_types       = $acc_ledger_det->subledger_types;
                $modelAccSubledger     = new AccSubledger();
                $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                $dropx .= CHtml::dropDownList('to_subledger_id', '', $subledger_types_array, array('class' => 'tooltipster', 'data-label' => 'Paid To<span style="color:red">*</span>', 'empty' => '-Select-', 'data-search' => 'true'));
            } else {
                $dropx .= CHtml::dropDownList('to_subledger_id', '', '', array('class' => 'tooltipster', 'data-label' => 'Paid To<span style="color:red">(No Subledgers)</span>'));
            }
        }


        $dropx .= '</li>';

        echo CJSON::encode($dropx);
    }
    // -----------------------19_05_2023-------------------------------

    public function actionAuditclosing()
    {
        if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["acc_final_audit_close_menu_view"] || (int) Yii::app()->user->havePermissionOn["acc_audit_close_menu_view"]) {
            $type = Yii::app()->request->getParam('type');
            $auditclose_ranges = AccAuditClose::model()->getAllClosedDateRanges();
            $auditclose_ranges_html = AccAuditClose::model()->getAllClosedDateRangesHtml('PRE');
            $existPreAuditClose = AccAuditClose::model()->findAll(array('condition' => 'closed = "PRE"', 'order' => 'id DESC'));
            $existFinalAuditClose = AccAuditClose::model()->findAll(array('condition' => 'closed = "FINAL"', 'order' => 'id DESC'));
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('audit_closing', array('type' => $type, 'model' => new AccAuditClose, 'auditclose_ranges' => $auditclose_ranges, 'existPreAuditClose' => $existPreAuditClose, 'existFinalAuditClose' => $existFinalAuditClose, 'auditclose_ranges_html' => $auditclose_ranges_html));
        } else {
            echo 'Access Denied';
        }
    }

    public function actionCloseyear_preaudit()
    {
        $type = $_POST['type'];
        $audit_close_name = $_POST['name'];
        $close_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['close_date'])));
        $current_date = date('Y-m-d');
        $close_date_new = strtotime($close_date);
        $current_date = strtotime($current_date);
        $lastCloseddate = strtotime(AccAuditClose::lastCloseddate());
        if (!empty($lastCloseddate)) {

            if ($lastCloseddate < $close_date_new) {

                if ($close_date !== '0000-00-00') {
                    if ($close_date_new < $current_date) {
                        $exist = AccAuditClose::model()->find(array('condition' => 'close_date="' . $close_date . '"'));
                        if ((int) $exist->id == 0) {
                            $newClosing                   = new AccAuditClose;
                            $newClosing->name       = $audit_close_name;
                            $newClosing->close_date       = $close_date;
                            $newClosing->created_by       = Yii::app()->user->id;
                            $newClosing->created_datetime = date('Y-m-d h:i:s');
                            $newClosing->save();
                            echo 'success';
                        } else {
                            echo 'Already closed!';
                        }
                    } else {
                        echo 'Nice try :)';
                    }
                } else {
                    echo 'Invalid Date!';
                }
            } else {
                echo  ' Given Close date must be Greater than Last Audit Close Date :-' . date("d/m/Y", strtotime(str_replace('/', '-', AccAuditClose::lastCloseddate()))) . '';
            }
        } else {
            $newClosing                   = new AccAuditClose;
            $newClosing->name       = $audit_close_name;
            $newClosing->close_date       = $close_date;
            $newClosing->created_by       = Yii::app()->user->id;
            $newClosing->created_datetime = date('Y-m-d h:i:s');
            $newClosing->save();
            echo 'success';
        }
    }
    
    public function actionUnlockyear_preaudit()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            $last_closed_date_id = AccAuditClose::lastClosedDate_id();
            if ($last_closed_date_id == $id) {
                $voucher_id = AccAuditClose::model()->findbypk($id)->voucher_id;
                AccAuditClose::model()->deleteBypk($id);
                echo 'success';
            } else {
                echo 'Only the last closed date can be deleted.';
            }
        } else {
            echo 'Failed';
        }
    }

    public function actionCloseyear_finalaudit()
    {
        $type = $_POST['type'];
        $close_date_id = $_POST['close_date_id'];
        $lastAuditcloseDateDetails = AccAuditClose::model()->findByPk($close_date_id);
        $last_close_date = AccAuditClose::lastFinalClosedDate();
        $lastCloseddateId = AccAuditClose::lastFinalClosedDateId();
        if (trim($close_date_id)) {
            if ($lastAuditcloseDateDetails) {
                $newClosing = new AccAuditClose;
                $newClosing->id = $lastAuditcloseDateDetails->id;
                $newClosing->closed = 'FINAL';
                $newClosing->updateByPk((int) $lastAuditcloseDateDetails->id, array('closed' => 'FINAL'));
                AccAuditClose::updateAuditcloseDetails($newClosing, $lastAuditcloseDateDetails->close_date, $last_close_date, $lastCloseddateId);
                echo 'success';
            } else {
                echo 'Already closed!';
            }
        } else {
            echo 'Invalid Date!';
        }
    }

    public function actionUnlockyear_finalaudit()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            $last_closed_date_id = AccAuditClose::lastFinalClosedDateId();
            if ($last_closed_date_id == $id) {
                $existPreAuditClose = AccAuditClose::model()->findAll(array('condition' => 'closed = "PRE"', 'order' => 'id DESC'));
                if ($existPreAuditClose) {
                    echo "Final audit close date can't be deleted if any pre audit close date exist.";
                } else {
                    $voucher_id = AccAuditClose::model()->findbypk($id)->voucher_id;
                    AccAuditClose::model()->updateByPk((int) $id, array('closed' => 'PRE'));
                    AccAuditCloseDetails::model()->deleteAll(array('condition' => 'audit_close_id = '.$id));
                    echo 'success';
                }
            } else {
                echo 'Only the last closed date can be deleted.';
            }
        } else {
            echo 'Failed';
        }
    }


    public function actionGetledgersPaymentMode()
    {

        $ledger_id   = (int)Yii::app()->request->getparam("ledger_id");
        $columnWidth = Yii::app()->request->getparam("columnWidth");
        $from        = Yii::app()->request->getparam("frm");

        $dropx = '<li class="col-sm-' . $columnWidth . '">';
        $modelAccLedger            = new AccLedger();
        $acc_ledger_det            =  $modelAccLedger->findByPk($ledger_id);


        if ($from == 'receiptacc') {
            if ($acc_ledger_det->currency_id !== 0) {
                $modelAccPaymentMode = new AccPaymentMode();
                $paymentmodes = $modelAccPaymentMode->getAccPaymentModesWithledger((int)$ledger_id);
                $paymentmode_arary = (!empty($paymentmodes)) ? $paymentmodes : array();
                $dropx .= CHtml::dropDownList('payment_modes', '', $paymentmode_arary, array('prompt' => '--select--', 'onchange' => 'CheckPaymentDetails(this.value)', 'data-label' => 'Receipt Mode <span style="color:red">*</span>'));
            } else {
                $dropx .= CHtml::dropDownList('payment_modes', '', array(), array('prompt' => '--select--', 'onchange' => 'CheckPaymentDetails(this.value)', 'data-label' => 'Receipt Mode <span style="color:red">*</span>'));
            }
        }



        $dropx .= '</li>';

        echo CJSON::encode($dropx);
    }
    
        public function actionGetSublegerByLedgerDetails()
    {
        
       
        $ledger_id       = $_GET['ledger_id'];
        
        $modelAccLedger        = new AccLedger();
        $acc_ledger_det        = $modelAccLedger->findByPk($ledger_id);
        $subledger_types       = $acc_ledger_det->subledger_types;
        $modelAccSubledger     = new AccSubledger();
       // $subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
        
        $searchTerm = $_GET['term'];
        if(!empty($subledger_types)){
             $condition  = '(subledger_name LIKE "%' . $searchTerm . '%" OR subledger_name LIKE "%' . $searchTerm . '%")';
        $condition .= 'AND subledger_type IN (' . $subledger_types . ')';
        $limit      = 100;
        $query      = 'SELECT * FROM {{acc_subledger}} WHERE ' . $condition . ' ORDER BY subledger_name LIMIT ' . $limit;
        $model      = Yii::app()->db->createCommand($query)->queryAll();
        }
       
        $i = 0;
        $data= [];
        foreach ($model as $eachModel) {
            $data[$i]['value']           = $eachModel['id'];
            $data[$i]['label']           = $eachModel['subledger_name'];
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
}
