<?php

class VouchersController extends Controller {

	public function accessRules() {
		return array(
				array('allow', // allow all users to perform 'index' and 'view' actions
						'actions' => array('login', 'error', 'logout'),
						'users' => array('*'),
				),
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('Create', 'Subledgerlist', 'Savevoucher', 'Updatevoucher', 'Createreceipt', 'Reports',
										  'Glreport_excel','Glreport_pdf', 'Trialbalance_excel', 'Trialbalance_pdf', 'Glsummary_excel', 'Statement_excel',
										  'Statement_pdf', 'Glsummary_pdf', 'Balancesheet_excel', 'Balancesheet_pdf', 'Profitorloss_pdf', 'Profitorloss_excel',
										  'Trialbalance_pdf_detailed', 'Trialbalance_excel_detailed', 'Loadtemplate', 'Allocate', 'Getallocationdata',
										  'Saveallocation', 'Ageing_excel'),
						'expression' => '$user->isMember()',
				),
				array('deny', // deny all users
						'users' => array('*'),
				),
		);
	}
	
	public function actionCreate() 
    {
		$id = (int) Yii::app()->request->getParam('id');
		$model = new FinanceVoucherHead;
		if( $id > 0 )
			$model = $model->findBypk( $id );
		else{
			$model->voucher_type = 3; //journal Voucher
		}
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('create_voucher', array( 'model' => $model ) );
	}

	public function actionSubledgerlist(){
		
		$term = trim( $_GET['term'] );
		$ledger = $_GET['ledger'];
		
		$response = array();
		
		if( $term != '' && $ledger > 0 ){
			$legderModel = FinanceLegder::model()->findBypk( $ledger );
			if( $legderModel->subledger_types != '' ){
				$subledgers = FinanceSubledger::model()->findAll( array( 'condition' => 'description LIKE "%'.$term.'%" AND subledger_type_id IN ('.$legderModel->subledger_types.')', 'limit' => 100 ) );
				foreach( $subledgers as $i => $each ){
					$response[$i]['label'] = $each->description;
					$response[$i]['value'] = $each->id;
				}
			}
		}
		
		echo json_encode( $response );
	}

	public function actionSavevoucher(){
		
		function savableDate( $date ){
			$last_closed_year = FinanceAuditClose::lastClosed();
			$voucherDate_array = explode('-', $date);
			$voucherYear = $voucherDate_array[0];
			return ( $voucherYear <= $last_closed_year ) ? false : true;
		}

		function matchTotal( $debit, $credit, $voucherType ){
			return ( ( $debit > 0 && $credit > 0 && $debit == $credit ) || ( $voucherType == 5 && ( $debit > 0 || $credit > 0 ) ) ) ? true : false;
		}

		$others = $modelItems = array();
		$model = new FinanceVoucherHead;
		$i = $debitTotal = $creditTotal = 0;
		if( (int) $_POST['FinanceVoucherHead']['id'] > 0 )
			$model = $model->findBypk( (int) $_POST['FinanceVoucherHead']['id']);
		else{
			$model->is_posted = 'Y';
			$model->created_by = Yii::app()->user->id;
			$model->created_datetime = date('Y-m-d h:i:s');
		}
		$model->attributes = $_POST['FinanceVoucherHead'];
		$model->voucher_date = ( count( explode('/', $_POST['FinanceVoucherHead']['voucher_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['voucher_date']) )) : date('Y-m-d');
		$model->due_date = $model->voucher_date;
		$savableVoucher = savableDate($model->voucher_date);
		$voucherType =  $_POST['FinanceVoucherHead']['voucher_type'];
		$model->voucher_no = 0;
		$model->total_voucher_amount = 0;
		
		$voucherModel = FinanceVoucherType::model()->findBypk( (int) $voucherType ); 
		if( in_array($voucherType, array(1, 2)) ){ //Receipt or Payment
			if( $_POST['FinanceVoucherHead']['payment_method'] == 4 ) //card
				$model->scenario = 'card';
			else if( $_POST['FinanceVoucherHead']['payment_method'] == 2 ){ //cheque
				$model->scenario = ( $voucherType == 2 ) ? 'chequereceived' : 'chequepaid';
				$model->realisation_date = ( count( explode('/', $_POST['FinanceVoucherHead']['realisation_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['realisation_date']) )) : date('Y-m-d');
				$model->cheque_date = ( count( explode('/', $_POST['FinanceVoucherHead']['cheque_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['cheque_date']) )) : date('Y-m-d');
				$model->cheque_cleared = 'N';
			}else if( $_POST['FinanceVoucherHead']['payment_method'] == 3 ){ //bank
				if( $voucherType == 2 ) //Bank
					$model->scenario = 'bank'; //
			}else //cash
				$model->scenario = 'cash';
		}else
			$model->scenario = 'simpleVoucher';
		$valid = $model->validate() && $savableVoucher;	
		if( is_array( $_POST['FinanceVoucherItems'] ) ){
			foreach( $_POST['FinanceVoucherItems'] as $eachIem ){
				$modelItems[$i] = new FinanceVoucherItems;
				$modelItems[$i]->attributes = $eachIem;
				$modelItems[$i]->header_id = 0;
				if( $eachIem['ledger_id'] > 0 ){
					$ledger = FinanceLegder::model()->findBypk( $eachIem['ledger_id'] );
					if( $ledger->haveSubledger == 'Y' )
						$modelItems[$i]->scenario = 'havesubledger';
				}
				$modelItems[$i]->narration = ( trim($eachItem['narration']) == '' ) ? $_POST['general_narration'] : $eachItem['narration'];
				if( $eachIem['debit'] > 0 ){
					$modelItems[$i]->amount = $eachIem['debit'];
					$debitTotal += $eachIem['debit'];
				}else{
					$modelItems[$i]->amount = -1*$eachIem['credit'];
					$creditTotal += $eachIem['credit'];
				}
				$valid = $modelItems[$i]->validate() && $valid;	
				$i++;
			}
		}
		
		$matchingTotals = matchTotal($debitTotal, $creditTotal, $voucherType);

		if( $valid && count($modelItems) > 0 && $matchingTotals ){
			$model->voucher_no = FinanceVoucherType::getVoucherno( $model->voucher_type, true);
			$model->total_voucher_amount = $debitTotal;
			if( $model->scenario == 'simpleVoucher' )
				$model->reference_no = $voucherModel->code.'/'.$model->voucher_no;
			$model->save();
			FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $model->id));
			foreach( $modelItems as $each ){
				$each->header_id = $model->id;
				$each->save();
			}
			echo json_encode( array( 'status' => 'success' ) );
		}else{
			$error1 = json_decode(CActiveForm::validate($model, '', false), true);
			$error2 = json_decode(CActiveForm::validateTabular($modelItems, '', false), true);
			if( !$savableVoucher )
				$others[] = 'All the vouchers in this year are closed';
			if( count($modelItems) == 0 )
				$others[] = 'Please add ledger entries!';
			if( !$matchingTotals )
				$others[] = 'Totals are not matching!';
			echo CJSON::encode(array_merge_recursive($error1, $others, $error2));
		}
	}

	public function actionUpdatevoucher(){
		$id = (int) $_POST['id'];
		$type = $_POST['type'];
		
		function isPostable( $date ){
			$last_closed_year = FinanceAuditClose::lastClosed();
			$voucherDate_array = explode('-', $date);
			$voucherYear = $voucherDate_array[0];
			return ( $voucherYear <= $last_closed_year ) ? false : true;
		}

		if( $id > 0 ){
			$voucherModel = FinanceVoucherHead::model()->findBypk( $id );
			if( isPostable( $voucherModel->voucher_date ) ){
				if( $type == 0 ){ 
					//unpost
					if( $voucherModel->is_allocated == 'N'){
						$voucherModel->is_posted = 'N';
						$voucherModel->save(false);
						$msg = 'success';
					}else{
						$msg = 'Remove allocation first!';
					}
				}else if( $type == 2 ){ 
					//delete
					if( $voucherModel->is_allocated == 'N'){
						FinanceVoucherHead::model()->deleteBypk($id);
						FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $id));
						$msg = 'success';
					}else{
						$msg = 'Remove allocation first!';
					}
				}else{ 
					//post
					$voucherModel->is_posted = 'Y';
					$voucherModel->save(false);
					$msg = 'success';
				}
				echo $msg;
			}else
				echo 'Audited!';
		}else
			echo 'Something Went Wrong!';
	}

	public function actionReports(){
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('reports');
	}

	public function actionGlreport_excel(){
		
		$from_date = ( count(explode('/',$_GET['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date'])))  : date('Y-m-d');
        $to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		
		$ledger = (int) $_GET['ledger'];
		$subledger = (int) $_GET['subledger'];
		
		$condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
		$condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "'.$from_date.'"';

		if( $ledger > 0 ){
			$condition .= ' AND t.ledger_id='.$ledger;
			$condition_for_opening .= ' AND I.ledger_id='.$ledger;
		}
		if( $subledger > 0 ){
			$condition .= ' AND t.subledger_id='.$subledger;
			$condition_for_opening .= ' AND I.subledger_id='.$subledger;
		}

		$openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE '.$condition_for_opening.' ')->queryScalar();
		$items = FinanceVoucherItems::model()->with('parent')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
		
		$filename = "glreport".date('dmYhis').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
							<thead>
								<th class="head">Date</th>
								<th class="head">Voucher No</th>
								<th class="head">Ledger</th>
								<th class="head">Subledger</th>
								<th class="head">Narration</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
								<th class="head">Balance</th>
                            </thead>
							<tbody>';
		$previousBalance = $openingBalance;
		$closingBalance = $openingBalance;
		$symbol = ( $previousBalance > 0 ) ? 'Dr' : 'Cr';
		$data .=    '<tr>
						<td colspan="5"><b>Opening Balance</b></td>
						<td>'.Yii::app()->numberFormatter->formatCurrency( ( ( $previousBalance > 0  ) ? $previousBalance : '' )," ").'</td>
						<td>'.Yii::app()->numberFormatter->formatCurrency( ( ( $previousBalance < 0  ) ? $previousBalance : '' )," ").'</td>
						<td>'.Yii::app()->numberFormatter->formatCurrency(abs($previousBalance)," ").' '.$symbol.'</td>
					</tr>';
		foreach ( $items as $each ){
				
				$debit = ( $each->amount > 0 ) ? $each->amount : '';
				$credit = ( $each->amount < 0 ) ? abs($each->amount) : '';
				$running = $debit - $credit + $previousBalance;
				$previousBalance = $running;
				$symbol = ( $running > 0 ) ? 'Dr' : 'Cr';
				$closingBalance +=  ( $debit - $credit );

				$subledgerName = ( $each->subledger_id > 0 ) ? $each->subledger->description : '';
				$data .=     '<tr>
								<td>'.$each->parent->voucher_date.'</td>
								<td>'.$each->parent->fullvoucher.'</td>
								<td>'.$each->ledger->description.'</td>
								<td>'.$subledgerName.'</td>
								<td>'.$each->narration.'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency($debit," ").'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency($credit," ").'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency(abs($running)," ").' '.$symbol.'</td>
							</tr>';
		}
		$symbol = ( $closingBalance > 0 ) ? 'Dr' : 'Cr';
		$data .=    '<tr>
						<td class="head" colspan="7"><b>Closing Balance</b></td>
						<td class="head">'.Yii::app()->numberFormatter->formatCurrency(abs($closingBalance)," ").' '.$symbol.'</td>
					</tr>';
		$data .= '      </tbody>
					</table>
				</body>
			</html>';
		header ( "Content-type: application/vnd.ms-excel" );
		header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
		echo $data;
		Yii::app()->end();
		return;
	}
	
	//Code added by Mereena on 10/09/2018 for GL Report PDF
	public function actionGlreport_pdf() {
        $from_date  = Yii::app()->request->getParam('from_date');
        $to_date    = Yii::app()->request->getParam('to_date');
        $ledger     = Yii::app()->request->getParam('ledger');
        $subledger  = Yii::app()->request->getParam('subledger');
        $param = array(
            'from_date' => $from_date,
            'to_date'   => $to_date,
            'ledger'    => $ledger,
            'subledger' => $subledger
        );
        
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_gl_report', $param, true));

        $mpdf->Output("GLReport".date("d-m-Y"), 'I');
    }
	//end code by Mereena

	public function generateView( $type, $from_date, $to_date, $ledger ){
		$accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
		if( $type == 'trial_balance' ){
			$query_head = 'CREATE OR REPLACE VIEW view_finance_balancesheet AS SELECT 
						L.id AS ledger_id, 
						L.account_no AS ledger_no, 
						L.description AS ledger_name, 
						L.level AS level, 
						L.parent_account AS parent, 
						SUM(amount) AS balance 
					FROM {{finance_legder}} L 
					LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id 
					LEFT JOIN {{finance_voucher_head}} V On VI.header_id = V.id  
					WHERE V.is_posted="Y" AND V.voucher_date <= "'.$to_date.'" AND L.type_of_account IN ("B") 
					GROUP BY L.id';
			Yii::app()->db->createCommand( $query_head )->execute();
			$query_tail =  'CREATE OR REPLACE VIEW view_finance_profit_or_loss AS SELECT 
								L.id AS ledger_id, 
								L.account_no AS ledger_no, 
								L.description AS ledger_name, 
								L.level AS level, 
								L.parent_account AS parent, 
								SUM(amount) AS balance 
							FROM {{finance_legder}} L 
							LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id 
							LEFT JOIN {{finance_voucher_head}} V On VI.header_id = V.id  
							WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "'.$accountingPeriod['from'].'" AND "'.$to_date.'" AND L.type_of_account IN ("P") 
							GROUP BY L.id';
			Yii::app()->db->createCommand( $query_tail )->execute();
			
			$query_all ='CREATE OR REPLACE VIEW view_finance_trialbalance AS SELECT * FROM view_finance_balancesheet UNION SELECT * FROM view_finance_profit_or_loss';
			Yii::app()->db->createCommand( $query_all )->execute();
		}else if( $type == 'gl_summary' ){
			
			$glSummaryquery = 'CREATE OR REPLACE VIEW view_finance_gl_summary AS SELECT 
								SL.account_no AS subledger_no, 
								SL.description AS subledger_name, 
								SUM(VI.amount) AS balance 
							FROM {{finance_voucher_items}} VI 
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id 
							LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id 
							LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id 
							WHERE VI.ledger_id="'.$ledger.'" AND V.is_posted = "Y" AND V.voucher_date <= "'.$to_date.'" 
							GROUP BY  VI.ledger_id, VI.subledger_id';
			Yii::app()->db->createCommand( $glSummaryquery )->execute();
		}else if( $type == 'profit_or_loss' ){
			
			$query_tail =  'CREATE OR REPLACE VIEW view_finance_profit_or_loss AS SELECT 
								L.id AS ledger_id, 
								L.account_no AS ledger_no, 
								L.description AS ledger_name, 
								L.level AS level, 
								L.parent_account AS parent, 
								SUM(amount) AS balance 
							FROM {{finance_legder}}  L 
							LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id 
							LEFT JOIN {{finance_voucher_head}} V On VI.header_id = V.id  
							WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "'.$from.'" AND "'.$to_date.'" AND L.type_of_account IN ("P") 
							GROUP BY L.id';
			Yii::app()->db->createCommand( $query_tail )->execute();
		}else if( $type == 'trial_balance_detailed' ){
			$query_head = 'CREATE OR REPLACE VIEW view_finance_balancesheet_detailed AS SELECT 
						L.id AS ledger_id, 
						L.account_no AS ledger_no, 
						L.description AS ledger_name, 
						L.level AS level, 
						L.parent_account AS parent, 
						S.id AS subledger_id,
						S.description AS subledger_name,
						S.account_no AS subledger_no,
						SUM(amount) AS balance 
					FROM {{finance_legder}}  L 
					LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id 
					LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id  
					LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
					WHERE V.is_posted="Y" AND V.voucher_date <= "'.$to_date.'" AND L.type_of_account IN ("B") 
					GROUP BY S.id, L.id';
			Yii::app()->db->createCommand( $query_head )->execute();
			$query_tail =  'CREATE OR REPLACE VIEW view_finance_profit_or_loss_detailed AS SELECT 
								L.id AS ledger_id, 
								L.account_no AS ledger_no, 
								L.description AS ledger_name, 
								L.level AS level, 
								L.parent_account AS parent, 
								S.id AS subledger_id,
								S.description AS subledger_name,
								S.account_no AS subledger_no,
								SUM(amount) AS balance 
							FROM {{finance_legder}}  L 
							LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id 
							LEFT JOIN {{finance_voucher_head}} V On VI.header_id = V.id  
							LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
							WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "'.$accountingPeriod['from'].'" AND "'.$to_date.'" AND L.type_of_account IN ("P") 
							GROUP BY S.id, L.id';
			Yii::app()->db->createCommand( $query_tail )->execute();
			
			$query_all ='CREATE OR REPLACE VIEW view_finance_trialbalance_detailed AS SELECT * FROM view_finance_balancesheet_detailed UNION SELECT * FROM view_finance_profit_or_loss_detailed';
			Yii::app()->db->createCommand( $query_all )->execute();
		}
	}

	public function actionTrialbalance_excel(){
		
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$this->generateView('trial_balance', 0, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_trialbalance WHERE ledger_id='.$id)->queryScalar();
		}

		$filename = "trialbalance".date('dmYhis').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Ledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';
			//We have 5 levels
			$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'level=1 AND type_of_account IN ("B", "P")' ) );
			$debitTotal = $creditTotal = 0;
			foreach ( $levelOne as $eachOne ){
				$accountTotal = accountTotal($eachOne->id);
				$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
				$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
				$debitTotal += ( $debit > 0 ) ? $debit : 0;
				$creditTotal += ( $credit > 0 ) ? $credit : 0;
				$data .= 	'<tr>
								<td>'.$eachOne->account_no.'</td>
								<td><b>'.$eachOne->description.'</b></td>
								<td>'.$debit.'</td>
								<td>'.$credit.'</td>
							</tr>';
					$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account='.$eachOne->id ) );
					foreach ( $levelTwo as $eachTwo ){
						$accountTotal = accountTotal($eachTwo->id);
						$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
						$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
						$debitTotal += ( $debit > 0 ) ? $debit : 0;
						$creditTotal += ( $credit > 0 ) ? $credit : 0;
						$data .= 	'<tr>
										<td>'.$eachTwo->account_no.'</td>
										<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>'.$eachTwo->description.'</b></td>
										<td>'.$debit.'</td>
										<td>'.$credit.'</td>
									</tr>';
							$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account='.$eachTwo->id ) );
							foreach( $levelThree as $eachThree  ){
								$accountTotal = accountTotal($eachThree->id);
								$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
								$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
								$debitTotal += ( $debit > 0 ) ? $debit : 0;
								$creditTotal += ( $credit > 0 ) ? $credit : 0;
								$data .= 	'<tr>
										<td>'.$eachThree->account_no.'</td>
										<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>'.$eachThree->description.'</b></td>
										<td>'.$debit.'</td>
										<td>'.$credit.'</td>
									</tr>';
								$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account='.$eachThree->id ) );
								foreach( $levelFour as $eachFour  ){
									$accountTotal = accountTotal($eachFour->id);
									$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
									$debitTotal += ( $debit > 0 ) ? $debit : 0;
									$creditTotal += ( $credit > 0 ) ? $credit : 0;
									$data .= 	'<tr>
											<td>'.$eachFour->account_no.'</td>
											<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
											<td>'.$debit.'</td>
											<td>'.$credit.'</td>
										</tr>';
									$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account='.$eachFour->id ) );
									foreach( $levelFive as $eachFive  ){
										$accountTotal = accountTotal($eachFive->id);
										$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
										$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
										$debitTotal += ( $debit > 0 ) ? $debit : 0;
										$creditTotal += ( $credit > 0 ) ? $credit : 0;
										$data .= 	'<tr>
												<td>'.$eachFive->account_no.'</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
												<td>'.$debit.'</td>
												<td>'.$credit.'</td>
											</tr>';
									}
								}
							}
					}
		}
		
		$data .=    '<tr>
						<td class="head" colspan="2"><b>Total</b></td>
						<td class="head">'.Yii::app()->numberFormatter->formatCurrency($debitTotal," ").'</td>
						<td class="head">'.Yii::app()->numberFormatter->formatCurrency($creditTotal," ").'</td>
					</tr>';
		$data .= '      </tbody>
					</table>
				</body>
			</html>';
		header ( "Content-type: application/vnd.ms-excel" );
		header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
		echo $data;
		Yii::app()->end();
		return;
	}

	public function actionTrialbalance_pdf() {
      
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$this->generateView('trial_balance', 0, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_trialbalance WHERE ledger_id='.$id)->queryScalar();
		}

		$data = '<tbody>';
			//We have 5 levels
			$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'level=1 AND type_of_account IN ("B", "P") ' ) );
			$debitTotal = $creditTotal = 0;
			foreach ( $levelOne as $eachOne ){
				$accountTotal = accountTotal($eachOne->id);
				$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
				$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
				$debitTotal += ( $debit > 0 ) ? $debit : 0;
				$creditTotal += ( $credit > 0 ) ? $credit : 0;
				$data .= 	'<tr>
								<td class="text-right">'.$eachOne->account_no.'</td>
								<td><b>'.$eachOne->description.'</b></td>
								<td class="text-right">'.$debit.'</td>
								<td class="text-right">'.$credit.'</td>
							</tr>';
					$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account='.$eachOne->id ) );
					foreach ( $levelTwo as $eachTwo ){
						$accountTotal = accountTotal($eachTwo->id);
						$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
						$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
						$debitTotal += ( $debit > 0 ) ? $debit : 0;
						$creditTotal += ( $credit > 0 ) ? $credit : 0;
						$data .= 	'<tr>
										<td class="text-right">'.$eachTwo->account_no.'</td>
										<td class="level_two"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
										<td class="text-right">'.$debit.'</td>
										<td class="text-right">'.$credit.'</td>
									</tr>';
							$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account='.$eachTwo->id ) );
							foreach( $levelThree as $eachThree  ){
								$accountTotal = accountTotal($eachThree->id);
								$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
								$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
								$debitTotal += ( $debit > 0 ) ? $debit : 0;
								$creditTotal += ( $credit > 0 ) ? $credit : 0;
								$data .= 	'<tr>
										<td class="text-right">'.$eachThree->account_no.'</td>
										<td class="level_three"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
										<td class="text-right">'.$debit.'</td>
										<td class="text-right">'.$credit.'</td>
									</tr>';
								$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account='.$eachThree->id ) );
								foreach( $levelFour as $eachFour  ){
									$accountTotal = accountTotal($eachFour->id);
									$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
									$debitTotal += ( $debit > 0 ) ? $debit : 0;
									$creditTotal += ( $credit > 0 ) ? $credit : 0;
									$data .= 	'<tr>
											<td class="text-right">'.$eachFour->account_no.'</td>
											<td class="level_four">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
									$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account='.$eachFour->id ) );
									foreach( $levelFive as $eachFive  ){
										$accountTotal = accountTotal($eachFive->id);
										$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
										$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
										$debitTotal += ( $debit > 0 ) ? $debit : 0;
										$creditTotal += ( $credit > 0 ) ? $credit : 0;
										$data .= 	'<tr>
												<td class="text-right">'.$eachFive->account_no.'</td>
												<td class="level_five">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
												<td class="text-right">'.$debit.'</td>
												<td class="text-right">'.$credit.'</td>
											</tr>';
									}
								}
							}
					}
			}

					$data .=    '<tr>
									<td colspan="2" class="text-right"><b>Total</b></td>
									<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($debitTotal," ").'</b></td>
									<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($creditTotal," ").'</b></td>
								</tr>';
			$data .= '  </tbody>';
        
		$param = array( 'data' => $data, 'to_date' => $to_date );
		$mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_trial_balance', $param, true));

        $mpdf->Output("trialbalance".date("d-m-Y"), 'I');
    }


	public function actionGlsummary_excel(){
		
        $to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$ledger = (int) $_GET['ledger'];
		
		$this->generateView('gl_summary', 0, $to_date, $ledger);

		$summaryItems = Yii::app()->db->createCommand('SELECT * FROM view_finance_gl_summary')->queryAll();

		$filename = "gl_summary".date('dmYhis').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Subledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';

			$totalDebit = $totalCredit = 0;
			foreach ( $summaryItems as $each ){
				
				$debit = ( $each['balance'] > 0 ) ? $each['balance'] : '';
				$credit = ( $each['balance'] < 0 ) ? abs($each['balance']) : '';

				$data .=     '<tr>
								<td>'.$each['subledger_no'].'</td>
								<td>'.$each['subledger_name'].'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency($debit," ").'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency($credit," ").'</td>
							</tr>';

					$totalDebit += 	$debit;
					$totalCredit += $credit;
				}

		$data .=    '<tr>
						<td class="head" colspan="2"><b>Total</b></td>
						<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency($totalDebit," ").'</b></td>
						<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency($totalCredit," ").'</b></td>
					</tr>';
		
		$balance = $totalDebit - $totalCredit;
		
		$debitBalance = ( $balance > 0 ) ? $balance : 0;
		$creditBalance = ( $balance <= 0 ) ? abs($balance) : 0;

		$data .=  '<tr>
					<td class="head" colspan="2"><b>Balance</b></td>
					<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency($debitBalance," ").'</b></td>
					<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency($creditBalance," ").'</b></td>
				</tr>';
		$data .= '      </tbody>
					</table>
				</body>
			</html>';
		header ( "Content-type: application/vnd.ms-excel" );
		header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
		echo $data;
		Yii::app()->end();
		return;
	}

	public function actionStatement_excel(){
		
		$from_date = ( count(explode('/',$_GET['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date'])))  : date('Y-m-d');
        $to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		
		$ledger = (int) $_GET['ledger'];
		$subledger = (int) $_GET['subledger'];
		
		$condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
		$condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "'.$from_date.'"';

		if( $ledger > 0 ){
			$condition .= ' AND t.ledger_id='.$ledger;
			$condition_for_opening .= ' AND I.ledger_id='.$ledger;
		}
		if( $subledger > 0 ){
			$condition .= ' AND t.subledger_id='.$subledger;
			$condition_for_opening .= ' AND I.subledger_id='.$subledger;
		}

		$openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE '.$condition_for_opening.' ')->queryScalar();
		$items = FinanceVoucherItems::model()->with('parent')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
		
		$filename = "statement".date('dmYhis').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
							<thead>
								<th class="head">Date</th>
								<th class="head">Voucher No</th>
								<th class="head">Narration</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
								<th class="head">Balance</th>
                            </thead>
							<tbody>';
		$previousBalance = $openingBalance;
		$closingBalance = $openingBalance;
		$symbol = ( $previousBalance > 0 ) ? 'Dr' : 'Cr';
		$data .=    '<tr>
						<td colspan="3"><b>Opening Balance</b></td>
						<td>'.Yii::app()->numberFormatter->formatCurrency( ( ( $previousBalance > 0  ) ? $previousBalance : '' )," ").'</td>
						<td>'.Yii::app()->numberFormatter->formatCurrency( ( ( $previousBalance < 0  ) ? abs($previousBalance) : '' )," ").'</td>
						<td>'.Yii::app()->numberFormatter->formatCurrency(abs($previousBalance)," ").' '.$symbol.'</td>
					</tr>';
		foreach ( $items as $each ){
				
				$debit = ( $each->amount > 0 ) ? $each->amount : '';
				$credit = ( $each->amount < 0 ) ? abs($each->amount) : '';
				$running = $debit - $credit + $previousBalance;
				$previousBalance = $running;
				$symbol = ( $running > 0 ) ? 'Dr' : 'Cr';
				$closingBalance +=  ( $debit - $credit );

				$subledgerName = ( $each->subledger_id > 0 ) ? $each->subledger->description : '';
				$data .=     '<tr>
								<td>'.$each->parent->voucher_date.'</td>
								<td>'.$each->parent->fullvoucher.'</td>
								<td>'.$each->narration.'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency($debit," ").'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency($credit," ").'</td>
								<td>'.Yii::app()->numberFormatter->formatCurrency(abs($running)," ").' '.$symbol.'</td>
							</tr>';
		}
		$symbol = ( $closingBalance > 0 ) ? 'Dr' : 'Cr';
		$data .=    '<tr>
						<td class="head" colspan="5"><b>Closing Balance</b></td>
						<td class="head">'.Yii::app()->numberFormatter->formatCurrency(abs($closingBalance)," ").' '.$symbol.'</td>
					</tr>';
		$data .= '      </tbody>
					</table>
				</body>
			</html>';
		header ( "Content-type: application/vnd.ms-excel" );
		header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
		echo $data;
		Yii::app()->end();
		return;
	}

	public function actionStatement_pdf() {
        $from_date  = Yii::app()->request->getParam('from_date');
        $to_date    = Yii::app()->request->getParam('to_date');
        $ledger     = Yii::app()->request->getParam('ledger');
        $subledger  = Yii::app()->request->getParam('subledger');
        $param = array(
            'from_date' => $from_date,
            'to_date'   => $to_date,
            'ledger'    => $ledger,
            'subledger' => $subledger
        );
        
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_statement', $param, true));

        $mpdf->Output("statement_of_account".date("d-m-Y"), 'I');
	}
	
	public function actionGlsummary_pdf() {
      
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$ledger     = Yii::app()->request->getParam('ledger');
		
		$this->generateView('gl_summary', 0, $to_date, $ledger);
      
        $param = array(
            'to_date'   => $to_date,
            'ledger'    => $ledger,
        );
        
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_gl_summary', $param, true));

        $mpdf->Output("gl_summary".date("d-m-Y"), 'I');
	}
	
	public function actionBalancesheet_excel(){
		
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$lastSavedid = 0;
		
		$accountingPeriod = FinanceVoucherType::generateAccountingperiod(date('Y-m-d'));
		$balanceQuery = 'SELECT SUM(amount) AS amount FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id WHERE V.is_posted="Y" AND V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "'.$accountingPeriod['from'].'" AND "'.$accountingPeriod['to'].'"';
		$grossProfitorloss = Yii::app()->db->createCommand( $balanceQuery )->queryScalar();
			
		$voucherHead = array();
		$voucherHead['voucher_type'] = 11; //Year Closing
		$voucherHead['voucher_no'] = date('Y');
		$voucherHead['voucher_date'] = date('Y-m-d');
		$voucherHead['header_table_id'] = 0;
		$voucherHead['reference_no'] = 'System generated voucher';
		$voucherHead['is_posted'] = 'Y';
		$voucherHead['created_by'] = Yii::app()->user->id;
		$voucherHead['created_datetime'] = date('Y-m-d h:i:s');
			
		$lastSavedid = $this->addVoucherhead($voucherHead);
		if( $lastSavedid > 0 ){
			$this->addVoucheritems($lastSavedid, array( 'narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit') ));
			$this->addVoucheritems($lastSavedid, array( 'narration' => 'Current Year Profit', 'amount' => -1*$grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('net_profit') ));
		}

		$this->generateView('trial_balance', 0, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_balancesheet WHERE ledger_id='.$id)->queryScalar();
		}

		$filename = "balancesheet".date('dmYhis').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Ledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';
			//We have 5 levels
			$balanceSheet = array( 'A' => 'Assets', 'L' => 'Equity & Liabilities' );
			foreach( $balanceSheet as $key => $head ){
				$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'level=1 AND main_account_type="'.$key.'"', 'order' => 'main_account_type' ) );
				$debitTotal = $creditTotal =  0;
				foreach ( $levelOne as $eachOne ){
					$accountTotal = accountTotal($eachOne->id);
					$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
					$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
					$debitTotal += $debit;
					$creditTotal += $credit;

					$data .= 	'<tr>
									<td>'.$eachOne->account_no.'</td>
									<td><b>'.$eachOne->description.'</b></td>
									<td class="text-right">'.$debit.'</td>
									<td class="text-right">'.$credit.'</td>
								</tr>';
						$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'level=2 AND parent_account='.$eachOne->id ) );
						foreach ( $levelTwo as $eachTwo ){
							$accountTotal = accountTotal($eachTwo->id);
							$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
							$debitTotal += $debit;
							$creditTotal += $credit;

							$data .= 	'<tr>
											<td>'.$eachTwo->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
								$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'level=3 AND parent_account='.$eachTwo->id ) );
								foreach( $levelThree as $eachThree  ){
									$accountTotal = accountTotal($eachThree->id);
									$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
									$debitTotal += $debit;
									$creditTotal += $credit;

									$data .= 	'<tr>
											<td>'.$eachThree->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
									$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'level=4 AND parent_account='.$eachThree->id ) );
									foreach( $levelFour as $eachFour  ){
										$accountTotal = accountTotal($eachFour->id);
										$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
										$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
										$debitTotal += $debit;
										$creditTotal += $credit;

										$data .= 	'<tr>
												<td>'.$eachFour->account_no.'</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
												<td class="text-right">'.$debit.'</td>
												<td class="text-right">'.$credit.'</td>
											</tr>';
										$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'level=5 AND parent_account='.$eachFour->id ) );
										foreach( $levelFive as $eachFive  ){
											$accountTotal = accountTotal($eachFive->id);
											$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
											$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
											$debitTotal += $debit;
											$creditTotal += $credit;

											$data .= 	'<tr>
													<td>'.$eachFive->account_no.'</td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
													<td class="text-right">'.$debit.'</td>
													<td class="text-right">'.$credit.'</td>
												</tr>';
										}
									}
								}
						}
			}
			
			$balance = $debitTotal - $creditTotal;
			$finalDebit =  ( $balance > 0 ) ? Yii::app()->numberFormatter->formatCurrency($balance," ") : '';
			$finalCredit =  ( $balance < 0 ) ? Yii::app()->numberFormatter->formatCurrency(abs($balance)," ") : '';
			$data .=   '<tr>
								<td class="head" colspan="2" class="text-right"><b>Total '.$head.'</b></td>
								<td class="head" class="text-right"><b>'.$finalDebit.'</b></td>
								<td class="head" class="text-right"><b>'.$finalCredit.'</b></td>						
							</tr>';
		}
		$data .= '      </tbody>
					</table>
				</body>
			</html>';
		
		if( $lastSavedid > 0 ){
			FinanceVoucherHead::model()->deletebypk($lastSavedid);
			FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
		}

		header ( "Content-type: application/vnd.ms-excel" );
		header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
		echo $data;
		Yii::app()->end();
		return;
	}

	public function actionBalancesheet_pdf(){
		
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$lastSavedid = 0;
		
		$accountingPeriod = FinanceVoucherType::generateAccountingperiod(date('Y-m-d'));
		$balanceQuery = 'SELECT SUM(amount) AS amount FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id WHERE V.is_posted="Y" AND V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "'.$accountingPeriod['from'].'" AND "'.$accountingPeriod['to'].'"';
		$grossProfitorloss = Yii::app()->db->createCommand( $balanceQuery )->queryScalar();
			
		$voucherHead = array();
		$voucherHead['voucher_type'] = 11; //Year Closing
		$voucherHead['voucher_no'] = date('Y');
		$voucherHead['voucher_date'] = date('Y-m-d');
		$voucherHead['header_table_id'] = 0;
		$voucherHead['reference_no'] = 'System generated voucher';
		$voucherHead['is_posted'] = 'Y';
		$voucherHead['created_by'] = Yii::app()->user->id;
		$voucherHead['created_datetime'] = date('Y-m-d h:i:s');
			
		$lastSavedid = $this->addVoucherhead($voucherHead);
		if( $lastSavedid > 0 ){
			$this->addVoucheritems($lastSavedid, array( 'narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit') ));
			$this->addVoucheritems($lastSavedid, array( 'narration' => 'Current Year Profit', 'amount' => -1*$grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('net_profit') ));
		}
		
		$this->generateView('trial_balance', 0, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_balancesheet WHERE ledger_id='.$id)->queryScalar();
		}
		$data = array();
      
			//We have 5 levels
			$balanceSheet = array( 'A' => 'Assets', 'L' => 'Equity & Liabilities' );
			foreach( $balanceSheet as $key => $head ){
				$data[$key] = '<tbody>';
				$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'level=1 AND main_account_type="'.$key.'"', 'order' => 'main_account_type' ) );
				$debitTotal = $creditTotal =  0;
				foreach ( $levelOne as $eachOne ){
					$accountTotal = accountTotal($eachOne->id);
					$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
					$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
					$debitTotal += $debit;
					$creditTotal += $credit;

					$data[$key] .= 	'<tr>
									<td><b>'.$eachOne->account_no.'</b></td>
									<td><b>'.$eachOne->description.'</b></td>
									<td class="text-right">'.$debit.'</td>
									<td class="text-right">'.$credit.'</td>
								</tr>';
						$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'level=2 AND parent_account='.$eachOne->id ) );
						foreach ( $levelTwo as $eachTwo ){
							$accountTotal = accountTotal($eachTwo->id);
							$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
							$debitTotal += $debit;
							$creditTotal += $credit;

							$data[$key] .= 	'<tr>
											<td><b>'.$eachTwo->account_no.'</b></td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
								$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'level=3 AND parent_account='.$eachTwo->id ) );
								foreach( $levelThree as $eachThree  ){
									$accountTotal = accountTotal($eachThree->id);
									$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
									$debitTotal += $debit;
									$creditTotal += $credit;

									$data[$key] .= 	'<tr>
											<td><b>'.$eachThree->account_no.'</b></td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
									$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'level=4 AND parent_account='.$eachThree->id ) );
									foreach( $levelFour as $eachFour  ){
										$accountTotal = accountTotal($eachFour->id);
										$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
										$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
										$debitTotal += $debit;
										$creditTotal += $credit;

										$data[$key] .= 	'<tr>
												<td><b>'.$eachFour->account_no.'</b></td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
												<td class="text-right">'.$debit.'</td>
												<td class="text-right">'.$credit.'</td>
											</tr>';
										$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'level=5 AND parent_account='.$eachFour->id ) );
										foreach( $levelFive as $eachFive  ){
											$accountTotal = accountTotal($eachFive->id);
											$debit = ( $accountTotal > 0 ) ? $accountTotal : '';
											$credit = ( $accountTotal < 0 ) ?  abs($accountTotal) : '';
											$debitTotal += $debit;
											$creditTotal += $credit;

											$data[$key] .= 	'<tr>
													<td><b>'.$eachFive->account_no.'</b></td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
													<td class="text-right">'.$debit.'</td>
													<td class="text-right">'.$credit.'</td>
												</tr>';
										}
									}
								}
						}
			}
			$balance = $debitTotal - $creditTotal;
			$finalDebit =  ( $balance > 0 ) ? Yii::app()->numberFormatter->formatCurrency($balance," ") : '';
			$finalCredit =  ( $balance < 0 ) ? Yii::app()->numberFormatter->formatCurrency(abs($balance)," ") : '';
			$data[$key] .=   '<tr>
								<td class="head" colspan="2" class="text-right"><b>Total '.$head.'</b></td>
								<td class="head" class="text-right"><b>'.$finalDebit.'</b></td>
								<td class="head" class="text-right"><b>'.$finalCredit.'</b></td>						
							</tr>';
			$data[$key] .= '</tbody>';
			}
		
			$mpdf = Yii::app()->ePdf->mpdf('', 'A4');
			$stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
			$mpdf->WriteHTML($stylesheet, 1);
			$mpdf->WriteHTML($this->renderPartial('print_balancesheet', array( 'data' => $data, 'to_date' => $to_date ), true));
			$mpdf->Output("balancesheet".date("d-m-Y"), 'I');

			if( $lastSavedid > 0 ){
				FinanceVoucherHead::model()->deletebypk($lastSavedid);
				FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
			}
	}

	public function actionProfitorloss_pdf(){
		
		$from_date = ( count(explode('/',$_GET['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date'])))  : date('Y-m-d');
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-t');

		$this->generateView('profit_or_loss', $from_date, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_profit_or_loss WHERE ledger_id='.$id)->queryScalar();
		}

		function isCostosale( $id ){
			return ( $id == FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale')  ) ? true : false;
		}

		$data = array();
      
			//We have 5 levels
			$balanceSheet = array( 'I' => 'Income', 'E' => 'Expense' );
			$totalIncome = 0;
			$cost_of_sale = 0;
			$totalExpense = 0;
			foreach( $balanceSheet as $key => $head ){
				$data[$key] = '<tbody>';
				$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=1 AND main_account_type="'.$key.'"' ) );
				$totalAmount = 0;
				foreach ( $levelOne as $eachOne ){
					$accountTotal = accountTotal($eachOne->id);
					$amount = abs($accountTotal);
					$totalAmount += $accountTotal;

					$data[$key] .= 	'<tr>
										<td><b>'.$eachOne->account_no.'</b></td>
										<td><b>'.$eachOne->description.'</b></td>
										<td class="text-right">'.$amount.'</td>
									</tr>';
						$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=2 AND parent_account='.$eachOne->id ) );
						foreach ( $levelTwo as $eachTwo ){
							$accountTotal = accountTotal($eachTwo->id);
							$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
							$amount = abs($accountTotal);
							$totalAmount += $accountTotal;

							$data[$key] .= 	'<tr>
												<td><b>'.$eachTwo->account_no.'</b></td>
												<td><b>&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
												<td class="text-right">'.$amount.'</td>
											</tr>';
								if( $key == 'E' && isCostosale($eachTwo->id) )
										$cost_of_sale = $amount;
								$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=3 AND parent_account='.$eachTwo->id ) );
								foreach( $levelThree as $eachThree  ){
									$accountTotal = accountTotal($eachThree->id);
									$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
									$amount = abs($accountTotal);
									$totalAmount += $accountTotal;

									$data[$key] .= 	'<tr>
														<td><b>'.$eachThree->account_no.'</b></td>
														<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
														<td class="text-right">'.$amount.'</td>
													</tr>';
									if( $key == 'E' && isCostosale($eachThree->id) )
										$cost_of_sale = $amount;
									$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=4 AND parent_account='.$eachThree->id ) );
									foreach( $levelFour as $eachFour  ){
										$accountTotal = accountTotal($eachFour->id);
										$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
										$amount = abs($accountTotal);
										$totalAmount += $accountTotal;

										$data[$key] .= 	'<tr>
															<td><b>'.$eachFour->account_no.'</b></td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
															<td class="text-right">'.$amount.'</td>
														</tr>';
										if( $key == 'E' && isCostosale($eachFour->id) )
											$cost_of_sale = $amount;
										$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=5 AND parent_account='.$eachFour->id ) );
										foreach( $levelFive as $eachFive  ){
											$accountTotal = accountTotal($eachFive->id);
											$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
											$amount = abs($accountTotal);
											$totalAmount += $accountTotal;

											$data[$key] .= 	'<tr>
																<td><b>'.$eachFive->account_no.'</b></td>
																<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
																<td class="text-right">'.$amount.'</td>
															</tr>';
											if( $key == 'E' && isCostosale($eachFive->id) )
												$cost_of_sale = $amount;
										}
									}
								}
						}
				if( $key == 'I' )
					$totalIncome = $totalAmount;
				if( $key == 'E' )
					$totalExpense = $totalAmount;
			}
			
			$symbol = ( $totalAmount > 0 ) ?  'Dr' : 'Cr';

			$data[$key] .=    '<tr>
							<td colspan="2" class="text-right"><b>Total '.$head.'</b></td>
							<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($totalAmount)," ").'</b></td>
						</tr>';
			$data[$key] .= '</tbody>';
			}

			$footer = '<tr>
						<td colspan="2" class="text-right"><b>Total Cogs</b></td>
						<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($cost_of_sale," ").'</b></td>
					  </tr>
					  <tr>
						<td colspan="2" class="text-right"><b>Gross Profit</b></td>
						<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency((abs($totalIncome) - abs($cost_of_sale) )," ").'</b></td>
					  </tr>';
			$state = ( abs($totalIncome) - abs($totalExpense) > 0 ) ? 'Profit' : 'Loss';
			$color = ( abs($totalIncome) - abs($totalExpense) > 0 ) ? '#97ff95' : '#ffa295';
			$value = abs($totalIncome) - abs($totalExpense);
		  	$footer .= '<tr style="background-color:'.$color.'">
						<td colspan="2" class="text-right"><b>Net '.$state.'</b></td>
						<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($value) ," ").'</b></td>
						</tr>';
		
			$mpdf = Yii::app()->ePdf->mpdf('', 'A4');
			$stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
			$mpdf->WriteHTML($stylesheet, 1);
			$mpdf->WriteHTML($this->renderPartial('print_profit_or_loss', array( 'data' => $data, 'from_date' => $from_date, 'to_date' => $to_date, 'footer' => $footer ), true));
	
			$mpdf->Output("profitorloss".date("d-m-Y"), 'I');
	}

	public function actionProfitorloss_excel(){
		
		$from_date = ( count(explode('/',$_GET['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date'])))  : date('Y-m-d');
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-t');

		$this->generateView('profit_or_loss', $from_date, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_profit_or_loss WHERE ledger_id='.$id)->queryScalar();
		}

		function isCostosale( $id ){
			return ( $id == FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale')  ) ? true : false;
		}

      
			//We have 5 levels
			$balanceSheet = array( 'I' => 'Income', 'E' => 'Expense' );
			$totalIncome = 0;
			$cost_of_sale = 0;
			$totalExpense = 0;
			$filename = "balancesheet".date('dmYhis').".xls";
			$data = '<html>
						<head>
							<style>
								table{
									width:100%;
								}
								.head{
									background-color : yellow;
									font-weight: bold;
									font-size: 14px;
								}
								.total{
									text-align: right;
									font-weight: bold;
									font-size: 14px;
								}
							</style>
						</head>
						<body>
							<table border=1>
								<thead>
									<th class="head">#</th>
									<th class="head">Ledger</th>
									<th class="head">Amount</th>
								</thead>
								<tbody>';
			foreach( $balanceSheet as $key => $head ){
				$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=1 AND main_account_type="'.$key.'"' ) );
				$totalAmount = 0;
				foreach ( $levelOne as $eachOne ){
					$accountTotal = accountTotal($eachOne->id);
					$amount = abs($accountTotal);
					$totalAmount += $accountTotal;

					$data .= 	'<tr>
										<td><b>'.$eachOne->account_no.'</b></td>
										<td><b>'.$eachOne->description.'</b></td>
										<td class="text-right">'.$amount.'</td>
									</tr>';
						$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=2 AND parent_account='.$eachOne->id ) );
						foreach ( $levelTwo as $eachTwo ){
							$accountTotal = accountTotal($eachTwo->id);
							$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
							$amount = abs($accountTotal);
							$totalAmount += $accountTotal;

							$data .= 	'<tr>
												<td><b>'.$eachTwo->account_no.'</b></td>
												<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
												<td class="text-right">'.$amount.'</td>
											</tr>';
								if( $key == 'E' && isCostosale($eachTwo->id) )
										$cost_of_sale = $amount;
								$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=3 AND parent_account='.$eachTwo->id ) );
								foreach( $levelThree as $eachThree  ){
									$accountTotal = accountTotal($eachThree->id);
									$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
									$amount = abs($accountTotal);
									$totalAmount += $accountTotal;

									$data .= 	'<tr>
														<td><b>'.$eachThree->account_no.'</b></td>
														<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
														<td class="text-right">'.$amount.'</td>
													</tr>';
									if( $key == 'E' && isCostosale($eachThree->id) )
										$cost_of_sale = $amount;
									$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=4 AND parent_account='.$eachThree->id ) );
									foreach( $levelFour as $eachFour  ){
										$accountTotal = accountTotal($eachFour->id);
										$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
										$amount = abs($accountTotal);
										$totalAmount += $accountTotal;

										$data .= 	'<tr>
															<td><b>'.$eachFour->account_no.'</b></td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
															<td class="text-right">'.$amount.'</td>
														</tr>';
										if( $key == 'E' && isCostosale($eachFour->id) )
											$cost_of_sale = $amount;
										$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'type_of_account IN ("P") AND level=5 AND parent_account='.$eachFour->id ) );
										foreach( $levelFive as $eachFive  ){
											$accountTotal = accountTotal($eachFive->id);
											$symbol = ( $accountTotal > 0 ) ?  'Dr' : 'Cr';
											$amount = abs($accountTotal);
											$totalAmount += $accountTotal;

											$data .= 	'<tr>
																<td><b>'.$eachFive->account_no.'</b></td>
																<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
																<td class="text-right">'.$amount.'</td>
															</tr>';
											if( $key == 'E' && isCostosale($eachFive->id) )
												$cost_of_sale = $amount;
										}
									}
								}
						}
				if( $key == 'I' )
					$totalIncome = $totalAmount;
				if( $key == 'E' )
					$totalExpense = $totalAmount;
			}
			
			$symbol = ( $totalAmount > 0 ) ?  'Dr' : 'Cr';

			$data .=    '<tr>
							<td colspan="2" class="head"><b>Total '.$head.'</b></td>
							<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($totalAmount)," ").'</b></td>
						</tr>';
			}

			$data .= '<tr>
						<td colspan="2" class="head"><b>Total Cogs</b></td>
						<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency($cost_of_sale," ").'</b></td>
					  </tr>
					  <tr>
						<td colspan="2" class="head"><b>Gross Profit</b></td>
						<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency((abs($totalIncome) - abs($cost_of_sale) )," ").'</b></td>
					  </tr>';
			$state = ( abs($totalIncome) - abs($totalExpense) > 0 ) ? 'Profit' : 'Loss';
			$value = abs($totalIncome) - abs($totalExpense);
		  	$data .= '<tr>
						<td colspan="2" class="head"><b>Net '.$state.'</b></td>
						<td class="head"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($value)," ").'</b></td>
						</tr>';
						$data .= '      </tbody>
						</table>
					</body>
				</html>';
			header ( "Content-type: application/vnd.ms-excel" );
			header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
			echo $data;
			Yii::app()->end();
			return;
	}

	public function addVoucherhead($arr_items){
		$model = new FinanceVoucherHead;
		$model->voucher_type = $arr_items['voucher_type'];
		$model->voucher_no = $arr_items['voucher_no'];
		$model->voucher_date = $arr_items['voucher_date'];
		$model->due_date = $model->voucher_date;
		$model->header_table_id = $arr_items['header_table_id'];
		$model->reference_no = $arr_items['reference_no'];
		$model->is_posted = 'Y';
		$model->created_by = Yii::app()->user->id;
		$model->created_datetime = date('Y-m-d h:i:s');
		return ( $model->save(false) ) ? $model->id : 0; //exception
	}

	public function addVoucheritems($headerId, $arr_items){
		$model = new FinanceVoucherItems;
		$model->header_id = $headerId;
		$model->ledger_id = $arr_items['ledger_id'];
		$model->subledger_id = $arr_items['subledger_id'];
		$model->narration = $arr_items['narration'];
		$model->amount= $arr_items['amount'];
		$model->save(false);
	}

	public function actionTrialbalance_pdf_detailed() {
      
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$this->generateView('trial_balance_detailed', 0, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_trialbalance_detailed WHERE ledger_id='.$id)->queryScalar();
		}
		
		function accountTotalsubledger( $id, $sub ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_trialbalance_detailed WHERE ledger_id='.$id.' AND subledger_id='.$sub)->queryScalar();
		}
		function getAllsubledgers(  $id ){
			return Yii::app()->db->createCommand('SELECT subledger_id AS id, subledger_name, subledger_no FROM view_finance_trialbalance_detailed WHERE ledger_id='.$id)->queryAll();
		}
		$data = '<tbody>';
			//We have 5 levels
			$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'level=1 AND type_of_account IN ("B", "P") ' ) );
			$debitTotal = $creditTotal = 0;
			foreach ( $levelOne as $eachOne ){
				if( $eachOne->haveSubledger == 'Y' ){
					$data .= 	'<tr>
									<td class="text-right">'.$eachOne->account_no.'</td>
									<td><b>'.$eachOne->description.'</b></td>
									<td class="text-right"></td>
									<td class="text-right"></td>
								</tr>';
					$allSublegders = getAllsubledgers( $eachOne->id );
					if( !empty( $allSublegders ) )
						foreach( $allSublegders as $eachsub ){
							$accountTotal = accountTotalsubledger($eachOne->id, $eachsub['id']);
							$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
							$debitTotal += ( $debit > 0 ) ? $debit : 0;
							$creditTotal += ( $credit > 0 ) ? $credit : 0;
							$data .= '<tr>
										<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
										<td><small><i>'.$eachsub['subledger_name'].'</i></small></td>
										<td class="text-right"><small><b><i>'.$debit.'</i></b></small></td>
										<td class="text-right"><small><b><i>'.$credit.'</i></b></small></td>
									</tr>';
						}
				}else{
							$accountTotal = accountTotal($eachOne->id);
							$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
							$debitTotal += ( $debit > 0 ) ? $debit : 0;
							$creditTotal += ( $credit > 0 ) ? $credit : 0;
							$data .= 	'<tr>
									<td class="text-right">'.$eachOne->account_no.'</td>
									<td><b>'.$eachOne->description.'</b></td>
									<td class="text-right">'.$debit.'</td>
									<td class="text-right">'.$credit.'</td>
								</tr>';
				}
					$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account='.$eachOne->id ) );
					foreach ( $levelTwo as $eachTwo ){
						if( $eachTwo->haveSubledger == 'Y' ){
							$data .= 	'<tr>
											<td class="text-right">'.$eachTwo->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
											<td class="text-right"></td>
											<td class="text-right"></td>
										</tr>';
							$allSublegders = getAllsubledgers( $eachTwo->id );
							if( !empty( $allSublegders ) )
								foreach( $allSublegders as $eachsub ){
									$accountTotal = accountTotalsubledger($eachTwo->id, $eachsub['id']);
									$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
									$debitTotal += ( $debit > 0 ) ? $debit : 0;
									$creditTotal += ( $credit > 0 ) ? $credit : 0;
									$data .= '<tr>
												<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
												<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</small></i></td>
												<td class="text-right"><small><b><i>'.$debit.'</i></b></small></td>
												<td class="text-right"><small><b><i>'.$credit.'</i></b></small></td>
											</tr>';
								}
						}else{
							$accountTotal = accountTotal($eachTwo->id);
							$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
							$debitTotal += ( $debit > 0 ) ? $debit : 0;
							$creditTotal += ( $credit > 0 ) ? $credit : 0;
							$data .= 	'<tr>
											<td class="text-right">'.$eachTwo->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
						}
							$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account='.$eachTwo->id ) );
							foreach( $levelThree as $eachThree  ){
								if( $eachThree->haveSubledger == 'Y' ){
									$data .= 	'<tr>
													<td class="text-right">'.$eachThree->account_no.'</td>
													<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
													<td class="text-right"></td>
													<td class="text-right"></td>
												</tr>';
									$allSublegders =  getAllsubledgers( $eachThree->id );
									if( !empty( $allSublegders ) )
										foreach( $allSublegders as $eachsub ){
											$accountTotal = accountTotalsubledger($eachThree->id, $eachsub['id']);
											$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
											$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
											$debitTotal += ( $debit > 0 ) ? $debit : 0;
											$creditTotal += ( $credit > 0 ) ? $credit : 0;
											$data .= '<tr>
														<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
														<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</small></i></td>
														<td class="text-right"><small><b><i>'.$debit.'</i></b></small></td>
														<td class="text-right"><small><b><i>'.$credit.'</i></b></small></td>
													</tr>';
										}
								}else{
									$accountTotal = accountTotal($eachThree->id);
									$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
									$debitTotal += ( $debit > 0 ) ? $debit : 0;
									$creditTotal += ( $credit > 0 ) ? $credit : 0;
									$data .= 	'<tr>
											<td class="text-right">'.$eachThree->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
								}
								$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account='.$eachThree->id ) );
								foreach( $levelFour as $eachFour  ){
									if( $eachFour->haveSubledger == 'Y' ){
										$data .= 	'<tr>
														<td class="text-right">'.$eachFour->account_no.'</td>
														<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
														<td class="text-right"></td>
														<td class="text-right"></td>
													</tr>';
										$allSublegders =  getAllsubledgers( $eachFour->id );
										if( !empty( $allSublegders ) )
											foreach( $allSublegders as $eachsub ){
												$accountTotal = accountTotalsubledger($eachFour->id, $eachsub['id']);
												$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
												$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
												$debitTotal += ( $debit > 0 ) ? $debit : 0;
												$creditTotal += ( $credit > 0 ) ? $credit : 0;
												$data .= '<tr>
															<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
															<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</small></i></td>
															<td class="text-right"><small><b><i>'.$debit.'</i></b></small></td>
															<td class="text-right"><small><b><i>'.$credit.'</i></b></small></td>
														</tr>';
											}
									}else{
										$accountTotal = accountTotal($eachFour->id);
										$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
										$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
										$debitTotal += ( $debit > 0 ) ? $debit : 0;
										$creditTotal += ( $credit > 0 ) ? $credit : 0;
										$data .= 	'<tr>
												<td class="text-right">'.$eachFour->account_no.'</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
												<td class="text-right">'.$debit.'</td>
												<td class="text-right">'.$credit.'</td>
											</tr>';
									}

									$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account='.$eachFour->id ) );
									foreach( $levelFive as $eachFive  ){
										if( $eachFive->haveSubledger == 'Y' ){
											$data .= 	'<tr>
															<td class="text-right">'.$eachFive->account_no.'</td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
															<td class="text-right"></td>
															<td class="text-right"></td>
														</tr>';
											$allSublegders =  getAllsubledgers( $eachFive->id );
											if( !empty( $allSublegders ) )
												foreach( $allSublegders as $eachsub ){
													$accountTotal = accountTotalsubledger($eachFive->id, $eachsub['id']);
													$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
													$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
													$debitTotal += ( $debit > 0 ) ? $debit : 0;
													$creditTotal += ( $credit > 0 ) ? $credit : 0;
													$data .= '<tr>
																<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
																<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</small></i></td>
																<td class="text-right"><small><b><i>'.$debit.'</i></b></small></td>
																<td class="text-right"><small><b><i>'.$credit.'</i></b></small></td>
															</tr>';
												}
										}else{
											$accountTotal = accountTotal($eachFive->id);
											$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
											$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
											$debitTotal += ( $debit > 0 ) ? $debit : 0;
											$creditTotal += ( $credit > 0 ) ? $credit : 0;
											$data .= 	'<tr>
													<td class="text-right">'.$eachFive->account_no.'</td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
													<td class="text-right">'.$debit.'</td>
													<td class="text-right">'.$credit.'</td>
												</tr>';
										}
									}
								}
							}
					}
			}

					$data .=    '<tr>
									<td colspan="2" class="text-right"><b>Total</b></td>
									<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($debitTotal," ").'</b></td>
									<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($creditTotal," ").'</b></td>
								</tr>';
			$data .= '  </tbody>';
        
		$param = array( 'data' => $data, 'to_date' => $to_date );
		$mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_trial_balance', $param, true));

        $mpdf->Output("trialbalance".date("d-m-Y"), 'I');
	}
	
	public function actionTrialbalance_excel_detailed() {
      
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$this->generateView('trial_balance_detailed', 0, $to_date, 0);
		
		function accountTotal( $id ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_trialbalance_detailed WHERE ledger_id='.$id)->queryScalar();
		}
		
		function accountTotalsubledger( $id, $sub ){
			return (float) Yii::app()->db->createCommand('SELECT balance FROM view_finance_trialbalance_detailed WHERE ledger_id='.$id.' AND subledger_id='.$sub)->queryScalar();
		}
		function getAllsubledgers(  $id ){
			return Yii::app()->db->createCommand('SELECT subledger_id AS id, subledger_name, subledger_no FROM view_finance_trialbalance_detailed WHERE ledger_id='.$id)->queryAll();
		}
		$filename = "trialbalance".date('dmYhis').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Ledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';

			//We have 5 levels
			$levelOne = FinanceLegder::model()->findAll( array( 'condition' => 'level=1 AND type_of_account IN ("B", "P") ' ) );
			$debitTotal = $creditTotal = 0;
			foreach ( $levelOne as $eachOne ){
				if( $eachOne->haveSubledger == 'Y' ){
					$data .= 	'<tr>
									<td class="text-right">'.$eachOne->account_no.'</td>
									<td><b>'.$eachOne->description.'</b></td>
									<td class="text-right"></td>
									<td class="text-right"></td>
								</tr>';
					$allSublegders = getAllsubledgers( $eachOne->id );
					if( !empty( $allSublegders ) )
						foreach( $allSublegders as $eachsub ){
							$accountTotal = accountTotalsubledger($eachOne->id, $eachsub['id']);
							$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
							$debitTotal += ( $debit > 0 ) ? $debit : 0;
							$creditTotal += ( $credit > 0 ) ? $credit : 0;
							$data .= '<tr>
										<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
										<td><i>'.$eachsub['subledger_name'].'</i></td>
										<td class="text-right"><small><b>'.$debit.'</b></small></td>
										<td class="text-right"><small><b>'.$credit.'</b></small></td>
									</tr>';
						}
				}else{
							$accountTotal = accountTotal($eachOne->id);
							$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
							$debitTotal += ( $debit > 0 ) ? $debit : 0;
							$creditTotal += ( $credit > 0 ) ? $credit : 0;
							$data .= 	'<tr>
									<td class="text-right">'.$eachOne->account_no.'</td>
									<td><b>'.$eachOne->description.'</b></td>
									<td class="text-right">'.$debit.'</td>
									<td class="text-right">'.$credit.'</td>
								</tr>';
				}
					$levelTwo = FinanceLegder::model()->findAll( array( 'condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account='.$eachOne->id ) );
					foreach ( $levelTwo as $eachTwo ){
						if( $eachTwo->haveSubledger == 'Y' ){
							$data .= 	'<tr>
											<td class="text-right">'.$eachTwo->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
											<td class="text-right"></td>
											<td class="text-right"></td>
										</tr>';
							$allSublegders = getAllsubledgers( $eachTwo->id );
							if( !empty( $allSublegders ) )
								foreach( $allSublegders as $eachsub ){
									$accountTotal = accountTotalsubledger($eachTwo->id, $eachsub['id']);
									$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
									$debitTotal += ( $debit > 0 ) ? $debit : 0;
									$creditTotal += ( $credit > 0 ) ? $credit : 0;
									$data .= '<tr>
												<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
												<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</i></td>
												<td class="text-right"><small><b>'.$debit.'</b></small></td>
												<td class="text-right"><small><b>'.$credit.'</b></small></td>
											</tr>';
								}
						}else{
							$accountTotal = accountTotal($eachTwo->id);
							$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
							$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
							$debitTotal += ( $debit > 0 ) ? $debit : 0;
							$creditTotal += ( $credit > 0 ) ? $credit : 0;
							$data .= 	'<tr>
											<td class="text-right">'.$eachTwo->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachTwo->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
						}
							$levelThree = FinanceLegder::model()->findAll( array( 'condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account='.$eachTwo->id ) );
							foreach( $levelThree as $eachThree  ){
								if( $eachThree->haveSubledger == 'Y' ){
									$data .= 	'<tr>
													<td class="text-right">'.$eachThree->account_no.'</td>
													<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
													<td class="text-right"></td>
													<td class="text-right"></td>
												</tr>';
									$allSublegders =  getAllsubledgers( $eachThree->id );
									if( !empty( $allSublegders ) )
										foreach( $allSublegders as $eachsub ){
											$accountTotal = accountTotalsubledger($eachThree->id, $eachsub['id']);
											$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
											$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
											$debitTotal += ( $debit > 0 ) ? $debit : 0;
											$creditTotal += ( $credit > 0 ) ? $credit : 0;
											$data .= '<tr>
														<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
														<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</i></td>
														<td class="text-right"><small><b>'.$debit.'</b></small></td>
														<td class="text-right"><small><b>'.$credit.'</b></small></td>
													</tr>';
										}
								}else{
									$accountTotal = accountTotal($eachThree->id);
									$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
									$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
									$debitTotal += ( $debit > 0 ) ? $debit : 0;
									$creditTotal += ( $credit > 0 ) ? $credit : 0;
									$data .= 	'<tr>
											<td class="text-right">'.$eachThree->account_no.'</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachThree->description.'</b></td>
											<td class="text-right">'.$debit.'</td>
											<td class="text-right">'.$credit.'</td>
										</tr>';
								}
								$levelFour = FinanceLegder::model()->findAll( array( 'condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account='.$eachThree->id ) );
								foreach( $levelFour as $eachFour  ){
									if( $eachFour->haveSubledger == 'Y' ){
										$data .= 	'<tr>
														<td class="text-right">'.$eachFour->account_no.'</td>
														<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
														<td class="text-right"></td>
														<td class="text-right"></td>
													</tr>';
										$allSublegders =  getAllsubledgers( $eachFour->id );
										if( !empty( $allSublegders ) )
											foreach( $allSublegders as $eachsub ){
												$accountTotal = accountTotalsubledger($eachFour->id, $eachsub['id']);
												$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
												$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
												$debitTotal += ( $debit > 0 ) ? $debit : 0;
												$creditTotal += ( $credit > 0 ) ? $credit : 0;
												$data .= '<tr>
															<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
															<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</i></td>
															<td class="text-right"><small><b>'.$debit.'</b></small></td>
															<td class="text-right"><small><b>'.$credit.'</b></small></td>
														</tr>';
											}
									}else{
										$accountTotal = accountTotal($eachFour->id);
										$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
										$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
										$debitTotal += ( $debit > 0 ) ? $debit : 0;
										$creditTotal += ( $credit > 0 ) ? $credit : 0;
										$data .= 	'<tr>
												<td class="text-right">'.$eachFour->account_no.'</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFour->description.'</td>
												<td class="text-right">'.$debit.'</td>
												<td class="text-right">'.$credit.'</td>
											</tr>';
									}

									$levelFive = FinanceLegder::model()->findAll( array( 'condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account='.$eachFour->id ) );
									foreach( $levelFive as $eachFive  ){
										if( $eachFive->haveSubledger == 'Y' ){
											$data .= 	'<tr>
															<td class="text-right">'.$eachFive->account_no.'</td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
															<td class="text-right"></td>
															<td class="text-right"></td>
														</tr>';
											$allSublegders =  getAllsubledgers( $eachFive->id );
											if( !empty( $allSublegders ) )
												foreach( $allSublegders as $eachsub ){
													$accountTotal = accountTotalsubledger($eachFive->id, $eachsub['id']);
													$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
													$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
													$debitTotal += ( $debit > 0 ) ? $debit : 0;
													$creditTotal += ( $credit > 0 ) ? $credit : 0;
													$data .= '<tr>
																<td class="text-right"><small>'.$eachsub['subledger_no'].'</small></td>
																<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachsub['subledger_name'].'</i></td>
																<td class="text-right"><small><b>'.$debit.'</b></small></td>
																<td class="text-right"><small><b>'.$credit.'</b></small></td>
															</tr>';
												}
										}else{
											$accountTotal = accountTotal($eachFive->id);
											$debit = ( $accountTotal > 0 ) ?  $accountTotal : '';
											$credit = ( $accountTotal < 0 ) ? abs($accountTotal) : '';
											$debitTotal += ( $debit > 0 ) ? $debit : 0;
											$creditTotal += ( $credit > 0 ) ? $credit : 0;
											$data .= 	'<tr>
													<td class="text-right">'.$eachFive->account_no.'</td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$eachFive->description.'</td>
													<td class="text-right">'.$debit.'</td>
													<td class="text-right">'.$credit.'</td>
												</tr>';
										}
									}
								}
							}
					}
			}

					$data .=    '<tr>
									<td colspan="2" class="text-right"><b>Total</b></td>
									<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($debitTotal," ").'</b></td>
									<td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($creditTotal," ").'</b></td>
								</tr>';
		$data .= '      </tbody>
					</table>
				</body>
			</html>';
		header ( "Content-type: application/vnd.ms-excel" );
		header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
		echo $data;
		Yii::app()->end();
		return;
	}
	
	public function actionLoadtemplate(){
		$voucher_type = $_POST['voucher_type'];
		$payment_method = $_POST['payment_method'];

		$template = FinanceVoucherType::loadtemplate($voucher_type, $payment_method);
		$this->render('voucher_template', array( 'template' => $template ));
	}

	public function actionAllocate() 
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('create_allocation', array( 'model' => new FinanceAllocation));
	}

	public function actionGetallocationdata(){
		$ledger	=  (int) $_POST['ledger'];
		$subledger = (int) $_POST['subledger'];
		$allocationDebit = 'CREATE OR REPLACE VIEW view_finance_allocated_debit AS SELECT 
								V.id AS voucher_id, 
								VI.id AS voucher_item_id, 
								V.voucher_no, VI.amount, 
								IFNULL(ABS(SUM(AI.amount)), 0) AS allocated, 
								VI.amount - IFNULL(ABS(SUM(AI.amount)), 0) AS balance  
							FROM {{finance_voucher_items}} VI 
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id 
							LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id 
							WHERE V.is_posted ="Y" AND VI.amount > 0 AND VI.ledger_id = '.$ledger.' AND VI.subledger_id = '.$subledger.'
							GROUP BY VI.id';
		$allocationCredit = 'CREATE OR REPLACE VIEW view_finance_allocated_credit AS SELECT 
							V.id AS voucher_id, 
							VI.id AS voucher_item_id, 
							V.voucher_no, ABS(VI.amount) AS amount, 
							IFNULL(ABS(SUM(AI.amount)), 0) AS allocated, 
							ABS(VI.amount) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance  
						FROM {{finance_voucher_items}} VI 
						LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id 
						LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id 
						WHERE V.is_posted ="Y" AND VI.amount < 0 AND VI.ledger_id = '.$ledger.' AND VI.subledger_id = '.$subledger.'
						GROUP BY VI.id';
		Yii::app()->db->createCommand( $allocationDebit )->execute();
		Yii::app()->db->createCommand( $allocationCredit )->execute();

		$debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM view_finance_allocated_debit WHERE balance > 0')->queryAll();
		$creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM view_finance_allocated_credit WHERE balance > 0')->queryAll();
		
		$tables = array();
		$tables['debit'] = '';
		$tables['credit'] = '';
		
		if( $debitAllocatables[0]['value'] != '' ){
			$allItems = FinanceVoucherItems::model()->findAll( array( 'condition' => 'id IN ('.$debitAllocatables[0]['value'].')' ) );
			foreach( $allItems as $i => $each ){
				$balance = Yii::app()->db->createCommand('SELECT balance AS balance FROM view_finance_allocated_debit WHERE voucher_item_id='.$each->id )->queryScalar();
				$tables['debit'] .= '<tr>
										<td>'.CHtml::CheckBox('Debit['.$i.'][check]','',array('value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id); calculateValue();')).'</td>
										<td>'.$each->parent->fullvoucher.'</td>
										<td>'.$each->parent->vtype->description.'</td>
										<td>'.date('d/m/Y', strtotime($each->parent->voucher_date)).'</td>
										<td>'.$balance.'</td>
										<td>'.CHtml::hiddenfield('Debit['.$i.'][voucher_id]', $each->header_id).
											  CHtml::hiddenfield('Debit['.$i.'][voucher_item_id]', $each->id).
											  CHtml::hiddenfield('Debit['.$i.'][balance]', $balance).
											  CHtml::textfield('Debit['.$i.'][amount]', 0, array( 'class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValue();' )).'</td>
									</tr>';
			}

			$tables['debit'] .= '<tr>
									<td colspan="5" class="text-right"><b>Total</b></td>
									<td>'.CHtml::textfield('total_debit', 0, array( 'class' => 'form-control text-right', 'readonly' => true)).'</td>
								</tr>';
		}else{
			$tables['debit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
		}
		
		if( $creditAllocatables[0]['value'] != '' ){
			$allItems = FinanceVoucherItems::model()->findAll( array( 'condition' => 'id IN ('.$creditAllocatables[0]['value'].')' ) );
			foreach( $allItems as $i => $each ){
				$balance = Yii::app()->db->createCommand('SELECT balance AS balance FROM view_finance_allocated_credit WHERE voucher_item_id='.$each->id )->queryScalar();
				$tables['credit'] .= '<tr>
										<td>'.CHtml::CheckBox('Credit['.$i.'][check]','',array('value' => $each->id, 'onChange' => 'copyValue("Credit", this, this.id); calculateValue();')).'</td>
										<td>'.$each->parent->fullvoucher.'</td>
										<td>'.$each->parent->vtype->description.'</td>
										<td>'.date('d/m/Y', strtotime($each->parent->voucher_date)).'</td>
										<td>'.$balance.'</td>
										<td>'.CHtml::hiddenfield('Credit['.$i.'][voucher_id]', $each->header_id).
											  CHtml::hiddenfield('Credit['.$i.'][voucher_item_id]', $each->id).
											  CHtml::hiddenfield('Credit['.$i.'][balance]', $balance).
											  CHtml::textfield('Credit['.$i.'][amount]', 0, array( 'class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Credit", this.id, this.value); calculateValue();' )).'</td>
									</tr>';
			}

			$tables['credit'] .= '<tr>
									<td colspan="5" class="text-right"><b>Total</b></td>
									<td>'.CHtml::textfield('total_credit', 0, array( 'class' => 'form-control text-right', 'readonly' => true)).'</td>
								</tr>';
		}else{
			$tables['credit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
		}
		echo json_encode($tables);
	}

	public function actionSaveallocation(){
		
		$creditTotal = (float) $_POST['total_credit'];
		$debitTotal = (float) $_POST['total_debit'];
		
		if( ( $debitTotal > 0 && $creditTotal > 0 ) && $creditTotal == $debitTotal ){
			
			$model = new FinanceAllocation;
			$model->attributes = $_POST['FinanceAllocation'];
			$model->allocation_date = date('Y-m-d');
			$model->created_by = Yii::app()->user->id;
			$model->created_date_time = date('Y-m-d h:i:s');
			
			$totalDebit = $totalCredit = 0; 
			$debitArray = $creditArray = array();
			foreach( $_POST['Debit'] as $i => $each ){
				if( $each['amount'] > 0 ){
					$debitArray[$i] = new FinanceAllocationItems;
					$debitArray[$i]->header_id = 0;
					$debitArray[$i]->voucher_id = $each['voucher_id'];
					$debitArray[$i]->voucher_item_id= $each['voucher_item_id'];
					$debitArray[$i]->amount =  $each['amount'];
					$totalDebit += $each['amount'];
				}
			}
			foreach( $_POST['Credit'] as $i => $each ){
				if( $each['amount'] > 0 ){
					$creditArray[$i] = new FinanceAllocationItems;
					$creditArray[$i]->header_id = 0;
					$creditArray[$i]->voucher_id = $each['voucher_id'];
					$creditArray[$i]->voucher_item_id= $each['voucher_item_id'];
					$creditArray[$i]->amount =  -1*$each['amount'];
					$totalCredit += $each['amount'];
				}
			}
			if( $totalCredit == $totalDebit ){
				if( $model->validate() ){
					echo json_encode( array( 'status' => 'success') );
					$model->amount = $totalCredit;
					$model->save();
					foreach( $debitArray as $each ){
						$each->header_id = $model->id;
						$each->save(false);
						FinanceVoucherHead::model()->updateBypk($each->voucher_id, array( 'is_allocated' => 'Y' ));
					}
					foreach( $creditArray as $each ){
						$each->header_id = $model->id;
						$each->save(false);
						FinanceVoucherHead::model()->updateBypk($each->voucher_id, array( 'is_allocated' => 'Y' ));
					}
				}else{
					echo CActiveForm::validate($model, '', false);
				}
			}else{
				echo json_encode( array('Totals are not matching!') );
			}
		}else{
			echo json_encode( array('Totals are not matching!') );
		}
	}

	public function actionAgeing_excel(){
		$to_date = ( count(explode('/',$_GET['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date'])))  : date('Y-m-d');
		$ledger	=  (int) Yii::app()->request->getParam('ledger');
		$subledger = (int) Yii::app()->request->getParam('subledger');
		
		function generateAgeing( $array_of_dates, $ledger, $subledger ){
			foreach( $array_of_dates as $key => $each_date_pair ){
				$condition = 'AND VI.ledger_id = "'.(int) $ledger.'"';
				if( $subledger > 0 )
					$condition = 'AND VI.subledger_id = "'.(int) $subledger.'"';
				$query = 'CREATE OR REPLACE VIEW view_finance_ageing_'.$key.' AS SELECT 
							L.description AS ledger, 
							SUM(VI.amount) AS amount 
						FROM {{finance_voucher_items}} VI 
						LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id 
						LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id 
						WHERE VH.due_date BETWEEN "'.$each_date_pair['from'].'" AND "'.$each_date_pair['to'].'"
						'.$condition.'
						GROUP BY VI.subledger_id, VI.ledger_id';
				Yii::app()->db->createCommand($query)->execute();
			}
		}
		
		$one = array( 'from' => date('Y-m-d', strtotime($to_date.' -30 days')), 'to' => $to_date );
		$two = array( 'from' => date('Y-m-d', strtotime($to_date.' -60 days')), 'to' => date('Y-m-d', strtotime($to_date.' -31 days')) );
		$three = array( 'from' => date('Y-m-d', strtotime($to_date.' -90 days')), 'to' => date('Y-m-d', strtotime($to_date.' -61 days')) );
		$four = array( 'from' => date('Y-m-d', strtotime($to_date.' -120 days')), 'to' => date('Y-m-d', strtotime($to_date.' -91 days')) );
		$five = array( 'from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date.' -121 days')) );

		$dates_array = array( '0_to_30' => $one, '31_to_60' => $two, '61_to_90' => $three, '91_to_120' => $four, 'greaterthan_120' => $five );

		generateAgeing( $dates_array, $ledger, $subledger);
	}

}