<?php

/**
 * This is the model class for table "{{unit_of_measurement}}".
 *
 * The followings are the available columns in table '{{unit_of_measurement}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $base_unit
 * @property string $name
 * @property string $factor
 * @property string $price
 * @property integer $created_by
 * @property string $created_date_time
 */
class UnitOfMeasurement extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $sales_price_group_id;
    public $default_price_group_id;

    public function tableName() {
        return '{{unit_of_measurement}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, base_unit, name, factor,is_secondary_unit', 'required'),
            array('product_id, base_unit,unit_id, created_by', 'numerical', 'integerOnly' => true),
            array('name', 'length', 'max' => 255),
            array('is_secondary_unit', 'length', 'max' => 10),
            array('factor, price', 'length', 'max' => 17),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, product_id, base_unit, name, factor, price, created_by, created_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unit' => array(self::BELONGS_TO, 'Unit', 'base_unit'),
            'uom' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'base_unit' => 'Base Unit',
            'name' => 'Name',
            'factor' => 'Factor',
            'price' => 'Price',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('base_unit', $this->base_unit);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('factor', $this->factor, true);
        $criteria->compare('price', $this->price, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return UnitOfMeasurement the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /* All units with base unit */

    public static function getUnits($product) {
        $model = self::model()->findAll(array('condition' => 'product_id=' . (int)$product, 'order' => 'is_secondary_unit'));
        return CHtml::listData($model, 'id', 'name');
    }

    public static function getBaseunit($product = 0) {
        $model = self::model()->find(array('condition' => 'product_id=' . $product . ' AND isBase="Y"'));
        return $model->id;
    }
    public static function getBaseunitname($product = 0) {
        $model = self::model()->find(array('condition' => 'product_id=' . $product . ' AND isBase="Y"'));
        return $model->name;
    }
    /*modified by jisha since iscountable not working-- 24/03/23*/
    public static function getSecondaryBaseunit($product = 0) {
        $model = self::model()->find(array('condition' => 'product_id=' . $product . ' AND is_secondary_unit="Y"'));
        if (!empty($model)) {//is_countable($model) && count($model) > 0
            return $model->id;
        } else {
            $model = self::model()->find(array('condition' => 'product_id=' . $product . ' AND isBase="Y"'));
            return $model->id;
        }
    }

    public static function getFactor($unit) {
        $model = self::model()->findByPk($unit);
        return $model->factor;
    }
    public static function getUOMName($unit) {
        $model = self::model()->findByPk($unit);
        return $model->name;
    }

    public static function getRate($unit) {
        $model = self::model()->findByPk($unit);
        $rate = $model->factor * $model->product->rate;
        return $rate;
    }

    public static function getSecondaryBaseUnitWithName($product_id) {
        $model = self::model()->find(array('condition' => 'product_id=' . (int)$product_id . ' AND is_secondary_unit="Y"'));
        if (!empty($model)) {
            return $model;
        } else {
            $model = self::model()->find(array('condition' => 'product_id=' . (int)$product_id . ' AND isBase="Y"'));
            return $model;
        }
    }

}
