<?php

/**
 * This is the model class for table "{{tracking_file}}".
 *
 * The followings are the available columns in table '{{tracking_file}}':
 * @property string $id
 * @property string $type
 * @property string $order_no
 * @property string $start_date
 * @property string $close_date
 * @property integer $created_by
 * @property integer $closed_by
 */
class TrackingFile extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tracking_file}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		//	array('type, order_no', 'required'),
			array('created_by, closed_by', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>2),
			array('order_no', 'length', 'max'=>30),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, type, order_no, start_date, close_date, created_by, closed_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'type' => 'Type',
			'order_no' => 'Order No',
			'start_date' => 'Start Date',
			'close_date' => 'Close Date',
			'created_by' => 'Created By',
			'closed_by' => 'Closed By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('order_no',$this->order_no,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('close_date',$this->close_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('closed_by',$this->closed_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TrackingFile the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
