<?php

/**
 * This is the model class for table "temp_upload_day_book_finance".
 *
 * The followings are the available columns in table 'temp_upload_day_book_finance':
 * @property integer $id
 * @property string $voucher_date
 * @property string $particulars
 * @property string $voucher_type
 * @property string $voucher_no
 * @property string $debit_amount
 * @property string $credit_amount
 */
class TempUploadDayBookFinance extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'temp_upload_day_book_finance';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('voucher_date, particulars, voucher_type, voucher_no, debit_amount, credit_amount', 'required'),
			array('voucher_type, voucher_no', 'length', 'max'=>255),
			array('debit_amount, credit_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, voucher_date, particulars, voucher_type, voucher_no, debit_amount, credit_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'voucher_date' => 'Voucher Date',
			'particulars' => 'Particulars',
			'voucher_type' => 'Voucher Type',
			'voucher_no' => 'Voucher No',
			'debit_amount' => 'Debit Amount',
			'credit_amount' => 'Credit Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('voucher_date',$this->voucher_date,true);
		$criteria->compare('particulars',$this->particulars,true);
		$criteria->compare('voucher_type',$this->voucher_type,true);
		$criteria->compare('voucher_no',$this->voucher_no,true);
		$criteria->compare('debit_amount',$this->debit_amount,true);
		$criteria->compare('credit_amount',$this->credit_amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TempUploadDayBookFinance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
