<?php

/**
 * This is the model class for table "{{service_store_material_details}}".
 *
 * The followings are the available columns in table '{{service_store_material_details}}':
 * @property integer $id
 * @property integer $service_store_id
 * @property integer $product_id
 * @property integer $material_receipt_id
 * @property string $material_receipt_qty
 * @property string $issued_qty
 * @property string $bill_exit
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $warehouse_id
 * @property integer $rack_id
 * @property integer $bin_id
 */
class ServiceStoreMaterialDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{service_store_material_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('service_store_id, product_id, material_receipt_id, material_receipt_qty, issued_qty, warehouse_id, rack_id, bin_id', 'required'),
			array('service_store_id, product_id, material_receipt_id, created_by, warehouse_id, rack_id, bin_id', 'numerical', 'integerOnly'=>true),
			array('material_receipt_qty, issued_qty', 'length', 'max'=>10),
			array('bill_exit', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, service_store_id, product_id, material_receipt_id, material_receipt_qty, issued_qty, bill_exit, created_by, created_date_time, warehouse_id, rack_id, bin_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'mr' => array(self::BELONGS_TO, 'MaterialReceiptStockDetails', 'material_receipt_id'),
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'servicestore_details' => array(self::BELONGS_TO, 'ServiceStore', 'service_store_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'service_store_id' => 'Service Store',
			'product_id' => 'Product',
			'material_receipt_id' => 'Material Receipt',
			'material_receipt_qty' => 'Material Receipt Qty',
			'issued_qty' => 'Issued Qty',
			'bill_exit' => 'Bill Exit',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'warehouse_id' => 'Warehouse',
			'rack_id' => 'Rack',
			'bin_id' => 'Bin',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('service_store_id',$this->service_store_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('material_receipt_id',$this->material_receipt_id);
		$criteria->compare('material_receipt_qty',$this->material_receipt_qty,true);
		$criteria->compare('issued_qty',$this->issued_qty,true);
		$criteria->compare('bill_exit',$this->bill_exit,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('warehouse_id',$this->warehouse_id);
		$criteria->compare('rack_id',$this->rack_id);
		$criteria->compare('bin_id',$this->bin_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ServiceStoreMaterialDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
