<?php

/**
 * This is the model class for table "{{quotes_service_item}}".
 *
 * The followings are the available columns in table '{{quotes_service_item}}':
 * @property integer $id
 * @property integer $quotes_id
 * @property integer $product_id
 * @property string $description
 * @property string $quantity
 * @property string $rate
 * @property string $amount
 * @property string $tax_vat_percentage
 * @property string $tax_vat_amount
 * @property string $net_amount
 */
class QuotesServiceItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 public $product_name;
    public $unit;
    public $item_qty;
	public function tableName()
	{
		return '{{quotes_service_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, description, quantity, rate', 'required'),
			array('quotes_id, product_id', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, amount, tax_vat_percentage, tax_vat_amount, net_amount', 'length', 'max'=>15),
			array('unit_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, quotes_id, product_id, description, quantity, rate, amount, tax_vat_percentage, tax_vat_amount, net_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'quotes' => array(self::BELONGS_TO, 'Quotes', 'quotes_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'quotes_id' => 'Quotes',
			'product_id' => 'Product',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'rate' => 'Rate',
			'amount' => 'Amount',
			'tax_vat_percentage' => 'Tax Vat Percentage',
			'tax_vat_amount' => 'Tax Vat Amount',
			'net_amount' => 'Net Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('quotes_id',$this->quotes_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('tax_vat_percentage',$this->tax_vat_percentage,true);
		$criteria->compare('tax_vat_amount',$this->tax_vat_amount,true);
		$criteria->compare('net_amount',$this->net_amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return QuotesServiceItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
