<?php

/**
 * This is the model class for table "{{quotes}}".
 *
 * The followings are the available columns in table '{{quotes}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $customer_id
 * @property integer $contact_id
 * @property string $qtn_start_date
 * @property string $qtn_close_date
 * @property string $sales_group_id
 * @property string $currency_id
 * @property double $exchange_rate
 * @property string $payment_terms
 * @property string $shipping_by
 * @property string $qtn_validity
 * @property string $qtn_date
 * @property string $shipping_conditions
 * @property integer $probability
 * @property double $grand_total
 * @property string $isActive
 * @property string $inco_term_id
 *
 * The followings are the available model relations:
 * @property CompanyContact $contact
 * @property User $crmUser
 * @property MasterFile $file
 * @property Company $company
 * @property QuotesItem[] $quotesItems
 */
class Quotes extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $company_name;
    //public $lead_owner_id;
    public $title;
    public $searchstartdate;
    public $searchenddate;
    public $value;
    public $country;
    public $quotation_value0;
    public $quotation_value1;
    public $tendor_no;
    public $import_code;
    public $balance_receiveable;

    public function tableName() {
        return '{{quotes}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('customer_id, lead_owner_id,qtn_start_date, ambient_scent_for,payment_terms_id,qtn_validity,invoice_type_id,terms_and_conditions', 'required'),
            array('file_id, contact_id, lead_owner_id,qtn_close_reason, ticket_id,customer_outlet_id', 'numerical', 'integerOnly' => true),
            array('exchange_rate, grand_total,total_discount_percentage,total_discount_amount', 'numerical'),
            array('customer_id,inco_term_id', 'length', 'max' => 20),
            array('enq_ref,sales_group_id, currency_id,payment_terms_id,billing_address, shipping_by, file_title', 'length', 'max' => 255),
            array('isActive, status', 'length', 'max' => 1),
            array('notes,remarks,terms_and_conditions', 'length', 'max' => 10000),
            array('customer_id', 'required', 'message' => 'Unknown Customer.'),
//            array(
//              'qtn_validity',
//              'compare',
//              'compareAttribute' => 'qtn_start_date',
//              'operator' => '>=',
//              'allowEmpty' => false,
//              'message' => '{attribute} must be greater than {compareAttribute}.'
//              ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,ticket_id, file_id,customer_id, contact_id, qtn_start_date, qtn_close_date,
                sales_group_id, currency_id, exchange_rate, payment_terms_id, shipping_by, qtn_validity,
                qtn_date, grand_total, isActive,qtn_close_reason,status,invoice_type_id,inco_term_id,qtn_type', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            //'probability_details' => array(self::BELONGS_TO, 'MasProbability', 'probability'),
            'contact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            //'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'company' => array(self::BELONGS_TO, 'Company', 'customer_id'),
            'currency0' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'items' => array(self::HAS_MANY, 'QuotesItem', 'quotes_id', 'order' => 'items.id asc'),
            'contract' => array(self::HAS_MANY, 'QuotesContractItem', 'quotes_id', 'order' => 'items.id asc'),
            'adItems' => array(self::HAS_MANY, 'QuotesAddition', 'quotes_id', 'order' => 'adItems.id asc'),
            'dedItems' => array(self::HAS_MANY, 'QuotesDeduction', 'quotes_id', 'order' => 'dedItems.id asc'),
            'netAmount' => array(self::STAT, 'QuotesItem', 'quotes_id', 'select' => 'SUM(net_amount)'),
            'netQuantity' => array(self::STAT, 'QuotesItem', 'quotes_id', 'select' => 'SUM(quantity)'),
            'adTotal' => array(self::STAT, 'QuotesAddition', 'quotes_id', 'select' => 'SUM(calculated_value)'),
            'dedTotal' => array(self::STAT, 'QuotesDeduction', 'quotes_id', 'select' => 'SUM(calculated_value)'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms_id'),
            'companycontact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'customercontact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type_id'),
            'createdby' => array(self::BELONGS_TO, 'User', 'created_by'),
            'statusdet' => array(self::BELONGS_TO, 'MasQuotesStatus', 'status'),
            'incoterm' => array(self::BELONGS_TO, 'MasIncoTerms', 'inco_term_id'),
            'outlet' => array(self::BELONGS_TO, 'CustomerOutletLocation', 'customer_outlet_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'title' => 'File Title',
            //'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'enq_ref' => 'Enquiry Ref.',
            'company_name' => 'Company',
            'customer_id' => 'Company',
            'contact_id' => 'Contact',
            'qtn_start_date' => 'Qtn Date',
            'qtn_close_date' => 'Qtn Closing',
            'sales_group_id' => 'Sales Group',
            'currency_id' => 'Currency',
            'exchange_rate' => 'Exchange Rate',
            'payment_terms_id' => 'Payment Terms',
            'shipping_by' => 'Shipping By',
            'qtn_validity' => 'Qtn Validity',
            'qtn_date' => 'Qtn date',
            'grand_total' => 'Grand Total',
            'isActive' => 'Is Active',
            'lead_owner_id' => 'Lead Owner',
            'ambient_scent_for' => 'Ambient Scent For',
            'project_classification_id' => 'Project Classification'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.
        //$userModel = User::model()->findByPK(Yii::app()->user->id);
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('quote_search')) : $searchterm;
        $criteria->with = array('file', 'file.company', 'file.leadowner');
        /* $criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND
          file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND'); */
        //$criteria->addCondition('file.lead_owner_id in (' . implode(',', $userModel->subordinates).')', 'AND');
        (int) Yii::app()->session['customer_id'] > 0 ? $criteria->addCondition('t.customer_id=' . Yii::app()->session['customer_id'], 'AND') : '';

        $user = User::model()->findByPK(Yii::app()->user->id);
        if (!isset(Yii::app()->user->havePermissionOn['sop_quote_viewall']) && Yii::app()->user->authorised_user != 1) {
            $criteria->addCondition('file.crm_user_id=' . Yii::app()->user->id . ' OR file.lead_owner_id=' . Yii::app()->user->id, 'AND');
        }

        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR
                                        t.file_id like "%' . $searchterm . '%" OR
                                        company.company_name like "%' . $searchterm . '%" OR
                                        file.file_title like "%' . $searchterm . '%" OR
                                        leadowner.first_name like "%' . $searchterm . '%" OR
                                        leadowner.last_name like "%' . $searchterm . '%"
                                            ', 'AND');
        }
        if (empty($searchterm)) {
            // $criteria->addCondition('file.current_process_status="Q"', 'AND');
            $criteria->addCondition('status in ("Y","O") AND file.current_process_status="Q"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.qtn_date DESC,t.id DESC,t.file_id DESC,t.customer_id DESC',
            ),
            // 'pagination' => false
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.company');
        $condition[] = 'file.current_process_status="Q"';
        if (!empty($this->customer_id))
            $condition[] = 't.customer_id="' . $this->customer_id . '"';
        if (!empty($this->sales_group_id))
            $condition[] = 'sales_group_id="' . $this->sales_group_id . '"';
        if (!empty($this->lead_owner_id))
            $condition[] = 'lead_owner_id="' . $this->lead_owner_id . '"';
        if (!empty($this->country))
            $condition[] = 'company.billing_country="' . $this->country . '"';
        if (!empty($this->quotation_value0))
            $condition[] = '(exchange_rate*grand_total)>="' . $this->quotation_value0 . '"';
        if (!empty($this->quotation_value1))
            $condition[] = '(exchange_rate*grand_total)<="' . $this->quotation_value1 . '"';
        
        if (!empty($this->status)) {
            if ($this->status == "Y")
                $condition[] = 'status="' . $this->status . '" AND qtn_validity >=CURDATE()';
            else if ($this->status == "E")
                $condition[] = 'status="Y" AND qtn_validity < CURDATE()';
            else
                $condition[] = 'status="' . $this->status . '"';
        }
        if (!empty($this->qtn_close_reason))
            $condition[] = 'qtn_close_reason="' . $this->qtn_close_reason . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('qtn_start_date', $this->searchstartdate, $this->searchenddate);
        }
        /* $criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND
          file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND'); */
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.customer_id,t.qtn_date DESC',
            ),
            'pagination' => false
        ));
    }

    public function printOut() {
        //dfg
        $criteria = new CDbCriteria;
        //$criteria->condition = "isActive='Y'";
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.customer_id,t.qtn_date DESC',
            ),
                //'pagination' => array('pageSize' => 5)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Quotes the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(grand_total*exchange_rate) FROM `crm_quotes` where id in ($ids)");
            return $command->queryScalar();
        } else
            return "";
    }

    public function getGrand_total_bc() {
        return ($this->grand_total * $this->exchange_rate);
    }

    public function getPaymentTerm($payment_terms) {
        if ($payment_terms) {
            $model_PaymentTerms = MasPaymentTerm::model()->find(array('condition' => 'id=' . $payment_terms));
            return $model_PaymentTerms->payment_code . ':' . $model_PaymentTerms->payment_terms;
        }
    }

    public function quotesFiles($lead_owner_id) {
        $model = MasterFile::model()->findAll(array('condition' => 'lead_owner_id=' . $lead_owner_id));
        $criteria = new CDbCriteria;
        $criteria->with = array('file');
        foreach ($model as $eachItem) {
            $criteria->addCondition('t.file_id=' . $eachItem->id, 'OR');
        }
        $criteria->addCondition('t.status="Y" AND file.current_process_status="Q"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.qtn_date ASC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 20) : false,
        ));
    }

    public function getExpiry_status() {
        $expired = false;
        if (strtotime($this->qtn_validity) > strtotime(date('Y-m-d')))
            $expired = true;
        return $expired;
    }

    public function getColor_of_row_quote() {
        $class = ($this->file->is_approved == "N" ? "colorRed" : "white");
        if (!$this->expiry_status || in_array($this->status, array("C", "L"))) {
            $class .= " strike-through";
        }
        return $class;
    }

    /* used in lead-getlist
     * modified jisha on 17-9-18
     */

    public function getStatusOfQuote() {
        switch ($this->status) {
            case 'Y':
                return "Open";
                break;
            case 'O':
                return "Order";
                break;
            case 'C':
                return "Closed";
                break;
            case 'L':
                return "Lost";
                break;
        }
    }

    public function getCreated_user() {
        $usermodel = User::model()->findByPK($this->created_by);
        return $usermodel->fullname;
    }

}
