<?php

/**
 * This is the model class for table "{{purchasingcredits_item}}".
 *
 * The followings are the available columns in table '{{purchasingcredits_item}}':
 * @property integer $id
 * @property integer $purchasingcredits_id
 * @property integer $product_id
 * @property double $purchased_quantity
 * @property string $description
 * @property double $rate
 * @property double $returned_quantity
 * @property double $net_amount
 */
class PurchasingdebitnoteItem extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $qcchecked_quantity;
    public $unit;
    public $amount;
    public $warehouse_name;
    public $purchasing_materialreceipt_id;
    public $credited_qty;


    public function tableName() {
        return '{{purchasing_debit_note_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, purchased_quantity, description, rate, returned_quantity, net_amount', 'required'),
            array('purchasing_debitnote_id, product_id,returned_unit_id', 'numerical', 'integerOnly' => true),
            array('purchased_quantity, rate, returned_quantity,warehouse_id , net_amount,unit_factor', 'numerical'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, purchasing_debitnote_id, product_id, purchased_quantity, description, rate, returned_quantity, net_amount', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'purchasedebitnote' => array(self::BELONGS_TO, 'Purchasingdebitnote', 'purchasing_debitnote_id'),
            'warehousename' => array(self::BELONGS_TO, 'MasInvWarehouse', 'warehouse_id '),
            'purchasingmatrialreceipt' => array(self::BELONGS_TO, 'PurchasingMaterialReceipt', 'purchasing_materialreceipt_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
            'retunitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'returned_unit_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'purchasing_debitnote_id' => 'Purchasing Debit Note',
            'product_id' => 'Product',
            'purchased_quantity' => 'Invoiced Quantity',
            'description' => 'Description',
            'rate' => 'Rate',
            'returned_quantity' => 'Returning Quantity',
            'net_amount' => 'Net Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id);
        $criteria->compare('purchasing_debitnote_id', $this->purchasing_debitnote_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('purchased_quantity', $this->purchased_quantity);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('rate', $this->rate);
        $criteria->compare('returned_quantity', $this->returned_quantity);
        $criteria->compare('net_amount', $this->net_amount);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => array('pageSize' => 10)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingcreditsItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
