<?php

/**
 * This is the model class for table "{{delivery_material_details}}".
 *
 * The followings are the available columns in table '{{delivery_material_details}}':
 * @property integer $id
 * @property integer $issue_id
 * @property integer $material_receipt_id
 * @property string $material_receipt_qty
 * @property string $issued_qty
 * @property string $bill_exit
 * @property integer $created_by
 * @property string $created_date_time
 */
class PurchasingDebitNoteIssueItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{purchasing_debit_note_issue_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('debit_note_id, material_receipt_id, issued_qty', 'required'),
			array('debit_note_id, material_receipt_id, created_by', 'numerical', 'integerOnly'=>true),
			array('issued_qty', 'length', 'max'=>10),
			array('bill_exit', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, debit_note_id, material_receipt_id, issued_qty, bill_exit, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			//'mr' => array(self::BELONGS_TO, 'MaterialReceiptStockDetails', 'material_receipt_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'issue_id' => 'Delivery',
			'material_receipt_id' => 'Material Receipt',			
			'issued_qty' => 'Received Qty',
			'bill_exit' => 'Bill Exit',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('issue_id',$this->issue_id);
		$criteria->compare('material_receipt_id',$this->material_receipt_id);
		$criteria->compare('issued_qty',$this->issued_qty,true);
		$criteria->compare('bill_exit',$this->bill_exit,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DeliveryMaterialDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
