<?php

/**
 * This is the model class for table "{{purchase_movement_analysis_details}}".
 *
 * The followings are the available columns in table '{{purchase_movement_analysis_details}}':
 * @property integer $id
 * @property integer $analysis_id
 * @property integer $product_id
 * @property string $part_number
 * @property string $description
 * @property integer $unit_id
 * @property string $current_stock
 * @property string $days_365
 * @property string $days_180
 * @property string $days_90
 * @property string $days_30
 * @property string $upcoming_shipment_qty
 * @property string $average_movement
 * @property string $expected_2_months_movement
 * @property string $expected_closing_stock_after_2_months
 * @property string $proposal_qty
 * @property string $remarks
 */
class PurchaseMovementAnalysisDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{purchase_movement_analysis_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('analysis_id, product_id, part_number, description, unit_id, current_stock, days_365, days_180, days_90, days_30, upcoming_shipment_qty, average_movement, expected_2_months_movement, expected_closing_stock_after_2_months, proposal_qty, remarks', 'required'),
			array('analysis_id, product_id, unit_id', 'numerical', 'integerOnly'=>true),
			array('part_number', 'length', 'max'=>255),
			array('current_stock, days_365, days_180, days_90, days_30, upcoming_shipment_qty, average_movement, expected_2_months_movement, expected_closing_stock_after_2_months, proposal_qty,approval_current_stock', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, analysis_id, product_id, part_number, description, unit_id, current_stock, days_365, days_180, days_90, days_30, upcoming_shipment_qty, average_movement, expected_2_months_movement, expected_closing_stock_after_2_months, proposal_qty, remarks', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'movementanalysis' => array(self::BELONGS_TO, 'PurchaseMovementAnalysis', 'analysis_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
  
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'analysis_id' => 'Analysis',
			'product_id' => 'Product',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'unit_id' => 'Unit',
			'current_stock' => 'Current Stock',
			'days_365' => 'Days 365',
			'days_180' => 'Days 180',
			'days_90' => 'Days 90',
			'days_30' => 'Days 30',
			'upcoming_shipment_qty' => 'Upcoming Shipment Qty',
			'average_movement' => 'Average Movement',
			'expected_2_months_movement' => 'Expected 2 Months Movement',
			'expected_closing_stock_after_2_months' => 'Expected Closing Stock After 2 Months',
			'proposal_qty' => 'Proposal Qty',
			'remarks' => 'Remarks',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('analysis_id',$this->analysis_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('current_stock',$this->current_stock,true);
		$criteria->compare('days_365',$this->days_365,true);
		$criteria->compare('days_180',$this->days_180,true);
		$criteria->compare('days_90',$this->days_90,true);
		$criteria->compare('days_30',$this->days_30,true);
		$criteria->compare('upcoming_shipment_qty',$this->upcoming_shipment_qty,true);
		$criteria->compare('average_movement',$this->average_movement,true);
		$criteria->compare('expected_2_months_movement',$this->expected_2_months_movement,true);
		$criteria->compare('expected_closing_stock_after_2_months',$this->expected_closing_stock_after_2_months,true);
		$criteria->compare('proposal_qty',$this->proposal_qty,true);
		$criteria->compare('remarks',$this->remarks,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchaseMovementAnalysisDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
