<?php

/**
 *
 * @property integer $id
 * @property string $activity
 * @property string $activity_type
 * @property string $isActive 
 * @property integer $created_by
 * @property integer $updated_by 
 * @property string $created_at 
 * @property string $updated_at 
 */
class ProspectsActivityMaster extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{prospects_activity_master}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('activity', 'required'),
            
        );
    }

    public static function checkDuplicate($activity, $condition){
        $duplicate =  Yii::app()->db->createCommand(
            " SELECT id
                    FROM erp_prospects_activity_master 
                    WHERE activity = :activity $condition
                                                "
        )
            ->bindValues(array(':activity' => $activity))
            ->queryAll();
            if (count($duplicate) > 0) return true;
            else return false;
    }

    public static function getListDetails($condition, $orderBy, $limit, $offset)
    {
        $list = Yii::app()->db->createCommand(
            " SELECT epa.id, epa.activity, epa.activity_type 
                                                    FROM erp_prospects_activity_master AS epa
                                                    WHERE epa.isActive = 'Y' $condition
                                                    GROUP BY epa.id
                                                    ORDER BY $orderBy
                                                    LIMIT $limit
                                                    OFFSET $offset
                                                "
        )
            ->queryAll();
        return $list;
    }

    public static function getListCount($condition)
    {
        $list = Yii::app()->db->createCommand(
            " SELECT epa.id
                                                    FROM erp_prospects_activity_master AS epa
                                                    WHERE epa.isActive = 'Y' $condition
                                                "
        )
            ->queryAll();
        return $list;
    }
    
     /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Activity the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }
    public static function getType(){
//        <option value="CALLS">CALLS</option>
//<option value="TASKS">TASKS</option>
//<option value="MEETINGS">MEETINGS</option>
//<option value="VISITS">VISITS</option>
//<option value="NOTES">NOTES</option>
//<option value="OTHERS">OTHERS</option>
        $typeArray =array(
            "TASKS" => "TASKS",
            "CALLS" => "CALLS",
            "MEETINGS" => "MEETINGS",
            "VISITS" => "VISITS",
            "NOTES" => "NOTES",
            "OTHERS" => "OTHERS"
        ); 
        return $typeArray;
    }
    
     public static function getActivityType() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'activity'));
        return CHtml::listData($model, 'id', 'activity');
    }
}
