<?php

/**
 * This is the model class for table "{{profit_calc}}".
 *
 * The followings are the available columns in table '{{profit_calc}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $net_selling_value
 * @property string $net_cost_value
 * @property string $profit_percentage
 * @property string $net_profit_value
 * @property integer $price_group_id
 */
class ProfitCalc extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{profit_calc}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('crm_user_id, file_id, net_selling_value, net_cost_value, profit_percentage, net_profit_value, price_group_id', 'required'),
			array('crm_user_id, file_id, price_group_id', 'numerical', 'integerOnly'=>true),
			array('net_selling_value, net_cost_value, net_profit_value', 'length', 'max'=>15),
			array('profit_percentage', 'length', 'max'=>5),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, crm_user_id, file_id, net_selling_value, net_cost_value, profit_percentage, net_profit_value, price_group_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'items' => array(self::HAS_MANY, 'ProfitCalcItem', 'profit_calc_id'),
        	'pricing_group' => 	 array(self::BELONGS_TO, 'CostPriceGroupName', 'price_group_id'),
        );
    }
    

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'crm_user_id' => 'Crm User',
			'file_id' => 'File',
			'net_selling_value' => 'Net Selling Value',
			'net_cost_value' => 'Net Cost Value',
			'profit_percentage' => 'Profit Percentage',
			'net_profit_value' => 'Net Profit Value',
			'price_group_id' => 'Price Group',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('crm_user_id',$this->crm_user_id);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('net_selling_value',$this->net_selling_value,true);
		$criteria->compare('net_cost_value',$this->net_cost_value,true);
		$criteria->compare('profit_percentage',$this->profit_percentage,true);
		$criteria->compare('net_profit_value',$this->net_profit_value,true);
		$criteria->compare('price_group_id',$this->price_group_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProfitCalc the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function getMasterFileDetails()
	{
		$model = self::model()->findAll();
		return CHtml::listData($model, 'file_id', 'file_id');
	}
	public function profitCalculation($file_id) {

		$modelFile = MasterFile::model()->with('quote.items', 'order.items1')->findByPK($file_id, array('order' => 'items.id ASC,items1.id ASC'));
		$modelProfit = ProfitCalc::model()->with('items')->find(array('condition' => 'file_id=' . $file_id, 'order' => 'items.id ASC'));



		$jsondata['file'] = $modelFile;
		if ($modelFile->is_approved == "Y") {
			$jsondata['approved_by'] = $modelFile->approvedBy->fullname;
		}

		switch ($modelFile->current_process_status) {
			case 'Q':
				$model = $modelFile->quote;
				break;
			default:
				$model = $modelFile->order;
				break;
		}

		$jsondata['model'] = $model;
		$jsondata['company'] = $model->company;
		$jsondata['leadowner'] = $model->file->leadowner->fullname;
		$jsondata['currency'] = $model->currency0->currency;
		$jsondata['contact'] = $model->contact;

		//$arr_default_pricing_group = PricingGroupName::getDefaultPricingGroupDetails();
		$arr_default_pricing_group = CostPriceGroupName::getDefaulCostPricingGroupDetails();
		$default_pricing_group_id = $arr_default_pricing_group->id;
		$default_pricing_group_name = $arr_default_pricing_group->pricing_group_name;
		//$default_internal_pricing_group_id = 90;
		$jsondata['items'] = '<tr>
            <th>No</th>
            <th>Product</th>
            <th>Description</th>
            <th>Qty.</th>
            <th>Unit</th>
            <th class="text-right">Selling Price/Ut.</th>
            <th>' . ((int) Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group'] ? CHtml::dropDownList('price-group', '', CostPriceGroupName::getCostPricingGroupName(), array(
	            		'title' => 'Choose cost price',
	            		'style' => 'width:100% !important',
	            		'options' => array($default_pricing_group_id=>array('selected'=>true)),
	            		'onchange' => 'reCalculateProfit(this.value);'
	            )) : $default_pricing_group_name) . '</th>
            <th class="text-right">Total Selling Price</th>
            <th class="text-right">Total Cost Price</th>
        </tr>';
		$totalCostvalue = 0;
		foreach ($model->items as $i => $eachItem) {
			$product_id = $eachItem->product_id;

			$eachItem->rate*=$eachItem->parent->exchange_rate;
			$jsondata['items'].='<tr>';
			$jsondata['items'].='<td>' . ($i + 1) . '</td>';
			$jsondata['items'].='<td class="cell-left">'
					. CHtml::hiddenField('product_id_' . $product_id, $product_id, array('class' => 'product_hidden_ids'))
					. $eachItem->product->part_number . '</td>';
			$jsondata['items'].='<td  class="cell-left" >' . substr($eachItem->description, 0, 30) . ".." . '</td>';
			$jsondata['items'].='<td class="cell-right">'
					. CHtml::hiddenField('quantity_' . $product_id, $eachItem->quantity)
					. $eachItem->quantity . '</td>';
			$jsondata['items'].='<td>' . $eachItem->product->unit->symbol . '</td>';
			$jsondata['items'].='<td  class="cell-right" >'
					. CHtml::hiddenField('sell_price_' . $product_id, $eachItem->net_amount)
					. number_format(round($eachItem->rate, 2), 2, '.', '') . '</td>';


			$costrate = ProfitCalcItem::model()->with('profitCalc')->find(array('condition' => 'profitCalc.file_id=' . $file_id . ' AND product_id=' . $eachItem->product_id))->cost_value_per_unit;

			if ($modelFile->is_approved!= "Y" || $costrate == 0) {



				$arr_cost_pricing_group = CostPriceGroup::model()->find(array('condition'=>'product_id='.$product_id));

				if($default_pricing_group_id==1)
				{
					$costrate = $arr_cost_pricing_group->cost_price1;
				}
				elseif($default_pricing_group_id==2)
				{
					$costrate = $arr_cost_pricing_group->cost_price2;
				}
				elseif($default_pricing_group_id==3)
				{
					$costrate = $arr_cost_pricing_group->cost_price3;
				}
				else
				{
					$costrate = Store::model()->findbypk($product_id)->rate;
				}

			}


			$jsondata['items'].='<td  class="cell-right" >'
					. CHtml::hiddenField('cost_price_' . $product_id, $costrate)
					. '<span id="span_cost_price_' . $product_id.'">' . number_format(round($costrate, 2), 2, '.', '') . '</span></td>';
			$jsondata['items'].='<td class="cell-right net-amount">'
					. Yii::app()->numberFormatter->formatCurrency($eachItem->net_amount * $eachItem->parent->exchange_rate, "") . '</td>';

			$costvalue = $costrate * $eachItem->quantity;


			$jsondata['items'].='<td class="cell-right cost-amount">'
					. Yii::app()->numberFormatter->formatCurrency($costrate, "") . '</td>';

			$totalCostvalue+=$costvalue;
		}
		$netsellingvalue = $model->netAmount * $model->exchange_rate;
		$netcostvalue = $totalCostvalue;


		$profit = $netsellingvalue - $netcostvalue;
		$profit_in_percentage = ($netsellingvalue > 0) ? round(($profit / $netsellingvalue) * 100, 2) : 0;

		$profit_percent_settings = OtherSettings::model()->getProfitPercentValue();


		$jsondata['items'].='<tr><td class="cell-center" colspan="5"><strong> Profit Calculations </strong><br/>';
		if ($modelFile->is_approved == "Y") {
			//$price_group = ($modelProfit->price_group_id) > 0 ? " based on " . PricingGroup::model()->findByPK($modelProfit->price_group_id)->pricing_group : "";
			$jsondata['items'].='<strong style="color:green; font:bold;">    Approved By: ' . $jsondata['approved_by'] . @$price_group . '</strong>';
			//.' On '.$modelFile->date_of_approval
			$jsondata['items'].='<strong style="color:red; font:bold;">';
			if($modelFile->date_of_approval!='0000-00-00')
			{
				$jsondata['items'].='On ' . date("d/m/Y", strtotime($modelFile->date_of_approval));
			}
			$jsondata['items'].='</strong>';
		}
		else
		{
			$jsondata['items'].='<strong style="color:blue; font:bold;">File is waiting for approval</strong>';
		}

		if($profit_in_percentage < $profit_percent_settings)
		{
			$jsondata['items'].='<br/><span class="below-min-profit-warning" style="color:red;"> Profit fallen below Minimum profit!<br/><i class="fa fa-close"></i></span>';
		}
		else {
			$jsondata['items'].='<br/><span class="below-min-profit-warning" style="color:green;"> <i class="fa fa-check"></i></span>';
		}
		$jsondata['items'].='</td>';
		$jsondata['items'].='<td class="cell-right" colspan="6">';

		$jsondata['items'] .= '<table id="profit_calc_footer" style="width:100%"><tr>
    <th>&nbsp;</td>
    <th class="text-right">Sell Amount: <strong class="total-sell-amount">'
				. Yii::app()->numberFormatter->formatCurrency($netsellingvalue, "") . '</strong></td>
    <th class="text-right">Cost Amount: <strong class="total-cost-amount">' . Yii::app()->numberFormatter->formatCurrency($totalCostvalue, "") . '</strong></td>
      <th>&nbsp;</th>
  </tr>';

		$jsondata['items'].='
            <tr class="net">
            <td>Net </td>
            <td><strong class="netsellingvalue">' . CHtml::textField('net_selling_value', number_format(round($netsellingvalue, 2), 2, '.', ''), array('readonly' => true, 'style' => "width:100%; text-align:right;","class"=>"bold")) . '</span></td>
            <td colspan="2"><strong class="netcostvalue">'
	            		. CHtml::textField('net_cost_value', number_format(round($netcostvalue, 2), 2, '.', ''), array('readonly' => true, 'style' => "width:100%; text-align:right;","class"=>"bold"))
	            		. '</span></td>
            </tr>';
		$jsondata['netsellingvalue'] = $netsellingvalue;
		$jsondata['netcostvalue'] = $netcostvalue;









		$min_sales_profit = 0;
		if ($netcostvalue <= 50000)
			$min_sales_profit = 0.15;
		else if ($netcostvalue > 50000 && $netcostvalue <= 100000)
			$min_sales_profit = 0.13;
		else if ($netcostvalue > 100000)
			$min_sales_profit = 0.10;
		//$min_sales_profit_amnt = $profit - ($profit * $min_sales_profit);
		//$jsondata['items'].='<tr><td colspan="4"></td></tr>';
		$jsondata['items'].='<tr>
    <td>Sales Profit</td>
    <td><span ><strong class="profit_percentage">'
				. CHtml::textField('profit_percentage', $profit_in_percentage . '%', array('readonly' => true, 'style' => "width:100%; text-align:right;","class"=>"bold"))
				. '</strong></span></td>
    <td colspan="2"><span><strong class="profit">' . CHtml::textField('profit', number_format(round($profit, 2), 2, '.', ''), array('readonly' => true, 'style' => "width:100%; text-align:right;","class"=>"bold")) . '</strong></span></td>
  </tr>';
		//$jsondata['profit_in_percentage'] = $profit_in_percentage;
		$jsondata['profit_in_percentage'] = $profit_in_percentage;
		$jsondata['items'].='</table></td></tr>';

		//Code added by mereena on 11/12/2014 for approval by value configuration
		$approval_button_show_hide				=	0;
		$unapprove_button_show_hide				=	0;
		$sop_profit_calc_change_pricing_group	=	0;
		if(isset(Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group']) && Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group'] > 0)
			$sop_profit_calc_change_pricing_group 	= 	1;

		if($sop_profit_calc_change_pricing_group == 1 && $modelFile->is_approved != "Y")
		{
			$approval_button_show_hide	=	1;
		}
		else if($sop_profit_calc_change_pricing_group == 1 && $modelFile->is_approved == "Y")
		{
			$unapprove_button_show_hide	=	1;
		}
		else
		{
			if($modelFile->current_process_status == 'O')
			{
				$approval_type_order	=	Yii::app()->user->havePermissionOn['approval_type_order'];
				$approval_min_profit_order	=	Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_order'];
				if($approval_type_order=='sop_order_appr_by_val' && $modelFile->is_approved != "Y")
				{
					$approval_button_show_hide	=	1;
				}
				elseif($approval_type_order=='sop_order_appr_by_pc' && $modelFile->is_approved != "Y")
				{
					$approval_button_show_hide	=	1;
				}
				elseif($modelFile->is_approved == "Y")
				{
					$unapprove_button_show_hide	=	1;
				}

			}
			else
			{

				$approval_type_quote			=	Yii::app()->user->havePermissionOn['approval_type_quote'];
				$approval_min_profit_quote	=	Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_quote'];
				if($approval_type_quote=='sop_quote_appr_by_val' && $modelFile->is_approved != "Y")
				{
					$approval_button_show_hide	=	1;
				}
				elseif($approval_type_quote=='sop_quote_appr_by_pc' && $modelFile->is_approved != "Y")
				{
					$approval_button_show_hide	=	1;
				}
				elseif($modelFile->is_approved == "Y")
				{
					$unapprove_button_show_hide	=	1;
				}
			}
		}
		$jsondata['approval_button_show_hide'] 		= $approval_button_show_hide;
		$jsondata['unapprove_button_show_hide'] 		= $unapprove_button_show_hide;
		//$jsondata['approval_type_quote'] 				= $approval_type_quote;
		//$jsondata['approval_min_profit_quote'] 		= $approval_min_profit_quote.$modelFile->current_process_status;

		//$jsondata['approval_type_order'] 				= $approval_type_order;
		//$jsondata['approval_min_profit_quote'] 		= $approval_min_profit_order.$modelFile->current_process_status;
		//end code


		return $jsondata;
	}

	/*public function profitCalculation($file_id) {
	 $modelFile = MasterFile::model()->with('quote.items', 'order.items1')->findByPK($file_id, array('order' => 'items.id ASC,items1.id ASC'));
	 $modelProfit = ProfitCalc::model()->with('items')->find(array('condition' => 'file_id=' . $file_id, 'order' => 'items.id ASC'));

	 $jsondata['file'] = $modelFile;
	 if ($modelFile->is_approved == "Y") {
	 $jsondata['approved_by'] = $modelFile->approvedBy->fullname;
	 }

	 switch ($modelFile->current_process_status) {
	 case 'Q':
	 $model = $modelFile->quote;
	 break;
	 default:
	 $model = $modelFile->order;
	 break;
	 }
	 $jsondata['model'] = $model;
	 $jsondata['company'] = $model->company;
	 $jsondata['leadowner'] = $model->file->leadowner->fullname;
	 $jsondata['currency'] = $model->currency0->currency;
	 $jsondata['contact'] = $model->contact;
	 // $default_internal_pricing_group = PricingGroup::getDefaultPricingGroup("I");
	 $default_internal_pricing_group_id = 90;
	 $jsondata['items'] = '<tr>
	 <th>No</th>
	 <th>Product</th>
	 <th>Description</th>
	 <th>Qty.</th>
	 <th>Unit</th>
	 <th>Selling Price/Ut.</th>
	 <th>' . ((int) Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group'] ? CHtml::dropDownList('price-group', '', PricingGroup::getPricingGroup("I"), array(
	 'title' => 'Choose cost price',
	 'style' => 'width:100% !important',
	 'options' => array($default_internal_pricing_group_id=>array('selected'=>true)),
	 'onchange' => 'reCalculateProfit(this.value);'
	 )) : "Internal Cost Price") . '</th>
	 <th>Add.</th>
	 <th>Ded.</th>
	 <th>Sell. Val.</th>
	 <th>Cost Val.</th>
	 </tr>';
	 $totalCostvalue = 0;
	 $totalInternalCostvalue = 0;
	 foreach ($model->items as $i => $eachItem) {

	 $eachItem->rate*=$eachItem->parent->exchange_rate;
	 $jsondata['items'].='<tr>';
	 $jsondata['items'].='<td>' . ($i + 1) . '</td>';
	 $jsondata['items'].='<td class="cell-left">'
	 . CHtml::hiddenField('product_id_' . $eachItem->product->id, $eachItem->product->id, array('class' => 'product_hidden_ids'))
	 . $eachItem->product->part_number . '</td>';
	 $jsondata['items'].='<td  class="cell-left" >' . substr($eachItem->description, 0, 30) . ".." . '</td>';
	 $jsondata['items'].='<td class="cell-right">'
	 . CHtml::hiddenField('quantity_' . $eachItem->product->id, $eachItem->quantity)
	 . $eachItem->quantity . '</td>';
	 $jsondata['items'].='<td>' . $eachItem->product->unit->symbol . '</td>';
	 $jsondata['items'].='<td  class="cell-right" >'
	 . CHtml::hiddenField('sell_price_' . $eachItem->product->id, $eachItem->rate)
	 . number_format(round($eachItem->rate, 2), 2, '.', '') . '</td>';


	 //Code added by Mereena on 13/10/2015

	 $costrate = ProfitCalcItemInternal::model()->with('profitCalcInternal')->find(array('condition' => 'profitCalcInternal.file_id=' . $file_id . ' AND product_id=' . $eachItem->product_id))->cost_rate;


	 if($costrate==0)
	 {
	 $costrate = ProfitCalcItem::model()->with('profitCalc')->find(array('condition' => 'profitCalc.file_id=' . $file_id . ' AND product_id=' . $eachItem->product_id))->cost_rate;
	 }

	 $internal_cost_rate = $costrate;
	 if ($modelFile->is_approved != "Y" || $costrate == 0) {

	 //This is landing cost price group id
	 //There are using landing price group for both landing cost and internal cost
	 $landing_price_group_id	=	82;
	 $cond = 'price_group_id=' . (int) $landing_price_group_id .
	 ' AND pricing_product_class_id=' . (int) $eachItem->product->product_class_id .
	 ' AND store_id=' . $eachItem->product->id;
	 // $costrate = PriceGroupProductRelation::model()->find($cond)->rate;

	 //$costrate = Store::model()->findbypk($eachItem->product->id)->rate;

	 $internal_pricing_group_id = 90;

	 $cond = 'price_group_id=' . (int) $internal_pricing_group_id .
	 ' AND pricing_product_class_id=' . (int) $eachItem->product->product_class_id .
	 ' AND store_id=' . $eachItem->product->id;

	 $internal_cost_rate = PriceGroupProductRelation::model()->find($cond)->rate;


	 $product_class_id 		= 	Store::model()->findByPk($eachItem->product->id)->product_class_id;
	 $arr_master_settings	=	MasterSettings::model()->find('product_class_id='.$product_class_id);
	 //$internal_cost_price	=	0;

	 if(count($arr_master_settings) > 0)
	 {
	 $landing_cost_price	=($costrate+($costrate*($arr_master_settings->landing_cost_percentage/100)));
	 $internal_cost_price=($landing_cost_price+($landing_cost_price*($arr_master_settings->internal_cost_percentage/100)));
	 $costrate=$internal_cost_price;
	 }

	 }


	 $jsondata['items'].='<td  class="cell-right" >'
	 . CHtml::hiddenField('cost_price_' . $eachItem->product->id, $costrate)
	 . CHtml::hiddenField('internal_cost_price_' . $eachItem->product->id, $internal_cost_rate)
	 . '<span id="span_cost_price_' . $eachItem->product->id.'">' . number_format(round($internal_cost_rate, 2), 2, '.', '') . '</span></td>';
	 $jsondata['items'].='<td  class="cell-right" >'
	 . CHtml::hiddenField('addition_' . $eachItem->product->id, $eachItem->addition_amount)
	 . $eachItem->addition_amount . '</td>';
	 $jsondata['items'].='<td  class="cell-right" >'
	 . CHtml::hiddenField('deduction_' . $eachItem->product->id, $eachItem->deduction_amount)
	 . $eachItem->deduction_amount . '</td>';
	 $jsondata['items'].='<td class="cell-right net-amount">'
	 . Yii::app()->numberFormatter->formatCurrency($eachItem->net_amount * $eachItem->parent->exchange_rate, "") . '</td>';

	 $costvalue = $costrate * $eachItem->quantity;
	 $internal_cost_value = $internal_cost_rate * $eachItem->quantity;

	 if(Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group']!=0)
	 {
	 $jsondata['items'].='<td class="cell-right cost-amount">'
	 . Yii::app()->numberFormatter->formatCurrency($internal_cost_value, "") . '</td>';
	 }
	 else
	 {
	 $jsondata['items'].='<td class="cell-right cost-amount">'
	 . Yii::app()->numberFormatter->formatCurrency($costvalue, "") . '</td>';
	 }
	 $totalCostvalue+=$costvalue;
	 $totalInternalCostvalue+=$internal_cost_value;
	 }
	 $netsellingvalue = $model->netAmount * $model->exchange_rate;
	 $netcostvalue = $totalCostvalue;
	 $internalnetcostvalue = $totalInternalCostvalue;
	 $jsondata['items'].='<tr><td class="cell-center" colspan="5"><strong> Profit calculations </strong><br/>';
	 if ($modelFile->is_approved == "Y") {
	 //$price_group = ($modelProfit->price_group_id) > 0 ? " based on " . PricingGroup::model()->findByPK($modelProfit->price_group_id)->pricing_group : "";
	 $jsondata['items'].='<strong style="color:green; font:bold;">    Approved By: ' . $jsondata['approved_by'] . @$price_group . '</strong>';
	 //.' On '.$modelFile->date_of_approval
	 $jsondata['items'].='<strong style="color:red; font:bold;">';
	 if($modelFile->date_of_approval!='0000-00-00')
	 {
	 $jsondata['items'].='On ' . date("d/m/Y", strtotime($modelFile->date_of_approval));
	 }
	 $jsondata['items'].='</strong>';
	 }
	 else
	 	$jsondata['items'].='<strong style="color:blue; font:bold;">File is waiting for approval</strong>';
	 	$jsondata['items'].='<br/><span class="below-min-profit-warning" style="color:red; display:none;"> Profit fallen below Minimum profit!</span>';
	 	$jsondata['items'].='</td>';
	 	$jsondata['items'].='<td class="cell-right" colspan="6">';

	 	$jsondata['items'] .= '<table id="profit_calc_footer" style="width:100%"><tr>
	 	<th>&nbsp;</td>
	 	<th>Sell amount: <strong class="total-sell-amount">'
	 	. CHtml::hiddenField('net_sell_amount_' . $model->id, $netsellingvalue)
	 	. Yii::app()->numberFormatter->formatCurrency($netsellingvalue, "") . '</strong></td>
	 	<th>Cost amount: <strong class="total-cost-amount">' . Yii::app()->numberFormatter->formatCurrency($totalInternalCostvalue, "") . '</strong></td>
	 	<th>' . CHtml::link('<i class="icon-plus-sign"></i>', 'javascript:void(0);', array(
	 	'onclick' => 'addNewFooter(this);',
	 	'title' => 'Add new footer item'
	 	)) . '</th>
	  </tr>';


	  if ($modelFile->is_approved == "Y" && count($modelProfit) > 0) {
	  $extras = ProfitCalcExtra::model()->findAll(array('condition' => 'profit_calc_id=' . $modelProfit->id, 'order' => 'id asc'));
	  foreach ($extras as $i => $eachDedItem) {
	  $jsondata['items'].='<tr>
	  <td>' . CHtml::textField("extra[]", $eachDedItem->particular, array(
	  'placeholder' => 'Deduction particular',
	  'class' => 'paricular')) . '</td>
	  <td>' . CHtml::textField("extra_addition[]", $eachDedItem->addition, array(
	  'readonly' => false,
	  'class' => "additions paricular",
	  'onkeyup' => 'calcProfit();'
	  )) . '</td>
	  <td>' . CHtml::textField("extra_deduction[]", $eachDedItem->deduction, array(
	  'readonly' => false,
	  'class' => "deductions paricular",
	  'onkeyup' => 'calcProfit();'
	  )) . '
	  </td><td>' . CHtml::link('<i class="icon-remove"></i>', 'javascript:void(0);', array(
	  'onclick' => 'removeProfitFooterRow(this);')) . '</td>
	  </tr>';
	  if (floatval($eachDedItem->addition) > 0)
	  	$netsellingvalue += floatval($eachDedItem->addition);
	  	if (floatval($eachDedItem->deduction) > 0)
	  		$netsellingvalue -= floatval($eachDedItem->deduction);
	  		}
	  		} else {
	  		foreach ($model->adItems as $eachAddItem) {
	  		if ($eachAddItem->calculated_value > 0) {
	  		$eachAddItem->calculated_value = $eachAddItem->calculated_value * $model->exchange_rate;
	  		$jsondata['items'].='<tr>
	  		<td>' . CHtml::textField("extra[]", $eachAddItem->particular, array(
	  		'class' => 'paricular',
	  		'placeholder' => 'Addition particular')) . '</td>
	  		<td>' . CHtml::textField("extra_addition[]", $eachAddItem->calculated_value, array(
	  		'readonly' => false,
	  		'class' => "additions paricular",
	  		'onkeyup' => 'calcProfit();'
	  		)) . '</td>
	  		<td>' . CHtml::textField("extra_deduction[]", 0, array(
	  		'readonly' => false,
	  		'class' => "deductions paricular",
	  		'onkeyup' => 'calcProfit();'
	  		)) . '
	  		</td>
	  		<td>' . CHtml::link('<i class="icon-remove"></i>', 'javascript:void(0);', array(
	  		'onclick' => 'removeProfitFooterRow(this);')) . '</td>
	  		</tr>';
	  		$netsellingvalue+=($eachAddItem->calculated_value );
	  		}
	  		}

	  		foreach ($model->dedItems as $eachDedItem) {
	  		if ($eachDedItem->calculated_value > 0) {
	  		$eachDedItem->calculated_value = $eachDedItem->calculated_value * $model->exchange_rate;
	  		$jsondata['items'].='<tr>
	  		<td>' . CHtml::textField("extra[]", $eachDedItem->particular, array(
	  		'placeholder' => 'Deduction particular',
	  		'class' => 'paricular')) . '</td>
	  		<td>' . CHtml::textField("extra_addition[]", 0, array(
	  		'readonly' => false,
	  		'class' => "additions paricular",
	  		'onkeyup' => 'calcProfit();'
	  		)) . '</td>
	  		<td>' . CHtml::textField("extra_deduction[]", $eachDedItem->calculated_value, array(
	  		'readonly' => false,
	  		'class' => "deductions paricular",
	  		'onkeyup' => 'calcProfit();'
	  		)) . '
	  		</td><td>' . CHtml::link('<i class="icon-remove"></i>', 'javascript:void(0);', array(
	  		'onclick' => 'removeProfitFooterRow(this);')) . '</td>
	  		</tr>';
	  		$netsellingvalue-=($eachDedItem->calculated_value );
	  		}
	  		}
	  		}
	  		$jsondata['items'].='
	  		<tr class="repeating_row" style="display:none;">
	  		<td>' . CHtml::textField("extra[]", '', array(
	  		'readonly' => false,
	  		'placeholder' => 'Additional particlars',
	  		'class' => 'paricular'
	  		)) . '</td>
	  		<td>' . CHtml::textField("extra_addition[]", '', array(
	  		'readonly' => false,
	  		'class' => "additions paricular",
	  		'placeholder' => 'Additions to sell amount',
	  		'onkeyup' => 'calcProfit();'
	  		)) . '</td>
	  		<td>' . CHtml::textField("extra_deduction[]", '', array(
	  		'readonly' => false,
	  		'class' => "deductions paricular",
	  		'placeholder' => 'Deductions to sell amount or additions to cost amount',
	  		'onkeyup' => 'calcProfit();'
	  		)) . '</td>
	  		<td>' . CHtml::link('<i class="icon-remove"></i>', 'javascript:void(0);', array(
	  		'onclick' => 'removeProfitFooterRow(this);')) . '</td>
	  		</tr>';
	  		$jsondata['items'].='
	  		<tr class="net">
	  		<td>Net </td>
	  		<td><strong class="netsellingvalue">' . CHtml::textField('netsellingvalue', number_format(round($netsellingvalue, 2), 2, '.', ''), array('readonly' => true, 'style' => "width:95%; text-align:right;")) . '</span></td>
	  		<td colspan="2"><strong class="netcostvalue">'
	  		. CHtml::hiddenField('netcostvalue', number_format(round($netcostvalue, 2), 2, '.', ''))
	  		. CHtml::textField('netcostvalueinternal', number_format(round($internalnetcostvalue, 2), 2, '.', ''), array('readonly' => true, 'style' => "width:95%; text-align:right;"))
	  		. '</span></td>
	  		</tr>';
	  		$jsondata['netsellingvalue'] = $netsellingvalue;
	  		$jsondata['netcostvalue'] = $netcostvalue;
	  		$jsondata['internalnetcostvalue'] = $internalnetcostvalue;
	  		$profit = $netsellingvalue - $netcostvalue;
	  		$internal_profit = $netsellingvalue - $internalnetcostvalue;
	  		//$profit_in_percentage = ($netcostvalue > 0) ? round(($profit / $netcostvalue) * 100, 2) : 100;
	  		$profit_in_percentage = ($netsellingvalue > 0) ? round(($profit / $netsellingvalue) * 100, 2) : 0;

	  		$internal_profit_in_percentage = ($netsellingvalue > 0) ? round(($internal_profit / $netsellingvalue) * 100, 2) : 0;
	  		$min_sales_profit = 0;
	  		if ($netcostvalue <= 50000)
	  			$min_sales_profit = 0.15;
	    	else if ($netcostvalue > 50000 && $netcostvalue <= 100000)
	    		$min_sales_profit = 0.13;
	    		else if ($netcostvalue > 100000)
	    			$min_sales_profit = 0.10;
	    			//$min_sales_profit_amnt = $profit - ($profit * $min_sales_profit);
	    			//$jsondata['items'].='<tr><td colspan="4"></td></tr>';
	    			$jsondata['items'].='<tr>
	    			<td>Sales Profit</td>
	    			<td><span ><strong class="profit_percentage">'
	    			. CHtml::hiddenField('profit_percentage', $profit_in_percentage . '%', array('readonly' => true, 'style' => "width:95%; text-align:right;"))
	    			. CHtml::textField('internal_profit_percentage', $internal_profit_in_percentage . '%', array('readonly' => true, 'style' => "width:95%; text-align:right;"))
	    			. '</strong></span></td>
	    			<td colspan="2"><span><strong class="profit">' . CHtml::textField('profit', number_format(round($internal_profit, 2), 2, '.', ''), array('readonly' => true, 'style' => "width:95%; text-align:right;")) . '</strong></span></td>
	    			</tr>';
	    			//$jsondata['profit_in_percentage'] = $profit_in_percentage;
	    			$jsondata['profit_in_percentage'] = $internal_profit_in_percentage;
	    			$jsondata['items'].='</table></td></tr>';

	    			//Code added by mereena on 11/12/2014 for approval by value configuration
	    			$approval_button_show_hide				=	0;
	    			$unapprove_button_show_hide				=	0;
	    			$sop_profit_calc_change_pricing_group	=	0;
	    			if(isset(Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group']) && Yii::app()->user->havePermissionOn['sop_profit_calc_change_pricing_group'] > 0)
	    				$sop_profit_calc_change_pricing_group 	= 	1;

	    				if($sop_profit_calc_change_pricing_group == 1 && $modelFile->is_approved != "Y")
	    				{
	    				$approval_button_show_hide	=	1;
	    				}
	    				else if($sop_profit_calc_change_pricing_group == 1 && $modelFile->is_approved == "Y")
	    				{
	    				$unapprove_button_show_hide	=	1;
	    				}
	    				else
	    				{
	    				if($modelFile->current_process_status == 'O')
	    				{
	    				$approval_type_order	=	Yii::app()->user->havePermissionOn['approval_type_order'];
	    				$approval_min_profit_order	=	Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_order'];
	    				if($approval_type_order=='sop_order_appr_by_val' && ($netsellingvalue < $approval_min_profit_order) && $modelFile->is_approved != "Y")
	    				{
	    				$approval_button_show_hide	=	1;
	    				}
	    				elseif($approval_type_order=='sop_order_appr_by_pc' && ($internal_profit_in_percentage > $approval_min_profit_order) && $modelFile->is_approved != "Y")
	    				{
	    				$approval_button_show_hide	=	1;
	    				}
	    				elseif($modelFile->is_approved == "Y")
	    				{
	    				$unapprove_button_show_hide	=	1;
	    				}

	    				}
	    				else
	    				{

	    				$approval_type_quote			=	Yii::app()->user->havePermissionOn['approval_type_quote'];
	    				$approval_min_profit_quote	=	Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_quote'];
	    				if($approval_type_quote=='sop_quote_appr_by_val' && ($netsellingvalue < $approval_min_profit_quote) && $modelFile->is_approved != "Y")
	    				{
	    				$approval_button_show_hide	=	1;
	    				}
	    				elseif($approval_type_quote=='sop_quote_appr_by_pc' && ($internal_profit_in_percentage > $approval_min_profit_quote) && $modelFile->is_approved != "Y")
	    				{
	    				$approval_button_show_hide	=	1;
	    				}
	    				elseif($modelFile->is_approved == "Y")
	    				{
	    				$unapprove_button_show_hide	=	1;
	    				}
	    				}
	    				}
	    				$jsondata['approval_button_show_hide'] 		= $approval_button_show_hide;
	    				$jsondata['unapprove_button_show_hide'] 		= $unapprove_button_show_hide;
	    				//$jsondata['approval_type_quote'] 				= $approval_type_quote;
	    				//$jsondata['approval_min_profit_quote'] 		= $approval_min_profit_quote.$modelFile->current_process_status;

	    				//$jsondata['approval_type_order'] 				= $approval_type_order;
	    				//$jsondata['approval_min_profit_quote'] 		= $approval_min_profit_order.$modelFile->current_process_status;
	    				//end code


	    				return $jsondata;
	    				}*/
}
