<?php

/**
 * This is the model class for table "{{product_location_details}}".
 *
 * The followings are the available columns in table '{{product_location_details}}':
 * @property integer $id
 * @property integer $header_id
 * @property integer $header_item_id
 * @property integer $product_id
 * @property string $bill_of_entry
 * @property integer $warehouse_id
 * @property integer $rack_id
 * @property integer $bin_id
 * @property string $batch_no
 * @property string $serial_no
 * @property string $manufacturing_date
 * @property string $expiry_date
 * @property string $quantity
 * @property string $transaction_type
 * @property integer $created_by
 * @property string $created_date
 */
class ProductLocationDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
     public $rowno;
	public function tableName()
	{
		return '{{product_location_details}}';
	}
    
    public $oldProductId;
    public $oldSerialNo;
    public $part_number;
    public $description;
    /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_id, header_item_id, product_id', 'required'),
			array('header_id, header_item_id, product_id, warehouse_id, rack_id, bin_id, created_by', 'numerical', 'integerOnly'=>true),
			array('bill_of_entry, batch_no, serial_no, transaction_type', 'length', 'max'=>255),
			array('quantity', 'length', 'max'=>15),
             array('product_id', 'checkUniqueness'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, header_id, header_item_id, product_id, bill_of_entry, warehouse_id, rack_id, bin_id, batch_no, serial_no, manufacturing_date, expiry_date, quantity, transaction_type, created_by, created_date', 'safe', 'on'=>'search'),
		);
	}
    
    public function checkUniqueness($attribute,$params)
    {
        if($this->product_id !== $this->oldProductId || $this->serial_no !== $this->oldSerialNo)
        {
            $model = ProductLocationDetails::model()->find('product_id = ? AND serial_no = ? AND quantity != ? AND serial_no != ?', array($this->product_id, $this->serial_no,0,''));
            if($model != null){
                $modelStore = new Store();
                $modelStore = $modelStore->findBypk($this->product_id);
                $this->addError('product_id','This '.$modelStore->part_number.' and serial no '.$this->serial_no.' already exist');
            }
                
        }   
    }
    
    protected function afterFind()
    {
        parent::afterFind();
        $this->oldProductId = $this->product_id;
        $this->oldSerialNo = $this->serial_no;        
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
                    'rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
                    'bin' => array(self::BELONGS_TO, 'MasInvBin', 'bin_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'header_id' => 'Header',
			'header_item_id' => 'Header Item',
			'product_id' => 'Product',
			'bill_of_entry' => 'Bill Of Entry',
			'warehouse_id' => 'Warehouse',
			'rack_id' => 'Rack',
			'bin_id' => 'Bin',
			'batch_no' => 'Batch No',
			'serial_no' => 'Serial No',
			'manufacturing_date' => 'Manufacturing Date',
			'expiry_date' => 'Expiry Date',
			'quantity' => 'sale from this qty',
			'transaction_type' => 'Transaction Type',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('header_id',$this->header_id);
		$criteria->compare('header_item_id',$this->header_item_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('bill_of_entry',$this->bill_of_entry,true);
		$criteria->compare('warehouse_id',$this->warehouse_id);
		$criteria->compare('rack_id',$this->rack_id);
		$criteria->compare('bin_id',$this->bin_id);
		$criteria->compare('batch_no',$this->batch_no,true);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('manufacturing_date',$this->manufacturing_date,true);
		$criteria->compare('expiry_date',$this->expiry_date,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('transaction_type',$this->transaction_type,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductLocationDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getBatchNo($product_loc_id=0){
            $batch_no='';
            if($product_loc_id>0){
                $model = self::model()->with('product')->findByPK($product_loc_id);
                if ($model->product->have_expiry_date=='Y'){
                    $batch_no=$model->batch_no;
                }
            }	
            return $batch_no;
        }
        public static function getBatchNoWithExpDate($product_loc_id=0){
            $batch_no='';
            if($product_loc_id>0){
                $model = self::model()->with('product')->findByPK($product_loc_id);
                if ($model->product->have_expiry_date=='Y'){
                    $batch_no=$model->batch_no.'(Exp. '.date('d/m/Y',STRTOTIME($model->expiry_date)).')';
                }
            }	
            return $batch_no;
        }
        public static function getSerialNo($product_loc_id=0){
            $sl_no='';
            if($product_loc_id>0){
                $model = self::model()->with('product')->findByPK($product_loc_id);
                if ($model->product->have_serial_no=='Y'){
                    $sl_no=$model->serial_no;
                }
            }	
            return $sl_no;
        }
}
