<?php

class ProductClass extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{product_class}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_class, restricted', 'required'),
            array('product_class,auto_generated_no', 'unique'),
            array('product_class, description', 'length', 'max' => 255),
            array('id, product_class', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::HAS_MANY, 'Store', 'product_class'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_class' => 'Product class',
        );
    }

    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('search_product_class')) : $searchterm;
        Yii::app()->session['pricinggroup_id'] = (int) Yii::app()->request->getParam('pricinggroup_id');
        //$criteria->addCondition('t.company_id =' . Yii::app()->user->master_user_company_id . ' AND  t.company_branch_id =' . Yii::app()->user->master_user_branch_id, 'AND');

        if (!empty($searchterm)) {
            $criteria->addCondition('product_class like "%' . $searchterm . '%"', 'AND');
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.product_class',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 100) : false
        ));
    }

    public function renderPercentageColumn($data, $row) {
        $pricinggroup_id = Yii::app()->session['pricinggroup_id'];
        $percentage = PriceGroupProductRelation::model()->find('price_group_id=' . $pricinggroup_id . ' AND pricing_product_class_id=' . $data->id)->percentage;
        return CHTML::textField("percentage[" . $data->id . "]", ($percentage > 0 ? $percentage : 100), array('class' => 'cell-right', 'onfocus' => '$(this).select();'));
    }

    public function renderPricingGroup($customer_id) {
        return CHTML::dropDownList("pricinggroup[" . $this->id . "]", self::getSelecetdPricingGroupId((int) $customer_id, $this->id), PricingGroup::getPricingGroup("S", $this->id), array('style' => '100% !important', 'class' => 'pricing'));
        //ropDownList($name,$select,$data,$htmlOptions=array())
        //return (PricingGroup::getPricingGroup("S", $data->id));
    }

    public function getSelecetdPricingGroupId($customer_id, $brand_id) {
        return CustomerPricingGroup::model()->find('customer_id=' . (int) $customer_id . ' AND brand_id=' . $brand_id)->pricing_group_id;
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Store the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /* public function getAllProductClass() {
        $sql = "SELECT DISTINCT(brand.id) AS id,product_class FROM crm_product_class AS brand          		
        INNER JOIN crm_store  ON product_class_id=brand.id ORDER BY product_class";                
        
        $model = Yii::app()->db->createCommand($sql)->queryAll();      
        
        
        $list = array();
        foreach ($model as $product_class) {
        	
        		$list[$product_class['id']] = $product_class['product_class'];
        }
        return $list;
    	
    } */

    public function getBrand() {
        if (!empty($this->description))
            return $this->description;
        else
            return $this->product_class;
    }
    
    public static function getAllProductClass() {
    	$model = self::model()->findAll(array('order' => 'is_default ASC, product_class ASC'));
    	return CHtml::listData($model, 'id', 'product_class');
    }
    public static function getAllProductClass_specified() {
    	$model = self::model()->findAll(array('order' => 'is_default ASC, product_class ASC', 'condition' => 'restricted="N"'));
    	return CHtml::listData($model, 'id', 'product_class');
    }
    public static function getProductClassName($id=0) {
    	$model = self::model()->findByPk($id);
    	return $model->product_class;
    }

}
