<?php

/**
 * This is the model class for table "{{pricing_group}}".
 *
 * The followings are the available columns in table '{{pricing_group}}':
 * @property integer $id
 * @property string $pricing_group
 * @property integer $parent_id
 * @property string $type
 * @property string $description
 * @property string $isActive
 * @property string $isBasePricingGroup
 * @property string $default_pricing_group
 * @property string $price_list_file_name
 */
class PricingGroup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pricing_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pricing_group, description, price_list_file_name', 'required'),
            array('pricing_group', 'unique', 'on' => 'add'),
			array('parent_id', 'numerical', 'integerOnly'=>true),
			array('pricing_group, price_list_file_name', 'length', 'max'=>255),
			array('type, isActive, isBasePricingGroup, default_pricing_group', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, pricing_group, parent_id, type, description, isActive, isBasePricingGroup, default_pricing_group, price_list_file_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'pricing_group' => 'Pricing Group',
			'parent_id' => 'Parent',
			'type' => 'Type',
			'description' => 'Description',
			'isActive' => 'Is Active',
			'isBasePricingGroup' => 'Is Base Pricing Group',
			'default_pricing_group' => 'Default Pricing Group',
			'price_list_file_name' => 'Price List',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('pricing_group',$this->pricing_group,true);
		$criteria->compare('parent_id',$this->parent_id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('isBasePricingGroup',$this->isBasePricingGroup,true);
		$criteria->compare('default_pricing_group',$this->default_pricing_group,true);
		$criteria->compare('price_list_file_name',$this->price_list_file_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PricingGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getList()
        {
                $condition = 'isActive =  "Y"';
                $model = self::model()->findAll(array('condition' => $condition,'order'=>'default_pricing_group,pricing_group'));
                return CHtml::listData($model, 'id', 'pricing_group');
        }
}
