<?php

/**
 * This is the model class for table "{{owner_bank_details}}".
 *
 * The followings are the available columns in table '{{owner_bank_details}}':
 * @property integer $id
 * @property integer $bank_id
 * @property string $bank_branch
 * @property string $bank_account_name
 * @property string $bank_ac_no
 * @property string $bank_tax_id
 * @property string $bank_iban
 * @property string $bank_swift
 * @property string $bank_ifsc
 * @property string $bank_others
 * @property string $isActive
 */
class OwnerBankDetails extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
	public $bank_name;
    public function tableName() {
        return '{{owner_bank_details}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('bank_id, bank_branch, bank_account_name, bank_ac_no,isActive', 'required'),
            array('bank_id', 'numerical', 'integerOnly' => true),
            array('bank_ac_no', 'unique'),  
            array('bank_branch, bank_account_name, bank_ac_no, bank_tax_id, bank_iban, bank_swift, bank_ifsc, bank_others', 'length', 'max' => 255),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, bank_id, bank_branch, bank_account_name, bank_ac_no, bank_tax_id, bank_iban, bank_swift, bank_ifsc, bank_others, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'bank' => array(self::BELONGS_TO, 'MasBank', 'bank_id'),
        );
        
        
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'bank_id' => 'Bank',
            'bank_branch' => 'Bank Branch',
            'bank_account_name' => 'Bank Account Name',
            'bank_ac_no' => 'Bank Ac No',
            'bank_tax_id' => 'Bank Tax',
            'bank_iban' => 'Bank Iban',
            'bank_swift' => 'Bank Swift',
            'bank_ifsc' => 'Bank Ifsc',
            'bank_others' => 'Bank Others',
            'isActive' => 'Status',
            'currency_id'=>'Currency'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('bank_id', $this->bank_id);
        $criteria->compare('bank_branch', $this->bank_branch, true);
        $criteria->compare('bank_account_name', $this->bank_account_name, true);
        $criteria->compare('bank_ac_no', $this->bank_ac_no, true);
        $criteria->compare('bank_tax_id', $this->bank_tax_id, true);
        $criteria->compare('bank_iban', $this->bank_iban, true);
        $criteria->compare('bank_swift', $this->bank_swift, true);
        $criteria->compare('bank_ifsc', $this->bank_ifsc, true);
        $criteria->compare('bank_others', $this->bank_others, true);
        $criteria->compare('isActive', $this->isActive, true);
        //$criteria->compare('company_id', Yii::app()->user->master_user_company_id, true);
        //$criteria->compare('company_branch_id', Yii::app()->user->master_user_branch_id, true);

        return new CActiveDataProvider($this, array(
              'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return OwnerBankDetails the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
