<?php

/**
 * This is the model class for table "{{order_machinehours}}".
 *
 * The followings are the available columns in table '{{order_machinehours}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $product_id
 * @property string $serial_no
 * @property string $work_date
 * @property string $start_time
 * @property string $end_time
 * @property string $machine_hours
 * @property string $breakdown_hours
 * @property string $net_machine_hrs
 * @property string $invoiced
 */
class OrderMachinehours extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{order_machinehours}}';
	}
        public $wk_date;
        public $product_serial_number;
        /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, product_id, work_date, start_time, end_time, machine_hours,  net_machine_hrs', 'required'),
			array('order_id, product_id', 'numerical', 'integerOnly'=>true),
			array('serial_no', 'length', 'max'=>255),
			array('invoiced', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, order_id, product_id, serial_no, work_date, start_time, end_time, machine_hours, breakdown_hours, net_machine_hrs, invoiced', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'machine_order' => array(self::BELONGS_TO, 'Order', 'order_id'),
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'product_id' => 'Product',
			'serial_no' => 'Serial No',
			'work_date' => 'Work Date',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
			'machine_hours' => 'Machine Hours',
			'breakdown_hours' => 'Breakdown Hours',
			'net_machine_hrs' => 'Net Machine Hrs',
			'invoiced' => 'Invoiced',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('work_date',$this->work_date,true);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);
		$criteria->compare('machine_hours',$this->machine_hours,true);
		$criteria->compare('breakdown_hours',$this->breakdown_hours,true);
		$criteria->compare('net_machine_hrs',$this->net_machine_hrs,true);
		$criteria->compare('invoiced',$this->invoiced,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OrderMachinehours the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getProductdetail($order_id=0) {
            $model_item = OrderItem::model()->find(array('condition' =>'hiring_master="Y" and order_id="'.$order_id.'" and checked="1"'));
            $m=0;
            $machine_array=array();
//            $model_pkg_details =HiringPackageDetails::model()->findAll(array('condition' => 'order_id = "'.$order_id.'" and product_id="'.$model_item->product_id.'"')); 
            $model_pkg_details =HiringPackageDetails::model()->with('product')->findAll(array('condition' => 'order_id = "'.$order_id.'" and product.machine_type="M"')); 
            foreach ($model_pkg_details as $j=>$each) {
                $machine_array[$m]['id'] = $each->product_id.'/'.$each->serial_no;
                $machine_array[$m]['name'] = $each->serial_no.' - '.$each->product->description;
                $m++;
            }
            return CHtml::listData($machine_array, 'id', 'name');
	}
        public static function getProductSerialNumber($order_id=0) {
            $model_item = OrderItem::model()->find(array('condition' =>'hiring_master="Y" and order_id="'.$order_id.'" and checked="1"'));
            $m=0;
            $machine_array=array();
            $model_pkg_details =HiringPackageDetails::model()->findAll(array('condition' => 'order_id = "'.$order_id.'" and product_id="'.$model_item->product_id.'"')); 
            foreach ($model_pkg_details as $j=>$each) {
                $machine_array[$m]['id'] = $each->serial_no;
                $machine_array[$m]['name'] = $each->product->description.'-'.$each->serial_no;
                $m++;
            }
            return CHtml::listData($machine_array, 'id', 'name');
	}
}
