<?php

/**
 * This is the model class for table "{{order_components}}".
 *
 * The followings are the available columns in table '{{order_components}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $product_id
 * @property string $description
 * @property string $quantity
 * @property integer $unit_id
 * @property string $actual_cost_rate
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 * @property string $convert_to_delivery_note
 * @property string $inventory_type
 */
class OrderComponents extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public $product_name;
    public function tableName()
    {
        return '{{order_components}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('order_id, product_id, description, quantity, unit_id, actual_cost_rate, inventory_type', 'required'),
            array('order_id, product_id, unit_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
            array('quantity, actual_cost_rate', 'length', 'max'=>15),
            array('convert_to_delivery_note, inventory_type', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, order_id, product_id, description, quantity, unit_id, actual_cost_rate, created_by, updated_by, created_datetime, updated_datetime, convert_to_delivery_note, inventory_type', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'parent' => array(self::BELONGS_TO, 'Order', 'order_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'orderunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'order_id' => 'Order',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_id' => 'Unit',
            'actual_cost_rate' => 'Actual Cost Rate',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_datetime' => 'Created Datetime',
            'updated_datetime' => 'Updated Datetime',
            'convert_to_delivery_note' => 'Convert To Delivery Note',
            'inventory_type' => 'Inventory Type',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('order_id',$this->order_id);
        $criteria->compare('product_id',$this->product_id);
        $criteria->compare('description',$this->description,true);
        $criteria->compare('quantity',$this->quantity,true);
        $criteria->compare('unit_id',$this->unit_id);
        $criteria->compare('actual_cost_rate',$this->actual_cost_rate,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('updated_by',$this->updated_by);
        $criteria->compare('created_datetime',$this->created_datetime,true);
        $criteria->compare('updated_datetime',$this->updated_datetime,true);
        $criteria->compare('convert_to_delivery_note',$this->convert_to_delivery_note,true);
        $criteria->compare('inventory_type',$this->inventory_type,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return OrderComponents the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}