<?php

/**
 * This is the model class for table "{{opening_cash}}".
 *
 * The followings are the available columns in table '{{opening_cash}}':
 * @property integer $id
 * @property string $opening_date
 * @property string $opening_cash
 * @property integer $created_by
 * @property string $created_date_time
 */
class OpeningCash extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{opening_cash}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('opening_date, opening_cash, warehouse_id, created_by, created_date_time', 'required'),
			array('opening_date', 'uniqueValidator'),
			array('created_by, warehouse_id', 'numerical', 'integerOnly'=>true),
			array('opening_cash', 'numerical', 'min'=>0),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, opening_date, opening_cash, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'warehouse' => [self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id']
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'opening_date' => 'Opening Date',
			'opening_cash' => 'Opening Cash',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('opening_date',$this->opening_date,true);
		$criteria->compare('opening_cash',$this->opening_cash,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OpeningCash the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function uniqueValidator($a, $b){
	    $condition = "t.opening_date= '{$this->opening_date}'  AND warehouse_id = {$this->warehouse_id} ";
	    if(!empty($this->id)){
	        $condition .= " AND t.id != '{$this->id}' "; 
	    }
	    $model = self::model()->find(['condition' => $condition]);
	    if(!empty($model)){
	        $this->addError('opening_date', "The record already exists.");
	    }
	    
	}
}
