<?php

/**
 * This is the model class for table "{{inventory_mtom_transfer}}".
 *
 * The followings are the available columns in table '{{inventory_mtom_transfer}}':
 * @property integer $id
 * @property string $transfer_date
 * @property string $note
 * @property integer $from_product
 * @property integer $from_unit
 * @property integer $from_qty
 * @property integer $to_product
 * @property integer $to_unit
 * @property integer $to_qty
 * @property integer $created_by
 * @property string $created_date_time
 */
class MtomTransfer extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_mtom_transfer}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('transfer_date, from_product, from_qty, to_product, to_qty', 'required'),
			array('from_product, from_unit, from_qty, to_product, to_unit, to_qty, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, transfer_date, note, from_product, from_unit, from_qty, to_product, to_unit, to_qty, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'fromproduct' => array(self::BELONGS_TO, 'Store', 'from_product'),
			'toproduct' => array(self::BELONGS_TO, 'Store', 'to_product'),
			'fromunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'from_unit'),
			'tounit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'to_unit'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'transfer_date' => 'Transfer Date',
			'note' => 'Note',
			'from_product' => 'From Product',
			'from_unit' => 'From Unit',
			'from_qty' => 'From Qty',
			'to_product' => 'To Product',
			'to_unit' => 'To Unit',
			'to_qty' => 'To Qty',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('transfer_date',$this->transfer_date,true);
		$criteria->compare('note',$this->note,true);
		$criteria->compare('from_product',$this->from_product);
		$criteria->compare('from_unit',$this->from_unit);
		$criteria->compare('from_qty',$this->from_qty);
		$criteria->compare('to_product',$this->to_product);
		$criteria->compare('to_unit',$this->to_unit);
		$criteria->compare('to_qty',$this->to_qty);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MtomTransfer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
