<?php

/**
 * This is the model class for table "{{meeting_type}}".
 *
 * The followings are the available columns in table '{{meeting_type}}':
 * @property integer $id
 * @property string $type_name
 * @property string $created_date_time
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MeetingType extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{meeting_type}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type_name', 'required'),
            array('created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('type_name', 'length', 'max' => 100),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, type_name, created_date_time, created_by, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'type_name' => 'Type Name',
            'created_date_time' => 'Created Date Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('type_name', $this->type_name, true);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MeetingType the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function beforeSave() {
        date_default_timezone_set('Asia/Dubai');
        if ($this->isNewRecord) {
            $this->created_by = Yii::app()->user->id;
            $this->created_date_time = date('Y-m-d H:i:s');
        }
        $this->updated_by = Yii::app()->user->id;
        $this->updated_date_time = date('Y-m-d H:i:s'); 
        return parent::beforeSave();
    }

    public static function getList() {
        $condition = ' 1=1 ';
        $model = self::model()->findAll(array('select' => array('id', 'type_name'), 'condition' => $condition, 'order' => 'type_name'));
        return CHtml::listData($model, 'id', 'type_name');
    }

}
