<?php

/**
 * This is the model class for table "{{material_movement_issue}}".
 *
 * The followings are the available columns in table '{{material_movement_issue}}':
 * @property integer $id
 * @property string $part_no
 * @property integer $stock_id
 * @property string $product_description
 * @property string $product_class
 * @property string $product_generic_name
 * @property integer $product_total_quantity
 * @property integer $product_allocated_quantity
 * @property integer $product_free_quantity
 * @property integer $unit
 * @property double $rate
 * @property double $total_value
 * @property string $status
 * @property string $receipt_no
 * @property string $adjust_date
 * @property string $adjust_description
 * @property integer $adjust_quantity
 * @property string $adjust_reference
 * @property double $adjust_value
 * @property integer $transfer_order_no
 * @property string $transfer_date
 * @property string $receipt_date
 * @property string $transfer_description
 * @property string $transfer_reference
 * @property integer $from_warehouse
 * @property integer $to_warehouse
 * @property integer $to_rack
 * @property integer $to_bin
 * @property integer $transfer_quantity
 */
class MaterialMovementIssue extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{material_movement_issue}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('part_no, stock_id, product_description, product_class, product_generic_name, product_total_quantity, product_allocated_quantity, product_free_quantity, unit, rate, total_value, status, receipt_no, adjust_date, adjust_description, adjust_quantity, adjust_reference, adjust_value, transfer_order_no, transfer_date, receipt_date, transfer_description, transfer_reference, from_warehouse, to_warehouse, to_rack, to_bin, transfer_quantity', 'required'),
			array('stock_id, product_total_quantity, product_allocated_quantity, product_free_quantity, unit, adjust_quantity, transfer_order_no, from_warehouse, to_warehouse, to_rack, to_bin, transfer_quantity', 'numerical', 'integerOnly'=>true),
			array('rate, total_value, adjust_value', 'numerical'),
			array('part_no, product_description, product_class, product_generic_name, receipt_no, adjust_description, adjust_reference, transfer_description, transfer_reference', 'length', 'max'=>255),
			array('status', 'length', 'max'=>3),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, part_no, stock_id, product_description, product_class, product_generic_name, product_total_quantity, product_allocated_quantity, product_free_quantity, unit, rate, total_value, status, receipt_no, adjust_date, adjust_description, adjust_quantity, adjust_reference, adjust_value, transfer_order_no, transfer_date, receipt_date, transfer_description, transfer_reference, from_warehouse, to_warehouse, to_rack, to_bin, transfer_quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'part_no' => 'Part No',
			'stock_id' => 'Stock',
			'product_description' => 'Product Description',
			'product_class' => 'Product Class',
			'product_generic_name' => 'Product Generic Name',
			'product_total_quantity' => 'Product Total Quantity',
			'product_allocated_quantity' => 'Product Allocated Quantity',
			'product_free_quantity' => 'Product Free Quantity',
			'unit' => 'Unit',
			'rate' => 'Rate',
			'total_value' => 'Total Value',
			'status' => 'Status',
			'receipt_no' => 'Receipt No',
			'adjust_date' => 'Adjust Date',
			'adjust_description' => 'Adjust Description',
			'adjust_quantity' => 'Adjust Quantity',
			'adjust_reference' => 'Adjust Reference',
			'adjust_value' => 'Adjust Value',
			'transfer_order_no' => 'Transfer Order No',
			'transfer_date' => 'Transfer Date',
			'receipt_date' => 'Receipt Date',
			'transfer_description' => 'Transfer Description',
			'transfer_reference' => 'Transfer Reference',
			'from_warehouse' => 'From Warehouse',
			'to_warehouse' => 'To Warehouse',
			'to_rack' => 'To Rack',
			'to_bin' => 'To Bin',
			'transfer_quantity' => 'Transfer Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('part_no',$this->part_no,true);
		$criteria->compare('stock_id',$this->stock_id);
		$criteria->compare('product_description',$this->product_description,true);
		$criteria->compare('product_class',$this->product_class,true);
		$criteria->compare('product_generic_name',$this->product_generic_name,true);
		$criteria->compare('product_total_quantity',$this->product_total_quantity);
		$criteria->compare('product_allocated_quantity',$this->product_allocated_quantity);
		$criteria->compare('product_free_quantity',$this->product_free_quantity);
		$criteria->compare('unit',$this->unit);
		$criteria->compare('rate',$this->rate);
		$criteria->compare('total_value',$this->total_value);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('receipt_no',$this->receipt_no,true);
		$criteria->compare('adjust_date',$this->adjust_date,true);
		$criteria->compare('adjust_description',$this->adjust_description,true);
		$criteria->compare('adjust_quantity',$this->adjust_quantity);
		$criteria->compare('adjust_reference',$this->adjust_reference,true);
		$criteria->compare('adjust_value',$this->adjust_value);
		$criteria->compare('transfer_order_no',$this->transfer_order_no);
		$criteria->compare('transfer_date',$this->transfer_date,true);
		$criteria->compare('receipt_date',$this->receipt_date,true);
		$criteria->compare('transfer_description',$this->transfer_description,true);
		$criteria->compare('transfer_reference',$this->transfer_reference,true);
		$criteria->compare('from_warehouse',$this->from_warehouse);
		$criteria->compare('to_warehouse',$this->to_warehouse);
		$criteria->compare('to_rack',$this->to_rack);
		$criteria->compare('to_bin',$this->to_bin);
		$criteria->compare('transfer_quantity',$this->transfer_quantity);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MaterialMovementIssue the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
