<?php
class MasterSettings extends CActiveRecord {
	
    public $product_class;
    public function tableName() {
        return '{{mas_settings}}';
    }
    
     /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_class,internal_cost_percentage, landing_cost_percentage', 'required'),
        	array('product_class_id', 'required', 'message' => 'Please choose Brand/Class'),
        	array('internal_cost_percentage, landing_cost_percentage', 'numerical'),
            array('internal_cost_percentage, landing_cost_percentage', 'length', 'max' => 5),
            array('id,product_class_id,landing_cost_percentage,internal_cost_percentage', 'safe'),
        );
    }
	public function attributeLabels() {
        return array(
            'id' => 'ID',
        	'product_class' => 'Brand/Class',
            'landing_cost_percentage' => 'Landing Cost (%)',
            'internal_cost_percentage' => 'Internal Cost (%)',
        );
    }
    
 public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
       return array(
            'productclass' => array(self::BELONGS_TO, 'ProductClass', 'product_class_id')
        );
     }
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public function search() {
        $criteria = new CDbCriteria;
        //$criteria->with = array('productclass', 'productclass.product_class', 'id');
        $criteria->with = array('productclass');
		$criteria->compare('id', $this->product_class_id);
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 10,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => '',
            ),
        ));
    }
}
?>
