<?php

/**
 * This is the model class for table "{{mas_status}}".
 *
 * The followings are the available columns in table '{{mas_status}}':
 * @property string $status_name
 * @property string $isDefault
 * @property string $created_datetime
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class MasStatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_status}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status_name', 'required'),
			array('status_name', 'unique'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('status_name', 'length', 'max'=>255),
			array('isDefault', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('status_name, isDefault, created_datetime, created_by, updated_by, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'status_name' => 'Status Name',
			'isDefault' => 'Is Default',
			'created_datetime' => 'Created Datetime',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('status_name',$this->status_name,true);
		$criteria->compare('isDefault',$this->isDefault,true);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getStatusList() {

        $model = self::model()->findAll(array('select' => array('id', 'status_name'), 'order' => 'status_name'));

        return CHtml::listData($model, 'id', 'status_name');

    }
}
