<?php

/**
 * This is the model class for table "{{mas_project_1}}".
 *
 * The followings are the available columns in table '{{mas_project_1}}':
 * @property integer $id
 * @property string $master_name
 * @property string $isActive
 * @property string $isMasterBase
 */
class MasProject1 extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_project_1}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('master_name,isMasterBase', 'required'),
			array('master_name', 'length', 'max'=>100),
			array('isActive, isMasterBase', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, master_name, isActive, isMasterBase', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'master_name' => 'Master Name',
			'isActive' => 'Is Active',
			'isMasterBase' => 'Is Master Base',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('master_name',$this->master_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('isMasterBase',$this->isMasterBase,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasProject1 the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getMaster1list() {
        $condition = 'isActive =  "Y" ';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'master_name  asc'));
        return CHtml::listData($model, 'id', 'master_name');
    }
	public static function getMasterName($type) {
		$typename= "";
		if($type>0)
		{
        $condition = 'isActive =  "Y" AND master_type= '.$type;
        $model = self::model()->find(array('condition' => $condition));
        return $model->master_name;
		}
		return $typename;
    }
}
